
/*  
   Dialogbox fr die Dateneingabe einer Dreiecksflche
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"
struct ybufferstruktur YBufferDialog;
STRING helpybufferdialog = "Definition einer Oberflche.";
Widget WYBufferDialog, YBufferWText1, YBufferWText2, YBufferWText3, YBufferWText4,
  YBufferWText5, YBufferCoverLabel, WMatrixDialog;
Widget *WMatrix;
int YBufferArt;
grobjekt *ybuffer_grobj;
longint ybuffer_anknr;
PEXVertexNormal *ybuffer_netz;


// zur Matrixeingabe
void matrixdialog(longint x, longint z);


void
YBufferDialog_init(longint Nrcover, vector P1, vector P2, vector P3, vector P4,
		   longint X, longint Z, float *Y)
{
  YBufferDialog.nrcover = Nrcover;
  YBufferDialog.p1 = P1;
  YBufferDialog.p2 = P2;
  YBufferDialog.p3 = P3;
  YBufferDialog.p4 = P4;
  YBufferDialog.x = X;
  YBufferDialog.z = Z;
  YBufferDialog.y = Y;
}

void
YBufferDialog_get(longint * Nrcover, vector * P1, vector * P2, vector * P3, vector * P4,
		  longint * X, longint * Z, float **Y)
{
  *Nrcover = YBufferDialog.nrcover;
  *P1 = YBufferDialog.p1;
  *P2 = YBufferDialog.p2,
    *P3 = YBufferDialog.p3, *P4 = YBufferDialog.p4,
    *X = YBufferDialog.x;
  *Z = YBufferDialog.z;
  *Y = YBufferDialog.y;
}


void
create_ybuffer_netz(void)
{
  int x, y, xanz, yanz, index;
  float xabs, yabs, a;
  vector nor, rp1, xa, ya, bx, by;

  xanz = YBufferDialog.x;
  yanz = YBufferDialog.z;
  ybuffer_netz = (PEXVertexNormal *) malloc(sizeof(PEXVertexNormal) * xanz * yanz);
  nor |= ((YBufferDialog.p2 - YBufferDialog.p1) && (YBufferDialog.p4 - YBufferDialog.p1))
    * -1.0;

  // Achsenrichtung und Lnge
  xa = YBufferDialog.p2 - YBufferDialog.p1;
  ya = YBufferDialog.p4 - YBufferDialog.p1;
  xabs = abs(xa) / (float) (xanz - 1);
  yabs = abs(ya) / (float) (yanz - 1);
  xa |= xa;
  ya |= ya;

  xa *= xabs;
  ya *= yabs;

  // laufe Sttzpunkte
  for (y = 0; y < yanz; y++)
    {
      by = ya * (float) y;

      for (x = 0; x < xanz; x++)
	{
	  bx = xa * (float) x;

	  // Punkte in der Ebene
	  rp1 = YBufferDialog.p1 + bx + by;

	  // Punkte mit Hhe
	  a = YBufferDialog.y[y * xanz + x];

	  rp1 += nor * a;

	  index = y * xanz + x;
	  ybuffer_netz[index].point.x = rp1.x;
	  ybuffer_netz[index].point.y = rp1.y;
	  ybuffer_netz[index].point.z = rp1.z;
	  // Normalvektor
	  ybuffer_netz[index].normal.x = nor.x;
	  ybuffer_netz[index].normal.y = nor.y;
	  ybuffer_netz[index].normal.z = nor.z;
	}
    }
}


void
aendere_ybuffer(grobjekt * ybuffergrobj)
{
  PEXArrayOfFacetData dummy;
  PEXArrayOfVertex ybuffer_vertex;

  PEXStructure *pybuffer = &(ybuffergrobj->obj_struct);

  /* Aendern */
  ybuffergrobj->cover = YBufferDialog.nrcover;	// Covereintrag

  ((cadybuffer *) (ybuffergrobj->objp))->
    init(YBufferDialog.p1, YBufferDialog.p2, YBufferDialog.p3, YBufferDialog.p4,
	 YBufferDialog.x, YBufferDialog.z, YBufferDialog.y);

  PEXSetEditingMode(pDisplay, *pybuffer, PEXStructureReplace);
  PEXSetElementPtr(pDisplay, *pybuffer, PEXBeginning, 0);
  PEXSetElementPtrAtLabel(pDisplay, *pybuffer, OBJ_POLYLINE_LABEL, 1);

  create_ybuffer_netz();
  ybuffer_vertex.normal = ybuffer_netz;
  PEXQuadrilateralMesh(pDisplay, *pybuffer, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANormal, PEXColorTypeRGB, dummy,
		       YBufferDialog.x, YBufferDialog.z, ybuffer_vertex);
  // wieder freigeben
  free(ybuffer_netz);

  un_echo(ybuffergrobj, ybuffergrobj->ch == 'N');
}

void
create_ybuffer(Display * D, Widget W, grobjekt * pybuffer, longint ank_nr, longint pick_id)
{
  bool echocolor = True;
  PEXName name[2];
  PEXMatrix matrix;
  PEXVector tr, scale;
  PEXCoord ref_point;
  PEXStructure *pybuffer_element = NULL;
  grobjekt *ankobj = NULL;

  PEXArrayOfFacetData dummy;
  PEXArrayOfVertex ybuffer_vertex;

  // suche strukturpointer zum anhngen
  if (ank_nr == 0L)
    {
      echocolor = True;
      pybuffer_element = &root_struct;
      ankobj = NULL;
    }
  else
    {
      if ((ankobj = oliste.getobjp(ank_nr)) != NULL)
	{
	  echocolor = ankobj->ch == 'N';
	  pybuffer_element = &ankobj->obj_struct;
	}
      else
	ankobj = NULL;
    }

  // Nameset und Pickid sind wichtig fr das Picken
  name[0] = (PEXName) GROBJSTR;
  name[1] = (PEXName) YBUFFER;
  PEXAddToNameSet(D, pybuffer->obj_struct, PEXOCStore, 2, name);
  PEXSetPickID(D, pybuffer->obj_struct, PEXOCStore, pick_id);

  PEXLabel(D, pybuffer->obj_struct, PEXOCStore, COLORLABEL);
  if (pybuffer->ch == 'N')
    PEXSetSurfaceColor(D, pybuffer->obj_struct, PEXOCStore, PEXColorTypeRGB, &normal_color);
  else
    PEXSetSurfaceColor(D, pybuffer->obj_struct, PEXOCStore, PEXColorTypeRGB, &schnitt_color);

  SET_VECT(0.0, 0.0, 0.0, tr);
  SET_VECT(0.0, 0.0, 0.0, ref_point);
  SET_VECT(1.0, 1.0, 1.0, scale);
  PEXBuildTransform(&ref_point, &tr, 0.0, 0.0, 0.0, &scale, matrix);
  PEXLabel(D, pybuffer->obj_struct, PEXOCStore, TRANSFORM_LABEL);
  PEXSetLocalTransform(D, pybuffer->obj_struct, PEXOCStore, PEXReplace, matrix);
  // Hier werden die Pickelemente eingefgt 
  PEXLabel(D, pybuffer->obj_struct, PEXOCStore, OBJ_PICK_ANF_LABEL);
  PEXLabel(D, pybuffer->obj_struct, PEXOCStore, OBJ_PICK_END_LABEL);

  PEXLabel(D, pybuffer->obj_struct, PEXOCStore, OBJ_POLYLINE_LABEL);

  create_ybuffer_netz();
  ybuffer_vertex.normal = ybuffer_netz;
  PEXQuadrilateralMesh(D, pybuffer->obj_struct, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANormal, PEXColorTypeRGB, dummy,
		       YBufferDialog.x, YBufferDialog.z, ybuffer_vertex);
  // wieder freigeben
  free(ybuffer_netz);

  // Kennung das hier die Kette beginnt
  PEXLabel(D, pybuffer->obj_struct, PEXOCStore, OBJ_KETTE_LABEL);

  /* in Root-Struktur einfgen */
  PEXSetEditingMode(D, *pybuffer_element, PEXStructureInsert);
  PEXSetElementPtr(D, *pybuffer_element, PEXEnd, 0);
  PEXLabel(D, *pybuffer_element, PEXOCStore, GROBJ_LABEL + pick_id);
  PEXExecuteStructure(D, *pybuffer_element, PEXOCStore, pybuffer->obj_struct);

  un_echo(ankobj, echocolor);
}

void
delete_cover_ybuffer_liste(void)
{
  int x, anzelem;

  for (anzelem = 0, coverx = coveranf; coverx; anzelem++, coverx = coverx->next);

  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(YBufferDialog.pCoverStr[x]);
}

void
CBMatrixOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  grobjekt *pybuffer;
  STRING str;
  longint pick_id, a;

  // Speicher allocieren
  YBufferDialog.y = (float *) malloc(sizeof(float) * YBufferDialog.x * YBufferDialog.z);

  for (a = 0; a < (YBufferDialog.x * YBufferDialog.z); a++)
    {
      str = XmTextGetString(WMatrix[a]);
      sscanf(str, "%f", &YBufferDialog.y[a]);
      // XmStringFree((XmString)str);
    }

  // erst hier Datenstruktur erzeugen
  if (YBufferArt == NEU)
    {
      pick_id = ank_grobjekt(YBUFFER, ybuffer_anknr,
	  ObjDialog.r, ObjDialog.g, ObjDialog.b, ObjDialog.e, ObjDialog.mat,
		  ObjDialog.sp, ObjDialog.du, ObjDialog.dif, ObjDialog.spec,
			     ObjDialog.high, ObjDialog.vel, ObjDialog.ch,
			     YBufferDialog.nrcover, vector(0.0, 0.0, 0.0),
			     vector(0.0, 0.0, 0.0));
      pybuffer =
	ank_ybuffer(YBufferDialog.p1, YBufferDialog.p2, YBufferDialog.p3, YBufferDialog.p4,
		    YBufferDialog.x, YBufferDialog.z, YBufferDialog.y);

      create_ybuffer(XtDisplay(W), W, pybuffer, ybuffer_anknr, pick_id);
    }
  else
    aendere_ybuffer(ybuffer_grobj);

  delete_cover_ybuffer_liste();
  free(YBufferDialog.y);	// Speicher freigeben

  XtUnmanageChild(WMatrixDialog);
  free(WMatrix);
  WMatrixDialog = NULL;
}

void
CBMatrixCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  XtUnmanageChild(WMatrixDialog);
  free(WMatrix);
  WMatrixDialog = NULL;
}

void
CBYBufferOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;
  longint x, z;
  vector p1, p2, p3, p4;
  char ok;

  /* Text in Zahlen umwandeln */
  str = XmTextGetString(YBufferWText1);
  if (!(ok = expr_vector(&p1, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor p1 liefert eine ungueltige Zahl!");
      return;			// gehe zurueck ohne Dialog zu beenden

    }
  // XmStringFree((XmString)str);
  YBufferDialog.p1 = p1;

  str = XmTextGetString(YBufferWText2);
  if (!(ok = expr_vector(&p2, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor p1 liefert eine ungueltige Zahl!");
      return;
    }
  if (ok == 2)
    p2 += p1;
  // XmStringFree((XmString)str);
  YBufferDialog.p2 = p2;

  str = XmTextGetString(YBufferWText4);
  if (!(ok = expr_vector(&p4, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor p1 liefert eine ungltige Zahl!");
      return;			// gehe zurueck ohne Dialog zu beenden

    }
  if (ok == 2)
    p4 += p3;
  // XmStringFree((XmString)str);
  YBufferDialog.p4 = p4;

  // p3 kann errechnet werden da es sich um ein Quadratisches Polygon handelt
  p3 = (p2 - p1) + (p4 - p1) + p1;
  YBufferDialog.p3 = p3;

  str = XmTextGetString(YBufferWText5);
  sscanf(str, "%ld;%ld", &x, &z);
  // XmStringFree((XmString)str);
  YBufferDialog.x = x;
  YBufferDialog.z = z;

  // Dialog zur Eingabe der Matrix
  matrixdialog(x, z);

  /* erst hier!!! */
  WObjDialog = NULL;

  XtUnmanageChild(WYBufferDialog);
  WYBufferDialog = NULL;
}

void
CBYBufferCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  delete_cover_ybuffer_liste();
  XtUnmanageChild(WYBufferDialog);

  /*  erst hier!!! */
  WObjDialog = NULL;

  WYBufferDialog = NULL;
}

void
CBYBufferHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpybufferdialog);
  else
    infobox("helpnureinmal");
}

void
CBYBufferCover(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  YBufferDialog.nrcover = (((XmListCallbackStruct *) pCallData)->item_position) - 1;
  sprintf(cpos, "%ld", YBufferDialog.nrcover);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(YBufferCoverLabel, &Aargs, 1);
  strcpy(YBufferDialog.coverlabel, cpos);
}

void
create_ybuffer_listen(void)
{
  char str[256];
  longint x = 0, anzelem = 0;

  /* CoverListe */
  if (coveranf)
    {
      coverx = coveranf;
      while (coverx)
	{
	  anzelem = coverx->nr;
	  coverx = coverx->next;
	}
      YBufferDialog.anzcover = anzelem + 1;
      YBufferDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      coverx = coveranf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      YBufferDialog.pCoverStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (coverx)
	{
	  sprintf(str, "%ld: Cover", coverx->nr);	/* C String erzeugen */
	  YBufferDialog.pCoverStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  coverx = coverx->next;
	  x++;
	}
    }
  else
    {
      /* nur Dummy */
      YBufferDialog.anzcover = 1;
      YBufferDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString));
      strcpy(str, "0: keine");
      YBufferDialog.pCoverStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }
}

void
ybufferdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art)
{
  Widget WButtonOK, WButtonPick, WButtonCancel, WButtonHelp, WRowCol1,
    WRowCol2, WRowCol3, WRowCol4, frame1, frame2, WLabel, WCoverList;

  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];

  YBufferArt = art;
  ybuffer_anknr = ank_nr;
  ybuffer_grobj = grobjp;


  if (YBufferArt == AENDERN)
    {
      ((cadybuffer *) (ybuffer_grobj->objp))->
	get(&YBufferDialog.p1, &YBufferDialog.p2, &YBufferDialog.p3, &YBufferDialog.p4,
	    &YBufferDialog.x, &YBufferDialog.z, &YBufferDialog.y);
      // zustzlich
      YBufferDialog.nrcover = ybuffer_grobj->cover;
    }
  else
    YBufferDialog_init(0L, vector(0.1, 0.1, 0.1), vector(2.0, 0.1, 0.1),
		  vector(1.0, 0.1, 2.0), vector(0.1, 0.1, 2.0), 3, 4, NULL);

  /* Strings fr Listen Aufbauen */
  create_ybuffer_listen();

  WYBufferDialog = XmCreateDialogShell(W, "ybufferdialog", NULL, 0);
  XtManageChild(WYBufferDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 350);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 425);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WYBufferDialog, "ybufferrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("ybufferframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "ybufferrow2", NULL, 0);
  XtManageChild(WRowCol2);

  WLabel = XtCreateManagedWidget("Vektor x;y;z :", xmLabelWidgetClass, WRowCol2, NULL, 0);

  sprintf(str, "%0.2f;%0.2f;%0.2f",
	  YBufferDialog.p1.x, YBufferDialog.p1.y, YBufferDialog.p1.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  YBufferWText1 = XtCreateManagedWidget("ybufferp", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f",
	  YBufferDialog.p2.x, YBufferDialog.p2.y, YBufferDialog.p2.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  YBufferWText2 = XtCreateManagedWidget("ybufferp", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

/*
   sprintf(str, "%0.2f;%0.2f;%0.2f",
   YBufferDialog.p3.x,YBufferDialog.p3.y,YBufferDialog.p3.z);
   nArgs = 0; XtSetArg(Aargs[nArgs], XmNvalue, str); nArgs++;
   YBufferWText3= XtCreateManagedWidget("ybufferp", xmTextWidgetClass, WRowCol2, Aargs, nArgs);
 */
  sprintf(str, "%0.2f;%0.2f;%0.2f",
	  YBufferDialog.p4.x, YBufferDialog.p4.y, YBufferDialog.p4.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  YBufferWText4 = XtCreateManagedWidget("ybufferp", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%ld;%ld", YBufferDialog.x, YBufferDialog.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  YBufferWText5 = XtCreateManagedWidget("ybufferp", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  /* Cover Auswahl */
  frame2 = XtCreateManagedWidget("ybuffercoverf", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol4 = XmCreateRowColumn(frame2, "ybufferc4", NULL, 0);
  XtManageChild(WRowCol4);

  sprintf(str, "%ld", YBufferDialog.nrcover);
  YBufferCoverLabel = XtCreateManagedWidget(str, xmLabelWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, YBufferDialog.pCoverStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, YBufferDialog.anzcover);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 4);
  nArgs++;
  WCoverList = XmCreateScrolledList(WRowCol4, "ybuffercover", Aargs, nArgs);
  XtAddCallback(WCoverList, XmNdefaultActionCallback, (XtCallbackProc) CBYBufferCover, NULL);
  XtManageChild(WCoverList);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "ybufferrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonPick);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBYBufferOk, NULL);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBYBufferCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBYBufferHelp, NULL);
}

void
matrixdialog(longint x, longint z)
{
  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[80];
  longint a;

  Widget WButtonOK, WButtonPick, WButtonCancel, WRowCol, WRowCol2, WRowColM,
    WEscrollwin, Wframe;

  WMatrixDialog = XmCreateDialogShell(WTop, "matrixdialog", NULL, 0);
  XtManageChild(WMatrixDialog);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 690);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 400);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol = XmCreateRowColumn(WMatrixDialog, "matrixrow", Aargs, nArgs);
  XtManageChild(WRowCol);

  /* Arbeitsflche */
  Wframe = XtCreateManagedWidget("matrixframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WEscrollwin =
    XtVaCreateManagedWidget("matrixscrol", xmScrolledWindowWidgetClass, Wframe,
			    XmNscrollingPolicy, XmAUTOMATIC,
			    XmNvisualPolicy, XmVARIABLE,
			    XmNwidth, 580,
			    XmNheight, 300,
			    NULL);

  // Eingabezeilen anordnen
  WRowColM = XtVaCreateManagedWidget("matrixrowm", xmRowColumnWidgetClass, WEscrollwin,
				     XmNorientation, XmHORIZONTAL,
				     XmNpacking, XmPACK_COLUMN,
				     XmNnumColumns, z,
				     NULL);

  // Speicher allocieren
  WMatrix = (Widget *) malloc(sizeof(Widget) * x * z);

  for (a = 0; a < (x * z); a++)
    {
      if (YBufferArt == AENDERN)
	sprintf(str, "%0.2f", YBufferDialog.y[a]);
      else
	strcpy(str, "0");

      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNvalue, str);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNwidth, 180);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNnumColumns, 5);
      nArgs++;
      WMatrix[a] =
	XtCreateManagedWidget("matrixt", xmTextWidgetClass, WRowColM, Aargs, nArgs);
    }

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(WRowCol, "matrixrow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  WButtonOK = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonOK);
  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBMatrixOk, NULL);

  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonPick);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);

  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonCancel);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBMatrixCancel, NULL);

}
