/*  
   Dialogbox fr Wellen

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"

STRING helpwavedialog = "Definition einer Welle";

struct wavestruktur WaveDialog;
Widget WWaveDialog, wavename, wavefrequenz1, wavelaenge1, wavefrequenz2,
  wavelaenge2, wavefrequenz3, wavelaenge3, wavepos1, wavepos2, wavepos3;

int WaveDialogArt;

void
WaveDialog_init(
float X1, float Y1, float Z1, float Freq1, float Amp1, float Damp1, float D1,
float X2, float Y2, float Z2, float Freq2, float Amp2, float Damp2, float D2,
float X3, float Y3, float Z3, float Freq3, float Amp3, float Damp3, float D3,
		 char *Name)
{
  WaveDialog.x1 = X1;
  WaveDialog.y1 = Y1;
  WaveDialog.z1 = Z1;
  WaveDialog.freq1 = Freq1;
  WaveDialog.amp1 = Amp1;
  WaveDialog.damp1 = Damp1;
  WaveDialog.d1 = D1;

  WaveDialog.x2 = X2;
  WaveDialog.y2 = Y2;
  WaveDialog.z2 = Z2;
  WaveDialog.freq2 = Freq2;
  WaveDialog.amp2 = Amp2;
  WaveDialog.damp2 = Damp2;
  WaveDialog.d2 = D2;

  WaveDialog.x3 = X3;
  WaveDialog.y3 = Y3;
  WaveDialog.z3 = Z3;
  WaveDialog.freq3 = Freq3;
  WaveDialog.amp3 = Amp3;
  WaveDialog.damp3 = Damp3;
  WaveDialog.d3 = D3;

  strcpy(WaveDialog.name, Name);
}

void
WaveDialog_get(
		float *X1, float *Y1, float *Z1, float *Freq1, float *Amp1, float *Damp1, float *D1,
		float *X2, float *Y2, float *Z2, float *Freq2, float *Amp2, float *Damp2, float *D2,
		float *X3, float *Y3, float *Z3, float *Freq3, float *Amp3, float *Damp3, float *D3,
		char *Name)
{
  *X1 = WaveDialog.x1;
  *Y1 = WaveDialog.y1;
  *Z1 = WaveDialog.z1;
  *Freq1 = WaveDialog.freq1;
  *Amp1 = WaveDialog.amp1;
  *Damp1 = WaveDialog.damp1;
  *D1 = WaveDialog.d1;

  *X2 = WaveDialog.x2;
  *Y2 = WaveDialog.y2;
  *Z2 = WaveDialog.z2;
  *Freq2 = WaveDialog.freq2;
  *Amp2 = WaveDialog.amp2;
  *Damp2 = WaveDialog.damp2;
  *D2 = WaveDialog.d2;

  *X3 = WaveDialog.x3;
  *Y3 = WaveDialog.y3;
  *Z3 = WaveDialog.z3;
  *Freq3 = WaveDialog.freq3;
  *Amp3 = WaveDialog.amp3;
  *Damp3 = WaveDialog.damp3;
  *D3 = WaveDialog.d3;

  strcpy(Name, WaveDialog.name);
}


void
CBWaveOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;

  /* Text Widgets auslesen */
  str = XmTextGetString(wavepos1);
  sscanf(str, "%f;%f;%f", &WaveDialog.x1, &WaveDialog.y1, &WaveDialog.z1);
  // XmStringFree((XmString)str);

  str = XmTextGetString(wavepos2);
  sscanf(str, "%f;%f;%f", &WaveDialog.x2, &WaveDialog.y2, &WaveDialog.z2);
  // XmStringFree((XmString)str);

  str = XmTextGetString(wavepos3);
  sscanf(str, "%f;%f;%f", &WaveDialog.x3, &WaveDialog.y3, &WaveDialog.z3);
  // XmStringFree((XmString)str);

  str = XmTextGetString(wavename);
  sscanf(str, "%s", (char *) &WaveDialog.name);
  // XmStringFree((XmString)str);

  str = XmTextGetString(wavefrequenz1);
  sscanf(str, "%f", &WaveDialog.freq1);
  // XmStringFree((XmString)str);

  str = XmTextGetString(wavelaenge1);
  sscanf(str, "%f", &WaveDialog.d1);
  // XmStringFree((XmString)str);

  str = XmTextGetString(wavefrequenz2);
  sscanf(str, "%f", &WaveDialog.freq2);
  // XmStringFree((XmString)str);

  str = XmTextGetString(wavelaenge2);
  sscanf(str, "%f", &WaveDialog.d2);
  // XmStringFree((XmString)str);

  str = XmTextGetString(wavefrequenz3);
  sscanf(str, "%f", &WaveDialog.freq3);
  // XmStringFree((XmString)str);

  str = XmTextGetString(wavelaenge3);
  sscanf(str, "%f", &WaveDialog.d3);
  // XmStringFree((XmString)str);

  if (WaveDialogArt == NEU)
    ank_wave(WaveDialog.name,
	     WaveDialog.x1, WaveDialog.y1, WaveDialog.z1,
	 WaveDialog.freq1, WaveDialog.amp1, WaveDialog.damp1, WaveDialog.d1,
	     WaveDialog.x2, WaveDialog.y2, WaveDialog.z2,
	 WaveDialog.freq2, WaveDialog.amp2, WaveDialog.damp2, WaveDialog.d2,
	     WaveDialog.x3, WaveDialog.y3, WaveDialog.z3,
	WaveDialog.freq3, WaveDialog.amp3, WaveDialog.damp3, WaveDialog.d3);
  else if (WaveDialogArt == AENDER)
    WaveDialog_get(&wavex->x1, &wavex->y1, &wavex->z1, &wavex->freq1, &wavex->amp1,
		   &wavex->damp1, &wavex->d1,
	    &wavex->x2, &wavex->y2, &wavex->z2, &wavex->freq2, &wavex->amp2,
		   &wavex->damp2, &wavex->d2,
	    &wavex->x3, &wavex->y3, &wavex->z3, &wavex->freq3, &wavex->amp3,
		   &wavex->damp3, &wavex->d3, wavex->name);

  /* Dialog schlieen */
  XtUnmanageChild(WWaveDialog);
  WWaveDialog = NULL;
}

void
CBWaveCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  XtUnmanageChild(WWaveDialog);
  WWaveDialog = NULL;
}

void
CBWaveHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpwavedialog);
  else
    infobox("helpnureinmal");
}

void
CBWaveAmpCanged1(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  WaveDialog.amp1 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
}

void
CBWaveDampCanged1(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  WaveDialog.damp1 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
}

void
CBWaveAmpCanged2(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  WaveDialog.amp2 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
}

void
CBWaveDampCanged2(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  WaveDialog.damp2 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
}

void
CBWaveAmpCanged3(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  WaveDialog.amp3 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
}

void
CBWaveDampCanged3(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  WaveDialog.damp3 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
}

void
wavedialog(Widget W, int art)
{

  Widget WButtonOK, WButtonCancel, WButtonHelp, WScale11, WScale21, WScale12,
    WScale22, WScale13, WScale23, WRowCol1, WRowCol2, WRowCol3, WRowCol4,
    WRowCol5, WRowCol6, WLabel1, WLabel2, WLabel3, WLabel4, WLabel5, WLabel6,
    WLabel7, frame1, frame2, frame3, frame4;

  int nArgs;
  Arg Aargs[MAX_ARGS];
  char str[256];
  XmString mstr;

  WaveDialogArt = art;
  /* Der Dialog */
  WWaveDialog = XmCreateDialogShell(W, "wavedialog", NULL, 0);
  XtManageChild(WWaveDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 655);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 380);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WWaveDialog, "waverow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  /* fr Name */
  frame1 = XtCreateManagedWidget("waveframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "waverow2", NULL, 0);
  XtManageChild(WRowCol2);

  WLabel1 = XtCreateManagedWidget("Wellenname", xmLabelWidgetClass, WRowCol2, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, WaveDialog.name);
  nArgs++;
  wavename = XtCreateManagedWidget("wavename", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  /* fr Unterwelle 1 */
  frame2 = XtCreateManagedWidget("waveframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol4 = XmCreateRowColumn(frame2, "waverow4", Aargs, nArgs);
  XtManageChild(WRowCol4);

  sprintf(str, "%0.2f;%0.2f;%0.2f", WaveDialog.x1, WaveDialog.y1, WaveDialog.z1);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  wavepos1 = XtCreateManagedWidget("wavepos1", xmTextWidgetClass, WRowCol4, Aargs, nArgs);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, WaveDialog.amp1 * 100.0);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNshowValue, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  mstr = XmStringCreateLtoR("Amplitude", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
  nArgs++;
  WScale11 = XtCreateManagedWidget("waveamp1", xmScaleWidgetClass, WRowCol4, Aargs, nArgs);
  XtAddCallback(WScale11, XmNvalueChangedCallback, (XtCallbackProc) CBWaveAmpCanged1, NULL);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, WaveDialog.damp1 * 100.0);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNshowValue, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  mstr = XmStringCreateLtoR("Dmpfung", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
  nArgs++;
  WScale21 = XtCreateManagedWidget("wavedamp1", xmScaleWidgetClass, WRowCol4, Aargs, nArgs);
  XtAddCallback(WScale21, XmNvalueChangedCallback, (XtCallbackProc) CBWaveDampCanged1, NULL);

  WLabel2 = XtCreateManagedWidget("f:", xmLabelWidgetClass, WRowCol4, NULL, 0);
  sprintf(str, "%0.2f", WaveDialog.freq1);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  wavefrequenz1 = XtCreateManagedWidget("wavefreq1", xmTextWidgetClass, WRowCol4, Aargs, nArgs);
  WLabel3 = XtCreateManagedWidget("l:", xmLabelWidgetClass, WRowCol4, NULL, 0);
  sprintf(str, "%0.2f", WaveDialog.d1);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  wavelaenge1 = XtCreateManagedWidget("wavelaenge1", xmTextWidgetClass, WRowCol4, Aargs, nArgs);

  /* fr Unterwelle 2 */
  frame3 = XtCreateManagedWidget("waveframe3", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol5 = XmCreateRowColumn(frame3, "waverow5", Aargs, nArgs);
  XtManageChild(WRowCol5);

  sprintf(str, "%0.2f;%0.2f;%0.2f", WaveDialog.x2, WaveDialog.y2, WaveDialog.z2);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  wavepos2 = XtCreateManagedWidget("wavepos2", xmTextWidgetClass, WRowCol5, Aargs, nArgs);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, WaveDialog.amp2 * 100.0);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNshowValue, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  mstr = XmStringCreateLtoR("Amplitude", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
  nArgs++;
  WScale12 = XtCreateManagedWidget("waveamp2", xmScaleWidgetClass, WRowCol5, Aargs, nArgs);
  XtAddCallback(WScale12, XmNvalueChangedCallback, (XtCallbackProc) CBWaveAmpCanged2, NULL);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, WaveDialog.damp2 * 100.0);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNshowValue, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  mstr = XmStringCreateLtoR("Dmpfung", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
  nArgs++;
  WScale22 = XtCreateManagedWidget("wavedamp2", xmScaleWidgetClass, WRowCol5, Aargs, nArgs);
  XtAddCallback(WScale22, XmNvalueChangedCallback, (XtCallbackProc) CBWaveDampCanged2, NULL);
  WLabel4 = XtCreateManagedWidget("f:", xmLabelWidgetClass, WRowCol5, NULL, 0);
  sprintf(str, "%0.2f", WaveDialog.freq2);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  wavefrequenz2 = XtCreateManagedWidget("wavefreq2", xmTextWidgetClass, WRowCol5, Aargs, nArgs);
  WLabel5 = XtCreateManagedWidget("l:", xmLabelWidgetClass, WRowCol5, NULL, 0);
  sprintf(str, "%0.2f", WaveDialog.d2);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  wavelaenge2 = XtCreateManagedWidget("wavelaenge2", xmTextWidgetClass, WRowCol5, Aargs, nArgs);

  /* fr Unterwelle 3 */
  frame4 = XtCreateManagedWidget("waveframe4", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol6 = XmCreateRowColumn(frame4, "waverow6", Aargs, nArgs);
  XtManageChild(WRowCol6);

  sprintf(str, "%0.2f;%0.2f;%0.2f", WaveDialog.x3, WaveDialog.y3, WaveDialog.z3);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  wavepos3 = XtCreateManagedWidget("wavepos3", xmTextWidgetClass, WRowCol6, Aargs, nArgs);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, WaveDialog.amp3 * 100.0);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNshowValue, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  mstr = XmStringCreateLtoR("Amplitude", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
  nArgs++;
  WScale13 = XtCreateManagedWidget("waveamp3", xmScaleWidgetClass, WRowCol6, Aargs, nArgs);
  XtAddCallback(WScale13, XmNvalueChangedCallback, (XtCallbackProc) CBWaveAmpCanged3, NULL);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, WaveDialog.damp3 * 100.0);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNshowValue, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  mstr = XmStringCreateLtoR("Dmpfung", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
  nArgs++;
  WScale23 = XtCreateManagedWidget("wavedamp3", xmScaleWidgetClass, WRowCol6, Aargs, nArgs);
  XtAddCallback(WScale23, XmNvalueChangedCallback, (XtCallbackProc) CBWaveDampCanged3, NULL);

  WLabel6 = XtCreateManagedWidget("f:", xmLabelWidgetClass, WRowCol6, NULL, 0);
  sprintf(str, "%0.2f", WaveDialog.freq3);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  wavefrequenz3 = XtCreateManagedWidget("wavefreq3", xmTextWidgetClass, WRowCol6, Aargs, nArgs);
  WLabel7 = XtCreateManagedWidget("l:", xmLabelWidgetClass, WRowCol6, NULL, 0);
  sprintf(str, "%0.2f", WaveDialog.d3);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  wavelaenge3 = XtCreateManagedWidget("wavelaenge3", xmTextWidgetClass, WRowCol6, Aargs, nArgs);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "waverow3", Aargs, nArgs);
  // XtManageChild(WRowCol3);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);
  XtManageChild(WRowCol3);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBWaveOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBWaveCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBWaveHelp, NULL);
}
