/*  
   Dialogbox fr die Dateneingabe eines Torus

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
*/

#include "pextool.H"

#define TORUS_APPROX_ANZ 6

struct torusstruktur TorusDialog;
STRING helptorusdialog = "Definition eines Torus.";
Widget WTorusDialog, TorusWText1, TorusWText2, TorusWText3, TorusCoverLabel;
int TorusArt;
grobjekt *torus_grobj;
longint torus_anknr;
PEXVertexNormal torus_netz[(TORUS_APPROX_ANZ + 1) * (TORUS_APPROX_ANZ + 1)];


void
TorusDialog_init(longint Nrcover, vector M, float R1, float R2, vector W)
{
  TorusDialog.m = M;
  TorusDialog.r1 = R1;
  TorusDialog.r2 = R2;
  TorusDialog.w = W;
  TorusDialog.nrcover = Nrcover;
}

void
TorusDialog_get(longint * Nrcover, vector * M, float *R1, float *R2, vector * W)
{
  *M = TorusDialog.m;
  *W = TorusDialog.w;
  *R1 = TorusDialog.r1;
  *R2 = TorusDialog.r2;
  *Nrcover = TorusDialog.nrcover;
}

void
create_torus_polyline(Display * D, PEXStructure poly, vector p1, vector p2, vector p3,
		      vector p4, vector pn)
{
  PEXCoord lp, coord[4];

  // Polymarker
  PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(D, poly, PEXOCStore, 3.0);
  PEXSetMarkerColor(D, poly, PEXOCStore, PEXColorTypeRGB, &echo_color);

//   SET_VECTA(p1, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p2, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p3, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);

//   SET_VECTA(p4, lp); 
  //   PEXMarkers(D, poly, PEXOCStore, 1, &lp);

  // Polyline
  SET_VECTA(p1, coord[0]);
  SET_VECTA(p2, coord[1]);
  SET_VECTA(p3, coord[2]);
  SET_VECTA(p1, coord[3]);
  PEXPolyline(D, poly, PEXOCStore, 4, coord);

//   PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCross);
  //   SET_VECTA(p4+(pn*0.1), lp); 
  //   PEXMarkers(D, poly, PEXOCStore, 1, &lp);

//   // Polyline Dreieck
  //   SET_VECTA(p4+(pn*0.1), coord[0]);
  //   SET_VECTA(p4, coord[1]);
  //   PEXPolyline(D, poly, PEXOCStore,  2, coord);
}

/*
void
torus_listtree(Display * D, PEXStructure obj,
	       vector m, vector n, float r)
{
  PEXCoord lp, coord[2];

  // Polymarker
  PEXSetMarkerType(D, obj, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(D, obj, PEXOCStore, 3.0);
  PEXSetMarkerColor(D, obj, PEXOCStore, PEXColorTypeRGB, &echo_color);

  SET_VECTA(m, lp);
  PEXMarkers(D, obj, PEXOCStore, 1, &lp);

  // Polyline Dreieck
  SET_VECTA(m, coord[0]);
  SET_VECTA(m + (n * r), coord[1]);
  PEXPolyline(D, obj, PEXOCStore, 2, coord);
}

void
listtorustree(patchtree * patr, longint a, longint * z,
	      Display * D, PEXStructure obj)
{
  patchtl *ptl;

  for (ptl = patr->o; ptl; ptl = ptl->next)
    {
      torus_listtree(D, obj, ptl->p->m, ptl->p->n, ptl->p->r);
      *z += 1;
      a++;
    }

  // cerr << a << " Elemente im Tree!\n";

  for (char x = 0; x < 8; x++)
    if (patr->pt[x] != NULL)
      listtorustree(patr->pt[x], 0, z, D, obj);
}

void
torus_calcpatches(vector m, float d, float r, vector w,
		  Display * D, PEXStructure obj)
{
  longint z = 0;
  cerr << "Erzeuge Torus-Liste!\n";

  patcharray pt(Patchweite, true, NULL, d, r, m, w);

  //  patchl *pl; 
  //for (pl = pt.pla; pl; pl = pl->next) 
  //torus_listtree(D, obj, pl->m, pl->n, pl->r);

//   patch *pat = pt.pa;
  //   // teste Array
  //   for (long x=0; x<pt.anz; x++) torus_listtree(D, obj, pat[x].m, pat[x].n, pat[x].r);

  pt.bilde_at();
  listtorustree(pt.pt, 0, &z, D, obj);

  cerr << "torus gesamt = " << z << " Patches.\n";
}

*/

void
create_torus_netz(Display * D, PEXStructure obj)
{
  vector pm, pk;
  double theta, phi, wstep;
  int index, i, j, anzpoints, anznetz;

  // generiere ein Netz in den Koordinaten eines Torus
  theta = phi = 0.0;
  anzpoints = TORUS_APPROX_ANZ;
  anznetz = anzpoints + 1;

  wstep = pi2 / (double) anzpoints;
  for (i = 0; i < anznetz; i++)
    {
      pm = vector(TorusDialog.r2, 0, 0);
      rotation(&pm, VNULL, vector(0, 0, wstep * (double) i));

      for (j = 0; j < anznetz; j++)
	{
	  pk = vector(TorusDialog.r1, 0, 0) + pm;
	  rotation(&pk, VNULL, vector(0, wstep * (double) j, 0));

	  // Koordinaten
	  rotation(&pk, VNULL, TorusDialog.w);
	  pk += TorusDialog.m;

	  index = i * anznetz + j;
	  torus_netz[index].point.x = pk.x;
	  torus_netz[index].point.y = pk.y;
	  torus_netz[index].point.z = pk.z;

	  // Normalvektor
	  torus_netz[index].normal.x = torus_netz[index].point.x;
	  torus_netz[index].normal.y = torus_netz[index].point.y;
	  torus_netz[index].normal.z = torus_netz[index].point.z;
	  normal(&torus_netz[index].normal);
	}

      // Kreis schlieen
      index = i * anznetz + anzpoints;
      torus_netz[index].point = torus_netz[index - anzpoints].point;
      torus_netz[index].normal = torus_netz[index - anzpoints].normal;
    }

  // torus_calcpatches(TorusDialog.m, TorusDialog.r1, TorusDialog.r2, TorusDialog.w, D, obj);
}

void
aendere_torus(grobjekt * torusgrobj)
{
  int anzpoints, anznetz;

  // Torusberechnung
  PEXArrayOfFacetData dummy;
  PEXArrayOfVertex torus_vertex;

  PEXStructure *torusp = &(torusgrobj->obj_struct);

  anzpoints = TORUS_APPROX_ANZ;
  anznetz = anzpoints + 1;

  /* Aendern im grobjekt */
  torusgrobj->cover = TorusDialog.nrcover;	// Covereintrag

  ((cadtorus *) (torusgrobj->objp))->
    init(TorusDialog.m, TorusDialog.r1, TorusDialog.r2, TorusDialog.w);

  PEXSetEditingMode(pDisplay, *torusp, PEXStructureReplace);
  PEXSetElementPtr(pDisplay, *torusp, PEXBeginning, 0);

  PEXSetElementPtrAtLabel(pDisplay, *torusp, OBJ_POLYLINE_LABEL, 1);

  create_torus_netz(pDisplay, *torusp);
  torus_vertex.normal = torus_netz;
  PEXQuadrilateralMesh(pDisplay, *torusp, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANormal, PEXColorTypeRGB, dummy,
		       anznetz, anznetz, torus_vertex);

  un_echo(torusgrobj, torusgrobj->ch == 'N');
}

void
create_torus(Display * D, Widget W, grobjekt * torus, longint ank_nr, longint pick_id)
{
  bool echocolor = True;
  int anzpoints, anznetz;
  PEXCoord ref_point;
  PEXName name[2];
  PEXMatrix matrix;
  PEXVector tr, scale;
  PEXStructure *torus_element = NULL;
  grobjekt *ankobj = NULL;


  // Torusberechnung
  PEXArrayOfFacetData dummy;
  PEXArrayOfVertex torus_vertex;

  anzpoints = TORUS_APPROX_ANZ;
  anznetz = anzpoints + 1;

  // suche strukturpointer zum anhngen
  if (ank_nr == 0L)
    {
      echocolor = True;
      torus_element = &root_struct;
      ankobj = NULL;
    }
  else
    {
      if ((ankobj = oliste.getobjp(ank_nr)) != NULL)
	{
	  echocolor = ankobj->ch == 'N';
	  torus_element = &ankobj->obj_struct;
	}
      else
	ankobj = NULL;
    }

  // Nameset und Pickid sind wichtig fr das Picken
  name[0] = (PEXName) GROBJSTR;
  name[1] = (PEXName) TORUS;
  PEXAddToNameSet(D, torus->obj_struct, PEXOCStore, 2, name);
  PEXSetPickID(D, torus->obj_struct, PEXOCStore, pick_id);

  PEXLabel(D, torus->obj_struct, PEXOCStore, COLORLABEL);
  if (torus->ch == 'N')
    PEXSetSurfaceColor(D, torus->obj_struct, PEXOCStore, PEXColorTypeRGB, &normal_color);
  else
    PEXSetSurfaceColor(D, torus->obj_struct, PEXOCStore, PEXColorTypeRGB, &schnitt_color);

  SET_VECT(0.0, 0.0, 0.0, tr);
  SET_VECT(0.0, 0.0, 0.0, ref_point);
  SET_VECT(1.0, 1.0, 1.0, scale);
  PEXBuildTransform(&ref_point, &tr, 0.0, 0.0, 0.0, &scale, matrix);
  PEXLabel(D, torus->obj_struct, PEXOCStore, TRANSFORM_LABEL);
  PEXSetLocalTransform(D, torus->obj_struct, PEXOCStore, PEXReplace, matrix);
  // Hier werden die Pickelemente eingefgt 
  PEXLabel(D, torus->obj_struct, PEXOCStore, OBJ_PICK_ANF_LABEL);
  PEXLabel(D, torus->obj_struct, PEXOCStore, OBJ_PICK_END_LABEL);

  PEXLabel(D, torus->obj_struct, PEXOCStore, OBJ_POLYLINE_LABEL);

  create_torus_netz(D, torus->obj_struct);
  torus_vertex.normal = torus_netz;

  // ### Testzwecke kein Netz
  PEXQuadrilateralMesh(D, torus->obj_struct, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANormal, PEXColorTypeRGB, dummy,
		       anznetz, anznetz, torus_vertex);

  // Kennung das hier die Kette beginnt
  PEXLabel(D, torus->obj_struct, PEXOCStore, OBJ_KETTE_LABEL);

  /* in Root-Struktur einfgen */
  PEXSetEditingMode(D, *torus_element, PEXStructureInsert);
  PEXSetElementPtr(D, *torus_element, PEXEnd, 0);
  PEXLabel(D, *torus_element, PEXOCStore, GROBJ_LABEL + pick_id);
  PEXExecuteStructure(D, *torus_element, PEXOCStore, torus->obj_struct);

  cerr << "in create_torus 5\n";

  un_echo(ankobj, echocolor);
}

void
delete_cover_tourus_liste(void)
{
  int x, anzelem;

  for (anzelem = 0, coverx = coveranf; coverx; anzelem++, coverx = coverx->next);

  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(TorusDialog.pCoverStr[x]);
}

void
CBTorusOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;
  grobjekt *torus;
  longint pick_id;
  vector m, w;
  float r1, r2;
  char ok;

  /* Text in Zahlen umwandeln */
  str = XmTextGetString(TorusWText1);
  if (!(ok = expr_vector(&m, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor m liefert eine ungltige Zahl!");
      return;			// gehe zurck ohne Dialog zu beenden

    }
  TorusDialog.m = m;

  str = XmTextGetString(TorusWText2);
  sscanf(str, "%f;%f", &r1, &r2);
  TorusDialog.r1 = r1;
  TorusDialog.r2 = r2;

  str = XmTextGetString(TorusWText3);
  if (!(ok = expr_vector(&w, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor w liefert eine ungltige Zahl!");
      return;			// gehe zurck ohne Dialog zu beenden

    }
  TorusDialog.w = w;

  /* neues Polygon anketten? */
  if (TorusArt == NEU)
    {
      pick_id = ank_grobjekt(TORUS, torus_anknr,
	  ObjDialog.r, ObjDialog.b, ObjDialog.g, ObjDialog.e, ObjDialog.mat,
		  ObjDialog.sp, ObjDialog.du, ObjDialog.dif, ObjDialog.spec,
			     ObjDialog.high, ObjDialog.vel, ObjDialog.ch,
	 TorusDialog.nrcover, vector(0.0, 0.0, 0.0), vector(0.0, 0.0, 0.0));
      cerr << "Anketten!!!\n";

      torus =
	ank_torus(TorusDialog.m, TorusDialog.r1, TorusDialog.r2, TorusDialog.w);

      cerr << "Create !!!\n";

      create_torus(XtDisplay(W), W, torus, torus_anknr, pick_id);
    }
  else
    aendere_torus(torus_grobj);

  cerr << "OK erzeugt !!!\n";

  delete_cover_tourus_liste();
  cerr << "delete_cover_tourus_liste(); !!!\n";
  /* erst hier!!! */
  WObjDialog = NULL;

  XtUnmanageChild(WTorusDialog);
  cerr << "XtUnmanageChild(WTorusDialog) !!!\n";

  WTorusDialog = NULL;
}

void
CBTorusCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  delete_cover_tourus_liste();
  XtUnmanageChild(WTorusDialog);
  /*  erst hier!!! */
  WObjDialog = NULL;
  WTorusDialog = NULL;
}

void
CBTorusHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helptorusdialog);
  else
    infobox("helpnureinmal");
}

void
CBTorusCover(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  TorusDialog.nrcover = (((XmListCallbackStruct *) pCallData)->item_position) - 1;
  sprintf(cpos, "%ld", TorusDialog.nrcover);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(TorusCoverLabel, &Aargs, 1);
  strcpy(TorusDialog.coverlabel, cpos);
}

void
create_torus_listen(void)
{
  char str[256];
  longint x = 0, anzelem = 0;

  /* CoverListe */
  if (coveranf)
    {
      coverx = coveranf;
      while (coverx)
	{
	  anzelem = coverx->nr;
	  coverx = coverx->next;
	}
      TorusDialog.anzcover = anzelem + 1;
      TorusDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      coverx = coveranf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      TorusDialog.pCoverStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (coverx)
	{
	  sprintf(str, "%ld: Cover", coverx->nr);	/* C String erzeugen */
	  TorusDialog.pCoverStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  coverx = coverx->next;
	  x++;
	}
    }
  else
    {
      /* nur Dummy */
      TorusDialog.anzcover = 1;
      TorusDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString));
      strcpy(str, "0: keine");
      TorusDialog.pCoverStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }
}

void
torusdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art)
{
  Widget WButtonOK, WButtonPick, WButtonCancel, WButtonHelp, WRowCol1,
    WRowCol2, WRowCol3, WRowCol4, frame1, frame2, WLabel, WCoverList;

  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];

  TorusArt = art;
  torus_anknr = ank_nr;
  torus_grobj = grobjp;

  if (TorusArt == AENDERN)
    {
      ((cadtorus *) (torus_grobj->objp))->
	get(&TorusDialog.m, &TorusDialog.r1, &TorusDialog.r2, &TorusDialog.w);
      // zustzlich
      TorusDialog.nrcover = torus_grobj->cover;
    }
  else
    TorusDialog_init(0L, vector(0.0, 0.0, 0.0), 0.3, 0.1, vector(0.0, 0.0, 0.0));

  /* Strings fr Listen Aufbauen */
  create_torus_listen();

  WTorusDialog = XmCreateDialogShell(W, "torusdialog", NULL, 0);
  XtManageChild(WTorusDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 350);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 340);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WTorusDialog, "torusrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("torusframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "torusrow2", NULL, 0);
  XtManageChild(WRowCol2);

  WLabel = XtCreateManagedWidget("Vektor x;y;z :", xmLabelWidgetClass, WRowCol2, NULL, 0);

  sprintf(str, "%0.2f;%0.2f;%0.2f", TorusDialog.m.x, TorusDialog.m.y, TorusDialog.m.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  TorusWText1 = XtCreateManagedWidget("torusm", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f", TorusDialog.r1, TorusDialog.r2);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  TorusWText2 = XtCreateManagedWidget("torusr", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f", TorusDialog.w.x, TorusDialog.w.y, TorusDialog.w.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  TorusWText3 = XtCreateManagedWidget("torusw", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  /* Cover Auswahl */
  frame2 = XtCreateManagedWidget("toruscoverf", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol4 = XmCreateRowColumn(frame2, "torusc4", NULL, 0);
  XtManageChild(WRowCol4);

  sprintf(str, "%ld", TorusDialog.nrcover);
  TorusCoverLabel = XtCreateManagedWidget(str, xmLabelWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, TorusDialog.pCoverStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, TorusDialog.anzcover);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 4);
  nArgs++;
  WCoverList = XmCreateScrolledList(WRowCol4, "toruscover", Aargs, nArgs);
  XtAddCallback(WCoverList, XmNdefaultActionCallback, (XtCallbackProc) CBTorusCover, NULL);
  XtManageChild(WCoverList);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "torusrow3", Aargs, nArgs);
  // XtManageChild(WRowCol3);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonPick);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);
  XtManageChild(WRowCol3);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBTorusOk, NULL);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBTorusCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBTorusHelp, NULL);
}
