/*  
   Dialogbox fr Texture

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"

STRING helptexturdialog =
"Definition einer Pixmap-Textur.";
struct texturestruktur TextDialog;
Widget WTexturDialog, Texturedateiname, Texturename;
int TextDialogArt;

void
TextDialog_init(float Prozent, char *Dateiname, char *Name)
{
  TextDialog.prozent = Prozent;
  strcpy(TextDialog.dateiname, Dateiname);
  strcpy(TextDialog.name, Name);
}

void
TextDialog_get(float *Prozent, char *Dateiname, char *Name)
{
  *Prozent = TextDialog.prozent;
  strcpy(Dateiname, TextDialog.dateiname);
  strcpy(Name, TextDialog.name);
}

void
CBTextOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;

  /* Text Widgets auslesen */
  str = XmTextGetString(Texturedateiname);
  sscanf(str, "%s", TextDialog.dateiname);
  // XmStringFree((XmString)str);

  str = XmTextGetString(Texturename);
  sscanf(str, "%s", TextDialog.name);
  // XmStringFree((XmString)str);

  if (TextDialogArt == NEU)
    ank_texturen(TextDialog.prozent, TextDialog.dateiname, TextDialog.name);
  else if (TextDialogArt == AENDER)
    TextDialog_get(&textx->prozent, textx->dname, textx->name);

  /* Dialog schlieen */
  XtUnmanageChild(WTexturDialog);
  WTexturDialog = NULL;
}

void
CBTextCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  XtUnmanageChild(WTexturDialog);
  WTexturDialog = NULL;
}

void
CBTextHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helptexturdialog);
  else
    infobox("helpnureinmal");
}

void
CBTextScaleCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  TextDialog.prozent = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
}

void
texturdialog(Widget W, int art)
{
  Widget WButtonOK, WButtonCancel, WButtonHelp, WScale, WRowCol1, WRowCol2,
    WRowCol3, WLabel1, WLabel2, frame1;
  Arg Aargs[MAX_ARGS];
  int nArgs;
  XmString mstr;

  TextDialogArt = art;

  /* Der Dialog */
  WTexturDialog = XmCreateDialogShell(W, "textdialog", NULL, 0);
  XtManageChild(WTexturDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 300);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 270);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WTexturDialog, "textrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  /* fr Regler */
  frame1 = XtCreateManagedWidget("textframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "textrow2", NULL, 0);
  XtManageChild(WRowCol2);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNshowValue, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  mstr = XmStringCreateLtoR("Sichtbarkeit", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvalue, TextDialog.prozent * 100.0);
  nArgs++;
  WScale =
    XtCreateManagedWidget("textprozent", xmScaleWidgetClass, WRowCol2, Aargs, nArgs);
  XtAddCallback(WScale, XmNvalueChangedCallback, (XtCallbackProc) CBTextScaleCanged, NULL);

  WLabel1 = XtCreateManagedWidget("Dateiname", xmLabelWidgetClass, WRowCol2, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, TextDialog.dateiname);
  nArgs++;
  Texturedateiname = XtCreateManagedWidget("textdn", xmTextWidgetClass, WRowCol2, Aargs, nArgs);
  WLabel2 = XtCreateManagedWidget("Texture Name", xmLabelWidgetClass, WRowCol2, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, TextDialog.name);
  nArgs++;
  Texturename = XtCreateManagedWidget("texttn", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "textrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBTextOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBTextCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBTextHelp, NULL);
}
