
/*  
   Dialogbox fr Muster

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"

STRING helptext3ddialog =
"Definition eines 3D Texture-Musters.";

struct text3dstruktur Text3dDialog;

Widget WText3dDialog, WText3dname, WText3danz, WText3dabs, WText3dr, WText3dd;
GC Text3dDialogGCFarbe;
int Text3dDialogArt;

void
Text3dDialog_init(float R1, float G1, float B1, float R2, float G2, float B2,
		  float Mix, float Abs, int Art, int Fehler, int Anz,
		  vector D, vector R, char *Name)
{
  Text3dDialog.r1 = R1;
  Text3dDialog.b1 = B1;
  Text3dDialog.g1 = G1;
  Text3dDialog.r2 = R2;
  Text3dDialog.b2 = B2;
  Text3dDialog.g2 = G2;
  Text3dDialog.mix = Mix;
  Text3dDialog.abs = Abs;
  Text3dDialog.art = Art;
  Text3dDialog.fehler = Fehler;
  Text3dDialog.anz = Anz;
  Text3dDialog.d = D;
  Text3dDialog.r = R;
  strcpy(Text3dDialog.name, Name);
}

void
Text3dDialog_get(float *R1, float *G1, float *B1, float *R2, float *G2,
		 float *B2,
		 float *Mix, float *Abs, int *Art, int *Fehler, int *Anz,
		 vector * D, vector * R, char *Name)
{
  *R1 = Text3dDialog.r1;
  *B1 = Text3dDialog.b1;
  *G1 = Text3dDialog.g1;
  *R2 = Text3dDialog.r2;
  *B2 = Text3dDialog.b2;
  *G2 = Text3dDialog.g2;
  *Mix = Text3dDialog.mix;
  *Abs = Text3dDialog.abs;
  *Art = Text3dDialog.art;
  *Fehler = Text3dDialog.fehler;
  *Anz = Text3dDialog.anz;
  *D = Text3dDialog.d;
  *R = Text3dDialog.r;
  strcpy(Name, Text3dDialog.name);
}

void
Text3dFarbealloc(Widget W, int x)
{
  if (Text3dDialog.privat && (x == 1))
    {
      Text3dDialog.XCol1.flags = DoRed | DoGreen | DoBlue;
      Text3dDialog.XCol1.red = (unsigned) (Text3dDialog.r1 * 65535.0);
      Text3dDialog.XCol1.green = (unsigned) (Text3dDialog.g1 * 65535.0);
      Text3dDialog.XCol1.blue = (unsigned) (Text3dDialog.b1 * 65535.0);
      XStoreColor(XtDisplay(W), Text3dDialog.CMap, &Text3dDialog.XCol1);
    }
  else if (Text3dDialog.privat && (x == 2))
    {
      Text3dDialog.XCol2.flags = DoRed | DoGreen | DoBlue;
      Text3dDialog.XCol2.red = (unsigned) (Text3dDialog.r2 * 65535.0);
      Text3dDialog.XCol2.green = (unsigned) (Text3dDialog.g2 * 65535.0);
      Text3dDialog.XCol2.blue = (unsigned) (Text3dDialog.b2 * 65535.0);
      XStoreColor(XtDisplay(W), Text3dDialog.CMap, &Text3dDialog.XCol2);
    }
  if (!Text3dDialog.privat && (x == 1))
    {
      Text3dDialog.XCol1.flags = DoRed | DoGreen | DoBlue;
      Text3dDialog.XCol1.red = (unsigned) (Text3dDialog.r1 * 65535.0);
      Text3dDialog.XCol1.green = (unsigned) (Text3dDialog.g1 * 65535.0);
      Text3dDialog.XCol1.blue = (unsigned) (Text3dDialog.b1 * 65535.0);
      XAllocColor(XtDisplay(W), Text3dDialog.CMap, &Text3dDialog.XCol1);
    }
  else if (!Text3dDialog.privat && (x == 2))
    {
      Text3dDialog.XCol2.flags = DoRed | DoGreen | DoBlue;
      Text3dDialog.XCol2.red = (unsigned) (Text3dDialog.r2 * 65535.0);
      Text3dDialog.XCol2.green = (unsigned) (Text3dDialog.g2 * 65535.0);
      Text3dDialog.XCol2.blue = (unsigned) (Text3dDialog.b2 * 65535.0);
      XAllocColor(XtDisplay(W), Text3dDialog.CMap, &Text3dDialog.XCol2);
    }
}

void
Text3dFarbanzeige(int x)
{
  if (Text3dDialog.Win && (x == 1))
    {
      XSetForeground(Text3dDialog.pD, Text3dDialogGCFarbe, Text3dDialog.XCol1.pixel);
      XFillRectangle(Text3dDialog.pD, Text3dDialog.Win, Text3dDialogGCFarbe, 1, 1, 150, 70);
    }
  else if (Text3dDialog.Win && (x == 2))
    {
      XSetForeground(Text3dDialog.pD, Text3dDialogGCFarbe, Text3dDialog.XCol2.pixel);
      XFillRectangle(Text3dDialog.pD, Text3dDialog.Win, Text3dDialogGCFarbe, 1, 1, 150, 70);
    }
}

void
CBText3dFarbanzeige(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  Text3dDialog.Win = ((XmDrawingAreaCallbackStruct *) pCallData)->window;
  if (Text3dDialog.Win != 0)
    {
      Text3dDialog.pD = XtDisplay(W);
      XSetForeground(Text3dDialog.pD, Text3dDialogGCFarbe, Text3dDialog.XCol1.pixel);
      XFillRectangle(Text3dDialog.pD, Text3dDialog.Win, Text3dDialogGCFarbe, 1, 1, 150, 70);
    }
}

void
CBText3dScaleCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case 1:
      Text3dDialog.r1 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      Text3dFarbealloc(W, 1);
      Text3dFarbanzeige(1);
      break;
    case 2:
      Text3dDialog.g1 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      Text3dFarbealloc(W, 1);
      Text3dFarbanzeige(1);
      break;
    case 3:
      Text3dDialog.b1 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      Text3dFarbealloc(W, 1);
      Text3dFarbanzeige(1);
      break;
    case 4:
      Text3dDialog.r2 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      Text3dFarbealloc(W, 2);
      Text3dFarbanzeige(2);
      break;
    case 5:
      Text3dDialog.g2 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      Text3dFarbealloc(W, 2);
      Text3dFarbanzeige(2);
      break;
    case 6:
      Text3dDialog.b2 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      Text3dFarbealloc(W, 2);
      Text3dFarbanzeige(2);
      break;
    default:
      fprintf(stderr, "Text3dRegler %d\n", *(int *) pClientData);
    }
}

void
CBText3dOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  String str;

  /* Text Widgets auslesen */
  str = XmTextGetString(WText3dname);
  sscanf(str, "%s", Text3dDialog.name);

  str = XmTextGetString(WText3danz);
  sscanf(str, "%d", &Text3dDialog.anz);

  str = XmTextGetString(WText3dabs);
  sscanf(str, "%f", &Text3dDialog.abs);

  str = XmTextGetString(WText3dd);
  sscanf(str, "%f;%f;%f", &Text3dDialog.d.x, &Text3dDialog.d.y, &Text3dDialog.d.z);

  str = XmTextGetString(WText3dr);
  sscanf(str, "%f;%f;%f", &Text3dDialog.r.x, &Text3dDialog.r.y, &Text3dDialog.r.z);

  // Bei allen Dialogen sollte nur die Struktur bergeben werden
  if (Text3dDialogArt == NEU)
    ank_text3d(Text3dDialog.r1, Text3dDialog.b1, Text3dDialog.g1,
	       Text3dDialog.r2, Text3dDialog.b2, Text3dDialog.g2,
	       Text3dDialog.mix, Text3dDialog.abs, Text3dDialog.art,
	       Text3dDialog.fehler, Text3dDialog.anz, Text3dDialog.d,
	       Text3dDialog.r, Text3dDialog.name);
  else if (Text3dDialogArt == AENDER)
    Text3dDialog_get(&text3dx->r1, &text3dx->b1, &text3dx->g1,
		     &text3dx->r2, &text3dx->b2, &text3dx->g2,
		     &text3dx->mix, &text3dx->abs, &text3dx->art,
		     &text3dx->fehler, &text3dx->anz, &text3dx->d,
		     &text3dx->r, text3dx->name);

  /* Farbe freigeben */
  if (Text3dDialog.privat)
    XFreeColors(Text3dDialog.pD, Text3dDialog.CMap, &Text3dDialog.XCol1.pixel, 1, 0);

  /* Dialog schlieen */
  XtUnmanageChild(WText3dDialog);
  WText3dDialog = NULL;
}

void
CBText3dCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* Farbe freigeben */
  if (Text3dDialog.privat)
    XFreeColors(Text3dDialog.pD, Text3dDialog.CMap, &Text3dDialog.XCol1.pixel, 1, 0);

  XtUnmanageChild(WText3dDialog);
  WText3dDialog = NULL;
}

void
CBText3dHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helptext3ddialog);
  else
    infobox("helpnureinmal");
}

void
CBText3dProzent(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  Text3dDialog.mix = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
}

void
CBText3dRandom(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  Text3dDialog.fehler = ((XmToggleButtonCallbackStruct *) pCallData)->set;
}

void
CBText3dButtonM(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /*  nur einschalten ist interresant */
  if (((XmToggleButtonCallbackStruct *) pCallData)->set)
    Text3dDialog.art = *(int *) pClientData;
}

void
text3ddialog(Widget W, int art)
{
  unsigned long pixel;
  char xystr[256];
  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    WRowCol4, WRowCol6, WRowCol7, WRowCol8, WScale[6], frame1, frame2,
    frame4, frame5, frame6, frame7, Wdrawarea, WLabel1, WLabel2, WLabel3,
    WLabel4, WLabel5, WProzent, WRandom, WRadioBoxM, AWButtonM[6];

  /* Definitionen */
  static int AiButtonID[] =
  {KUGELM, ZYLINDERM};

  /* Definitionen */
  STRING AIScale[] =
  {"text3dr1", "text3dr2", "text3dr3", "text3dr4", "text3dr5", "text3dr6"};
  static int AIScaleID[] =
  {1, 2, 3, 4, 5, 6};

  int nScale;
  int maxScale = 6, nArgs, i;
  Arg Aargs[MAX_ARGS];
  XmString mstr;

  Text3dDialogArt = art;
  /* Der Dialog */
  WText3dDialog = XmCreateDialogShell(W, "text3ddialog", NULL, 0);
  XtManageChild(WText3dDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 725);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 400);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WText3dDialog, "text3drow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  /* fr Regler */
  frame2 = XtCreateManagedWidget("text3dframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(frame2, "text3drow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  /* Scalen */
  for (nScale = 0; nScale < maxScale; nScale++)
    {
      nArgs = 0;
      if (nScale == 0)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Rot1", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, Text3dDialog.r1 * 100.0);
	}
      else if (nScale == 1)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Grn1", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, Text3dDialog.g1 * 100.0);
	}
      else if (nScale == 2)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Blau1", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, Text3dDialog.b1 * 100.0);
	}
      else if (nScale == 3)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Rot2", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, Text3dDialog.r2 * 100.0);
	}
      else if (nScale == 4)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Grn2", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, Text3dDialog.g2 * 100.0);
	}
      else if (nScale == 5)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Blau2", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, Text3dDialog.b2 * 100.0);
	}

      nArgs++;
      WScale[nScale] =
	XtCreateManagedWidget(AIScale[nScale], xmScaleWidgetClass, WRowCol2, Aargs, nArgs);
      XtAddCallback(WScale[nScale], XmNvalueChangedCallback,
		    CBText3dScaleCanged, &AIScaleID[nScale]);
    }

  /*  Farbanzeigen */
  Text3dDialog.pD = XtDisplay(WTop);
  Text3dDialog.CMap = DefaultColormap(Text3dDialog.pD, DefaultScreen(Text3dDialog.pD));
  Text3dDialog.privat = true;
  if (XAllocColor(Text3dDialog.pD, Text3dDialog.CMap, &Text3dDialog.XCol1))
    {
      Text3dDialog.privat = false;
      Text3dFarbealloc(WTop, 1);
      Text3dDialog.XCol2 = Text3dDialog.XCol1;
      Text3dFarbealloc(WTop, 2);
    }
  else if (!XAllocColorCells(Text3dDialog.pD, Text3dDialog.CMap, false, NULL, 0, &pixel, 1))
    {
      Text3dDialog.privat = false;
      infobox("ke	inefarbzelle");
    }
  if (Text3dDialog.privat)
    {
      Text3dDialog.XCol1.pixel = pixel;
      Text3dFarbealloc(WTop, 1);
      Text3dDialog.XCol2.pixel = pixel;
      Text3dFarbealloc(WTop, 2);
    }

  frame4 = XtCreateManagedWidget("text3dframe4", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNadjustLast, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNmarginWidth, 20);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNspacing, 20);
  nArgs++;
  WRowCol6 = XmCreateRowColumn(frame4, "text3drow6", Aargs, nArgs);
  XtManageChild(WRowCol6);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 20);
  nArgs++;

  frame5 = XtCreateManagedWidget("text3dframe5", xmFrameWidgetClass, WRowCol6, Aargs, nArgs);
  Wdrawarea =
    XtCreateManagedWidget("text3ddrawcol", xmDrawingAreaWidgetClass, frame5, Aargs, nArgs);
  /* Callbacks um neu zu zeichnen */
  XtAddCallback(Wdrawarea, XmNexposeCallback, (XtCallbackProc) CBText3dFarbanzeige, NULL);
  XtAddCallback(Wdrawarea, XmNresizeCallback, (XtCallbackProc) CBText3dFarbanzeige, NULL);

  /* GC erzeugen um zeichnen zu knnen */
  Text3dDialogGCFarbe = CreateSimpleGC(Wdrawarea);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNshowValue, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
  nArgs++;
  mstr = XmStringCreateLtoR("Sicht:", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvalue, Text3dDialog.mix * 100.0);
  nArgs++;
  /* in Prozent die Sichtbarkeit */
  WProzent = XtCreateManagedWidget("text3dsicht", xmScaleWidgetClass, WRowCol6, Aargs, nArgs);
  XtAddCallback(WProzent, XmNvalueChangedCallback, (XtCallbackProc) CBText3dProzent, NULL);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, Text3dDialog.fehler);
  nArgs++;
  WRandom =
    XtCreateManagedWidget("Ausflle", xmToggleButtonWidgetClass, WRowCol6, Aargs, nArgs);
  XtAddCallback(WRandom, XmNvalueChangedCallback, (XtCallbackProc) CBText3dRandom, NULL);

  frame1 = XtCreateManagedWidget("text3dframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol4 = XmCreateRowColumn(frame1, "text3drow4", NULL, 0);
  XtManageChild(WRowCol4);

  /*  Welches Muster */
  /* RadioBox erzeugen die Togglebuttons als Kinder hat */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNentryClass, xmToggleButtonWidgetClass);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRadioBoxM = XmCreateRadioBox(WRowCol4, "text3dradioboxm", Aargs, nArgs);
  XtManageChild(WRadioBoxM);

  /* 6 Togglebuttons erzeugen */
  i = 0;
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, Text3dDialog.art == BLANK);
  nArgs++;
  AWButtonM[i++] =
    XtCreateManagedWidget("Kugel", xmToggleButtonWidgetClass, WRadioBoxM, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, Text3dDialog.art == KAROS);
  nArgs++;
  AWButtonM[i++] =
    XtCreateManagedWidget("Zylinder", xmToggleButtonWidgetClass, WRadioBoxM, Aargs, nArgs);


  /* Callbacks fr alle Buttons */
  for (i = 0; i < 2; i++)
    XtAddCallback(AWButtonM[i], XmNvalueChangedCallback, (XtCallbackProc) CBText3dButtonM, &AiButtonID[i]);

  frame6 = XtCreateManagedWidget("text3dframe6", xmFrameWidgetClass, WRowCol4, NULL, 0);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol7 = XmCreateRowColumn(frame6, "text3drow7", Aargs, nArgs);
  XtManageChild(WRowCol7);

  WLabel2 = XtCreateManagedWidget("Name:", xmLabelWidgetClass, WRowCol7, NULL, 0);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, Text3dDialog.name);
  nArgs++;
  WText3dname = XtCreateManagedWidget("text3ddn", xmTextWidgetClass, WRowCol7, Aargs, nArgs);

  WLabel3 = XtCreateManagedWidget("Anz:", xmLabelWidgetClass, WRowCol7, NULL, 0);
  sprintf(xystr, "%d", Text3dDialog.anz);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, xystr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  WText3danz = XtCreateManagedWidget("text3danz", xmTextWidgetClass, WRowCol7, Aargs, nArgs);

  WLabel1 = XtCreateManagedWidget("Abs:", xmLabelWidgetClass, WRowCol7, NULL, 0);
  sprintf(xystr, "%0.2f", Text3dDialog.abs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, xystr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  WText3dabs = XtCreateManagedWidget("text3dabs", xmTextWidgetClass, WRowCol7, Aargs, nArgs);

  frame7 = XtCreateManagedWidget("text3dframe7", xmFrameWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol8 = XmCreateRowColumn(frame7, "text3drow8", Aargs, nArgs);
  XtManageChild(WRowCol8);

  WLabel4 = XtCreateManagedWidget("d:", xmLabelWidgetClass, WRowCol8, NULL, 0);
  sprintf(xystr, "%0.2f;%0.2f;%0.2f", Text3dDialog.d.x, Text3dDialog.d.y, Text3dDialog.d.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, xystr);
  nArgs++;
  WText3dd = XtCreateManagedWidget("text3dd", xmTextWidgetClass, WRowCol8, Aargs, nArgs);

  WLabel5 = XtCreateManagedWidget("r:", xmLabelWidgetClass, WRowCol8, NULL, 0);
  sprintf(xystr, "%0.2f;%0.2f;%0.2f", Text3dDialog.r.x, Text3dDialog.r.y, Text3dDialog.r.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, xystr);
  nArgs++;
  WText3dr = XtCreateManagedWidget("text3dr", xmTextWidgetClass, WRowCol8, Aargs, nArgs);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "text3drow3", Aargs, nArgs);
  XtManageChild(WRowCol3);
  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBText3dOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBText3dCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBText3dHelp, NULL);
}
