/*  
   Dialogbox fr Strahler-Lichtquellendefinition und 

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

#define PAINTY 50
#define PAINTX 550

STRING helpstrahlerdialog =

"Definition einer gerichteten Lichtquelle.\nFarbe der Lichtquelle, Vektor und Intensitaet.";

struct strahlerstruktur StrahlerDialog;
GC StrahlerDialogGCFarbe;
char StrahlerDialogArt;
Widget WStrahlerDialog, WPosition, WRichtung, WWinkel;

void
StrahlerDialog_init(float R, float B, float G, float Intens,
		    vector Pos, vector Richtung, float Winkel)
{
  StrahlerDialog.r = R;
  StrahlerDialog.b = B;
  StrahlerDialog.g = G;
  StrahlerDialog.intens = Intens;
  StrahlerDialog.pos = Pos;
  StrahlerDialog.richtung = Richtung;
  StrahlerDialog.winkel = Winkel;
}

void
StrahlerDialog_get(float *R, float *B, float *G, float *Intens,
		   vector * Pos, vector * Richtung, float *Winkel)
{
  *R = StrahlerDialog.r;
  *B = StrahlerDialog.b;
  *G = StrahlerDialog.g;
  *Intens = StrahlerDialog.intens;
  *Pos = StrahlerDialog.pos;
  *Richtung = StrahlerDialog.richtung;
  *Winkel = StrahlerDialog.winkel;
}

void
StrahlerFarbealloc(Widget W)
{
  StrahlerDialog.XCol.flags = DoRed | DoGreen | DoBlue;
  StrahlerDialog.XCol.red = (unsigned) (StrahlerDialog.r * 65535.0);
  StrahlerDialog.XCol.green = (unsigned) (StrahlerDialog.g * 65535.0);
  StrahlerDialog.XCol.blue = (unsigned) (StrahlerDialog.b * 65535.0);

  if (StrahlerDialog.privat)
    XStoreColor(XtDisplay(W), StrahlerDialog.CMap, &StrahlerDialog.XCol);
  else
    XAllocColor(XtDisplay(W), StrahlerDialog.CMap, &StrahlerDialog.XCol);
}

void
StrahlerFarbanzeige()
{
  if (StrahlerDialog.Win)
    {
      XSetForeground(StrahlerDialog.pD, StrahlerDialogGCFarbe, StrahlerDialog.XCol.pixel);
      XFillRectangle(StrahlerDialog.pD, StrahlerDialog.Win, StrahlerDialogGCFarbe, 1, 1, PAINTX, PAINTY);
    }
}

void
CBStrahlerFarbanzeige(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  StrahlerDialog.Win = ((XmDrawingAreaCallbackStruct *) pCallData)->window;
  if (StrahlerDialog.Win != 0)
    {
      StrahlerDialog.pD = XtDisplay(W);
      XSetForeground(StrahlerDialog.pD, StrahlerDialogGCFarbe, StrahlerDialog.XCol.pixel);
      XFillRectangle(StrahlerDialog.pD, StrahlerDialog.Win,
		     StrahlerDialogGCFarbe, 1, 1, PAINTX, PAINTY);
    }
}

void
erz_strahler(vector point, vector richtung, longint nr)
{
  vector r;
  PEXCoord lp;
  PEXCoord rv[2];

  // Lichtquelle in der Struktur erzeugen
  PEXSetEditingMode(pDisplay, strahler_struct, PEXStructureInsert);
  PEXSetElementPtr(pDisplay, strahler_struct, PEXEnd, 0);

  SET_VECTA(point, lp);
  SET_VECTA(point, rv[0]);

  // Polymarker
  PEXSetMarkerType(pDisplay, strahler_struct, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(pDisplay, strahler_struct, PEXOCStore, 3.0);
  PEXSetMarkerColor(pDisplay, strahler_struct, PEXOCStore, PEXColorTypeRGB, &echo_color);
  PEXLabel(pDisplay, strahler_struct, PEXOCStore, (long) nr);
  PEXMarkers(pDisplay, strahler_struct, PEXOCStore, 1, &lp);

  // Richtungsvektor anzeigen
  r |= richtung;
  r *= 0.1;
  r += point;
  SET_VECTA(r, rv[1]);
  PEXPolyline(pDisplay, strahler_struct, PEXOCStore, 2, rv);
}

void
aender_strahler(vector point, vector richtung, float winkel, longint nr)
{
  vector r;
  PEXCoord lp;
  PEXCoord rv[2];

  // Lichtquelle in der Struktur erzeugen
  PEXSetEditingMode(pDisplay, strahler_struct, PEXStructureReplace);
  PEXSetElementPtr(pDisplay, strahler_struct, PEXBeginning, 0);

  PEXSetElementPtrAtLabel(pDisplay, strahler_struct, (long) nr, 1);

  SET_VECTA(point, lp);
  SET_VECTA(point, rv[0]);
  PEXMarkers(pDisplay, strahler_struct, PEXOCStore, 1, &lp);

  // Richtungsvektor anzeigen
  r |= richtung;
  r *= 0.1;
  r += point;
  SET_VECTA(r, rv[1]);
  PEXPolyline(pDisplay, strahler_struct, PEXOCStore, 2, rv);

  // Polymarker neu zeichnen
  redraw(True);
}

void
CBStrahlerOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  float x, y, z;
  STRING str;
  longint nr;

  /* Text Widgets auslesen */
  str = XmTextGetString(WPosition);
  sscanf(str, "%f;%f;%f", &x, &y, &z);
  StrahlerDialog.pos = vector(x, y, z);

  str = XmTextGetString(WRichtung);
  sscanf(str, "%f;%f;%f", &x, &y, &z);
  StrahlerDialog.richtung = vector(x, y, z);

  str = XmTextGetString(WWinkel);
  sscanf(str, "%f", &StrahlerDialog.winkel);

  /* neuen Strahler anketten? */
  if (StrahlerDialogArt == NEU)
    {
      nr = ank_strahler(StrahlerDialog.r, StrahlerDialog.g, StrahlerDialog.b,
			StrahlerDialog.intens,
	StrahlerDialog.pos, StrahlerDialog.richtung, StrahlerDialog.winkel);
      erz_strahler(StrahlerDialog.pos, StrahlerDialog.richtung, nr);
    }
  else
    {
      if (StrahlerDialogArt == AENDER)
	{
	  StrahlerDialog_get(&strahlerx->r, &strahlerx->b, &strahlerx->g, &strahlerx->s,
		 &strahlerx->pos, &strahlerx->richtung, &strahlerx->winkel);
	  aender_strahler(strahlerx->pos, strahlerx->richtung, strahlerx->winkel, strahlerx->nr);
	}
    }

  /* Farbe freigeben */
  if (StrahlerDialog.privat)
    XFreeColors(StrahlerDialog.pD, StrahlerDialog.CMap, &StrahlerDialog.XCol.pixel, 1, 0);

  XtUnmanageChild(WStrahlerDialog);
  WStrahlerDialog = NULL;
}

void
CBStrahlerCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* Farbe freigeben */
  if (StrahlerDialog.privat)
    XFreeColors(StrahlerDialog.pD, StrahlerDialog.CMap, &StrahlerDialog.XCol.pixel, 1, 0);

  XtUnmanageChild(WStrahlerDialog);
  WStrahlerDialog = NULL;
}

void
CBStrahlerHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpstrahlerdialog);
  else
    infobox("helpnureinmal");
}

void
CBStrahlerScaleCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case 1:
      StrahlerDialog.r = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 2:
      StrahlerDialog.g = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 3:
      StrahlerDialog.b = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 4:
      StrahlerDialog.intens = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 10.0;
      break;
    default:
      fprintf(stderr, "StrahlerRegler %d\n", *(int *) pClientData);
    }
  StrahlerFarbealloc(W);
  StrahlerFarbanzeige();
}

void
strahlerdialog(Widget W, int art)
{
  unsigned long pixel;

  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    WRowCol4, WScale[4], frame1, frame2, frame3, Wdrawarea, WLabel, WLabelPunkt,
    WLabelRichtung, WLabelWinkel;

  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];

  /* Definitionen */
  STRING AIScale[] =
  {"strahlerr1", "strahlerr2", "strahlerr3", "strahlerr4"};
  XmString mstr;

  static int AIScaleID[] =
  {
    1, 2, 3, 4
  };

  int nScale;
  int maxScale = 4;

  StrahlerDialogArt = art;

  /* Der Dialog */
  WStrahlerDialog = XmCreateDialogShell(W, "strahlerdialog", NULL, 0);
  XtManageChild(WStrahlerDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 350);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 505);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WStrahlerDialog, "strahlerdrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("strahlerframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNnumColumns, 1);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(frame1, "strahlerdrow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  frame2 = XtCreateManagedWidget("strahlerframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(frame2, "strahlerdrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol4 = XmCreateRowColumn(WRowCol1, "strahlerdrow4", Aargs, nArgs);
  XtManageChild(WRowCol4);

  /* Scalen */
  for (nScale = 0; nScale < maxScale; nScale++)
    {
      nArgs = 0;
      if (nScale == 0)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("R", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, StrahlerDialog.r * 100.0);
	}
      else if (nScale == 1)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("G", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, StrahlerDialog.g * 100.0);
	}
      else if (nScale == 2)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("B", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, StrahlerDialog.b * 100.0);
	}
      else if (nScale == 3)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNmaximum, 100);
	  nArgs++;
	  mstr = XmStringCreateLtoR("S", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, StrahlerDialog.intens * 10.0);
	}

      nArgs++;
      WScale[nScale] =
	XtCreateManagedWidget(AIScale[nScale], xmScaleWidgetClass, WRowCol2, Aargs, nArgs);

      XtAddCallback(WScale[nScale], XmNvalueChangedCallback,
		    CBStrahlerScaleCanged, (caddr_t) & AIScaleID[nScale]);
    }

  /* Farbanzeige */
  WLabel = XtCreateManagedWidget("Farbe:", xmLabelWidgetClass, WRowCol3, NULL, 0);
  frame3 = XtCreateManagedWidget("strahlerframe3", xmFrameWidgetClass, WRowCol3, NULL, 0);

  /* Fr Farbnderung eine ColorCell holen */
  StrahlerDialog.pD = XtDisplay(WTop);
  StrahlerDialog.CMap = DefaultColormap(StrahlerDialog.pD, DefaultScreen(StrahlerDialog.pD));
  StrahlerDialog.privat = true;
  if (XAllocColor(StrahlerDialog.pD, StrahlerDialog.CMap, &StrahlerDialog.XCol))
    {
      StrahlerDialog.privat = false;
      StrahlerFarbealloc(WTop);
    }
  else if (!XAllocColorCells(StrahlerDialog.pD, StrahlerDialog.CMap, false, NULL, 0, &pixel, 1))
    {
      StrahlerDialog.privat = false;
      infobox("keinefarbzelle");
    }
  if (StrahlerDialog.privat)
    {
      StrahlerDialog.XCol.pixel = pixel;
      StrahlerFarbealloc(WTop);
    }
  Wdrawarea = XtCreateManagedWidget("strahlerdrawcol", xmDrawingAreaWidgetClass, frame3, NULL, 0);
  /* Callbacks um neu zu zeichnen */
  XtAddCallback(Wdrawarea, XmNexposeCallback, CBStrahlerFarbanzeige, NULL);
  XtAddCallback(Wdrawarea, XmNresizeCallback, CBStrahlerFarbanzeige, NULL);

  /* GC erzeugen um zeichnen zu knnen */
  StrahlerDialogGCFarbe = CreateSimpleGC(Wdrawarea);

  WLabelPunkt = XtCreateManagedWidget("Punkt:", xmLabelWidgetClass, WRowCol3, NULL, 0);
  sprintf(str, "%0.2f;%0.2f;%0.2f",
	  StrahlerDialog.pos.x, StrahlerDialog.pos.y, StrahlerDialog.pos.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 14);
  nArgs++;
  WPosition = XtCreateManagedWidget("strahlerpos", xmTextWidgetClass, WRowCol3, Aargs, nArgs);

  WLabelRichtung = XtCreateManagedWidget("Richtung:", xmLabelWidgetClass, WRowCol3, NULL, 0);
  sprintf(str, "%0.2f;%0.2f;%0.2f",
	  StrahlerDialog.richtung.x, StrahlerDialog.richtung.y, StrahlerDialog.richtung.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  WRichtung = XtCreateManagedWidget("strahlerrichtung",
				 xmTextWidgetClass, WRowCol3, Aargs, nArgs);

  WLabelWinkel =
    XtCreateManagedWidget("ffungswinkel:", xmLabelWidgetClass, WRowCol3, NULL, 0);
  sprintf(str, "%0.2f", StrahlerDialog.winkel);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  WWinkel = XtCreateManagedWidget("strahlerwinkel",
				  xmTextWidgetClass, WRowCol3, Aargs, nArgs);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, CBStrahlerOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, CBStrahlerCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, CBStrahlerHelp, NULL);

  /* Daten auf Grundwerte einstellen */
  StrahlerDialog.intens = 10.0;
}
