/*

   skelett.C
   Skelett fr Motif Programme

   Tool - Funktionen fr PEX aus Literatur
   PEXlib Programming Manual  Tom Gaskins

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"
#include "skelett.H"
#include "pextool.H"

/*
 * Application Class, diese Klasse ist wichtig fr das Resourcemanagement
 * dieser Name ist auch gleichzeitig der Dateiname, aus dem versucht wird
 * die Resourcen zu lesen.
 */


int
main(int argc, char **argv)
{
  static Atom delete_window_atom;
  char error[80];
  PEXColorApproxEntry capx_info;
  XStandardColormap stdcmap;

  XSetWindowAttributes wattrs;

  XtToolkitInitialize();	/* Initialisierung der Intrinsics */
  context = XtCreateApplicationContext();

#ifdef X11R4
  /* hier fallback resources laden, wenn ntig und X11R4 vorhanden */
#endif

  pDisplay = XtOpenDisplay(context,
			   NULL,	/* Display durch User */
			   NULL, APP_CLASS,	/* Name und Klasse    */
			   NULL, 0,	/* mehr Argumente     */
			   &argc, argv);	/* aus Kommandozeile  */
  if (pDisplay == NULL)
    {
      fprintf(stderr, "%s: Kann Display nicht ffnen!\n", argv[0]);
      exit(1);
    }

  if (PEXInitialize(pDisplay, &pexinfo, 80, error))
    {
      fprintf(stderr, "Keine PEX Extension.\n");
      fprintf(stderr, "%s\n", error);
      exit(1);
    }


  WTop = XtAppCreateShell(argv[0], APP_CLASS, applicationShellWidgetClass, pDisplay, NULL, 0);

  /* 
   * hier werden die jeweils bentigten Widgets in die Hierarchie eingefuegt 
   */
  CreateApplicationWidgets(WTop);

  XtRealizeWidget(WTop);	/* Anzeige des Widget Baumes */

  /* Set up to use window manager DELETE_WINDOW protocol. */
  /* es werden beim Windowschlieen noch gesichert!! */
  delete_window_atom = XInternAtom(XtDisplay(WTop), "WM_DELETE_WINDOW", true);
  XmAddWMProtocols(WTop, &delete_window_atom, 1);
  XmSetWMProtocolHooks(WTop, delete_window_atom, NULL, NULL, (XtCallbackProc) CBsavemb, NULL);

  /* gebraucht ??? */
  wattrs.backing_store = NotUseful;
  XChangeWindowAttributes(pDisplay, XtWindow(WGdrawarea), CWBackingStore, &wattrs);

  get_standard_colormap(pDisplay, &stdcmap);
  initPEXColors(&capx_info, &stdcmap);

  /* Set up the PEX renderer. */
  if (STRUCTURE_SPT(pexinfo))
    {
      renderer = setup_renderer(pDisplay, XtWindow(WGdrawarea), &capx_info, &PEXattributes);

      /* erzeuge root_struktur */
      create_structure();
    }
  else
    {
      fprintf(stderr, "Strukturen nicht implementiert!\n");
      exit(1);
    }

  /* Eintritt in die Ereignisschleife */
  XtAppMainLoop(context);
}
