/*  
   Dialogbox fr Schrittweite
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"


Widget WSchrittDialog;

STRING
helpschrittweitedialog = "Definition der Schrittweite fr Buttonleiste.";


STRING
XmString2String(XmString XSSource)
{
  STRING szConverted;		/* Ergebnis C String */
  XmStringContext pContext;	/* String Context */
  STRING szString;		/* Teilstring des Gesamt C Strings */
  XmStringCharSet CharSet;	/* Font */
  XmStringDirection Direction;	/* Schreibrichtung */
  Boolean bSeparator;		/* folgt Separator Segment ? */

  szConverted = NULL;
  XmStringInitContext(&pContext, XSSource);

  /*
     * nchstes Stringsegment lesen
   */
  while (XmStringGetNextSegment(pContext, &szString, &CharSet,
				&Direction, &bSeparator))
    {

      if (szConverted)
	{			/* schon etwas umgewandelt, nur anhaengen */
	  szConverted = XtRealloc(szConverted,
				strlen(szConverted) + strlen(szString) + 2);
	  strcat(szConverted, szString);
	}
      else
	{			/* noch kein Umwandlung, neuer String   */
	  szConverted = (STRING) XtMalloc(strlen(szString) + 1);
	  strcpy(szConverted, szString);
	}
      XtFree(szString);

      if (bSeparator)		/* nchstes Segment ist ein Trenner */
	break;
    }
  XmStringFreeContext(pContext);
  return szConverted;
}

void
CBSchrittOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  String str;

  str = XmString2String(((XmSelectionBoxCallbackStruct *) pCallData)->value);
  sscanf(str, "%f", &DrawareaData.schrittw);
  XtUnmanageChild(WSchrittDialog);
  WSchrittDialog = NULL;
}

void
CBSchrittCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  XtUnmanageChild(WSchrittDialog);
  WSchrittDialog = NULL;
}

void
CBSchrittHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpschrittweitedialog);
  else
    infobox("helpnureinmal");
}

void
schrittdialog(Widget W)
{
  Arg Aargs[MAX_ARGS];
  int nArgs;

  char inputline[256];
  XmString schrittwstr, inputstr, cancelstr, helpstr;

  sprintf(inputline, "%0.2f", DrawareaData.schrittw);

  inputstr = XmStringCreateLtoR(inputline, XmSTRING_DEFAULT_CHARSET);
  schrittwstr = XmStringCreateLtoR("Schrittweite:", XmSTRING_DEFAULT_CHARSET);
  cancelstr = XmStringCreateLtoR("Abbruch", XmSTRING_DEFAULT_CHARSET);
  helpstr = XmStringCreateLtoR("Hilfe", XmSTRING_DEFAULT_CHARSET);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNtextString, inputstr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNtextColumns, 4);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNselectionLabelString, schrittwstr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcancelLabelString, cancelstr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNhelpLabelString, helpstr);
  nArgs++;

  WSchrittDialog = XmCreatePromptDialog(W, "schrittprompt", Aargs, nArgs);
  XtManageChild(WSchrittDialog);

  XtAddCallback(WSchrittDialog, XmNokCallback, (XtCallbackProc) CBSchrittOk, NULL);
  XtAddCallback(WSchrittDialog, XmNcancelCallback, (XtCallbackProc) CBSchrittCancel, NULL);
  XtAddCallback(WSchrittDialog, XmNhelpCallback, (XtCallbackProc) CBSchrittHelp, NULL);
}
