#ifndef _RAY_IST_INCLUDE_
#define _RAY_IST_INCLUDE_

/*
   Include fr ray.C

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996 Helmut Fahrion
 */


// Datenstruktur fr Begrenzungsvolumen
#include <unistd.h>		// fr usleep()
#include <stdlib.h>		// fr RAND_MAX
#include <stdio.h>		// fr FILE
#include <time.h>		// fr ctime()
#include <signal.h>		// fr Signalbehandlung SIGTERM

// Multithreadet
#ifdef _REENTRANT
#include <pthread.h>
#endif

// Patches fr Radiosity
#include "defs.H"
#include "patches.H"

// Mathematische Definitionen
#include "vect.H"

class cbyte
{
  public:
  byte r, g, b;
};
class cword
{
  public:
  unsigned short r, g, b;
};

// Forward Deklaration
class world;
class obj;
class tree;
class wave;
class cover;
class ybuffer;
class bezier;
class light;
class lamp;
class spot;


class twopass
{
  public:
  twopass (word X1, word Y1, word X2, word Y2, word S, word P);
  twopass ()
  {
  };
  void twopasscalc (void);	// Startet die Methode

protected:
private:
  void calcradio (void);	// nach Radiosity vorberechnen
  void calcray (void);		// nach Radiosity vorberechnen
  word x1, y1, x2, y2, s, p;	// Bildgeometrie
};

class zbuffer
{
  public:
  zbuffer (word x1, word y1, word x2, word y2, word S, word O);
  ~zbuffer ();

private:
  void ray (tree * ptr);	// Geht den Baum durch
  vector hit (vector point);	// errechnet den Schnittpunkt
  void anzeigen (obj * obj);	// errechnet Einflupolygon

  vector mkdir (int x, int y);
  // Bildet Richtung durch Bildschirm x,y
  void zray (obj * obj, int x, int y);	// Bildet Z-Wert und Farbe

  void calc_background (void);	// fehlenden Punkte den Hintergrund

  word mky (word y)
  {
    return dy - y;
  }				// Dreht y um

  void kammove (vector * point);
  void polyrot (vector * point);
  void sortmin (vector p);
  vector tf (vector p);

  void calccolor (dword index, color col);

  vector p1, p2, p3,		// Punkte des Bildschirmpolygons
    np,				// Normalvektor des Bildschp.
    pt,				// Projektionspunkt
    intmin, intmax, intmin2, intmax2;

  word dx, dy, s, o;
  int hitminx, hitmaxx, hitminy, hitmaxy;

  float *z;
  cbyte *cbuff;

  // Statistik
  dword anzobj;
};

// in der private section kapiert es der compiler nicht!
typedef enum worktyp
{
  create_patches, get_anzahl, init_array
};

class radios
{
public:
  radios(word X1, word Y1, word X2, word Y2, word S, word P, bool diff);
  ~radios() 
  { 
    // wird nicht mehr gebraucht, fr Kameraanimation sind die Farbwerte in den
    // patcharrays der Objekte enthalten, ev. knnen diese auch fr spter auf
    // dem Datentrger gesichert werden (persistente Objekte)
    if (ita)  delete ita; 
  }

  void verteile(void);
  void anzeige(void);

  class iterarray   // die Grundlage der Lichtverteilung
  {
   public:
    obj   *o; // nur Zeiger keine Werte!
    patch *p;
  };

  longint anzpatches;
  // zum Sortieren
  void setmaxarray(longint anza);
  void verteile_licht(longint anza, longint von, longint bis);

private:
  void get_tree(worktyp work, tree * ptr);

  // testzwecke
  void outputarray(void);

  // zum Verteilen
  void verteile_lichtquellen(void);
  void verteile_quellen_lamp(light *la);

  color calc_color(patch * intp, patch * pt, float e, float f);

  void max(patch *p, color c);

  void verteile_treading(longint von, longint bis);  // def in raytreads.C

  iterarray *ita;
  
  longint i;
  bool spek2diff;
  word x1, y1, x2, y2, s, p;
};

class ray
{
  public:
  ray ()
  {
    zmode = false;
  }

  void calc2pass(word x1, word y1, word x2, word y2, word S, word P);	// 2 Pass
  void radiosity(word x1, word y1, word x2, word y2, word S, word P);	// Radiosity
  void radiositybuf(word x1, word y1, word x2, word y2, word S, word P);

  // Optimiertes Raytracing
  void raytraceboxR (word x1, word y1, word x2, word y2, word S, word P);
  void raytracebox (word x1, word y1, word x2, word y2, word s);
  void raytracebuffer (word x1, word y1, word x2, word y2, char *name);

  void rayzbuffer (word x1, word y1, word x2, word y2, word s, word o);

  // errechnet einen Bildpunkt, in screen.C definiert
  float showpoint (word x, word y, world * w, color * col);

  // verfolgt einen Sichtstrahl
  obj *show_trace (tree * ptr, vector point, vector dir,
		   vector * npoint, vector * normal, obj *sobject, float *entf);

  // der eigentliche Raytrace Algorithmus
  float raytrace (vector point, vector dir, word depth, color * col);

  // testet ob der Strahl einen Schnittkrper trifft
  bool hit (obj * o, vector point, vector dir, vector * sr, vector * sn);
  // Hintergrundfarbe
  void bckgrnd (color * col, color backh, color backb, vector dir);

  // berechnet Reflectionsrichtung auf eine Spiegelflche
  void ref_vector (obj * pbj, vector intpt, vector normal, vector dir, vector * ref_dir);
  // berechnet transmittiertende Richtung durch eine durchsichtige Wand
  void trans_vector (obj * pbj, vector intpt, vector normal, vector dir,
		     vector * trans_dir);

  // fr Statistik
  longint anz_erspart;
  longint anz_mehr;

  // fr zbuffer
  obj *zbuffobj;
  bool zmode;			// Falls z-Buffer mit Raytracing


  void oray (word x1, word y1, word x2, word y2);
  word s;

protected:
  // Hilfsfunktionen fr showpoint
  int getfuzzy (int blende, int oentf, float rentf);
  void position (vector * a, vector * b, world * w);
  float showp (word x, word y, world * w, byte alias, color * col);

  // berechnet den lokalen Farbwert des Schnittpunktes des Objektes
  void local_color (obj * obj, vector point, vector dir, vector normal,
		    vector int_point, color * local_col);

  // kombiniert alle Farben zur Gesamtfarbe
  void Combine (color * colour, color * local_col, float local_weight,
		color * ref_col, float ref_weight,
		color * trans_col, float trans_weight);

  // berzieht Objekte mit Texture
  void surfaceCol (color * colour, obj * object, vector intpoint);


private:

#ifdef _REENTRANT
  class raytread
  {
  public:
    raytread(word X1, word Y1, word X2, word Y2, word S);
    raytread(word X1, word Y1, word X2, word Y2, cbyte *cbuff);
  protected:
  private:
    pthread_t th_1,th_2,th_3,th_4;
  };
#endif

  bool testcolors (cbyte c1, cbyte c2, cbyte c3, cbyte c4, cbyte c5);
  void getrcolor (word xp, word yp, word x, word s, cbyte * e, dword *dw);

  cbyte *pbuff;
  color *cbuff;

  // Globale Variable fr Rekurives Fllen der Zeichenflche, nicht mehr als
  // bergabeparameter! oray()
  word x, p;

  // Testet ob Strahl durch ein Objekt hindurchgeht
  bool durchgang (obj * o, obj * last, vector point, vector dir, float entganz,
		  vector * pte, vector * dre);
  void durchgangD (obj * o, vector point, vector dir, bool * durch, bool * schnitt);

  bool testebene (obj * so, vector p);
};

// Texture
class texture
{
  friend world;
  friend ray;

public:
  texture (texture * text, float Mix, word Num)
  {
    next = 0x0;
    // einketten
    if (text)
      text->next = this;
    x = y = 0;
    mix = Mix;
    num = Num;
    map = 0;
  }

   ~texture ()
  {
    delete map;
    delete next;
  }

  void gettexture(color * col, float x, float y, cover * cp, vector tbp);

  word x, y;			// Mae der Map
  color pal[256];		// RGB - Werte fr Palettenfarben
  byte *map;			// Map als Zeiger auf die Palettenfarben als BYTE auslesen!
  float mix;			// [0<=x<=1] Mischung Textur oder Oberflche

protected:
  word num;			// Nummer
  texture *next;
};


// Texture 3D
class texture3d
{
  friend world;
  friend ray;

public:
  texture3d (texture3d * text, word Num, word Objtype, word Anzi, bool Ausf,
	     float Mix, float Abs,
	     vector Gr, vector R, color C1, color C2);
  
  ~texture3d ()
  {
    delete next;
  }

  void gettext (color * col, vector f, vector p);

private:
  color sphere (vector f, vector p);
  color cone (vector f, vector p);
  bool ausfrand (vector v);

  bool ausfall;			// Zufllige Strung des Musters
  word num;			// Nummer
  word objtype;			// Welche Textur (Kugel, Zylinder, u.a.)
  word anzi;			// Anzahl der ineinanderliegenden
  float mix;			// [0<=x<=1] Mischung Textur oder Oberflche
  float abso;			// Abstand von Obj zu Obj
  vector gr, r;			// Mustergre, Richtung
  color c1, c2;			// Farben
  bool ausf[100];		// Ausfallarray
  texture3d *next;
};

// Musterklasse fr solid Texturing
class muster
{
  friend world;

public:
  muster (muster * Mp, byte N, word A, bool R, float Mix,
	  float X, float Y, color C1, color C2);
  ~muster ()
  {
    delete next;
  }

  void getmust (color * col, vector f, vector p);

  float mix;			// % des Farbanteils

private:
  // Musterfunktionen
  color karo (vector f, vector p);
  color line (vector f, vector p);
  color wolk (vector f, vector p);
  color elips (vector f, vector p);
  color apfel (vector f, vector p);
  word apfeli (float cx, float cy, word maxiter);
  color julia (vector f, vector p);
  word juliai (float cx, float cy, word maxiter);

  // Bestimmt Strstellen
  bool ausfrand (float x, float y);

  color pal[344];		// RGB - Werte fr Palettenfarben maxcol^3
  bool ausf[100];		// Ausflle im Muster fr Wolken u.a.
  muster *next;			// Listenpointer
  word num, art, max;		// Musternr., Musterart, Anz. der Iterationen 
  float mx, my;			// Musterwiederholung
  color c1, c2;			// Grundfarbe
  bool ausfall;			// Zufllige Strung des Musters

};

// Ermittelt Gewichte zum Mischen zweier Oberflchen
class turbo
{
public:
  turbo ();

  byte tu;			// Art der Anwendung, auf Muster oder Mischung oder Beides
  bool noise;			// Art der Rauschfunktion noise dnoise
  float t;			// Skalierung der Turbolenz
  byte lvl;			// Anzahl der Frequenzen, fr turb..()

  vector getturbo (vector p);
  float getgturbo (vector p);

private:
  float noise_1 (vector p);
  void noise_3 (vector p, vector * v);
  void dnoise_3 (vector p, vector * v);

  float pts[ANZ_TPTS];		// Punkte fr Zufallszahlen
};

// Einzelwelle fr Obj. Wave
class welle
{
  friend wave;

  welle (welle * wp, vector M, float F, float A, float D, float De)
  {
    m = M;
    f = F;
    a = A;
    d = D;
    de = De;
    // einketten
    if (wp != 0x0)
      wp->next = this;
    next = 0x0;
  }

   ~welle ()
  {
    delete next;
  }

private:
  welle * next;
  vector m;
  float f, a, d, de;
};

// Objekttyp Welle
class wave
{
  friend world;

public:
  wave (wave * wp, byte Num)
  {
    w = 0x0;
    num = Num;
    // einketten
    if (wp != 0x0)
      wp->next = this;
    next = 0x0;
  }

   ~wave ()
  {
    delete next;
    delete w;
  }

  void getnorm (vector * norm, vector i);

protected:
  void setwave (vector M, float F, float A, float D, float De);

  byte num;
  wave *next;
  welle *w, *wl;
};

// Oberflchenstruktur
class cover
{
public:
  cover (cover * CP, longint Nr, float X1, float Y1, float X2, float Y2, 
	 texture * TF, texture * TV, texture * TS, texture * TB, 
	 vector Mfp, 
	 muster * MP, muster * MP2, muster * MS, muster * MB,  
	 byte Tu, byte Lvl, float T, bool N, wave * WP, texture3d * Text3d)
  {
    // einketten
    if (CP != NULL)  CP->next = this;  next = NULL;

    // Bitmap Position
    x1 = X1;
    x2 = X2;
    y1 = Y1;
    y2 = Y2;

    // Texture und Muster
    textcp = TF;
    textvp = TV;
    textsp = TS;
    textbp = TB;

    musterp  = MP;
    musterp2 = MP2;
    mustersp = MS;
    musterbp = MB;

    musterfp = Mfp;

    tb.tu = Tu;
    tb.lvl = Lvl;
    tb.t = T;
    tb.noise = N;

    // Wellen
    wavep = WP;

    // 3D-Texture
    text3d = Text3d;

    // Covernummer
    nr = Nr;
  }

  ~cover ()
  {
    // werden in World gelscht da mehrere Covers auf eine Texture zeigen knnen
    // delete text3d; delete textcp; delete textvp; 
    // delete musterp; delete musterp2; 
    delete next;
  }

  cover   *next;		// Zeiger auf nchstes Cover
  texture *textcp,		// Zeiger auf Texture fr Farben
          *textvp,		// Zeiger auf Texture fr Vektorverschiebung
          *textsp,		// Zeiger auf Texture fr Spiegelung
          *textbp;		// Zeiger auf Texture fr Brechung

  // Hier ev. noch ndern der anderen Optischen Eigenschaften

  muster *musterp,		// Zeiger auf Musterstruktur zur nderung der Oberflche
         *musterp2,		// Zeiger auf Musterstruktur zur nderung des Normalvektors
         *mustersp,		// Zeiger auf Musterstruktur zur nderung der Spiegelung
         *musterbp;		// Zeiger auf Musterstruktur zur nderung der Brechung

  texture3d *text3d;		// 3D Texture, ev. auch fr die nderung des Normalvektors
  wave *wavep;			// Wellen
  longint nr;			// Covernummer
  turbo tb;			// Turbolenzen
  vector musterfp;		// Fupunkt fr Muster, falls Objekt bewegt wird, mu der
  // Fupunkt mit bewegt werden! ansonsten bewegt sich die Texture!

  float x1, y1, x2, y2;		// Position der Bitmap-Texture
};

// Vaterobjekt fr alle Grafischen Objekte
class grobj
{
public:
  // Virtulle Klasse hat virtuellen Destruktor!
  virtual ~ grobj ()
  {
  };

  // Oberflchenfarbe zurckgeben
  virtual void surfaceCol (color * color, vector intpoint, cover * cp, byte art) = 0;

  // wird das Objekt getroffen?
  virtual bool hit_object (vector point, vector dir, bool hitin,
			   vector * int_pt1, vector * norm1,
			   vector * int_pt2, vector * norm2) = 0;

  // pat es in den Wrfel?
  virtual bool testgrobj (vector * z1, vector * z2, vector nv1, vector nv2) = 0;
  virtual bool getpoints (vector * v1, longint x) = 0;

  // erzeugt Patches fr radios
  virtual patcharray *createpatch (float Min, bool Schn, obj * grobj) = 0;
  virtual patcharray *getpatcharray (void) = 0;
  virtual void deletepatcharray (void) = 0;
  virtual bool in_obj (vector mp) = 0;	// test ob sich der Punkt im Objekt befindet
};

// Objekttyp Y-Buffer
class ybuffer
{
  friend world;

public:
  ybuffer (float *v, word dx, word dy,
	   obj ** Objekt, obj ** Ox, obj ** Nextsp, cover * Ycover,
	   float R, float G, float B, float E,
	   float Mat, float Sp, float Du, float Dif, float Spec,
	   float High, float Vel, char Ch);
  
  ~ybuffer ()
  {
    delete ybuf;
  }				// ybuf wird in maketri() freigegeben
  
private:
  // erzeugt Dreiecksliste
  void maketri (void);
  void genobj (void);
  
  vector p1, p2, p3, p4,	// Die Eckpunkte des Polygons
    nor;			// Normalvektor
  
  word xanz, yanz;		// Rastereinheiten
  
  float *ybuf;			// Zeiger auf die Hhenmatrix
  
  // Optische Eigenschaften
  obj **objekt, **ox, **nextsp;
  cover *ycover;
  float r, g, b, e, mat, sp, du, dif, spec, high, vel;
  char ch;
};

//  Objekttyp Polygon
class polygon:
  public grobj
{
  friend world;
  
public:
  polygon();
  polygon(byte anz, vector N, vector P1, vector P2, vector P3, vector P4)
    : normal (N), //n0 (N), n1 (N), n2 (N), n3 (N), 
      p0 (P1), p1 (P2), p2 (P3), p3 (P4)
  {
    num_vec = anz;
    ebene = false;
    //nset = false;
  };

  ~polygon()
  {
    if (pp) delete pp; 
  };

  vector getnormal (void);
  vector *getvector (byte x);
  
  bool hit_object (vector point, vector dir, bool hitin,
		   vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2);
  void surfaceCol (color * color, vector intpoint, cover * cp, byte art);
  bool testgrobj (vector * z1, vector * z2, vector nv1, vector nv2);

  bool getpoints (vector * v1, longint x);

  // erzeugt Patches fr radios
  patcharray *createpatch (float Min, bool Schn, obj * grobj);	// fr Radios, Patches erzeugen
  patcharray *getpatcharray (void)
  {
    return pp;
  };
  void deletepatcharray (void)
  {
    delete pp;
    pp = NULL;
  };
  bool in_obj (vector mp);

  // setzt einen Vektor und testet die Ebene
  void setvector (byte x, vector V);
  void set (vector * v1,...);
  void setn (vector * v1,...);

  bool ebene;			// Schnittebene oder Polygon?
private:
  vector getn (vector p);
  byte num_vec;			// Anzahl der Ecken
  vector normal;		// Normalvektor der Ebene

  //bool nset;			// Falls Normalvektoren gesetzt erfolgt die Berechnung
  // des Oberflchennormalvektors ansonsten wird der 
  // Normalvektor des Polygons zurckgeliefert

  //vector n0, n1, n2, n3;	// gesetzter Normalvektor der Zurckgegeben wird
  vector p0, p1, p2, p3;	// Eckpunkte

  patcharray *pp;		// Patch fr radios-Vorder und Hinterseite
};

/*
class bezier
{
  friend world;

public:
  bezier (obj ** Ox, obj ** Objekt, obj ** Nextsp, char Ch,
	  float R, float G, float B, float E,
	  float Mat, float Sp, float Du, float Dif, float Spec,
	  float High, float Vel);

  ~bezier ()
  {
    delete m;
  }

private:
  void ausgabe ();		// fr Testzwecke

  void erz_polygon (cover * C, vector * P1,...);
  void create_polygon (cover * Map);	// zu Raytracendes Polygonnetz

  void init (cover * Map, word X, word Z, vector Bpuf[4][4]);
  // void ziehe3(vector *p1, vector *p2, vector *p3);
  // void ziehe4(vector *p1, vector *p2, vector *p3, vector *p4);

  // Berechnet die Position und Normalvektor eines Koordinatenpunktes auf einer Bezierflche
  void bezier_value (float u0, float v0, vector * P, vector * N);

  // Berechnungsdaten
  vector *m;			// Matrix des Polygonnetz

  // Obj Daten
  word x, z;			// Anz x, y der Polygone
  vector bpuf[4][4];		// fr Bezier

  // Optische Eigenschaften
  obj **objekt, **ox, **nextsp;
  float r, g, b, e, mat, sp, du, dif, spec, high, vel;
  char ch;
};
*/

// Objekttyp Block, eineindeutiges Objekt da geschloen
class block:public grobj
{
  friend world;

public:
  block ()
  {
    ok = false;
    //bp = NULL; 
  }
  block (vector p0, vector p1, vector p2, vector p3,
	 vector p4, vector p5, vector p6, vector p7)
  {
    ok = true;
    setvector (0, p0);
    setvector (1, p1);
    setvector (2, p2);
    setvector (3, p3);
    setvector (4, p4);
    setvector (5, p5);
    setvector (6, p6);
    setvector (7, p7);
  }
  ~block ()
  {
    if (pp)
      delete pp;
  }

  // Oberflchenfarbe
  void surfaceCol (color * color, vector intpoint, cover * cp, byte art);

  // getroffen ?
  bool hit_object (vector point, vector dir, bool hitin,
		   vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2);

  // im Wrfel enthalten?
  bool testgrobj (vector * z1, vector * z2, vector nv1, vector nv2);
  bool getpoints (vector * v1, longint x);

  patcharray *createpatch (float Min, bool Schn, obj * grobj);	// fr Radios

  patcharray *getpatcharray (void)
  {
    return pp;
  };
  void deletepatcharray (void)
  {
    delete pp;
    pp = NULL;
  };
  bool in_obj (vector mp);

  //protected:
  void setvector (byte n, vector V);

private:
  byte hit1, hit2;
  bool ok;			// sind alle Daten gesetzt?
  vector e[8];			// Eckpunkte, eigentlich Verschwendung!!!
  polygon p[6];			// Polygone
  patcharray *pp;
};

// Objekttyp Kugel
class sphere:public grobj
{
  friend world;

public:
  sphere ()
  {
    //sp = NULL; 
  }

  sphere (vector m, float r)
  {
    vect = m;
    radius = r;
    //sp = NULL; 
  }
  ~sphere ()
  {
    if (pp)
      delete pp;
  }

  void surfaceCol (color * col, vector intpoint, cover * cp, byte art);
  bool hit_object (vector point, vector dir, bool hitin,
		   vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2);
  bool testgrobj (vector * z1, vector * z2, vector nv1, vector nv2);
  bool getpoints (vector * v1, longint x);

  patcharray *createpatch (float Min, bool Schn, obj * grobj);	// fr Radios

  patcharray *getpatcharray (void)
  {
    return pp;
  };
  void deletepatcharray (void)
  {
    delete pp;
    pp = NULL;
  };
  bool in_obj (vector mp);

  //protected:

  void setsphere (vector V, float R, float A, float B)
  {
    vect = V;
    radius = R;
    alpha = A;
    beta = B;
  }

  vector vect;			// Mittelpunkt

private:
  float radius;			// Radius
  float alpha;			// Drehwinkel der Texture um Z
  float beta;			// Drehwinkel der Texture um Y
  patcharray *pp;
};


// Objekttyp Patchobj

// Noch ungetestet, unimplementiert ...

class patchobj: public grobj
{
  friend world;

public:
  patchobj()  { pla=pl=NULL; pp=NULL; }

  ~patchobj()  { if (pp) delete pp; } // nicht pla, da in createpatch gelscht wird 

  void surfaceCol (color * col, vector intpoint, cover * cp, byte art);
  bool hit_object (vector point, vector dir, bool hitin,
		   vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2);
  bool testgrobj (vector * z1, vector * z2, vector nv1, vector nv2);
  bool getpoints (vector * v1, longint x);

  patcharray *createpatch (float Min, bool Schn, obj * grobj);	// fr Radios
  patcharray *getpatcharray (void)  { return pp;  };
  void deletepatcharray (void)      { delete pp; pp = NULL; };
  bool in_obj (vector mp);

protected:
  void setpatch(vector m, vector n);

private:
  patcharray *pp;
  patchinitl *pla, *pl;
};

// Sternenobjekt
class star:public sphere
{
  friend world;

public:
  void setstar (word n, float entfernung, float radius)
  {
    num = n;
    starentf = entfernung;
    starrad = radius;
    sphere::setsphere (vector (0.0, 0.0, entfernung), radius, 0.0, 0.0);
  }

  // Die Sterne werden rotiert, daher eine der Entfernung entsprechende
  // Begrenzungsbox!
  bool testgrobj (vector * z1, vector * z2, vector nv1, vector nv2)
  {
    float er = starentf + starrad;
    *z1 = vector (-er, -er, -er);
    *z2 = vector (er, er, er);

    // Test ob reinpasst, weglassen da in 1. Begrenzungskrper bleiben soll
    return ((nv1.x <= z1->x && nv1.y <= z1->y && nv1.z <= z1->z) &&
	    (nv2.x >= z2->x && nv2.y >= z2->y && nv2.z >= z2->z)) ? true : false;
  }

  // Ein Stern (oder jedes andere Objekt) kann nur Rotiert werden, da es
  // sonst aus seiner Begrenzungsbox geschoben wird!
  void rotstar (vector w)
  {
    rotation (&vect, VNULL, w);
  }

private:
  word num;
  float starentf, starrad;
};

// Elipsoid
class elipsoid:public grobj
{
  friend world;

public:
  elipsoid ()
  {
  };
  elipsoid (vector M, vector R, vector W);
  ~elipsoid ()
  { if (pp) delete pp;  };

  void surfaceCol (color * color, vector intpoint, cover * cp, byte art);
  bool hit_object (vector point, vector dir, bool hitin,
		   vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2);
  bool testgrobj (vector * z1, vector * z2, vector nv1, vector nv2);
  bool getpoints (vector * v1, longint x);

  patcharray *createpatch (float Min, bool Schn, obj * grobj);	// fr Radios

  patcharray *getpatcharray (void)
  {
    return pp;
  };
  void deletepatcharray (void)
  {
    delete pp;
    pp = NULL;
  };
  bool in_obj (vector mp);

  //protected:
  void setelip (vector M, vector W, vector R)
  {
    m = M;
    w = W;
    r = R;
    rzx = (r.z + r.x) / 2.0;
    ryz = (r.y + r.z) / 2.0;

    cout << "ellip gesetzt m=" << m << " r=" << r << " w=" << w << "\n";
  }

protected:
  bool hit_in (vector r0, float aq, float bq, float cq);

private:
  float ryz, rzx;		// Radien fr Texture

  vector m;			// Mittelpunkt

  vector r;			// Radien

  vector w;			// Rotationswinkel

  patcharray *pp;
};

// Zylinder
class cone:
  public grobj
{
  friend world;
public:

  cone (vector P1, vector P2, float r1, float r2)
  {
    Kegel = false;
    setcone (P1, P2, r1, r2, 0.0);
    //zp = NULL;
  };
  cone ()
  {
    p1 = p2 = VNULL;
    r = eps4;
    alpha = 0.0;
    Kegel = false;
    //zp = NULL;
  };
  ~cone ()
  {
    if (pp)
      delete pp;
  }

  void surfaceCol (color * color, vector intpoint, cover * cp, byte art);
  bool hit_object (vector point, vector dir, bool hitin,
		   vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2);
  bool testgrobj (vector * z1, vector * z2, vector nv1, vector nv2);
  bool getpoints (vector * v1, longint x);
  patcharray *createpatch (float Min, bool Schn, obj * grobj);	// fr Radios

  patcharray *getpatcharray (void)
  {
    return pp;
  };
  void deletepatcharray (void)
  {
    delete pp;
    pp = NULL;
  };
  bool in_obj (vector mp);

  void setcone (vector P1, vector P2, float R, float R2, float Alpha);

protected:
  bool hit_in (vector v0);

private:
  float r, r2,			// Radius
    h,				// Hhe
    alpha,			// Drehung um seine eigene Achse
    d, dq, cq;			// Breite und dessen Quadrat

  vector p1, p2,		// Punkte
    wn;				// Drehungswinkel als Richtungsvektor von p1 -> p2

  char Kegel;			// Kegel oder Zylinder

  patcharray *pp;
};

// Torus
class torus:
  public grobj
{
  friend world;
public:

  torus ()
  {
    m = w = vector (0., 0., 0.);
    d = r = 0.;
    //tp = NULL; 
  }
  torus (vector M, vector W, float D, float R)
    : m (M), w (W)
  {
    d = D;
    r = R;
    //tp = NULL; 
  }
  ~torus ()
  {
    if (pp)
      delete pp;
  }

  // Oberflchenfarbe
  void surfaceCol (color * color, vector intpoint, cover * cp, byte art);
  bool hit_object (vector point, vector dir, bool hitin,
		   vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2);
  bool testgrobj (vector * z1, vector * z2, vector nv1, vector nv2);
  bool getpoints (vector * v1, longint x);
  patcharray *createpatch (float Min, bool Schn, obj * grobj);	// fr Radios

  patcharray *getpatcharray (void)
  {
    return pp;
  };
  void deletepatcharray (void)
  {
    delete pp;
    pp = NULL;
  };
  bool in_obj (vector mp);

  void settorus (vector P, float D, float R, vector W)
  {
    m = P;
    w = W;
    d = D;
    r = R;
  }

protected:
  bool hit_in (vector r0, float dq, float xq, float yq, float zq, float rq);

private:
  float d, r;			// Radien

  vector m,			// Mittelpunkt
    w;				// Drehungswinkel

  patcharray *pp;
};

// Gegenstand
class obj	// Virtuelle forward-definition
{
public:
  obj(obj * lo,
      float r, float g, float b, float Energie,
      float Material, float Mirror, float Trans, float Dif, float Spec,
      float High, float n, cover * Cover, byte Type, byte SType);

  ~obj()
  {
    if (grobjp)
      delete grobjp;
    if (nextS)
      delete nextS;
    if (next)
      delete next;
  }

  // Memberfunktionen zur Oberflchengestaltung
  void surfaceCol (color * colo, vector intpoint);

  bool calc_spiegelnd(float *sp, vector intpt); // Spiegelnde Texture
  bool calc_brechend(float *br, vector intpt);  // Durchsichtige Texture

  // Radiosity extra!
  color surfaceColRadio(vector int_pt, vector pt, vector vr);

  void musterCol (color * colo, vector intpoint);

  // berechnet eine Vektordrehung fr Wellen
  void calc_wave (vector * d, vector intpt, vector normal);

  // Treffer ?
  obj *hit_object (vector point, vector dir,
		   vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2)
  {
    if (grobjp->hit_object (point, dir, hitin, int_pt1, norm1, int_pt2, norm2))
      return this;
    return NULL;
  }

  void sobj (obj * so);		// fgt Schnittkrper ein

  patcharray *createpatches (float min);	// erzeugt Patches fr radios

  patcharray *getpatches (void)
  {
    return grobjp->getpatcharray ();
  };
  void deletepatcharray (void)
  {
    grobjp->deletepatcharray();
  };

  // ermittelt das Patch welches den Schnittpunkt umschliet
  patch * get_patch(vector npt, vector po, vector vr)
  {
    patcharray *pp = grobjp->getpatcharray();
    return pp->get_patch(npt, po, vr);
  };

  // ermittelt das Patch welches den Schnittpunkt umschliet
  color get_patch_color(vector npt, vector po, vector vr)
  {
    patcharray *pp = grobjp->getpatcharray();
    patch      *p  = pp->get_patch(npt, po, vr);
    return p->c;
  };

  // testet ob sich der Mittelpunkt eines Patches im Objekt befindet
  bool in_obj (vector mp)
  {
    return grobjp->in_obj (mp);
  };

  float material;		// Wieviel Prozent des Materials
  float mirror;			// Wieviel Prozent werden von Spiegelung dargestellt
  float trans;			// -''-  des durchscheinenden Lichts werden dargestellt
  float dif_const;		// 0<=x<=1   Wieviel % diffuses Licht aussenden
  float spec_const;		// 0<=x<=1   Specularlicht
  float high_const;		// 0<=x<=100 licht=ospec_const*(V * norm)^high_const;
  float N;			// Velocitfaktor
  float e;			// Energie je Flche

  obj *next;			// nchstes Objekt
  obj *nextS;			// nchstes Schnittobjekt
  color col;			// Farbe
  byte type;			// Objecttyp
  byte stype;			// Type des Schnittobjektes
  bool hitin;			// mu hitin getestet werden?
  cover *coverp;		// Zeiger auf Oberflchenstruktur
  grobj *grobjp;		// Grafisches Element als Sohn von "grobj"

private:

};

class tree
{
  friend world;

public:
  // Da die Wrfel an den Koordinatenachsen ausgerichtet
  // sind kann der Wrfel mit 2 Punkten definiert werden
  tree (vector p1, vector p2, obj * o);
  ~tree ()
  {
    // alle Objekte entfernen
    delete o;
    for (byte x = 0; x < 8; x++)
      delete t[x];
  };

  // public Daten
  obj *o;			// Objektliste

  tree *t[8];			// 8 Bltter (am Ast "hngen" 8 ste)

  // wird der Wrfel vom Sichtstrahl getroffen?
  bool hit_object (vector point, vector dir);

  // Anzahl der Objekte fr Statistik
  longint anzobj;

protected:
  // bildet neuen Wrfel je nach Nummer
  void newpol (vector * p1, vector * p2, char x);

  // bildet neue Objektliste und entfernt die bernommenen aus
  // der alten Liste
  void newobj (obj ** obn, obj ** obo, vector p1, vector p2);

  // zhlt wieviele Obj in den neuen Wrfel passen
  void testobj (longint * entf, longint * neu, vector p1, vector p2);

  // fr Testzwecke, druckt die Anzahl der Objekte eines Blattes aus
  void print (longint * blatt);

private:
  // Die Ecken
  vector v1, v2;
  // Begrenzungskugel
  vector vect;
  float radius;
};


class light
{
public:
  virtual ~light(){};
  virtual color get_color (vector int_point, vector dir, vector normal, obj * obj)=0;
  
  vector m;			// Position
};

class lamp: public light			// Lichtquellen
{
  friend world;
  friend ray;

public:
  lamp (lamp * ll, float x, float y, float z, float r, float g, float b,
	float Intens, byte typ)
    // ???  :m(x, y, z), col(r, g, b)
  {
    m = vector (x, y, z);
    col = color (r, g, b);

    next = 0;
    // einketten
    if (ll)
      ll->next = this;
    intens = Intens;
    type = typ;
  }

  ~lamp ()
  {
    delete next;
  }

  // ermittelt die Farbe des gegebenen Punktes
  color get_color(vector int_point, vector dir, vector normal, obj * obj);

  // ermittelt das Glanzlicht
  color get_color_spec(vector int_point, vector dir, vector normal, obj * obj);

  // radios mu zugreifen
  color col;			// Farbe des Lichts
  float intens;			// Strke
  byte type;
  lamp *next;			// nchste Lampe

private:
};

class spot:			// Lichtstrahler
  public lamp
{
public:
  spot (spot * ll, float x, float y, float z, float a, float b, float c,
	float r, float g, float bl,
	float Intens, float winkel, byte typ)
    : richtung (a, b, c), lamp (NULL, x, y, z, r, g, bl, Intens, typ)
  {
    next = 0;
    // einketten
    if (ll)
      ll->next = this;
    w = winkel;
  }

  ~spot ()
  {
    // ruft automaisch destruktor von Lamp?
    delete next;
  }

  // ermittelt die Farbe des gegebenen Punktes
  color get_color(vector int_point, vector dir, vector normal, obj * obj);
  color get_color_spec(vector int_point, vector dir, vector normal, obj * obj);

  vector richtung;		// Richtung der Strahlen
  float w;
  spot *next;			// nchste Lampe
};

class lichtpoly: 
  public light			// Lichtstrahler
{
public:
  lichtpoly (lichtpoly * ll, float p1x, float p1y, float p1z,
	     float p2x, float p2y, float p2z, float p3x, float p3y, float p3z,
	     float p4x, float p4y, float p4z, float cr, float cg, float cb,
	     int Xanz, int Yanz, float Intens, float W)
    : p1 (p1x, p1y, p1z), p2 (p2x, p2y, p2z), p3 (p3x, p3y, p3z), p4 (p4x, p4y, p4z),
      pcol (cr, cg, cb)
  {
    next = NULL;
    // einketten
    if (ll)
      ll->next = this;
    w = W;
    xanz = Xanz;
    yanz = Yanz;

    // es wird die Gesamtlichtstrke angegeben
    // intens = Intens / ((xanz+2)*(yanz+2));
    intens = Intens;

    n |= (p2 - p1) && (p3 - p1);	// Normalvektor des Polygons

    initmatrix ();
  }

  ~lichtpoly ()
  {
    delete next;
  }

  // ermittelt die Farbe des gegebenen Punktes
  color get_color (vector int_point, vector dir, vector normal, obj * obj);
  color get_color_spec(vector int_point, vector dir, vector normal, obj * obj);

  // public fr for Schleife
  lichtpoly *next;		// nchste Lampe
  vector *licht_m;		// Matrix fr Scheinwerfer
  vector n;			// Normalvektor des Polygons
  vector p1, p2, p3, p4;	// Richtung der Strahlen
  color pcol;			// Farbe des Lichts
  int xanz, yanz;		// Anzahl der Unterteilungen
  float intens, w;		// Strke, ffungswinkel

  // protected:
private:
  // initialisiert die Matrix
  void initmatrix ();
  color get_patchcolor (vector int_point, vector dir, vector normal, obj * objp);
  // ermittelt die Farbe mit der Lichtquelle i
  color get_light (int i, vector int_point, vector dir, vector normal, obj * obj);
  color get_light_spec(int i, vector int_point, vector dir, vector normal, obj * obj);
};

// Der Bildschirm
class observer
{
  friend world;
  friend ray;

public:			// wir der Bildschirm
  int p_width;			// Bildbreite
  int p_height;			// Bildhhe
  int x1, x2, y1, y2;		// Bildausschnitt
  int pixel;			// Anzahl der Pixel fr ein Bildpunkt
  int opixel;			// Anzahl der Pixel fr Optimierung

private:
  float dx, dy;			// Abstand vom Screen
  char ch;			// Art fr Anti-Aliasing
};

// die Kamera
class camera
{
  friend world;
  friend ray;

public:
  // Construktor
  camera ()
  {
    mov = w = VNULL;
    scal = 1.;
    blende = 16;
    entf = 10;
    frame = 0L;
  }

  vector mov;			// Verschiebung je Koordinatenachse
  vector w;			// Drehung je Koordinatenachse

private:
  float scal;			// Vergrerung
  byte blende, entf;		// Objektiveinstellungen
  longint frame;		// Bei welchen Bild
};

// die virtuelle Welt
class world
{
  friend ray;
  //friend radios;

public:
  world ();
  ~world ();

  longint step (int seite);
  observer observ;		// wir
  byte methode;			// Mit welcher Methode die Szene angezeigt wird
  color backh;		        // Hintergrundfarbe Himmel
  color backb;		        // Hintergrundfarbe Boden
  camera cam;			// Kamera
  float MinA;			// Patchgre
  //int teile;			// Fr Radiosity, adaptive Unterteilung (int wegen scanf())
  int diff;			// Fr Radiosity, weitere Rechnung fr durchscheinen und Sp.ielung
  int pid;			// Proze-ID, fr Anzeige

  lamp *lampe;			// erste Lampe
  spot *strahler;		// erster Strahler
  lichtpoly *lichtpolyp;	// erstes Lichtpolygon

protected:
  void gentree (void);
  void posplanet (word planet, vector pos);

private:

  void scantexture(texture **t, texture *txt, dword num)
  {
    if (num == 0) *t = NULL;
    else
      { 
	*t = txt; 
	while ((*t != NULL) && ((*t)->num != num))
	  *t = (*t)->next;
      }
  }

  void scanmuster(muster **t, muster *mus, dword num)
  {
    if (num == 0) *t = NULL;
    else
      { 
	*t = mus; 
	while ((*t != NULL) && ((*t)->num != num))
	  *t = (*t)->next;
      }
  }

  color ambient;		// Umgebungslicht (ohne Lichtquelle)
  color black;			// Farbe fr Schwarz
  float nebel;			// definiert die Sichtweite
  texture *bgtextur1, *bgtextur2;	// Textur fr Hintergrund
  muster *bgmuster1, *bgmuster2;	// Hintergrundmuster
  turbo tb1, tb2;		// Turbolenzen
  vector mv1, mv2;		// Musterverschiebung
  polygon hi;			// Kugel fr Himmel (Kind von Sphere)
  polygon bo;			// Polygon fr Erde
  bool ish, isb;		// Bool ob Himmel und Erde definiert sind
  muster *mustp;		// erste Muster
  wave *wavep;			// erste Wave
  obj *objekt;			// erstes Objekt der ursprnglichen Objektliste
  texture *text;		// erste Texture
  texture3d *text3d;		// erste 3D-Texture
  cover *coverl;		// Liste der Covers
};

inline cbyte intcolor256 (color col)
{
  cbyte c;
  c.r = (byte) (col.r * 255.0);
  c.g = (byte) (col.g * 255.0);
  c.b = (byte) (col.b * 255.0);
  return c;
}

inline float retcol256 (byte col)
{
  return ((float) col / 255.0);
}

// in raywin.C
extern int MAXCOL;

// fr alle auer xw.C
extern world *pwelt;		// Zeiger auf Welt fr alle Welt
extern tree *ptree;		// Wurzel des Baumes, Globaler Pointer denn es gibt nur ein Baum
extern ray pray;

#endif
