 /*  
   Dialogbox fuer die Dateneingabe der Polygone
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   Copyright (C) 1997 Helmut Fahrion
 */

#include "pextool.H"

#define POLYGON_APPROX_ANZ 10

struct polygonstruktur PolygonDialog;

STRING helppolygondialog = "Definition eines Polygon.";
Widget WPolygonDialog, PolygonWText1, PolygonWText2, PolygonWText3, PolygonWText4,
  PolygonCoverLabel;
int PolygonArt;
grobjekt *poly_grobj;
longint polygon_anknr;

// fuer Netz
PEXVertexNormal polygon_netz[(POLYGON_APPROX_ANZ + 1) * (POLYGON_APPROX_ANZ + 1)];

// fuer Dreieck 
PEXCoord polygon_coord[4];
PEXListOfCoord polygon_listcoord;


void
polysetvect(vector v1, vector v2, vector v3, vector v4)
{
  PolygonDialog.p1 = v1;
  PolygonDialog.p2 = v2;
  PolygonDialog.p3 = v3;
  PolygonDialog.p4 = v4;
}


// ##########  Hier die Patches berechnen  #####################

void
create_polyline(Display * D, PEXStructure poly, vector p1, vector p2,
		vector p3, vector p4, vector pn, float r)
{
  PEXCoord lp, coord[4];

  // Polymarker
  //   PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCircle);
  //   PEXSetMarkerScale(D, poly, PEXOCStore, 3.0);
  //   PEXSetMarkerColor(D, poly, PEXOCStore, PEXColorTypeRGB, &echo_color);

//   SET_VECTA(p4, lp); 
  //   PEXMarkers(D, poly, PEXOCStore, 1, &lp);

  // Polyline Dreieck
  SET_VECTA(p1, coord[0]);
  SET_VECTA(p2, coord[1]);
  SET_VECTA(p3, coord[2]);
  SET_VECTA(p1, coord[3]);
  PEXPolyline(D, poly, PEXOCStore, 4, coord);

  // Normalvektor zeigen
  SET_VECTA(p4 + (pn * r), lp);
  PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCross);
  PEXMarkers(D, poly, PEXOCStore, 1, &lp);

  // Polyline Dreieck
  //   SET_VECTA(p4+(pn*0.1), coord[0]);
  //   SET_VECTA(p4, coord[1]);
  //   PEXPolyline(D, poly, PEXOCStore,  2, coord);
}
/*
void
listtree(Display * D, PEXStructure obj, vector m, vector n, float r)
{
  PEXCoord lp, coord[2];

  // Polymarker
  PEXSetMarkerType(D, obj, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(D, obj, PEXOCStore, 3.0);
  PEXSetMarkerColor(D, obj, PEXOCStore, PEXColorTypeRGB, &echo_color);

  SET_VECTA(m, lp);
  PEXMarkers(D, obj, PEXOCStore, 1, &lp);

  // Polyline Dreieck
  SET_VECTA(m, coord[0]);
  SET_VECTA(m + (n * r), coord[1]);
  PEXPolyline(D, obj, PEXOCStore, 2, coord);
}

// scanne rekursiv den Baum
void
listpolygontree(patchtree * patr, longint a, longint * z,
		Display * D, PEXStructure obj)
{
  patchtl *ptl;


  for (ptl = patr->o; ptl; ptl = ptl->next)
    {
      listtree(D, obj, ptl->p->m, ptl->p->n, ptl->p->r);
      *z += 1;
      a++;
    }

  // cerr << a << " Elemente im Tree!\n";

  for (char x = 0; x < 8; x++)
    if (patr->pt[x] != NULL)
      listpolygontree(patr->pt[x], 0, z, D, obj);
}

void
polygon_calcpatches(int anzvect, Display * D, PEXStructure obj)
{
  patcharray pt(Patchweite, true, NULL, anzvect,
		PolygonDialog.p1, PolygonDialog.p2,
		PolygonDialog.p3, PolygonDialog.p4);
  longint z = 0;

  // patch *pat=pt.pa;
  // teste Array
  //for (long x=0; x<pt.anz; x++) listtree(D, obj, pat[x].m, pat[x].n);

  // teste Liste
  // patchl *pl; 
  //   for (pl = pt.pla; pl; pl = pl->next) 
  //     listtree(D, obj, pl->m, pl->n, pl->r);

  // teste Baum
  pt.bilde_at();
  listpolygontree(pt.pt, 0, &z, D, obj);
  cerr << "Polygon gesamt = " << z << " Patches.\n";
}
*/
//#########################################################################################


void
PolygonDialog_init(int Anz_vect, longint Nrcover,
		   vector P1, vector P2, vector P3, vector P4)
{
  PolygonDialog.anz_vect = Anz_vect;
  PolygonDialog.nrcover = Nrcover;
  PolygonDialog.p1 = P1;
  PolygonDialog.p2 = P2;
  PolygonDialog.p3 = P3;
  PolygonDialog.p4 = P4;
}

void
PolygonDialog_get(int *Anz_vect, longint * Nrcover,
		  vector * P1, vector * P2, vector * P3, vector * P4)
{
  *Anz_vect = PolygonDialog.anz_vect;
  *Nrcover = PolygonDialog.nrcover;
  *P1 = PolygonDialog.p1;
  *P2 = PolygonDialog.p2;
  *P3 = PolygonDialog.p3;
  *P4 = PolygonDialog.p4;
}

void
create_polygon_netz(int anzvect, Display * D, PEXStructure obj)
{
  double xabs, yabs;
  int anznetz;

  // generiere ein Netz in den Koordinaten einer Kugel
  // dies ist noetig weil PEX keine Kugeln kennt
  xabs = yabs = 0.0;
  anznetz = POLYGON_APPROX_ANZ;

  // 4 Punkte 
  if (anzvect)
    {
      // 4 Punkte
      SET_VECT(PolygonDialog.p1.x, PolygonDialog.p1.y, PolygonDialog.p1.z,
	       polygon_coord[0]);
      SET_VECT(PolygonDialog.p2.x, PolygonDialog.p2.y, PolygonDialog.p2.z,
	       polygon_coord[1]);
      SET_VECT(PolygonDialog.p3.x, PolygonDialog.p3.y, PolygonDialog.p3.z,
	       polygon_coord[2]);
      SET_VECT(PolygonDialog.p4.x, PolygonDialog.p4.y, PolygonDialog.p4.z,
	       polygon_coord[3]);

      polygon_listcoord.count = 4;
      polygon_listcoord.points = polygon_coord;
    }
  else
    {
      // 3 Punkte
      SET_VECT(PolygonDialog.p1.x, PolygonDialog.p1.y, PolygonDialog.p1.z,
	       polygon_coord[0]);
      SET_VECT(PolygonDialog.p2.x, PolygonDialog.p2.y, PolygonDialog.p2.z,
	       polygon_coord[1]);
      SET_VECT(PolygonDialog.p3.x, PolygonDialog.p3.y, PolygonDialog.p3.z,
	       polygon_coord[2]);

      polygon_listcoord.count = 3;
      polygon_listcoord.points = polygon_coord;
    }

  // polygon_calcpatches(anzvect, D, obj);
}


void
aendere_polygon(Display * D)
{
  PEXStructure *polygonp = &(poly_grobj->obj_struct);

  /* Aendern */
  poly_grobj->cover = PolygonDialog.nrcover;	// Covereintrag

  ((cadpolygon *) (poly_grobj->objp))->
    init(PolygonDialog.anz_vect, PolygonDialog.p1,
	 PolygonDialog.p2, PolygonDialog.p3, PolygonDialog.p4);		// restlichen Daten

  PEXSetEditingMode(D, *polygonp, PEXStructureReplace);
  PEXSetElementPtr(D, *polygonp, PEXBeginning, 0);
  PEXSetElementPtrAtLabel(D, *polygonp, OBJ_POLYLINE_LABEL, 1);

  create_polygon_netz(PolygonDialog.anz_vect, D, *polygonp);

  PEXFillAreaSet(D, *polygonp, PEXOCStore, PEXShapeConvex,
		 False, PEXContourNested, 1, &polygon_listcoord);

  un_echo(poly_grobj, poly_grobj->ch == 'N');
}

void
create_polygon(Display * D, Widget W, grobjekt * poly, longint ank_nr, longint pick_id)
{
  bool echocolor = True;

  PEXCoord ref_point;
  PEXName name[2];
  PEXMatrix matrix;
  PEXVector tr, scale;
  PEXStructure *polygon_element = NULL;
  grobjekt *ankobj = NULL;

  // suche strukturpointer zum anhaengen
  if (ank_nr == 0L)
    {
      echocolor = True;
      polygon_element = &root_struct;
      ankobj = NULL;
    }
  else
    {
      if ((ankobj = oliste.getobjp(ank_nr)) != NULL)
	{
	  echocolor = ankobj->ch == 'N';
	  polygon_element = &ankobj->obj_struct;
	}
      else
	ankobj = NULL;
    }

  // Nameset und Pickid sind wichtig fr das Picken
  name[0] = (PEXName) GROBJSTR;
  name[1] = (PEXName) POLYGON;
  PEXAddToNameSet(D, poly->obj_struct, PEXOCStore, 2, name);
  PEXSetPickID(D, poly->obj_struct, PEXOCStore, pick_id);

  PEXLabel(D, poly->obj_struct, PEXOCStore, COLORLABEL);

  if (poly->ch == 'N')
    PEXSetSurfaceColor(D, poly->obj_struct, PEXOCStore, PEXColorTypeRGB, &normal_color);
  else
    PEXSetSurfaceColor(D, poly->obj_struct, PEXOCStore, PEXColorTypeRGB, &schnitt_color);

  SET_VECT(0.0, 0.0, 0.0, ref_point);
  SET_VECT(0.0, 0.0, 0.0, tr);
  SET_VECT(1.0, 1.0, 1.0, scale);
  PEXBuildTransform(&ref_point, &tr, 0.0, 0.0, 0.0, &scale, matrix);
  PEXLabel(D, poly->obj_struct, PEXOCStore, TRANSFORM_LABEL);
  PEXSetLocalTransform(D, poly->obj_struct, PEXOCStore, PEXReplace, matrix);

  PEXLabel(D, poly->obj_struct, PEXOCStore, OBJ_PICK_ANF_LABEL);
  // Hier werden die Pickelemente eingefgt 
  PEXLabel(D, poly->obj_struct, PEXOCStore, OBJ_PICK_END_LABEL);

  PEXLabel(D, poly->obj_struct, PEXOCStore, OBJ_POLYLINE_LABEL);

  create_polygon_netz(PolygonDialog.anz_vect, D, poly->obj_struct);

  PEXFillAreaSet(D, poly->obj_struct, PEXOCStore, PEXShapeConvex,
		 False, PEXContourNested, 1, &polygon_listcoord);

  // Kennung das hier die Kette beginnt
  PEXLabel(D, poly->obj_struct, PEXOCStore, OBJ_KETTE_LABEL);

  /* in Root-Struktur einfgen */
  PEXSetEditingMode(D, *polygon_element, PEXStructureInsert);
  PEXSetElementPtr(D, *polygon_element, PEXEnd, 0);
  PEXLabel(D, *polygon_element, PEXOCStore, GROBJ_LABEL + pick_id);
  PEXExecuteStructure(D, *polygon_element, PEXOCStore, poly->obj_struct);

  un_echo(ankobj, echocolor);
}

void
delete_cover_polygon_liste(void)
{
  int x, anzelem;

  for (anzelem = 0, coverx = coveranf; coverx; anzelem++, coverx = coverx->next);

  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(PolygonDialog.pCoverStr[x]);
}

void
CBPolygonOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;
  grobjekt *poly;
  longint pick_id;
  vector v1, v2, v3, v4;
  bool ok;

  /* Text in Zahlen umwandeln */
  str = XmTextGetString(PolygonWText1);
  if (!(ok = expr_vector(&v1, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor 1 liefert eine ungueltige Zahl!");
      return;			// gehe zurueck ohne Dialog zu beenden

    }

  str = XmTextGetString(PolygonWText2);
  if (!(ok = expr_vector(&v2, str)))
    {
      errorbox("Vektor 2 liefert eine ungueltige Zahl!");
      return;
    }
  if (ok == 2)
    v2 += v1;

  str = XmTextGetString(PolygonWText3);
  if (!(ok = expr_vector(&v3, str)))
    {
      errorbox("Vektor 3 liefert eine ungltige Zahl!");
      return;
    }
  if (ok == 2)
    v3 += v2;

  str = XmTextGetString(PolygonWText4);
  if (!(ok = expr_vector(&v4, str)))
    {
      errorbox("Vektor 4 liefert eine ungueltige Zahl!");
      return;
    }

  if (ok == 2)
    v4 = v3 + v4;

  if (!testebene(v1, v2, v3, v4))
    {
      v4 = v1 + v3 - v2;
      errorbox("Keine Ebene!\nrcke nach p4=p1+p3-p2");
    }

  polysetvect(v1, v2, v3, v4);

  /* neues Polygon anketten? */
  if (PolygonArt == NEU)
    {
      pick_id = ank_grobjekt(POLYGON, polygon_anknr,
			 ObjDialog.r, ObjDialog.g, ObjDialog.b, ObjDialog.e,
			     ObjDialog.mat,
		  ObjDialog.sp, ObjDialog.du, ObjDialog.dif, ObjDialog.spec,
			     ObjDialog.high, ObjDialog.vel, ObjDialog.ch,
			     PolygonDialog.nrcover,
			     vector(0.0, 0.0, 0.0), vector(0.0, 0.0, 0.0));
      poly = ank_polygon(PolygonDialog.anz_vect, v1, v2, v3, v4);
      create_polygon(XtDisplay(W), W, poly, polygon_anknr, pick_id);
    }
  else
    aendere_polygon(XtDisplay(W));

  delete_cover_polygon_liste();

  /* erst hier!!! */
  WObjDialog = NULL;

  XtUnmanageChild(WPolygonDialog);
  WPolygonDialog = NULL;
}

void
CBPolygonCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  delete_cover_polygon_liste();
  XtUnmanageChild(WPolygonDialog);

  /*  erst hier!!! */
  WObjDialog = NULL;

  WPolygonDialog = NULL;
}

void
CBPolygonHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helppolygondialog);
  else
    infobox("helpnureinmal");
}

void
CBAnzahl(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  PolygonDialog.anz_vect = ((XmToggleButtonCallbackStruct *) pCallData)->set;
}

void
CBPolygonCover(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  PolygonDialog.nrcover = (((XmListCallbackStruct *) pCallData)->item_position) - 1;
  sprintf(cpos, "%ld", PolygonDialog.nrcover);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(PolygonCoverLabel, &Aargs, 1);
  strcpy(PolygonDialog.coverlabel, cpos);
}

void
create_polygon_listen(void)
{
  char str[256];
  longint x = 0, anzelem = 0;

  /* CoverListe */
  if (coveranf)
    {
      coverx = coveranf;
      while (coverx)
	{
	  anzelem = coverx->nr;
	  coverx = coverx->next;
	}
      PolygonDialog.anzcover = anzelem + 1;
      PolygonDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      coverx = coveranf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      PolygonDialog.pCoverStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (coverx)
	{
	  sprintf(str, "%ld: Cover", coverx->nr);	/* C String erzeugen */
	  PolygonDialog.pCoverStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  coverx = coverx->next;
	  x++;
	}
    }
  else
    {
      /* nur Dummy */
      PolygonDialog.anzcover = 1;
      PolygonDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString));
      strcpy(str, "0: keine");
      PolygonDialog.pCoverStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }
}

void
polygondialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art)
{
  Widget WButtonOK, WButtonPick, WButtonCancel, WButtonHelp, WRowCol1,
    WRowCol2, WRowCol3, WRowCol4, frame1, frame2, WAnzahl, WLabel, WCoverList;

  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];

  PolygonArt = art;
  polygon_anknr = ank_nr;
  poly_grobj = grobjp;

  if (PolygonArt == AENDERN)
    {

      ((cadpolygon *) (poly_grobj->objp))->
	get(&PolygonDialog.anz_vect, &PolygonDialog.p1, &PolygonDialog.p2,
	    &PolygonDialog.p3, &PolygonDialog.p4);

      PolygonDialog.nrcover = poly_grobj->cover;
    }
  else
    PolygonDialog_init(1, 0L, vector(0.1, 0.1, 0.1), vector(1.0, 0.10, 0.10),
		       vector(1.00, 1.00, 0.10), vector(0.10, 1.00, 0.10));
  /* Nur fuer Testzwecke vectorwerte */

  /* Strings fuer Listen Aufbauen */
  create_polygon_listen();

  WPolygonDialog = XmCreateDialogShell(W, "polygondialog", NULL, 0);
  XtManageChild(WPolygonDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 400);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 430);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WPolygonDialog, "polygondrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("polygonframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "polygondrow2", NULL, 0);
  XtManageChild(WRowCol2);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, PolygonDialog.anz_vect);
  nArgs++;
  WAnzahl = XtCreateManagedWidget("4 Ecken", xmToggleButtonWidgetClass, WRowCol2, Aargs, nArgs);
  XtAddCallback(WAnzahl, XmNvalueChangedCallback, (XtCallbackProc) CBAnzahl, NULL);

  WLabel = XtCreateManagedWidget("Vektoren x;y;z :", xmLabelWidgetClass, WRowCol2, NULL, 0);

  sprintf(str, "%0.2f;%0.2f;%0.2f", PolygonDialog.p1.x, PolygonDialog.p1.y, PolygonDialog.p1.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  PolygonWText1 = XtCreateManagedWidget("polygonp1", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f", PolygonDialog.p2.x, PolygonDialog.p2.y, PolygonDialog.p2.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  PolygonWText2 = XtCreateManagedWidget("polygonp2", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f", PolygonDialog.p3.x, PolygonDialog.p3.y, PolygonDialog.p3.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  PolygonWText3 = XtCreateManagedWidget("polygonp3", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f", PolygonDialog.p4.x, PolygonDialog.p4.y, PolygonDialog.p4.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  PolygonWText4 = XtCreateManagedWidget("polygonp4", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  /* Cover Auswahl */
  frame2 = XtCreateManagedWidget("polygoncoverf", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol4 = XmCreateRowColumn(frame2, "polygonc4", NULL, 0);
  XtManageChild(WRowCol4);

  sprintf(str, "%ld", PolygonDialog.nrcover);

  PolygonCoverLabel = XtCreateManagedWidget(str, xmLabelWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, PolygonDialog.pCoverStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, PolygonDialog.anzcover);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 4);
  nArgs++;
  WCoverList = XmCreateScrolledList(WRowCol4, "polygoncover", Aargs, nArgs);
  XtAddCallback(WCoverList, XmNdefaultActionCallback, (XtCallbackProc) CBPolygonCover, NULL);
  XtManageChild(WCoverList);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "polygonrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonPick);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBPolygonOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBPolygonCancel, NULL);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBPolygonHelp, NULL);

}
