/*
   Modul fuer Picking
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"
#include "cadtool.H"

#define          PICK_APPROX_ANZ 4

PEXVertexNormal pick_netz[(PICK_APPROX_ANZ + 1) * (PICK_APPROX_ANZ + 1)];

// entfernt Pickmarker aus der Markerliste, Struktur ist noch angekettet
void
pickmarker_delete()
{
  // Alte Pickdefinition loeschen
  PEXSetEditingMode(pDisplay, pick_struct, PEXStructureReplace);
  PEXSetElementPtr(pDisplay, pick_struct, PEXBeginning, 0);
  PEXDeleteElements(pDisplay, pick_struct, PEXBeginning, 0, PEXEnd, 0);
}

// entfernt Pickmarkerstruktur aus dem Renderingnetzwerk
void
pickmarker_destroy(PEXStructure * pobj)
{
  // Alte Pickdefinition loeschen
  pickmarker_delete();
  PEXSetElementPtr(pDisplay, *pobj, PEXBeginning, 0);
  PEXDeleteBetweenLabels(pDisplay, *pobj, OBJ_PICK_ANF_LABEL, OBJ_PICK_END_LABEL);
}

// kettet die Pickmarker in das Netz ein
void
pickmarker_create(PEXStructure * pobj)
{
  // Cursor setzen
  PEXSetEditingMode(pDisplay, *pobj, PEXStructureInsert);
  PEXSetElementPtr(pDisplay, *pobj, PEXBeginning, 0);
  PEXSetElementPtrAtLabel(pDisplay, *pobj, OBJ_PICK_ANF_LABEL, 0);
  PEXExecuteStructure(pDisplay, *pobj, PEXOCStore, pick_struct);
}

void
create_pick_netz(vector m, float r)
{
  double theta, phi;
  int index, i, j, anzpoints, anznetz;

  // generiere ein Netz in den Koordinaten einer Kugel
  // dies ist noetig weil PEX keine Kugeln kennt
  theta = phi = 0.0;
  anzpoints = PICK_APPROX_ANZ;
  anznetz = anzpoints + 1;

  // in richtigen koordinaten erzeugen!
  for (i = 0; i < anznetz; i++)
    {
      for (j = 0; j < anznetz; j++)
	{
	  index = i * anznetz + j;
	  pick_netz[index].point.x = sin(phi) * sin(theta) * r + m.x;
	  pick_netz[index].point.y = cos(phi) * r + m.y;
	  pick_netz[index].point.z = sin(phi) * cos(theta) * r + m.z;
	  // Normalvektor
	  pick_netz[index].normal.x = pick_netz[index].point.x;
	  pick_netz[index].normal.y = pick_netz[index].point.y;
	  pick_netz[index].normal.z = pick_netz[index].point.z;
	  normal(&pick_netz[index].normal);
	  theta += (2.0 * pi) / (float) anzpoints;
	}
      phi += pi / (float) anzpoints;
      // Kreis schliessen
      index = i * anznetz + anzpoints;
      pick_netz[index].point = pick_netz[index - anzpoints].point;
      pick_netz[index].normal = pick_netz[index - anzpoints].normal;
    }
}

// erzeugt die einzelnen Pickmarker
void
pickmarker_insert(vector point, int nr)
{
  PEXArrayOfFacetData dummy;
  PEXArrayOfVertex pickn;

  create_pick_netz(point, 0.1);

  PEXSetEditingMode(pDisplay, pick_struct, PEXStructureInsert);
  PEXSetElementPtr(pDisplay, pick_struct, PEXBeginning, 0);
  PEXSetPickID(pDisplay, pick_struct, PEXOCStore, (long) nr);
  PEXSetSurfaceColor(pDisplay, pick_struct, PEXOCStore, PEXColorTypeRGB, &pick_color);
  pickn.normal = pick_netz;
  PEXQuadrilateralMesh(pDisplay, pick_struct, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANormal, PEXColorTypeRGB, dummy,
		       PICK_APPROX_ANZ + 1, PICK_APPROX_ANZ + 1, pickn);
}

bool
getpickid(long *pickid, PEXPickPath ** ppath, float box)
{
  int method, aperture_type, status, better, draw_quadrat;
  PEXPickRecord aperture;
  PEXPickPath *path;
  Cursor pickcursor;
  XWindowAttributes wattrs;
  XEvent event;

  /* einfacher Font-Pickcursor */

  pickcursor = XCreateFontCursor(pDisplay, XC_hand2);
  XDefineCursor(pDisplay, XtWindow(WGdrawarea), pickcursor);

  // Event holen
  do
    {
      XMaskEvent(pDisplay, ButtonPress, &event);
    }
  while (event.type != ButtonPress);

  if (event.xbutton.button == Button1)
    {
      // method = PEXPickClosestZ;
      method = PEXPickLast;
      aperture_type = PEXPickDeviceNPCHitVolume;	/* 3d Pickbox */
      XGetWindowAttributes(pDisplay, XtWindow(WGdrawarea), &wattrs);
      /* die Zeichenflaeche ist immer Quadratisch! */
      draw_quadrat = (wattrs.width < wattrs.height) ? wattrs.width : wattrs.height;
      aperture.box.position.x = event.xbutton.x;
      aperture.box.position.y = wattrs.height - event.xbutton.y;
      aperture.box.distance = 2.0;
      /* primitives Beispiel */
      aperture.volume.min.x = (float) event.xbutton.x / (float) draw_quadrat - box;
      aperture.volume.min.y = (float) (draw_quadrat - event.xbutton.y) /
	(float) draw_quadrat - box;

      /* NC !!!! */
      aperture.volume.min.z = 0.0;
      aperture.volume.max.x = aperture.volume.min.x + box;
      aperture.volume.max.y = aperture.volume.min.y + box;
      aperture.volume.max.z = 1.0;

      path = PEXPickOne(pDisplay, XtWindow(WGdrawarea), renderer, root_struct, method,
			aperture_type, &aperture, &status, &better);
      if (status == PEXPick)
	{
	  /* pick id holen */
	  *pickid = path->elements[path->count - 1].pick_id;
	  *ppath = path;
	  // pickcursor lschen 
	  XUndefineCursor(pDisplay, XtWindow(WGdrawarea));
	  return true;
	}
      else
	*pickid = 0;
    }
  // pickcursor loeschen 
  XUndefineCursor(pDisplay, XtWindow(WGdrawarea));
  *ppath = NULL;
  return false;
}

void
getpick_polygon(grobjekt * pgrobj)
{
  long pick_id;
  int anz;
  PEXPickPath *path;
  vector p1, p2, p3, p4;
  char vstr[80];

  // Daten des Polygones
  ((cadpolygon *) (pgrobj->objp))->get(&anz, &p1, &p2, &p3, &p4);
  // Selektiere die Punkte
  pickmarker_create(&(pgrobj->obj_struct));

  pickmarker_insert(p1, -1);
  pickmarker_insert(p2, -2);
  pickmarker_insert(p3, -3);
  if (anz)
    pickmarker_insert(p4, -4);

  redraw(false);

  if (getpickid(&pick_id, &path, 0.01))
    {
      pickmarker_delete();
      switch (pick_id)
	{
	case -1:
	  pickmarker_insert(p1, -1);
	  transform(&p1, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p1.x, p1.y, p1.z);
	  break;
	case -2:
	  pickmarker_insert(p2, -2);
	  transform(&p2, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p2.x, p2.y, p2.z);
	  break;
	case -3:
	  pickmarker_insert(p3, -3);
	  transform(&p3, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p3.x, p3.y, p3.z);
	  break;
	case -4:
	  pickmarker_insert(p4, -4);
	  transform(&p4, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p4.x, p4.y, p4.z);
	  break;
	default:
	  sprintf(vstr, "Pick-Ergebnis: Kein Punkt gefunden!");
	}
      // Drag & Drop Ausgabe
      statuszeile(vstr);
    }
  redraw(true);
  pickmarker_destroy(&(pgrobj->obj_struct));
}

void
getpick_kugel(grobjekt * pgrobj)
{
  vector p1;
  float r1, w1, w2;
  char vstr[80];

  // Daten holen
  ((cadsphere *) (pgrobj->objp))->get(&r1, &w1, &w2, &p1);

  // Selektiere die Punkte
  pickmarker_create(&(pgrobj->obj_struct));

  pickmarker_insert(p1, -1);

  transform(&p1, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p1.x, p1.y, p1.z);

  // Drag & Drop Ausgabe
  statuszeile(vstr);
  redraw(true);
  pickmarker_destroy(&(pgrobj->obj_struct));
}

void
getpick_elipsoid(grobjekt * pgrobj)
{
  vector p1, p2, p3;
  char vstr[80];

  // Daten holen
  ((cadelipsoid *) (pgrobj->objp))->get(&p1, &p2, &p3);

  // Selektiere die Punkte
  pickmarker_create(&(pgrobj->obj_struct));

  pickmarker_insert(p1, -1);

  transform(&p1, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p1.x, p1.y, p1.z);

  // Drag & Drop Ausgabe
  statuszeile(vstr);
  redraw(true);
  pickmarker_destroy(&(pgrobj->obj_struct));
}

void
getpick_torus(grobjekt * pgrobj)
{
  vector p1, p2;
  float w1, w2;
  char vstr[80];

  // Daten holen
  ((cadtorus *) (pgrobj->objp))->get(&p1, &w1, &w2, &p2);

  // Selektiere die Punkte
  pickmarker_create(&(pgrobj->obj_struct));

  pickmarker_insert(p1, -1);

  transform(&p1, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p1.x, p1.y, p1.z);

  // Drag & Drop Ausgabe
  statuszeile(vstr);
  redraw(true);
  pickmarker_destroy(&(pgrobj->obj_struct));
}

void
getpick_block(grobjekt * pgrobj)
{
  long pick_id;
  PEXPickPath *path;
  vector p1, p2, p3, p4, p5, p6, p7, p8;
  char vstr[80];

  // Daten des Polygones
  ((cadblock *) (pgrobj->objp))->get(&p1, &p2, &p3, &p4, &p5, &p6, &p7, &p8);

  // Selektiere die Punkte
  pickmarker_create(&(pgrobj->obj_struct));

  pickmarker_insert(p1, -1);
  pickmarker_insert(p2, -2);
  pickmarker_insert(p3, -3);
  pickmarker_insert(p4, -4);
  pickmarker_insert(p5, -5);
  pickmarker_insert(p6, -6);
  pickmarker_insert(p7, -7);
  pickmarker_insert(p8, -8);

  redraw(false);

  if (getpickid(&pick_id, &path, 0.01))
    {
      pickmarker_delete();
      switch (pick_id)
	{
	case -1:
	  pickmarker_insert(p1, -1);
	  transform(&p1, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p1.x, p1.y, p1.z);
	  break;
	case -2:
	  pickmarker_insert(p2, -2);
	  transform(&p2, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p2.x, p2.y, p2.z);
	  break;
	case -3:
	  pickmarker_insert(p3, -3);
	  transform(&p3, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p3.x, p3.y, p3.z);
	  break;
	case -4:
	  pickmarker_insert(p4, -4);
	  transform(&p4, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p4.x, p4.y, p4.z);
	  break;
	case -5:
	  pickmarker_insert(p5, -1);
	  transform(&p5, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p5.x, p5.y, p5.z);
	  break;
	case -6:
	  pickmarker_insert(p6, -2);
	  transform(&p6, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p6.x, p6.y, p6.z);
	  break;
	case -7:
	  pickmarker_insert(p7, -3);
	  transform(&p7, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p7.x, p7.y, p7.z);
	  break;
	case -8:
	  pickmarker_insert(p8, -4);
	  transform(&p8, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p8.x, p8.y, p8.z);
	  break;
	default:
	  sprintf(vstr, "Pick-Ergebnis: Kein Punkt gefunden!");
	}
      // Drag & Drop Ausgabe
      statuszeile(vstr);
    }
  redraw(true);
  pickmarker_destroy(&(pgrobj->obj_struct));
}

void
getpick_zylinder(grobjekt * pgrobj)
{
  long pick_id;
  PEXPickPath *path;
  vector p1, p2;
  float r1, r2, w1;
  char vstr[80];

  // Daten des Polygones
  ((cadzylinder *) (pgrobj->objp))->get(&p1, &p2, &r1, &r2, &w1);

  // Selektiere die Punkte
  pickmarker_create(&(pgrobj->obj_struct));

  pickmarker_insert(p1, -1);
  pickmarker_insert(p2, -2);

  redraw(false);

  if (getpickid(&pick_id, &path, 0.01))
    {
      pickmarker_delete();
      switch (pick_id)
	{
	case -1:
	  pickmarker_insert(p1, -1);
	  transform(&p1, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p1.x, p1.y, p1.z);
	  break;
	case -2:
	  pickmarker_insert(p2, -2);
	  transform(&p2, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p2.x, p2.y, p2.z);
	  break;
	default:
	  sprintf(vstr, "Pick-Ergebnis: Kein Punkt gefunden!");
	}
      // Drag & Drop Ausgabe
      statuszeile(vstr);
    }
  redraw(true);
  pickmarker_destroy(&(pgrobj->obj_struct));
}

void
getpick_ybuffer(grobjekt * pgrobj)
{
  long pick_id;
  PEXPickPath *path;
  vector p1, p2, p3, p4;
  longint xl, zl;
  float *py;
  char vstr[80];

  // Daten des Polygones
  ((cadybuffer *) (pgrobj->objp))->get(&p1, &p2, &p3, &p4, &xl, &zl, &py);

  // Selektiere die Punkte
  pickmarker_create(&(pgrobj->obj_struct));

  pickmarker_insert(p1, -1);
  pickmarker_insert(p2, -2);
  pickmarker_insert(p3, -3);
  pickmarker_insert(p4, -4);

  redraw(false);

  if (getpickid(&pick_id, &path, 0.01))
    {
      pickmarker_delete();
      switch (pick_id)
	{
	case -1:
	  pickmarker_insert(p1, -1);
	  transform(&p1, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p1.x, p1.y, p1.z);
	  break;
	case -2:
	  pickmarker_insert(p2, -2);
	  transform(&p2, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p2.x, p2.y, p2.z);
	  break;
	case -3:
	  pickmarker_insert(p3, -3);
	  transform(&p3, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p3.x, p3.y, p3.z);
	  break;
	case -4:
	  pickmarker_insert(p4, -4);
	  transform(&p4, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
	  sprintf(vstr, "%0.4f;%0.4f;%0.4f", p4.x, p4.y, p4.z);
	  break;
	default:
	  sprintf(vstr, "Pick-Ergebnis: Kein Punkt gefunden!");
	}
      // Drag & Drop Ausgabe
      statuszeile(vstr);
    }
  redraw(true);
  pickmarker_destroy(&(pgrobj->obj_struct));
}

/*
void
getpick_bezier(grobjekt * pgrobj)
{
  long pick_id, x, z, m;
  longint a, b;
  PEXPickPath *path;

  vector pbuf[4][4];
  char vstr[80];

  // Daten holen
  ((cadbezier *) (pgrobj->objp))->get(&a, &b, &pbuf);

  // Selektiere die Punkte
  pickmarker_create(&(pgrobj->obj_struct));

  for (z = 0, m = 0; z < 4; z++)
    for (x = 0; x < 4; x++)
      pickmarker_insert(pbuf[x][z], --m);

  redraw(false);

  if (getpickid(&pick_id, &path, 0.01))
    {
      pickmarker_delete();

      // zaehle den pickmarker hoch
      for (z = 0, m = 0; z < 4; z++)
	for (x = 0; x < 4; x++)
	  {
	    m--;		// zaehlen

	    if (pick_id == m)
	      {
		pickmarker_insert(pbuf[x][z], m);
		transform(&(pbuf[x][z]), pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
		sprintf(vstr, "%0.4f;%0.4f;%0.4f", pbuf[x][z].x, pbuf[x][z].y, pbuf[x][z].z);
		// gehe aus Schleife
		x = z = 4;
		// Drag & Drop Ausgabe
		statuszeile(vstr);
	      }
	  }
    }
  redraw(true);
  pickmarker_destroy(&(pgrobj->obj_struct));
}
*/

void
getpick_nurbs(grobjekt * pgrobj)
{
  int cu, cv, ou, ov, zl, xl;
  float *i, *j;
  vect4d *y;
  longint a, b, pos;
  long pick_id, m;
  PEXPickPath *path;
  vector p1;
  char vstr[80];

  // Daten holen
  ((nurbs *) (pgrobj->objp))->get(&a, &b, &cu, &cv, &ou, &ov, &y, &i, &j);

  // Selektiere die Punkte
  pickmarker_create(&(pgrobj->obj_struct));

  // schreibe Knoten
  for (zl = 0, m = 0; zl < b; zl++)
    for (xl = 0; xl < a; xl++)
      {
	pos = zl * a + xl;
	p1 = vector(y[pos].x, y[pos].y, y[pos].z);
	pickmarker_insert(p1, --m);
      }

  redraw(false);

  if (getpickid(&pick_id, &path, 0.01))
    {
      pickmarker_delete();

      // zaehle den pickmarker hoch
      for (zl = 0, m = 0; zl < b; zl++)
	for (xl = 0; xl < a; xl++)
	  {
	    m--;		// zaehlen

	    if (pick_id == m)
	      {
		pos = zl * a + xl;
		p1 = vector(y[pos].x, y[pos].y, y[pos].z);
		pickmarker_insert(p1, m);
		transform(&p1, pgrobj->s, pgrobj->v, pgrobj->w, pgrobj->ref);
		sprintf(vstr, "%0.4f;%0.4f;%0.4f", p1.x, p1.y, p1.z);
		// gehe aus Schleife
		xl = a;
		zl = b;
		// Drag & Drop Ausgabe
		statuszeile(vstr);
	      }
	  }
    }
  redraw(true);
  pickmarker_destroy(&(pgrobj->obj_struct));
}

void
CBGetPick(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  long pick_id;
  PEXPickPath *path;
  grobjekt *pobj;

  if (getpickid(&pick_id, &path, 0.02))
    {
      // es kann auch das Visier am Bildschirm getroffen werden!
      pobj = oliste.getobjp(pick_id);

      // es kann auch das Visier am Bildschirm getroffen werden!
      if (pobj != NULL)
	{
	  // Type testen
	  switch (pobj->type)
	    {
	    case POLYGON:
	      getpick_polygon(pobj);
	      break;
	    case SPHERE:
	      getpick_kugel(pobj);
	      break;
	    case ELIPSOID:
	      getpick_elipsoid(pobj);
	      break;
	    case BLOCK:
	      getpick_block(pobj);
	      break;
	    case TORUS:
	      getpick_torus(pobj);
	      break;
	    case CONE:
	      getpick_zylinder(pobj);
	      break;
	    case YBUFFER:
	      getpick_ybuffer(pobj);
	      break;
	      /*
	    case BEZIER:
	      getpick_bezier(pobj);
	      break;*/
	    case NURBS:
	      getpick_nurbs(pobj);
	      break;
	    default:
	      fprintf(stderr, "Nicht definierter Objekttyp!\n");
	    }
	}
    }
  else
    fprintf(stderr, "pick_id = keines getroffen \n");
}

PEXPickPath *
pick(grobjekt ** pgrobj, int type)
{
  long pick_id;
  PEXPickPath *path;
  grobjekt *pobj;

  if (getpickid(&pick_id, &path, 0.02))
    {
      // es kann auch das Visier am Bildschirm getroffen werden!
      if ((pobj = oliste.getobjp(pick_id)) == NULL)
	return NULL;

      // nur den definierten Typ picken!, oder alle wenn type == 0
      if ((pobj->type == type) || !type)
	{
	  if (pobj->nr == pick_id)
	    {
	      *pgrobj = pobj;
	      echo(path);
	    }
	  else
	    *pgrobj = NULL;
	  return path;
	}
      else
	return NULL;
    }
  return NULL;
}
