/* 
   Headerfile fr PEX - Tool
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __PEXTOOL_H
#define __PEXTOOL_H

#include "cadtool.H"
//#include "patches.H"
#include "ray.H"

#define SET_VERTEX_COORD(d, s)\
{ (d).x = (s).x; (d).y = (s).y;  (d).z = (s).z; }

#define SET_VECT(r,g,b,c) { (c).x=(r); (c).y=(g); (c).z=(b); }
#define SET_VECTA(a, c) { (c).x=(a).x; (c).y=(a).y; (c).z=(a).z; }
#define SET_VECT2D(r,g,c) { (c).x=(r); (c).y=(g); }

#define SET_COLOR( r, g, b, c ) { \
	(c).rgb.red = (r); \
	(c).rgb.green = (g); \
	(c).rgb.blue = (b);}

#define VERSION_5_0( info ) \
    ( (info)->major_version == 5 && (info)->minor_version == 0)

#define VERSION_5_1( info ) \
    ( (info)->major_version == 5 && (info)->minor_version == 1)

#define STRUCTURE_SPT( info ) \
    (   ( VERSION_5_0( info ) && \
	( ((info)->subset_info & 0xFFFF) == PEXCompleteImplementation ) ) \
     || ( VERSION_5_1( info ) && \
	( ((info)->subset_info & 0xFFFF) == PEXCompleteImplementation \
	    || (info)->subset_info & PEXStructureMode ) ) \
    )

/* Ausgabe neu aufbauen */
void redraw (bool clear);

/* echo high-lighting aufheben */
void un_echo (class grobjekt * grobjp, bool noschnitt);
//void un_echo(PEXStructure *element, bool noschnitt);

/* echo high-lighting aufheben */
void un_echo_all (void);

// erzeugt eine neue PEX-Struktur nach dem Lschen 
// einer Lichtquelle
void neue_licht_marker ();
void neue_strahler_marker ();
void neue_lichtpoly_marker ();

// erzeugt in der Rootstruct die Definitionen um mit Lichtquellen
// arbeiten zu knnen
void create_lichtquellen (void);
void delete_lichtquellen (bool rd);

/* PEX - Struktur erzeugen */
void create_structure ();

/* String auf Statuszeile ausgeben */
void statuszeile (char *str);

/* picken eines Grafischen Objekts */
PEXPickPath *pick (grobjekt ** pgrobj, int type);

/* viewport setzen */
void set_view (PEXLookupTable view_table);

/* pick Filter setzen */
void set_pick_filter_inc (int name);

void initPEXColors (PEXColorApproxEntry * acolor, XStandardColormap * stdcmap);

PEXRenderer setup_renderer (Display * dpy, Window window, PEXColorApproxEntry * capx_info,
			    PEXRendererAttributes * attrs);
int get_standard_colormap (Display * dpy, XStandardColormap * cmap_info);

void create_model ();

void print_nurbs (grobjekt * pobj);

// Vektornormalisierung fr PEXVector
void normal (PEXVector * v);

void transform (vector * p, float scal, vector mov, vector winkel, vector ref);

#endif
