/*  Hilfsfunktionen fuer PEX 
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

PEXRenderer renderer;

// Haupt Struktur
PEXStructure root_struct;
PEXLookupTable view_table;
PEXViewEntry view;

// Struktur fuer Lichtquellen Polymarker
PEXStructure light_struct;

// Struktur fuer Lichtstrahler
PEXStructure strahler_struct;

// Struktur fuer LichtPolygon
PEXStructure lichtpoly_struct;

// Struktur fuer Pickpunkte
PEXStructure pick_struct;

// Struktur fr Kamerafhrung
PEXStructure kamera_struct;

PEXColor echo_color, normal_color, schnitt_color, pick_color;

void
transform(vector * p, float scal, vector mov, vector winkel, vector ref)
{
  *p *= scal;
  rotation(p, ref, winkel);
  *p += mov;
}

void
normal(PEXVector * v)
{
  float s = v->x * v->x + v->y * v->y + v->z * v->z;
  if (fabs(s) <= eps5)
    {
      v->x = 0.0;
      v->y = 0.0;
      v->z = 0.0;
    }
  else
    {
      s = 1.0 / sqrt(s);
      v->x *= s;
      v->y *= s;
      v->z *= s;
    }
}

// klappt nicht, gibt nur Eingabedaten aus!
void
print_nurbs(grobjekt * pobj)
{
  PEXStructure struct_id = pobj->obj_struct;
  PEXStructureInfo struct_info;
  PEXOCData *el_data;
  char *raw_data;
  unsigned long mask, num_elements, raw_length;
  int x, y, float_format, status;
  word e;
  float a;

  float_format = PEXGetProtocolFloatFormat(pDisplay);
  mask = PEXNumElements | PEXEditMode | PEXElementPtr | PEXHasRefs;
  PEXGetStructureInfo(pDisplay, struct_id, float_format, mask, &struct_info);

  for (e = 1; e <= struct_info.element_count; e++)
    {
      status = PEXFetchElements(pDisplay, struct_id,
				PEXBeginning, e,
				PEXBeginning, e,
				float_format, &num_elements,
				&raw_length, &raw_data);

      el_data = PEXDecodeOCs(float_format, num_elements, raw_length, raw_data);
      fprintf(stderr, "Drucke Nurbs Elemente\n");
      if (el_data->oc_type == PEXOCNURBSurface)
	{
	  fprintf(stderr, "Nurb gefunden!\n");

	  x = el_data->data.NURBSurface.curve_count;
	  y = el_data->data.NURBSurface.row_count;

	  fprintf(stderr, "x: %d y: %d\n", x, y);

	  for (y = 0; y < 12; y++)
	    {
	      // Eingabedaten!!
	      a = el_data->data.NURBSurface.points.point_4d[y].x;
	      fprintf(stderr, "%0.2f ", a);
	    }
	}
    }
}

void
set_pick_filter_inc(int name)
{
  PEXName incl_list[1];

  incl_list[0] = (PEXName) name;	/* Name der zu pickenden Objekte */
  PEXChangeNameSet(pDisplay, PEXattributes.pick_incl, PEXNSAdd, 1, incl_list);
}

void
un_echo(class grobjekt * grobjp, bool noschnitt)
{
  PEXColor obj_color;

  // ist Zeiger nicht NULL
  if (grobjp)
    {
      /* offset 1 = Farbeintrag da Label davor ist */
      PEXSetElementPtr(pDisplay, grobjp->obj_struct, PEXBeginning, 0);
      PEXSetElementPtrAtLabel(pDisplay, grobjp->obj_struct, COLORLABEL, 1);

      PEXSetEditingMode(pDisplay, grobjp->obj_struct, PEXStructureReplace);

      if (noschnitt)
	{
	  SET_COLOR(grobjp->r, grobjp->g, grobjp->b, obj_color);
	  PEXSetSurfaceColor(pDisplay, grobjp->obj_struct, PEXOCStore,
			     PEXColorTypeRGB, &obj_color);
	}
      else
	PEXSetSurfaceColor(pDisplay, grobjp->obj_struct, PEXOCStore,
			   PEXColorTypeRGB, &schnitt_color);

    }
  // immer Redraw!
  redraw(false);
}

void
un_echo_all(void)
{
  PEXColor obj_color;
  grobjekt *grx;

  for (grx = oliste.getfirst(); grx; grx = oliste.getnext())
    {
      PEXSetEditingMode(pDisplay, grx->obj_struct, PEXStructureReplace);

      /* offset 1 = Farbeintrag da Label davor ist */
      PEXSetElementPtr(pDisplay, grx->obj_struct, PEXBeginning, 0);
      PEXSetElementPtrAtLabel(pDisplay, grx->obj_struct, COLORLABEL, 1);

      if (grx->ch == 'N')
	{
	  if (lichton)
	    {
	      SET_COLOR(grx->r, grx->g, grx->b, obj_color);
	      PEXSetSurfaceColor(pDisplay, grx->obj_struct,
				 PEXOCStore, PEXColorTypeRGB, &obj_color);
	    }
	  else
	    PEXSetSurfaceColor(pDisplay, grx->obj_struct,
			       PEXOCStore, PEXColorTypeRGB, &normal_color);
	}
      else
	PEXSetSurfaceColor(pDisplay, grx->obj_struct,
			   PEXOCStore, PEXColorTypeRGB, &schnitt_color);
      redraw(false);
    }
}

void
echo(PEXPickPath * path)
{
  PEXStructure *element;
  /* Struktur */
  element = &path->elements[path->count - 1].sid;
  PEXSetEditingMode(pDisplay, *element, PEXStructureReplace);
  /* offset 1 = Farbeintrag da Label davor ist */
  PEXSetElementPtr(pDisplay, *element, PEXBeginning, 0);
  PEXSetElementPtrAtLabel(pDisplay, *element, COLORLABEL, 1);
  PEXSetSurfaceColor(pDisplay, *element, PEXOCStore, PEXColorTypeRGB, &echo_color);
  redraw(false);
}


/* Das View wird nicht vom Nutzer definiert da es dem Raytracer entsprechen soll */
void
set_view()
{
  bool erg;
  PEXCoord prp;
  PEXCoord2D vwindow[2];
  double view_plane, front_plane, back_plane;
  PEXNPCSubVolume viewport;

  /* view parameter */
  PEXCoord view_ref_pt =
  {0.0, 0.0, 0.0};
  PEXVector view_plane_normal =
  {0.0, 0.0, 1.0};
  PEXVector view_up_vec =
  {0.0, 1.0, 0.0};

  /* berechne die view Transformation */
  PEXViewOrientationMatrix(&view_ref_pt, &view_plane_normal, &view_up_vec,
			   view.orientation);

  /* view mapping Parameter */
  SET_VECT(0.0, 0.0, -1.0, prp);

  SET_VECT2D(-1.025, -1.025, vwindow[0]);
  SET_VECT2D(+1.025, +1.025, vwindow[1]);

  /* damit das Objekt nicht so schnell auer Sichtbereich gelangt */
  front_plane = 40.0;
  view_plane = 0.0;
  back_plane = -.80;

  SET_VECT(0.0, 0.0, 0.0, viewport.min);
  SET_VECT(1.0, 1.0, 1.0, viewport.max);

  /* berechne die view mapping Transformation */
  erg = PEXViewMappingMatrix(vwindow, &viewport, True, &prp, view_plane, back_plane,
			     front_plane, view.mapping);

  /* clipping Parameter */
  view.clip_flags = !PEXClippingAll;
  view.clip_limits = viewport;

  /* View setzen */
  if (!erg)
    PEXSetTableEntries(pDisplay, view_table, 1, 1,
		       PEXLUTView, (PEXPointer) & view);
  else
    fprintf(stderr, "PEXViewMappingMatrix() liefert Fehler %d\n", erg);
}

void
statuszeile(char *str)
{
  XmString anzstr;
  Arg Aargs;

  anzstr = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(SWStatuslabel, &Aargs, 1);
}

void
redraw(bool clear)
{
  if (clear)
    XClearWindow(pDisplay, XtWindow(WGdrawarea));
  PEXRenderNetwork(pDisplay, XtWindow(WGdrawarea), renderer, root_struct);
  XFlush(pDisplay);		/* Ausnamsweise mal! */
}

void
neue_licht_marker()
{
  // einfach alle Lschen und neu aufbauen
  PEXDeleteElements(pDisplay, light_struct, PEXBeginning, 0, PEXEnd, 0);
  for (lichtx = lichtanf; lichtx; lichtx = lichtx->next)
    erz_lichtquelle(vector(lichtx->x, lichtx->y, lichtx->z), lichtx->nr);
}

void
neue_strahler_marker()
{
  // einfach alle Loeschen und neu aufbauen
  PEXDeleteElements(pDisplay, strahler_struct, PEXBeginning, 0, PEXEnd, 0);
  for (strahlerx = strahleranf; strahlerx; strahlerx = strahlerx->next)
    erz_strahler(strahlerx->pos, strahlerx->richtung, strahlerx->nr);
}

void
neue_lichtpoly_marker()
{
  // einfach alle Loeschen und neu aufbauen
  PEXDeleteElements(pDisplay, lichtpoly_struct, PEXBeginning, 0, PEXEnd, 0);
  for (lichtpolyx = lichtpolyanf; lichtpolyx; lichtpolyx = lichtpolyx->next)
    erz_lichtpolygon(lichtpolyx->p1, lichtpolyx->p2, lichtpolyx->p3, lichtpolyx->p4,
		     lichtpolyx->xanz, lichtpolyx->yanz, lichtpolyx->nr);
}

void
delete_lichtquellen(bool rd)
{
  grobjekt *grobjp;
  longint anzl;

  // Objekte wieder zu normal_color setzen
  for (grobjp = oliste.getfirst(); grobjp; grobjp = oliste.getnext())
    {
      PEXSetEditingMode(pDisplay, grobjp->obj_struct, PEXStructureReplace);
      PEXSetElementPtr(pDisplay, grobjp->obj_struct, PEXBeginning, 0);
      PEXSetElementPtrAtLabel(pDisplay, grobjp->obj_struct, COLORLABEL, 1);

      PEXSetSurfaceColor(pDisplay, grobjp->obj_struct, PEXOCStore,
			 PEXColorTypeRGB, &normal_color);
    }

  // zaehle Anzahl
  for (lichtx = lichtanf, anzl = 1; lichtx; lichtx = lichtx->next, anzl++);

  // Tabelleneintraege fuer Lichtquellen loeschen
  PEXDeleteTableEntries(pDisplay, PEXattributes.light_table, 1, anzl);
  // PEXFreeLookupTable(pDisplay, PEXattributes.light_table);

  if (rd)
    redraw(true);		// Mit Bildschirmloeschen wegen den Flaechen zwischen den Linien

}

void
create_lichtquellen(void)
{
  PEXTableIndex lights_on[2] =
  {AMBIENT_LIGHT, POINT_LIGHT};
  PEXColor obj_color;
  longint anzl;
  PEXLightEntry *lightsp;
  grobjekt *grobjp;


  PEXSetEditingMode(pDisplay, root_struct, PEXStructureInsert);

  // Flchen fllen!
  PEXSetInteriorStyle(pDisplay, root_struct, PEXOCStore, PEXInteriorStyleSolid);

  // Lichteffekte berechnen
  PEXSetReflectionModel(pDisplay, root_struct, PEXOCStore, PEXReflectionSpecular);

  // Groundshading
  PEXSetSurfaceInterpMethod(pDisplay, root_struct, PEXOCStore, PEXSurfaceInterpColor);

  // lasse Rckseite weg
  //PEXSetFacetCullingMode(pDisplay, root_struct, PEXOCStore, PEXBackFaces);
  PEXSetFacetCullingMode(pDisplay, root_struct, PEXOCStore, PEXFrontFaces);

  // erzeuge Lichtquellen
  // zhle Anzahl
  for (lichtx = lichtanf, anzl = 0; lichtx; lichtx = lichtx->next, anzl++);

  lightsp = new PEXLightEntry[anzl + 1];

  // Umgebungslicht setzen
  lightsp[0].type = PEXLightAmbient;
  lightsp[0].color.type = PEXColorTypeRGB;
  lightsp[0].color.value.rgb.red = AmbDialog.r;
  lightsp[0].color.value.rgb.green = AmbDialog.g;
  lightsp[0].color.value.rgb.blue = AmbDialog.b;

  for (lichtx = lichtanf, anzl = 1; lichtx; lichtx = lichtx->next, anzl++)
    {
      lightsp[anzl].type = PEXLightWCPoint;

      lightsp[anzl].color.type = PEXColorTypeRGB;
      lightsp[anzl].color.value.rgb.red = lichtx->r;
      lightsp[anzl].color.value.rgb.green = lichtx->g;
      lightsp[anzl].color.value.rgb.blue = lichtx->b;

      lightsp[anzl].point.x = lichtx->x;
      lightsp[anzl].point.y = lichtx->y;
      lightsp[anzl].point.z = lichtx->z;

      // Was fuer Werte???
      lightsp[anzl].attenuation1 = 1.0;
      lightsp[anzl].attenuation2 = 1.0;
    }

  // Tabelleneintrag fr Lichtquelle
  PEXSetTableEntries(pDisplay, PEXattributes.light_table, 1, anzl, PEXLUTLight, lightsp);

  //                                                        2 Lichtarten!
  PEXSetLightSourceState(pDisplay, root_struct, PEXOCStore, 2, lights_on,
			 0, (PEXTableIndex *) NULL);

  // Speicher wieder freigeben
  delete lightsp;

  // Die richtigen Farben der Objekte setzen
  for (grobjp = oliste.getfirst(); grobjp; grobjp = oliste.getnext())
    {
      PEXSetEditingMode(pDisplay, grobjp->obj_struct, PEXStructureReplace);
      PEXSetElementPtr(pDisplay, grobjp->obj_struct, PEXBeginning, 0);
      PEXSetElementPtrAtLabel(pDisplay, grobjp->obj_struct, COLORLABEL, 1);

      SET_COLOR(grobjp->r, grobjp->g, grobjp->b, obj_color);
      PEXSetSurfaceColor(pDisplay, grobjp->obj_struct, PEXOCStore, PEXColorTypeRGB, &obj_color);
    }

  redraw(false);
}

void
create_structure()
{
  PEXCoord coord[5], ref_point;
  PEXName name[1];
  PEXMatrix matrix;
  PEXVector tr, scale;
  PEXColor coord_color;

  root_struct = PEXCreateStructure(pDisplay);

  /* View Index setzen */
  PEXSetViewIndex(pDisplay, root_struct, PEXOCStore, 1);

  /* Edge Flags setzen */
  PEXSetSurfaceEdgeFlag(pDisplay, root_struct, PEXOCStore, PEXOn);

  name[0] = (PEXName) GROBJSTR;
  PEXAddToNameSet(pDisplay, root_struct, PEXOCStore, 1, name);

  /* Default Werte fr grafische Elemente */
  SET_COLOR(1.0, 1.0, 1.0, normal_color);
  SET_COLOR(1.0, 1.0, 0.0, echo_color);
  SET_COLOR(0.0, 1.0, 0.0, coord_color);
  SET_COLOR(1.0, 0.0, 0.0, schnitt_color);
  SET_COLOR(0.0, 1.0, 0.0, pick_color);

  PEXSetPickID(pDisplay, root_struct, PEXOCStore, 0);

  PEXSetLineColor(pDisplay, root_struct, PEXOCStore, PEXColorTypeRGB, &coord_color);

  /* Koordinatensystem */
  /* Boden */
  SET_VECT(-1.0, -1.0, +0.0, coord[0]);
  SET_VECT(+1.0, -1.0, +0.0, coord[1]);
  SET_VECT(+1.0, -1.0, +1.0, coord[2]);
  SET_VECT(-1.0, -1.0, +1.0, coord[3]);
  SET_VECT(-1.0, -1.0, +0.0, coord[4]);
  PEXPolyline(pDisplay, root_struct, PEXOCStore, 5, coord);

  /* Deckel */
  SET_VECT(-1.0, +1.0, +0.0, coord[0]);
  SET_VECT(+1.0, +1.0, +0.0, coord[1]);
  SET_VECT(+1.0, +1.0, +1.0, coord[2]);
  SET_VECT(-1.0, +1.0, +1.0, coord[3]);
  SET_VECT(-1.0, +1.0, +0.0, coord[4]);
  PEXPolyline(pDisplay, root_struct, PEXOCStore, 5, coord);

  /* Visier */
/*
   SET_VECT(-0.5, -0.5, +1.0, coord[0]);
   SET_VECT(+0.5, -0.5, +1.0, coord[1]);
   SET_VECT(+0.5, +0.5, +1.0, coord[2]);
   SET_VECT(-0.5, +0.5, +1.0, coord[3]);
   SET_VECT(-0.5, -0.5, +1.0, coord[4]);
   PEXPolyline(pDisplay, root_struct, PEXOCStore,  5, coord);
 */

  PEXLabel(pDisplay, root_struct, PEXOCStore, COLORLABEL);
  PEXSetLineColor(pDisplay, root_struct, PEXOCStore, PEXColorTypeRGB, &coord_color);

  // Struktur fr die Kamerafhrung vor Globaler Transformation
  // da die Kamera nicht transformiert werden soll
  kamera_struct = PEXCreateStructure(pDisplay);
  PEXLabel(pDisplay, kamera_struct, PEXOCStore, OBJ_KAMERA_LABEL);
  PEXExecuteStructure(pDisplay, root_struct, PEXOCStore, kamera_struct);

  /* Globale Transformation, da root Stuktur */
  SET_VECT(0.0, 0.0, 0.0, ref_point);
  SET_VECT(0.0, 0.0, 0.0, tr);
  SET_VECT(1.0, 1.0, 1.0, scale);
  PEXBuildTransform(&ref_point, &tr, 0.0, 0.0, 0.0, &scale, matrix);
  PEXLabel(pDisplay, root_struct, PEXOCStore, TRANSFORM_LABEL);

  PEXSetLocalTransform(pDisplay, root_struct, PEXOCStore, PEXReplace, matrix);

  // Struktur zum Picken von Punkten
  pick_struct = PEXCreateStructure(pDisplay);

  // Lichtquellen ausfhren
  light_struct = PEXCreateStructure(pDisplay);
  PEXLabel(pDisplay, light_struct, PEXOCStore, OBJ_LIGHT_LABEL);
  PEXExecuteStructure(pDisplay, root_struct, PEXOCStore, light_struct);

  // Strahler ausfhren
  strahler_struct = PEXCreateStructure(pDisplay);
  PEXLabel(pDisplay, strahler_struct, PEXOCStore, OBJ_STRAHLER_LABEL);
  PEXExecuteStructure(pDisplay, root_struct, PEXOCStore, strahler_struct);

  // Lichtpolygon ausfhren
  lichtpoly_struct = PEXCreateStructure(pDisplay);
  PEXLabel(pDisplay, lichtpoly_struct, PEXOCStore, OBJ_LIGHTPOLY_LABEL);
  PEXExecuteStructure(pDisplay, root_struct, PEXOCStore, lichtpoly_struct);

  /* ein paar Globale Eigenschaften */
  PEXSetLineWidth(pDisplay, root_struct, PEXOCStore, 1.0);
  PEXSetLineType(pDisplay, root_struct, PEXOCStore, 1);

  /* View definieren */
  set_view();
  set_pick_filter_inc(GROBJSTR);
}

void
initPEXColors(PEXColorApproxEntry * acolor, XStandardColormap * stdcmap)

{
  /* 
   * Set up the color approximations structure. The values
   * come from the standard colormap.
   */

  acolor->type = PEXColorSpace;
  acolor->model = PEXColorApproxRGB;
  acolor->dither = PEXOn;
  acolor->base_pixel = stdcmap->base_pixel;
  acolor->max1 = stdcmap->red_max;
  acolor->max2 = stdcmap->green_max;
  acolor->max3 = stdcmap->blue_max;
  acolor->mult1 = stdcmap->red_mult;
  acolor->mult2 = stdcmap->green_mult;
  acolor->mult3 = stdcmap->blue_mult;
  acolor->weight1 = 0;
  acolor->weight2 = 0;
  acolor->weight3 = 0;
}

int get_standard_colormap(Display * dpy, XStandardColormap * cmap_info)
{
  int screen, i, number_colormaps, depth;
  Visual *visual;
  XStandardColormap *col_returns;

  screen = DefaultScreen(dpy);
  visual = DefaultVisual(dpy, screen);
  depth = DefaultDepth(dpy, screen);

  if (XmuLookupStandardColormap(dpy, screen, XVisualIDFromVisual(visual),
				depth, XA_RGB_DEFAULT_MAP, False, True) != 0)
    {
      if (XGetRGBColormaps(dpy, RootWindow(dpy, screen), &col_returns, &number_colormaps,
			   XA_RGB_DEFAULT_MAP))
	{
	  for (i = 0; i < number_colormaps; i++)
	    {
	      if (XVisualIDFromVisual(visual) == col_returns[i].visualid)
		{
		  *cmap_info = col_returns[i];
		  /* colormap = *cmap_info.colormap; */
		  break;
		}
	    }
	  if (i >= number_colormaps)
	    {
	      fprintf(stderr, "Fehler beim ermitteln der Farbtabelle!\n");
	      exit(1);
	    }
	}
    }
  return 0;
}

int
enum_type_supported(Display * dpy, Window window, int enum_type, int value)
{
  int enum_types[1], found = 0;
  unsigned long *num_values;
  PEXEnumTypeDesc *values;
  word i;

  enum_types[0] = enum_type;
  if (PEXGetEnumTypeInfo(dpy, window, 1, enum_types,
			 PEXETIndex, &num_values, &values))
    {
      for (i = 0; i < *num_values; i++)
	{
	  if (values[i].index == ((short) value))
	    {
	      found = 1;	/* found it! */
	      break;		/* out of for loop */
	    }
	}
      PEXFreeEnumInfo(1, num_values, values);
    }
  return found;
}

void
load_all_available_fonts(Display * dpy, Window window, PEXRendererAttributes * attrs)
{
  int max;
  word i;
  unsigned long num_fonts;
  char **font_names;
  PEXFont *font_ids;
  PEXTextFontEntry *entries;
  PEXTableInfo table_info;
  PEXExtensionInfo *pex_info;

  /* The X Consortium's sample server crashes when attempting to */
  /* load fonts, and has them pre-loaded anyway.  So return if */
  /* that's the server we're dealing with. */
  pex_info = PEXGetExtensionInfo(dpy);
  if (strstr(pex_info->vendor_name, "Sample Implementation"))
    return;

  /* Determine the font table limit. */
  if (!PEXGetTableInfo(dpy, window, PEXLUTTextFont, &table_info))
    return;			/* bad display pointer or window */
  max = table_info.definable_entries;

  /* Allocate space for the font ids and table entries. */
  font_ids = (PEXFont *) malloc(max * sizeof(PEXFont));
  entries = (PEXTextFontEntry *)
    malloc(max * sizeof(PEXTextFontEntry));

  /* Get the font names, load the fonts, and store in the table. */
  if (font_names = PEXListFonts(dpy, "*", max, &num_fonts))
    {
      for (i = 0; i < num_fonts; i++)
	{
	  font_ids[i] = PEXLoadFont(dpy, font_names[i]);
	  entries[i].count = 1;
	  entries[i].fonts = &font_ids[i];
	}

      PEXSetTableEntries(dpy, attrs->text_font_table, 1, num_fonts,
			 PEXLUTTextFont, (PEXPointer) entries);
      PEXFreeFontNames(num_fonts, font_names);
    }
  free(font_ids);
  free(entries);
}

PEXRenderer
setup_renderer(Display * dpy, Window window, PEXColorApproxEntry * capx_info,
	       PEXRendererAttributes * attrs)
{
  unsigned long mask = 0;
  PEXRenderer renderer;

  /* Create all the bundle tables. */
  mask |= PEXRALineBundle;
  attrs->line_bundle =
    PEXCreateLookupTable(dpy, window, PEXLUTLineBundle);

  mask |= PEXRAMarkerBundle;
  attrs->marker_bundle =
    PEXCreateLookupTable(dpy, window, PEXLUTMarkerBundle);

  mask |= PEXRATextBundle;
  attrs->text_bundle =
    PEXCreateLookupTable(dpy, window, PEXLUTTextBundle);

  mask |= PEXRAInteriorBundle;
  attrs->interior_bundle =
    PEXCreateLookupTable(dpy, window, PEXLUTInteriorBundle);

  mask |= PEXRAEdgeBundle;
  attrs->edge_bundle =
    PEXCreateLookupTable(dpy, window, PEXLUTEdgeBundle);

  /* Conditionally create the pattern table. */
  if (enum_type_supported(dpy, window, PEXETInteriorStyle,
			  PEXInteriorStylePattern))
    {
      mask |= PEXRAPatternTable;
      attrs->pattern_table =
	PEXCreateLookupTable(dpy, window, PEXLUTPattern);
    }

  /* Create a font table. */
/*
   mask |= PEXRATextFontTable;
   attrs->text_font_table =
   PEXCreateLookupTable( dpy, window, PEXLUTTextFont );
   load_all_available_fonts(dpy, window, attrs);
 */

  /* Create a color table. */
  mask |= PEXRAColorTable;
  attrs->color_table =
    PEXCreateLookupTable(dpy, window, PEXLUTColor);

  /* Create a view table. */
  mask |= PEXRAViewTable;
  attrs->view_table =
    PEXCreateLookupTable(dpy, window, PEXLUTView);

  /* Create a light table. */
  mask |= PEXRALightTable;
  attrs->light_table =
    PEXCreateLookupTable(dpy, window, PEXLUTLight);

  /* Create a depth cue table. */
  mask |= PEXRADepthCueTable;
  attrs->depth_cue_table =
    PEXCreateLookupTable(dpy, window, PEXLUTDepthCue);

  /* Create a color approximation table and set the default */
  /* entry, entry 0, to the colormap approximation specified. */
  mask |= PEXRAColorApproxTable;
  attrs->color_approx_table =
    PEXCreateLookupTable(dpy, window, PEXLUTColorApprox);
  PEXSetTableEntries(dpy, attrs->color_approx_table, 0, 1,
		     PEXLUTColorApprox, capx_info);

  /* Create the highlighting, invisibility, and pick name sets. */
  mask |= PEXRAHighlightIncl | PEXRAHighlightExcl;
  attrs->highlight_incl = PEXCreateNameSet(dpy);
  attrs->highlight_excl = PEXCreateNameSet(dpy);

  mask |= PEXRAInvisibilityIncl | PEXRAInvisibilityExcl;
  attrs->invisibility_incl = PEXCreateNameSet(dpy);
  attrs->invisibility_excl = PEXCreateNameSet(dpy);

  mask |= PEXRAPickIncl | PEXRAPickExcl;
  attrs->pick_incl = PEXCreateNameSet(dpy);
  attrs->pick_excl = PEXCreateNameSet(dpy);

  /* Create the renderer */
  renderer = PEXCreateRenderer(dpy, window, mask, attrs);

  view_table = attrs->view_table;

  return renderer;
}
