/*  
   Dialogbox fr Patchgroesse

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"

/* Globale Variable fuer Patchweite */
float Patchweite = 0.1;

Widget WPatchDialog;

STRING helppatchweitedialog = "Kantenlaenge eines Patches fuer die Radiosityrechnung.";


static STRING
XmString2String(XmString XSSource)
{
  STRING szConverted;		/* Ergebnis C String */
  XmStringContext pContext;	/* String Context */
  STRING szString;		/* Teilstring des Gesamt C Strings */
  XmStringCharSet CharSet;	/* Font */
  XmStringDirection Direction;	/* Schreibrichtung */
  Boolean bSeparator;		/* folgt Separator Segment ? */

  szConverted = NULL;
  XmStringInitContext(&pContext, XSSource);

  /*
     * nchstes Stringsegment lesen
   */
  while (XmStringGetNextSegment(pContext, &szString, &CharSet,
				&Direction, &bSeparator))
    {

      if (szConverted)
	{			/* schon etwas umgewandelt, nur anhaengen */
	  szConverted = XtRealloc(szConverted,
				strlen(szConverted) + strlen(szString) + 2);
	  strcat(szConverted, szString);
	}
      else
	{			/* noch kein Umwandlung, neuer String   */
	  szConverted = (STRING) XtMalloc(strlen(szString) + 1);
	  strcpy(szConverted, szString);
	}
      XtFree(szString);

      if (bSeparator)		/* nchstes Segment ist ein Trenner */
	break;
    }
  XmStringFreeContext(pContext);
  return szConverted;
}

void
CBPatchOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  String str;

  str = XmString2String(((XmSelectionBoxCallbackStruct *) pCallData)->value);

  sscanf(str, "%f", &Patchweite);
  XtUnmanageChild(WPatchDialog);
  WPatchDialog = NULL;
}

void
CBPatchCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  XtUnmanageChild(WPatchDialog);
  WPatchDialog = NULL;
}

void
CBPatchHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helppatchweitedialog);
  else
    infobox("helpnureinmal");
}

void
patchdialog(Widget W)
{
  Arg Aargs[MAX_ARGS];
  int nArgs;

  char inputline[256];
  XmString patchwstr, inputstr, cancelstr, helpstr;

  sprintf(inputline, "%0.2f", Patchweite);

  inputstr = XmStringCreateLtoR(inputline, XmSTRING_DEFAULT_CHARSET);
  patchwstr = XmStringCreateLtoR("Patchabstand:", XmSTRING_DEFAULT_CHARSET);
  cancelstr = XmStringCreateLtoR("Abbruch", XmSTRING_DEFAULT_CHARSET);
  helpstr = XmStringCreateLtoR("Hilfe", XmSTRING_DEFAULT_CHARSET);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNtextString, inputstr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNtextColumns, 4);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNselectionLabelString, patchwstr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcancelLabelString, cancelstr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNhelpLabelString, helpstr);
  nArgs++;

  WPatchDialog = XmCreatePromptDialog(W, "patchprompt", Aargs, nArgs);
  XtManageChild(WPatchDialog);

  XtAddCallback(WPatchDialog, XmNokCallback, CBPatchOk, NULL);
  XtAddCallback(WPatchDialog, XmNcancelCallback, CBPatchCancel, NULL);
  XtAddCallback(WPatchDialog, XmNhelpCallback, CBPatchHelp, NULL);
}
