/*
   Syntaxberprfung fr Eingabezeilen
   c++ parse.C -I/usr/X386/include -o parse -lm

   Folgende Gramatik 

   relativ -> @ vector
   vector  -> [relativ] expr ; expr ; expr

   expression -> '-' num expr | '-' expr | expr ;
   expr -> term { '+' term | '-' term  }
   term -> fact { '*' fact | '/' fact  }
   fact -> num | '(' expr ')'

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"


#define SYNTAX_DIV_0       1
#define SYNTAX_FEHLER      2
#define ZU_LANG            3

#define TES_T

enum mcodes
  {
    mop, mdbl
  };

typedef struct Morph
  {
    enum mcodes mc;
    float dval;
    char cval;
    char mv;
  }
tmorph;


float expression(void);

/* globale Variable fr die Ausdrcke */
tmorph morph;

void
error(int num)
{
  fprintf(stderr, "Fehler: ");
  switch (num)
    {
    case SYNTAX_DIV_0:
      errorbox("Parsing: Division durch Null!");
      // fprintf(stderr, "Division durch Null!\n");
      break;
    case SYNTAX_FEHLER:
      errorbox("Parsing: Kein Mathematisch richtiger Ausdruck!");
      // fprintf(stderr, "Kein Mathematisch richtiger Ausdruck!\n");
      break;
    case ZU_LANG:
      errorbox("Parsing: Der Ausdruck ist zu lang!");
      // fprintf(stderr, "Der Ausdruck ist zu lang!\n");
      break;
    default:
      errorbox("Parsing: Unbekannter Fehler!");
      // fprintf(stderr, "Unbekannte Errornummer!\n");
    }
}

bool
oper(char o)
{
  if (o == '+')
    return true;
  if (o == '-')
    return true;
  if (o == '*')
    return true;
  if (o == '/')
    return true;
  if (o == '(')
    return true;
  if (o == ')')
    return true;
  return false;
}

bool
lex(char *str)
{
  static char *strp;

  /* Beim ersten Aufruf Zeiger speichern */
  if (str)
    {
      strp = str;
      morph.mv = true;
      return true;
    }

  /* noch nicht verarbeitet */
  if (!morph.mv)
    {
      return true;
    }

  for (; *strp == ' '; strp++);

  if (oper(*strp))
    {
      morph.mc = mop;
      morph.mv = false;
      morph.cval = *strp;
      strp++;
      return true;
    }
  else
    {
      morph.mc = mdbl;
      morph.mv = false;
      morph.dval = strtod(strp, &strp);
      return true;
    }

  return false;
}

double
fact(bool isneg)
{
  double tmp;
  if (lex(NULL) && (morph.mc == mdbl))
    {
      morph.mv = true;
      if (isneg)
	tmp = -morph.dval;
      else
	tmp = morph.dval;
      return tmp;
    }
  else
    {
      if ((morph.mc == mop) && (morph.cval == '('))
	{
	  morph.mv = true;
	  tmp = expression();
	  if (lex(NULL) && (morph.mc == mop) && (morph.cval == ')'))
	    {
	      morph.mv = true;
	      return tmp;
	    }
	  else
	    {
	      error(SYNTAX_FEHLER);
	      return 0.0;
	    }
	}
      else
	{
	  error(SYNTAX_FEHLER);
	  return 0.0;
	}
    }
}

float
term(bool isneg)
{
  float tmp, divisor;

  tmp = fact(isneg);

  while (lex(NULL) && (morph.mc == mop) &&
	 (morph.cval == '*' || morph.cval == '/'))
    {
      if (morph.cval == '*')
	{
	  morph.mv = true;
	  tmp *= fact(false);
	}
      else
	{
	  if (morph.cval == '/')
	    {
	      morph.mv = true;
	      divisor = fact(false);
	      if (fabs(divisor) > eps12)
		tmp /= divisor;
	      else
		error(SYNTAX_DIV_0);
	    }
	}
    }
  return tmp;
}

/* expr()  + und -, ruft term fr * und / */
float
expr(bool isneg)
{
  float tmp;

  tmp = term(isneg);

  while (lex(NULL) && (morph.mc == mop) &&
	 ((morph.cval == '+') || (morph.cval == '-')))
    {
      if (morph.cval == '+')
	{
	  morph.mv = true;
	  tmp += term(false);
	}
      else
	{
	  if (morph.cval == '-')
	    {
	      morph.mv = true;
	      tmp -= term(false);
	    }
	}
    }
  return tmp;
}

float
expression(void)
{
  if (lex(NULL) && (morph.mc == mop) && (morph.cval == '-'))
    {
      morph.mv = true;
      if (lex(NULL) && (morph.mc == mdbl))
	// keine morph.mv denn Zahl mu von term()
	// noch verarbeitet werden
	return expr(true);
      else
	// wirkt wie eine Klammer
	return -expr(true);
    }
  // ohne Vorzeichen
  return expr(false);
}

bool
expr_vector(vector * v, char *str)
{
#define max 150
  int a, ret;
  // wichtig static !!!
  static char strx[max], stry[max], strz[max], strtmp[max + max + max + 3];

  /* kopiere String */
  if (strlen(str) > max + max + max)
    {
      error(ZU_LANG);
      return false;
    }
  strcpy(strtmp, str);

  if (strtmp[0] == '@')
    {
      ret = true + true;	// 2 -> relativ = Wahr

      strcpy(strtmp, &str[1]);
    }
  else
    ret = true;

  for (a = 0; (strtmp[a] != ';') && (a < max); a++)
    strx[a] = strtmp[a];
  strx[a + 1] = (char) 0;
  if (a >= max)
    {
      error(ZU_LANG);
      return false;
    }

  strcpy(strtmp, &strtmp[a + 1]);
  for (a = 0; (strtmp[a] != ';') && (a < max); a++)
    stry[a] = strtmp[a];
  stry[a + 1] = (char) 0;
  if (a >= max)
    {
      error(ZU_LANG);
      return false;
    }

  if (strlen(&strtmp[a + 1]) > max)
    {
      error(ZU_LANG);
      return false;
    }
  strcpy(strz, &strtmp[a + 1]);

  for (a = 0; strz[a] != 0; a++)
    if (strz[a] == ';')
      {
	error(ZU_LANG);
	return false;
      }

  lex(strx);
  v->x = expression();
  lex(stry);
  v->y = expression();
  lex(strz);
  v->z = expression();

#ifdef TEST
  fprintf(stderr, "analyse -> %f %f %f\n", v->x, v->y, v->z);
#endif

  return ret;
#undef max
}

bool
expr_vector4d(float *x, float *y, float *z, float *g, char *str)
{
#define max 150
  int a, ret;
  // wichtig static !!!
  static char strx[max], stry[max], strz[max], strg[max], strtmp[max + max + max + max + 4];

  /* kopiere String */
  if (strlen(str) > max + max + max + max)
    {
      error(ZU_LANG);
      return false;
    }
  strcpy(strtmp, str);

  if (strtmp[0] == '@')
    {
      ret = true + true;	// 2 -> relativ = Wahr
      strcpy(strtmp, &str[1]);
    }
  else
    ret = true;

  for (a = 0; (strtmp[a] != ';') && (a < max); a++)
    strx[a] = strtmp[a];
  strx[a + 1] = (char) 0;
  if (a >= max)
    {
      error(ZU_LANG);
      return false;
    }

  strcpy(strtmp, &strtmp[a + 1]);
  for (a = 0; (strtmp[a] != ';') && (a < max); a++)
    stry[a] = strtmp[a];
  stry[a + 1] = (char) 0;
  if (a >= max)
    {
      error(ZU_LANG);
      return false;
    }

  strcpy(strtmp, &strtmp[a + 1]);
  for (a = 0; (strtmp[a] != ';') && (a < max); a++)
    strz[a] = strtmp[a];
  strz[a + 1] = (char) 0;
  if (a >= max)
    {
      error(ZU_LANG);
      return false;
    }

  if (strlen(&strtmp[a + 1]) > max)
    {
      error(ZU_LANG);
      return false;
    }
  strcpy(strg, &strtmp[a + 1]);
  for (a = 0; strg[a] != 0; a++)
    if (strg[a] == ';')
      {
	error(ZU_LANG);
	return false;
      }

  lex(strx);
  *x = expression();
  lex(stry);
  *y = expression();
  lex(strz);
  *z = expression();
  lex(strg);
  *g = expression();

  return ret;
#undef max
}

#ifdef TEST
int
main(int argc, char **argv)
{
  vector v;

  /* Vektoranalyse */
  if ((argc >= 2) && expr_vector(&v, argv[1]))
    {
      printf("vector(x, y, z) = %lf, %lf, %lf\n", v.x, v.y, v.z);
    }
  else
    fprintf(stderr, "keinen gueltigen Parameter !\n");

  return 0;
}
#endif




