/*  
   Dialogbox fuer Objektdefinition und 
   Helpbox, Infobox fuer CAD-Tool 

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"

struct objstruktur ObjDialog;

Widget WObjDialog;

STRING helpobjdialog = "Der ObjektDialog\n";

GC ObjGCFarbe;
int ObjArt, ObjEdit_art;
grobjekt *pgr_obj;
longint ankettnr;


void
ObjDialog_init(float R, float B, float G, float E, float Mat, float Sp, float Du,
	       float Dif, float Spec, float High, float Vel, char Ch)
{
  ObjDialog.r = R;
  ObjDialog.b = B;
  ObjDialog.g = G;
  ObjDialog.e = E;
  ObjDialog.mat = Mat;
  ObjDialog.sp = Sp;
  ObjDialog.du = Du;
  ObjDialog.dif = Dif;
  ObjDialog.spec = Spec;
  ObjDialog.high = High;
  ObjDialog.vel = Vel;
  ObjDialog.ch = Ch;
}

void
ObjDialog_get(float *R, float *B, float *G, float *E, float *Mat, float *Sp, float *Du,
	      float *Dif, float *Spec, float *High, float *Vel, char *Ch)
{
  *R = ObjDialog.r;
  *B = ObjDialog.b;
  *G = ObjDialog.g;
  *E = ObjDialog.e;
  *Mat = ObjDialog.mat;
  *Sp = ObjDialog.sp;
  *Du = ObjDialog.du;
  *Dif = ObjDialog.dif;
  *Spec = ObjDialog.spec;
  *High = ObjDialog.high;
  *Vel = ObjDialog.vel;
  *Ch = ObjDialog.ch;
}

void
Farbealloc(Widget W)
{
  ObjDialog.XCol.flags = DoRed | DoGreen | DoBlue;
  ObjDialog.XCol.red = (unsigned) (ObjDialog.r * 65535.0);
  ObjDialog.XCol.green = (unsigned) (ObjDialog.g * 65535.0);
  ObjDialog.XCol.blue = (unsigned) (ObjDialog.b * 65535.0);
  if (ObjDialog.privat)
    XStoreColor(XtDisplay(W), ObjDialog.CMap, &ObjDialog.XCol);
  else
    XAllocColor(XtDisplay(W), ObjDialog.CMap, &ObjDialog.XCol);
}

void
Farbanzeige()
{
  if (ObjDialog.Win)
    {
      XSetForeground(ObjDialog.pD, ObjGCFarbe, ObjDialog.XCol.pixel);
      XFillRectangle(ObjDialog.pD, ObjDialog.Win, ObjGCFarbe, 1, 1, 245, 25);
    }
}

void
CBFarbanzeige(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  ObjDialog.Win = ((XmDrawingAreaCallbackStruct *) pCallData)->window;
  if (ObjDialog.Win != 0)
    {
      ObjDialog.pD = XtDisplay(W);
      XSetForeground(ObjDialog.pD, ObjGCFarbe, ObjDialog.XCol.pixel);
      XFillRectangle(ObjDialog.pD, ObjDialog.Win, ObjGCFarbe, 1, 1, 245, 25);
    }
}

void
CBObjOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* Farbe freigeben */
  if (ObjDialog.privat)
    XFreeColors(ObjDialog.pD, ObjDialog.CMap, &ObjDialog.XCol.pixel, 1, 0);

  XtUnmanageChild(WObjDialog);

  if (ObjEdit_art == AENDERN)
    {
      ObjDialog_get(&pgr_obj->r, &pgr_obj->b, &pgr_obj->g, &pgr_obj->e, &pgr_obj->mat,
		    &pgr_obj->sp,
		&pgr_obj->du, &pgr_obj->dif, &pgr_obj->spec, &pgr_obj->high,
		    &pgr_obj->vel, &pgr_obj->ch);
    }

  /* Definition des Objektes */
  switch (ObjArt)
    {
    case POLYGON:
      polygondialog(WTop, pgr_obj, ankettnr, ObjEdit_art);
      break;
    case SPHERE:
      spheredialog(WTop, pgr_obj, ankettnr, ObjEdit_art);
      break;
    case BLOCK:
      blockdialog(WTop, pgr_obj, ankettnr, ObjEdit_art);
      break;
    case ELIPSOID:
      elipsoiddialog(WTop, pgr_obj, ankettnr, ObjEdit_art);
      break;
    case TORUS:
      torusdialog(WTop, pgr_obj, ankettnr, ObjEdit_art);
      break;
    case CONE:
      zylinderdialog(WTop, pgr_obj, ankettnr, ObjEdit_art);
      break;
    case YBUFFER:
      ybufferdialog(WTop, pgr_obj, ankettnr, ObjEdit_art);
      break;
    case NURBS:
      nurbsdialog(WTop, pgr_obj, ankettnr, ObjEdit_art);
      break;
      /*
    case BEZIER:
      bezierdialog(WTop, pgr_obj, ankettnr, ObjEdit_art);
      break;
      */
    default:
      fprintf(stderr, "Objdialog, undefinierte Objektart:%d\n", ObjArt);
    }

  /* erst wenn Objekt fertig definiert! */
  /* im jeweiligen Obj. Dialog -> WObjDialog = NULL; */
}

void
CBObjCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* Farbe freigeben */
  if (ObjDialog.privat)
    XFreeColors(ObjDialog.pD, ObjDialog.CMap, &ObjDialog.XCol.pixel, 1, 0);

  XtUnmanageChild(WObjDialog);
  WObjDialog = NULL;
}

void
CBObjHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpobjdialog);
  else
    infobox("helpnureinmal");
}

void
CBObjScaleCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case 1:
      ObjDialog.r = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      Farbealloc(W);
      Farbanzeige();
      break;
    case 2:
      ObjDialog.g = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      Farbealloc(W);
      Farbanzeige();
      break;
    case 3:
      ObjDialog.b = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      Farbealloc(W);
      Farbanzeige();
      break;
    case 4:
      ObjDialog.e = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 5:
      ObjDialog.mat = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 6:
      ObjDialog.sp = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 7:
      ObjDialog.du = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 8:
      ObjDialog.dif = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 9:
      ObjDialog.spec = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 10:
      ObjDialog.high = (float) ((XmScaleCallbackStruct *) pCallData)->value;
      break;
    case 11:
      ObjDialog.vel = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    default:
      fprintf(stderr, "Regler %d\n", *(int *) pClientData);
    }
}

void
CBObjSchnittk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case 0:
      ObjDialog.ch = 'N';
      break;
    case 1:
      ObjDialog.ch = 'S';
      break;
    case 2:
      ObjDialog.ch = 's';
      break;
    default:
      fprintf(stderr, "Callback Schnittk = %d\n", *(int *) pClientData);
    }
}

void
objdialog(Widget W, class grobjekt * grobjp, longint ank_nr, int art, int editart)
{
  unsigned long pixel;

  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    WRowCol4, WRowCol5, WScale[11], frame1, frame2, frame3, WRadioBox,
    Wdrawarea, AWButtonD[3], WLabel;

  /* Definitionen */
  STRING AIScale[] =
  {"regler1", "regler2", "regler3", "regler4", "regler5", "regler6",
   "regler7", "regler8", "regler9", "regler10", "regler11"};

  static int AIScaleID[] =
  {
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11
  };

  static int SchnittButtonID[] =
  {
    0, 1, 2
  };

  int nScale, nArgs, maxScale = 11, i;
  Arg Aargs[15];
  XmString mstr;

  ObjArt = art;
  ObjEdit_art = editart;
  ankettnr = ank_nr;
  pgr_obj = grobjp;

  if (ObjEdit_art == AENDERN)
    ObjDialog_init(pgr_obj->r, pgr_obj->b, pgr_obj->g, pgr_obj->e, pgr_obj->mat, pgr_obj->sp,
		   pgr_obj->du, pgr_obj->dif, pgr_obj->spec, pgr_obj->high,
		   pgr_obj->vel, pgr_obj->ch);

  /* Der Dialog */
  WObjDialog = XmCreateDialogShell(W, "objdialog", NULL, 0);
  XtManageChild(WObjDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 610);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 330);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  // XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);nArgs++;
  WRowCol1 = XmCreateRowColumn(WObjDialog, "objdrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("objframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNnumColumns, 2);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(frame1, "objdrow2", Aargs, nArgs);
//   XtManageChild(WRowCol2);

  frame2 = XtCreateManagedWidget("objframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNnumColumns, 2);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(frame2, "objdrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);


  /* Scalen */
  for (nScale = 0; nScale < maxScale; nScale++)
    {
      nArgs = 0;

      XtSetArg(Aargs[nArgs], XmNshowValue, True);
      nArgs++;

      switch (nScale)
	{
	case 0:
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Rot", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjDialog.r * 100.0);
	  break;
	case 1:
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Gr", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjDialog.g * 100.0);
	  break;
	case 2:
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Blu", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjDialog.b * 100.0);
	  break;
	case 3:
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Eng", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjDialog.e * 100.0);
	  break;
	  XtSetArg(Aargs[nArgs], XmNminimum, 0);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNmaximum, 10);
	  nArgs++;
	case 4:
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Mat", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjDialog.mat * 100.0);
	  break;
	case 5:
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Spg", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjDialog.sp * 100.0);
	  break;
	case 6:
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Dur", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjDialog.du * 100.0);
	  break;
	case 7:
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Dif", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjDialog.dif * 100.0);
	  break;
	case 8:
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Spc", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjDialog.spec * 100.0);
	  break;
	case 9:
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Hig", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjDialog.high);
	  break;
	case 10:
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Vel", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNminimum, 100);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNmaximum, 200);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjDialog.vel * 100.0);
	  break;
	}
      nArgs++;
      WScale[nScale] =
	XtCreateManagedWidget(AIScale[nScale], xmScaleWidgetClass, WRowCol2, Aargs, nArgs);
      XtAddCallback(WScale[nScale], XmNvalueChangedCallback,
		    CBObjScaleCanged, &AIScaleID[nScale]);
    }
  XtManageChild(WRowCol2);


  /* Schalter ob Schnittkrper oder nicht */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNentryClass, xmToggleButtonWidgetClass);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRadioBox = XmCreateRadioBox(WRowCol3, "objradio", Aargs, nArgs);
  XtManageChild(WRadioBox);

  /* 4 Togglebuttons erzeugen */
  i = 0;
  nArgs = 0;
  if (ObjDialog.ch == 'N')
    XtSetArg(Aargs[nArgs], XmNset, True);
  else
    XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] = XtCreateManagedWidget("Norm", xmToggleButtonWidgetClass,
					 WRadioBox, Aargs, nArgs);
  nArgs = 0;

  if (ObjDialog.ch == 'S')
    XtSetArg(Aargs[nArgs], XmNset, True);
  else
    XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("Diff", xmToggleButtonWidgetClass, WRadioBox, Aargs, nArgs);

  if (ObjDialog.ch == 's')
    XtSetArg(Aargs[nArgs], XmNset, True);
  else
    XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("Sum", xmToggleButtonWidgetClass, WRadioBox,
			  Aargs, nArgs);
  /* Callbacks fr alle 3 Buttons */
  for (i = 0; i < 3; i++)
    XtAddCallback(AWButtonD[i], XmNvalueChangedCallback, (XtCallbackProc) CBObjSchnittk, &SchnittButtonID[i]);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol5 = XmCreateRowColumn(WRowCol3, "objdrowf", Aargs, nArgs);

  /* Farblabel */
  WLabel = XtCreateManagedWidget("Farbe:   ->", xmLabelWidgetClass, WRowCol5, NULL, 0);


  /* Fr Farbnderung eine ColorCell holen */
  ObjDialog.pD = XtDisplay(WTop);
  ObjDialog.CMap = DefaultColormap(ObjDialog.pD, DefaultScreen(ObjDialog.pD));
  ObjDialog.privat = true;

  if (XAllocColor(ObjDialog.pD, ObjDialog.CMap, &ObjDialog.XCol))
    {
      ObjDialog.privat = false;
      Farbealloc(WTop);
    }
  else if (!XAllocColorCells(ObjDialog.pD, ObjDialog.CMap, false, NULL, 0, &pixel, 1))
    {
      ObjDialog.privat = false;
      infobox("keinefarbzelle");
    }
  if (ObjDialog.privat)
    {
      ObjDialog.XCol.pixel = pixel;
      Farbealloc(WTop);
    }

  /* Farbanzeige */
  frame3 = XtCreateManagedWidget("objframe3", xmFrameWidgetClass, WRowCol5, NULL, 0);
  Wdrawarea = XtCreateManagedWidget("objdrawcol", xmDrawingAreaWidgetClass, frame3, NULL, 0);

  /* Callbacks um neu zu zeichnen */
  XtAddCallback(Wdrawarea, XmNexposeCallback, (XtCallbackProc) CBFarbanzeige, NULL);
  XtAddCallback(Wdrawarea, XmNresizeCallback, (XtCallbackProc) CBFarbanzeige, NULL);

  /* GC erzeugen um zeichnen zu knnen */
  ObjGCFarbe = CreateSimpleGC(Wdrawarea);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol4 = XmCreateRowColumn(WRowCol1, "objdrow4", Aargs, nArgs);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonHelp);

  XtManageChild(WRowCol4);
  XtManageChild(WRowCol5);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBObjOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBObjCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBObjHelp, NULL);
}
