/*  
   Dialogbox zum Objektndern

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

STRING objaenderdialogstr = "Aenderung des Objektes.";

Widget WObjAenderDialog, WVersch, WScal, WReferenz;
PEXPickPath *aender_path;
grobjekt *graenderobj;

struct objaenderstruktur ObjAenderDialog, ObjAnfang;

void
ObjAenderDialog_save(void)
{
  ObjAnfang.s = ObjAenderDialog.s;
  ObjAnfang.w = ObjAenderDialog.w;
  ObjAnfang.v = ObjAenderDialog.v;
  ObjAnfang.r = ObjAenderDialog.r;
}
void
ObjAenderDialog_load(void)
{
  ObjAenderDialog.s = ObjAnfang.s;
  ObjAenderDialog.w = ObjAnfang.w;
  ObjAenderDialog.v = ObjAnfang.v;
  ObjAenderDialog.r = ObjAnfang.r;
}
void
ObjAenderDialog_init(float S, vector W, vector V, vector R)
{
  ObjAenderDialog.s = S;
  ObjAenderDialog.w = W;
  ObjAenderDialog.v = V;
  ObjAenderDialog.r = R;
}

void
ObjAenderDialog_get(float *S, vector * W, vector * V, vector * R)
{
  *S = ObjAenderDialog.s;
  *W = ObjAenderDialog.w;
  *V = ObjAenderDialog.v;
  *R = ObjAenderDialog.r;
}

void
aender_obj(void)
{
  PEXCoord ref_point;
  PEXStructure *element;
  PEXVector move, scale;
  PEXMatrix matrix;

  /* auch was gefunden? */
  if (aender_path)
    {
      /* Farbe zuruecksetzen  */
      element = &aender_path->elements[1].sid;
    }
  else
    element = &root_struct;

  /* Farbe aendern, immer die gleiche Programmfolge */
  PEXSetEditingMode(pDisplay, *element, PEXStructureReplace);
  PEXSetElementPtr(pDisplay, *element, PEXBeginning, 0);

  PEXSetElementPtrAtLabel(pDisplay, *element, COLORLABEL, 1);
  PEXSetSurfaceColor(pDisplay, *element, PEXOCStore, PEXColorTypeRGB, &normal_color);

  SET_VECT(ObjAenderDialog.r.x, ObjAenderDialog.r.y, ObjAenderDialog.r.z, ref_point);
  SET_VECT(ObjAenderDialog.v.x, ObjAenderDialog.v.y, ObjAenderDialog.v.z, move);
  SET_VECT(ObjAenderDialog.s, ObjAenderDialog.s, ObjAenderDialog.s, scale);
  PEXBuildTransform(&ref_point, &move, ObjAenderDialog.w.x, ObjAenderDialog.w.y,
		    ObjAenderDialog.w.z, &scale, matrix);
  PEXSetElementPtrAtLabel(pDisplay, *element, TRANSFORM_LABEL, 1);
  PEXSetLocalTransform(pDisplay, *element, PEXOCStore, PEXReplace, matrix);

  redraw(true);
}

void
aendere()
{
  bool ok;
  STRING str;

  str = XmTextGetString(WVersch);
  if (!(ok = expr_vector(&ObjAenderDialog.v, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Verschiebevektor liefert eine ungueltige Zahl!");
      return;			// gehe zurueck ohne Dialog zu beenden

    }

  str = XmTextGetString(WScal);
  sscanf(str, "%f", &ObjAenderDialog.s);

  str = XmTextGetString(WReferenz);
  if (!(ok = expr_vector(&ObjAenderDialog.r, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Referenzpunkt liefert eine ungueltige Zahl!");
      return;			// gehe zurueck ohne Dialog zu beenden

    }

  /* beim Verschieben wird Referenzpunkt mit verschoben */
  // ObjAenderDialog.r += ObjAenderDialog.v;

  /* in Datenstruktur sichern */
  if (graenderobj)
    ObjAenderDialog_get(&graenderobj->s, &graenderobj->w, &graenderobj->v, &graenderobj->ref);
  else
    ObjAenderDialog_get(&DrawareaData.s, &DrawareaData.w, &DrawareaData.v, &DrawareaData.r);

  /* Objekt veraendern */
  aender_obj();
}

void
CBObjAenderOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  aendere();

  XtUnmanageChild(WObjAenderDialog);
  WObjAenderDialog = NULL;
}

void
CBObjAenderSet(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  aendere();
}

void
CBObjAenderCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  PEXStructure *element;

  /* auch was gefunden? */
  if (aender_path)
    {
      /* Farbe zuruecksetzen  */
      element = &aender_path->elements[aender_path->count - 1].sid;
    }
  else
    element = &root_struct;

  // Alte wiederherstellen
  ObjAenderDialog_load();
  aender_obj();

  XtUnmanageChild(WObjAenderDialog);
  WObjAenderDialog = NULL;
}

void
CBObjAenderHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal oeffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, objaenderdialogstr);
  else
    infobox("helpnureinmal");
}

void
CBObjAenderScaleCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case 1:
      ObjAenderDialog.w.x = ((float) ((XmScaleCallbackStruct *) pCallData)->value / 100.0);
      break;
    case 2:
      ObjAenderDialog.w.y = ((float) ((XmScaleCallbackStruct *) pCallData)->value / 100.0);
      break;
    case 3:
      ObjAenderDialog.w.z = ((float) ((XmScaleCallbackStruct *) pCallData)->value / 100.0);
      break;
    default:
      fprintf(stderr, "ObjaenderRegler %d\n", *(int *) pClientData);
    }
  // sofort anzeigen
  aender_obj();
}


void
objaenderdialog(Widget W, PEXPickPath * path, class grobjekt * pgrobj)
{

  Arg Aargs[10];
  int nArgs;
  char str[256];

  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    WRowCol4, WScale[3], frame1, frame2, WLabel, WLabelv, WLabelr, WButtonPick,
    WButtonSet;

  /* Definitionen */
  STRING AIScale[] =
  {"objaenderr1", "objaenderr2", "objaenderr3"};

  static int AIScaleID[] =
  {
    1, 2, 3
  };

  int nScale;
  int maxScale = 3;
  XmString anzstr;

  /* global fuer ok setzten */
  aender_path = path;
  graenderobj = pgrobj;

  if (pgrobj)
    ObjAenderDialog_init(graenderobj->s, graenderobj->w, graenderobj->v, graenderobj->ref);
  else
    /* Rootstruktur */
    ObjAenderDialog_init(DrawareaData.s, DrawareaData.w, DrawareaData.v, DrawareaData.r);

  // Speichern fuer Abbruch
  ObjAenderDialog_save();

  /* Der Dialog */
  WObjAenderDialog = XmCreateDialogShell(W, "objaenderdialog", NULL, 0);
  XtManageChild(WObjAenderDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 345);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 340);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WObjAenderDialog, "objaenderrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("objaenderframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNnumColumns, 1);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(frame1, "objaenderrow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  frame2 = XtCreateManagedWidget("objaenderframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol3 = XmCreateRowColumn(frame2, "objaenderrow3", NULL, 0);
  XtManageChild(WRowCol3);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNnumColumns, 5);
  nArgs++;
  WRowCol4 = XmCreateRowColumn(WRowCol1, "objaenderrow4", Aargs, nArgs);
  XtManageChild(WRowCol4);

  /* Scalen */
  for (nScale = 0; nScale < maxScale; nScale++)
    {
      nArgs = 0;
      if (nScale == 0)
	{
	  anzstr = XmStringCreateLtoR("x", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, anzstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjAenderDialog.w.x * 100.0);
	  nArgs++;
	}
      else if (nScale == 1)
	{
	  anzstr = XmStringCreateLtoR("y", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, anzstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjAenderDialog.w.y * 100.0);
	  nArgs++;
	}
      else if (nScale == 2)
	{
	  anzstr = XmStringCreateLtoR("z", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, anzstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, ObjAenderDialog.w.z * 100.0);
	  nArgs++;
	}

      XtSetArg(Aargs[nArgs], XmNshowValue, True);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNmaximum, 628);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
      nArgs++;

      WScale[nScale] =
	XtCreateManagedWidget(AIScale[nScale], xmScaleWidgetClass, WRowCol2, Aargs, nArgs);
      XtAddCallback(WScale[nScale], XmNvalueChangedCallback,
		    CBObjAenderScaleCanged, &AIScaleID[nScale]);
    }

  WLabel = XtCreateManagedWidget("objaenderlabel", xmLabelWidgetClass, WRowCol3, NULL, 0);
  sprintf(str, "%0.2f;%0.2f;%0.2f",
	  ObjAenderDialog.v.x, ObjAenderDialog.v.y, ObjAenderDialog.v.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  WVersch = XtCreateManagedWidget("objaenderversch", xmTextWidgetClass, WRowCol3,
				  Aargs, nArgs);

  WLabelv = XtCreateManagedWidget("objaenderlabels", xmLabelWidgetClass, WRowCol3, NULL, 0);
  if (ObjAenderDialog.s <= 0.0)
    ObjAenderDialog.s = 1.0;
  sprintf(str, "%0.2f", ObjAenderDialog.s);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  WScal = XtCreateManagedWidget("objaenderscal", xmTextWidgetClass, WRowCol3,
				Aargs, nArgs);


  WLabelr = XtCreateManagedWidget("Referenzpunkt", xmLabelWidgetClass, WRowCol3, NULL, 0);
  sprintf(str, "%0.2f;%0.2f;%0.2f", ObjAenderDialog.r.x, ObjAenderDialog.r.y,
	  ObjAenderDialog.r.z);
  WReferenz = XtVaCreateManagedWidget("objaenderscal", xmTextWidgetClass, WRowCol3,
				      XmNvalue, str,
				      NULL);
  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonSet =
    XtCreateManagedWidget("set", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonSet);
  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonPick);

  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonCancel);

  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBObjAenderOk, NULL);
  XtAddCallback(WButtonSet, XmNactivateCallback, (XtCallbackProc) CBObjAenderSet, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBObjAenderCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBObjAenderHelp, NULL);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);

}
