
/*  
   Dialogbox fr die Dateneingabe einer Dreiecksflche

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

static STRING helpnurbsdialog = "Definition: None-rational B-spline curves.";
struct nurbsstruktur NurbsDialog;
Widget WNurbsDialog, NurbsDialogWText1, NurbsDialogWText2, NurbsDialogWText3,
  NurbsCoverLabel, WNurbsMatrixDialog;
Widget *WNurbsMatrix;
int NurbsDialogArt;
grobjekt *nurbs_grobj;
longint nurbs_anknr;

// Fr Demo
#define GEWICHT 1.2
static PEXCoord4D control_points[] =
{
  {1.0, 0.5, 0.5, GEWICHT},
  {1.0, 1.0, 0.5, GEWICHT},
  {0.5, 1.0, 0.5, GEWICHT},
  {0.0, 1.0, 0.5, GEWICHT},
  {0.0, 0.5, 0.5, GEWICHT},
  {0.5, 0.0, 0.0, GEWICHT},
  {1.0, 0.5, 0.5, GEWICHT},
  {1.0, 1.0, 1.0, GEWICHT},
  {0.5, 1.0, 1.0, GEWICHT},
  {0.0, 1.0, 1.0, GEWICHT},
  {0.0, 0.5, 0.5, GEWICHT},
  {0.0, 0.0, 0.0, GEWICHT},
  {1.0, 0.5, 0.5, GEWICHT},
  {1.0, 0.5, 1.0, GEWICHT},
  {0.5, 0.5, 1.0, GEWICHT},
  {0.0, 0.5, 1.0, GEWICHT},
  {0.0, 0.5, 0.5, GEWICHT},
  {0.0, 0.0, 0.5, GEWICHT},
  {1.0, 0.5, 0.5, GEWICHT},
  {1.0, 0.0, 1.0, GEWICHT},
  {0.5, 0.0, 1.0, GEWICHT},
  {0.0, 0.0, 1.0, GEWICHT},
  {0.0, 0.5, 0.5, GEWICHT},
  {0.0, 1.0, 0.0, GEWICHT},
  {1.0, 0.5, 0.5, GEWICHT},
  {1.0, 0.0, 0.5, GEWICHT},
  {0.5, 0.0, 0.5, GEWICHT},
  {0.0, 0.0, 0.5, GEWICHT},
  {0.0, 0.5, 0.5, GEWICHT},
  {0.0, 1.0, 0.5, GEWICHT},
  {1.0, 0.5, 0.5, GEWICHT},
  {1.0, 0.0, 0.0, GEWICHT},
  {0.5, 0.0, 0.0, GEWICHT},
  {0.0, 0.0, 0.0, GEWICHT},
  {0.0, 0.5, 0.5, GEWICHT},
  {0.0, 1.0, 1.0, GEWICHT},
  {1.0, 0.5, 0.5, GEWICHT},
  {1.0, 0.5, 0.0, GEWICHT},
  {0.5, 0.5, 0.0, GEWICHT},
  {0.0, 0.5, 0.0, GEWICHT},
  {0.0, 0.5, 0.5, GEWICHT},
  {0.0, 0.5, 1.0, GEWICHT},
  {1.0, 0.5, 0.5, GEWICHT},
  {1.0, 1.0, 0.0, GEWICHT},
  {0.5, 1.0, 0.0, GEWICHT},
  {0.0, 1.0, 0.0, GEWICHT},
  {0.0, 0.5, 0.5, GEWICHT},
  {0.0, 0.0, 1.0, GEWICHT},
  {1.0, 0.5, 0.5, GEWICHT},
  {1.0, 1.0, 0.5, GEWICHT},
  {0.5, 1.0, 0.5, GEWICHT},
  {0.0, 1.0, 0.5, GEWICHT},
  {0.0, 0.5, 0.5, GEWICHT},
  {0.5, 0.0, 0.0, GEWICHT}};

// zur Matrixeingabe
void nurbsmatrixdialog(longint x, longint z);

void
lade_knotenstr()
{
  char str[10];
  int anz, x;

  anz = (int) NurbsDialog.i[0];
  NurbsDialog.knotenstr1[0] = (char) 0;

  // beginnt beim 1.
  for (x = 1; x < anz + 1; x++)
    {
      sprintf(str, "%0.0f", NurbsDialog.i[x]);
      strcat(NurbsDialog.knotenstr1, str);
      if (x < anz)
	strcat(NurbsDialog.knotenstr1, ";");
    }

  anz = (int) NurbsDialog.j[0];
  NurbsDialog.knotenstr2[0] = (char) 0;
  // beginnt beim 1.
  for (x = 1; x < anz + 1; x++)
    {
      sprintf(str, "%0.0f", NurbsDialog.j[x]);
      strcat(NurbsDialog.knotenstr2, str);
      if (x < anz)
	strcat(NurbsDialog.knotenstr2, ";");
    }
}

void
NurbsDialog_init(longint Nrcover, longint X, longint Z, int CU, int CV, int OU, int OV,
		 vect4d * Y, float *I, float *J)
{
  NurbsDialog.nrcover = Nrcover;
  NurbsDialog.x = X;
  NurbsDialog.z = Z;
  NurbsDialog.cu = CU;
  NurbsDialog.cv = CV;
  NurbsDialog.y = Y;
  NurbsDialog.i = I;
  NurbsDialog.j = J;
  NurbsDialog.ou = OU;
  NurbsDialog.ov = OV;

  if (I == NULL)
    sprintf(NurbsDialog.knotenstr1, "0;0;0;1;1;2;2;2");
  if (J == NULL)
    sprintf(NurbsDialog.knotenstr2, "0;0;0;1;1;2;2;3;3;4;4;4");
}

void
NurbsDialog_get(longint * Nrcover, longint * X, longint * Z, int *CU, int *CV,
		int *OU, int *OV, vect4d ** Y, float **I, float **J)
{
  *Nrcover = NurbsDialog.nrcover;
  *X = NurbsDialog.x;
  *Z = NurbsDialog.z;
  *Y = NurbsDialog.y;
  *CU = NurbsDialog.cu;
  *CV = NurbsDialog.cv;
  *I = NurbsDialog.i;
  *J = NurbsDialog.j;
  *OU = NurbsDialog.ou;
  *OV = NurbsDialog.ov;
}

void
aendere_nurbs(grobjekt * nurbso)
{
  PEXPSCData psc;
  PEXArrayOfCoord grid;
  PEXStructure *pnurbs = &(nurbso->obj_struct);
  float i, j;

  // Aendern
  nurbso->cover = NurbsDialog.nrcover;	// Covereintrag

  ((nurbs *) (nurbso->objp))->
    init(NurbsDialog.x, NurbsDialog.z, NurbsDialog.cu, NurbsDialog.cv,
	 NurbsDialog.ou, NurbsDialog.ov, NurbsDialog.y, NurbsDialog.i, NurbsDialog.j);

  PEXSetEditingMode(pDisplay, *pnurbs, PEXStructureReplace);
  PEXSetElementPtr(pDisplay, *pnurbs, PEXBeginning, 0);
  PEXSetElementPtrAtLabel(pDisplay, *pnurbs, OBJ_NURBS_LABEL, 1);

  // Set the parametric surface characteristics.
  psc.iso_curves.placement_type = PEXNonUniformPlacement;
  psc.iso_curves.u_count = ((nurbs *) (nurbso->objp))->cu;	// Genauigkeit

  psc.iso_curves.v_count = ((nurbs *) (nurbso->objp))->cv;	// Genauigkeit

  PEXSetParaSurfCharacteristics(pDisplay, *pnurbs, PEXOCStore, PEXPSCIsoCurves, &psc);

  // Set the surface approximation criteria.
  PEXSetSurfaceApprox(pDisplay, *pnurbs, PEXOCStore,
		      PEXApproxConstantBetweenKnots,
		      (double) ((nurbs *) (nurbso->objp))->cu,
		      (double) ((nurbs *) (nurbso->objp))->cv);

  // Create the surface.
  grid.point_4d = (PEXCoord4D *) ((nurbs *) (nurbso->objp))->y;

  i = *((nurbs *) (nurbso->objp))->i + 1.0;
  j = *((nurbs *) (nurbso->objp))->j + 1.0;

  PEXNURBSurface(pDisplay, *pnurbs, PEXOCStore, PEXRational,
		 ((nurbs *) (nurbso->objp))->ou,
		 ((nurbs *) (nurbso->objp))->ov,
		 &i,
		 &j,
		 ((nurbs *) (nurbso->objp))->x,
		 ((nurbs *) (nurbso->objp))->z,
		 grid,
		 0, (PEXListOfTrimCurve *) NULL);

  un_echo(nurbso, nurbso->ch == 'N');
}

void
create_nurbs(Display * D, Widget W, grobjekt * pnurbs, longint ank_nr, longint pick_id)
{
  bool echocolor = True;
  PEXName name[2];
  PEXMatrix matrix;
  PEXVector tr, scale;
  PEXCoord ref_point;
  PEXStructure *pnurbs_element = NULL;
  grobjekt *ankobj = NULL;

  PEXPSCData psc;
  PEXArrayOfCoord grid;

  pnurbs->obj_struct = PEXCreateStructure(D);

  // suche strukturpointer zum anhngen
  if (ank_nr == 0L)
    {
      echocolor = True;
      pnurbs_element = &root_struct;
      ankobj = NULL;
    }
  else
    {
      if ((ankobj = oliste.getobjp(ank_nr)) != NULL)
	{
	  echocolor = ankobj->ch == 'N';
	  pnurbs_element = &ankobj->obj_struct;
	}
      else
	ankobj = NULL;
    }

  // Nameset und Pickid sind wichtig fr das Picken
  name[0] = (PEXName) GROBJSTR;
  name[1] = (PEXName) NURBS;
  PEXAddToNameSet(D, pnurbs->obj_struct, PEXOCStore, 2, name);
  PEXSetPickID(D, pnurbs->obj_struct, PEXOCStore, pick_id);

  PEXLabel(D, pnurbs->obj_struct, PEXOCStore, COLORLABEL);
  if (pnurbs->ch == 'N')
    PEXSetSurfaceColor(D, pnurbs->obj_struct, PEXOCStore, PEXColorTypeRGB, &normal_color);
  else
    PEXSetSurfaceColor(D, pnurbs->obj_struct, PEXOCStore, PEXColorTypeRGB, &schnitt_color);

  SET_VECT(0.0, 0.0, 0.0, tr);
  SET_VECT(0.0, 0.0, 0.0, ref_point);
  SET_VECT(1.0, 1.0, 1.0, scale);
  PEXBuildTransform(&ref_point, &tr, 0.0, 0.0, 0.0, &scale, matrix);
  PEXLabel(D, pnurbs->obj_struct, PEXOCStore, TRANSFORM_LABEL);
  PEXSetLocalTransform(D, pnurbs->obj_struct, PEXOCStore, PEXReplace, matrix);
  // Hier werden die Pickelemente eingefgt 
  PEXLabel(D, pnurbs->obj_struct, PEXOCStore, OBJ_PICK_ANF_LABEL);
  PEXLabel(D, pnurbs->obj_struct, PEXOCStore, OBJ_PICK_END_LABEL);

  PEXLabel(D, pnurbs->obj_struct, PEXOCStore, OBJ_NURBS_LABEL);

  // Set the parametric surface characteristics.
  psc.iso_curves.placement_type = PEXNonUniformPlacement;
  psc.iso_curves.u_count = ((nurbs *) (pnurbs->objp))->cu;	// Genauigkeit

  psc.iso_curves.v_count = ((nurbs *) (pnurbs->objp))->cv;	// Genauigkeit

  PEXSetParaSurfCharacteristics(D, pnurbs->obj_struct, PEXOCStore, PEXPSCIsoCurves, &psc);

  // Set the surface approximation criteria.
  PEXSetSurfaceApprox(D, pnurbs->obj_struct, PEXOCStore,
		      PEXApproxConstantBetweenKnots,
		      (double) ((nurbs *) (pnurbs->objp))->cu,
		      (double) ((nurbs *) (pnurbs->objp))->cv);

  // Create the surface.
  grid.point_4d = (PEXCoord4D *) ((nurbs *) (pnurbs->objp))->y;

  PEXNURBSurface(D, pnurbs->obj_struct, PEXOCStore, PEXRational,
		 ((nurbs *) (pnurbs->objp))->ou,
		 ((nurbs *) (pnurbs->objp))->ov,
		 ((nurbs *) (pnurbs->objp))->i + 1,
		 ((nurbs *) (pnurbs->objp))->j + 1,
		 ((nurbs *) (pnurbs->objp))->x,
		 ((nurbs *) (pnurbs->objp))->z, grid,
		 0, (PEXListOfTrimCurve *) NULL);

  // Kennung das hier die Kette beginnt
  PEXLabel(D, pnurbs->obj_struct, PEXOCStore, OBJ_KETTE_LABEL);

  // in Root-Struktur einfgen 
  PEXSetEditingMode(D, *pnurbs_element, PEXStructureInsert);
  PEXSetElementPtr(D, *pnurbs_element, PEXEnd, 0);
  PEXLabel(D, *pnurbs_element, PEXOCStore, GROBJ_LABEL + pick_id);
  PEXExecuteStructure(D, *pnurbs_element, PEXOCStore, pnurbs->obj_struct);

  un_echo(ankobj, echocolor);
}

void
delete_cover_nurbs_liste(void)
{
  int x, anzelem;
  for (anzelem = 0, coverx = coveranf; coverx; anzelem++, coverx = coverx->next);
  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(NurbsDialog.pCoverStr[x]);
}

void
CBNurbsMatrixOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  grobjekt *pnurbs;
  STRING str;
  longint pick_id, a;
  char ok;

  // Speicher allocieren
  NurbsDialog.y = (vect4d *) malloc(sizeof(vect4d) * NurbsDialog.x * NurbsDialog.z);

  for (a = 0; a < (NurbsDialog.x * NurbsDialog.z); a++)
    {
      str = XmTextGetString(WNurbsMatrix[a]);

      if (!(ok = expr_vector4d(&NurbsDialog.y[a].x, &NurbsDialog.y[a].y,
			    &NurbsDialog.y[a].z, &NurbsDialog.y[a].g, str)))
	{
	  errorbox("Vektor liefert eine ungltige Zahl!");
	  return;		// gehe zurck ohne Dialog zu beenden

	}
      if (ok == 2)
	{
	  NurbsDialog.y[a].x = NurbsDialog.y[a - 1].x;
	  NurbsDialog.y[a].y = NurbsDialog.y[a - 1].y;
	  NurbsDialog.y[a].z = NurbsDialog.y[a - 1].z;
	  NurbsDialog.y[a].g = NurbsDialog.y[a - 1].g;
	}

      // sscanf(str, "%f;%f;%f;%f", &NurbsDialog.y[a].x, &NurbsDialog.y[a].y, 
      // &NurbsDialog.y[a].z, &NurbsDialog.y[a].g);

      // XmStringFree((XmString)str);
    }

  // erst hier Datenstruktur erzeugen
  if (NurbsDialogArt == NEU)
    {
      pick_id = ank_grobjekt(NURBS, nurbs_anknr,
	  ObjDialog.r, ObjDialog.g, ObjDialog.b, ObjDialog.e, ObjDialog.mat,
		  ObjDialog.sp, ObjDialog.du, ObjDialog.dif, ObjDialog.spec,
			     ObjDialog.high, ObjDialog.vel, ObjDialog.ch,
			     NurbsDialog.nrcover, vector(0.0, 0.0, 0.0),
			     vector(0.0, 0.0, 0.0));
      pnurbs =
	ank_nurbs(NurbsDialog.x, NurbsDialog.z, NurbsDialog.cu, NurbsDialog.cv,
		  NurbsDialog.ou, NurbsDialog.ov,
		  NurbsDialog.y, NurbsDialog.i, NurbsDialog.j);
      create_nurbs(XtDisplay(W), W, pnurbs, nurbs_anknr, pick_id);
    }
  else
    aendere_nurbs(nurbs_grobj);

  delete_cover_nurbs_liste();
  free(NurbsDialog.y);		// Speicher Vektoren freigeben

  free(NurbsDialog.i);		// Speicher Knoten   freigeben

  free(NurbsDialog.j);		// Speicher Knoten   freigeben

  XtUnmanageChild(WNurbsMatrixDialog);
  free(WNurbsMatrix);
  WNurbsMatrixDialog = NULL;
}

void
CBNurbsMatrixCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  XtUnmanageChild(WNurbsMatrixDialog);
  free(WNurbsMatrix);
  WNurbsMatrixDialog = NULL;
}

void
CBNurbsOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;
  char buff[256], s1[256], s2[256];
  longint x, z;
  int cu, cv, l, a, nr, bx, anz;

  /* Text in Zahlen umwandeln */
  str = XmTextGetString(NurbsDialogWText1);
  sscanf(str, "%ld;%ld;%d;%d", &x, &z, &cu, &cv);
  NurbsDialog.x = x;
  NurbsDialog.z = z;
  NurbsDialog.cu = cu;
  NurbsDialog.cv = cv;

  // Knotenstring lesen
  str = XmTextGetString(NurbsDialogWText2);
  sscanf(str, "%s", (char *) &NurbsDialog.knotenstr1);
  sscanf(str, "%s", (char *) &s1);

  // Knotenstring lesen
  str = XmTextGetString(NurbsDialogWText3);
  sscanf(str, "%s", (char *) &NurbsDialog.knotenstr2);
  sscanf(str, "%s", (char *) &s2);

  // Am Ende ein ; anhaengen damit Alg. einfacher wird
  strcat(s1, ";");
  // Anzahl ermitteln
  for (l = strlen(s1), anz = a = 0; a < l; a++)
    if (s1[a] == ';')
      anz++;
  NurbsDialog.i = (float *) malloc(sizeof(float) * (anz + 1));
  NurbsDialog.i[0] = (float) anz;
  // Ziffern des Knotenvektor bilden
  for (nr = bx = a = 0; a < l; a++)
    {
      if (s1[a] != ';')
	buff[bx++] = s1[a];
      else
	{
	  buff[bx] = (char) 0;
	  sscanf(buff, "%f", &NurbsDialog.i[++nr]);
	  bx = 0;
	}
    }

  // Am Ende ein ; anhaengen damit Alg. einfacher wird
  strcat(s2, ";");
  // Anzahl ermitteln
  for (l = strlen(s2), anz = a = 0; a < l; a++)
    if (s2[a] == ';')
      anz++;
  NurbsDialog.j = (float *) malloc(sizeof(float) * (anz + 1));
  NurbsDialog.j[0] = (float) anz;
  // Ziffern des Knotenvektor bilden
  for (nr = bx = a = 0; a < l; a++)
    {
      if (s2[a] != ';')
	buff[bx++] = s2[a];
      else
	{
	  buff[bx] = (char) 0;
	  sscanf(buff, "%f", &NurbsDialog.j[++nr]);
	  bx = 0;
	}
    }

  // Dialog zur Eingabe der Matrix
  nurbsmatrixdialog(x, z);

  /* erst hier!!! */
  WObjDialog = NULL;

  XtUnmanageChild(WNurbsDialog);
  WNurbsDialog = NULL;
}

void
CBNurbsCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  delete_cover_nurbs_liste();
  XtUnmanageChild(WNurbsDialog);

  /*  erst hier!!! */
  WObjDialog = NULL;

  WNurbsDialog = NULL;
}

void
CBNurbsHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal oeffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpnurbsdialog);
  else
    infobox("helpnureinmal");
}

void
CBNurbsCover(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  NurbsDialog.nrcover = (((XmListCallbackStruct *) pCallData)->item_position) - 1;
  sprintf(cpos, "%ld", NurbsDialog.nrcover);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(NurbsCoverLabel, &Aargs, 1);
  strcpy(NurbsDialog.coverlabel, cpos);
}

void
CBNurbRButton(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case 0:
      NurbsDialog.ou = NurbsDialog.ov = 2;
      break;
    case 1:
      NurbsDialog.ou = NurbsDialog.ov = 3;
      break;
    case 2:
      NurbsDialog.ou = 2;
      NurbsDialog.ov = 3;
      break;
    case 3:
      NurbsDialog.ou = 3;
      NurbsDialog.ov = 2;
      break;
    default:
      fprintf(stderr, "Callback CBNurbRButton = %d\n", *(int *) pClientData);
    }
}

void
create_nurbs_listen(void)
{
  char str[256];
  longint x = 0, anzelem = 0;

  /* CoverListe */
  if (coveranf)
    {
      coverx = coveranf;
      while (coverx)
	{
	  anzelem = coverx->nr;
	  coverx = coverx->next;
	}
      NurbsDialog.anzcover = anzelem + 1;
      NurbsDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      coverx = coveranf;
      x = 0;
      /* Dummy fuer keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      NurbsDialog.pCoverStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (coverx)
	{
	  sprintf(str, "%ld: Cover", coverx->nr);	/* C String erzeugen */
	  NurbsDialog.pCoverStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  coverx = coverx->next;
	  x++;
	}
    }
  else
    {
      /* nur Dummy */
      NurbsDialog.anzcover = 1;
      NurbsDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString));
      strcpy(str, "0: keine");
      NurbsDialog.pCoverStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }
}

void
nurbsdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art)
{
  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    WRowCol4, AWButtonD[1], WRadioBox, frame1, frame2, frame3, WLabel,
    WCoverList, WRadioCol;

  Arg Aargs[MAX_ARGS];
  int nArgs, i;
  char str[256];

  static int NurbButtonID[] =
  {0, 1, 2, 3};

  NurbsDialogArt = art;
  nurbs_anknr = ank_nr;
  nurbs_grobj = grobjp;

  if (NurbsDialogArt == AENDERN)
    {
      ((nurbs *) (nurbs_grobj->objp))->
	get(&NurbsDialog.x, &NurbsDialog.z, &NurbsDialog.cu, &NurbsDialog.cv,
	    &NurbsDialog.ou, &NurbsDialog.ov,
	    &NurbsDialog.y, &NurbsDialog.i, &NurbsDialog.j);
      // zustzlich
      NurbsDialog.nrcover = nurbs_grobj->cover;

      // Knotenstring init
      lade_knotenstr();
    }
  else
    NurbsDialog_init(0L, 6, 9, 10, 10, 3, 3, NULL, NULL, NULL);

  /* Strings fr Listen Aufbauen */
  create_nurbs_listen();

  WNurbsDialog = XmCreateDialogShell(W, "nurbsdialog", NULL, 0);
  XtManageChild(WNurbsDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 350);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 500);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WNurbsDialog, "nurbsrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("nurbsframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "nurbsrow2", NULL, 0);
  XtManageChild(WRowCol2);

  WLabel = XtCreateManagedWidget("Punkte x,z,approxuv & Knoten u,v:",
				 xmLabelWidgetClass, WRowCol2, NULL, 0);

  sprintf(str, "%ld;%ld;%d;%d", NurbsDialog.x, NurbsDialog.z, NurbsDialog.cu, NurbsDialog.cv);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  NurbsDialogWText1 =
    XtCreateManagedWidget("nurbsp", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  // Order ?
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNentryClass, xmToggleButtonWidgetClass);
  nArgs++;
  WRadioBox = XmCreateRadioBox(WRowCol2, "nurbsradio", Aargs, nArgs);
  XtManageChild(WRadioBox);

  /* 4 Togglebuttons erzeugen */

  i = 0;
  nArgs = 0;
  if ((NurbsDialog.ou == 2) && (NurbsDialog.ov == 2))
    XtSetArg(Aargs[nArgs], XmNset, True);
  else
    XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] = XtCreateManagedWidget("u&v Grad 1", xmToggleButtonWidgetClass,
					 WRadioBox, Aargs, nArgs);
  nArgs = 0;

  if ((NurbsDialog.ou == 3) && (NurbsDialog.ov == 3))
    XtSetArg(Aargs[nArgs], XmNset, True);
  else
    XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("u&v Grad 2", xmToggleButtonWidgetClass, WRadioBox, Aargs, nArgs);

  if ((NurbsDialog.ou == 2) && (NurbsDialog.ov == 3))
    XtSetArg(Aargs[nArgs], XmNset, True);
  else
    XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("u 1., v 2. Grad", xmToggleButtonWidgetClass, WRadioBox,
			  Aargs, nArgs);

  if ((NurbsDialog.ou == 3) && (NurbsDialog.ov == 2))
    XtSetArg(Aargs[nArgs], XmNset, True);
  else
    XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("u 2., v 1. Grad", xmToggleButtonWidgetClass, WRadioBox,
			  Aargs, nArgs);

  // Callbacks fr alle 4 Buttons
  for (i = 0; i < 4; i++)
    XtAddCallback(AWButtonD[i], XmNvalueChangedCallback, (XtCallbackProc) CBNurbRButton, &NurbButtonID[i]);

  // eigentlich nicht notwendig, es koennte alles von RowCol2 abstammen !
  frame3 = XtCreateManagedWidget("nurbsframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRadioCol = XmCreateRowColumn(frame3, "nurbsrowr", NULL, 0);
  XtManageChild(WRadioCol);

  sprintf(str, "%s", NurbsDialog.knotenstr1);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;

  NurbsDialogWText2 =
    XtCreateManagedWidget("nurbsp", xmTextWidgetClass, WRadioCol, Aargs, nArgs);

  sprintf(str, "%s", NurbsDialog.knotenstr2);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  NurbsDialogWText3 = XtCreateManagedWidget("nurbsp", xmTextWidgetClass, WRadioCol,
					    Aargs, nArgs);

  frame2 = XtCreateManagedWidget("nurbscoverf", xmFrameWidgetClass, WRadioCol, NULL, 0);
  WRowCol4 = XmCreateRowColumn(frame2, "nurbsc4", NULL, 0);
  XtManageChild(WRowCol4);

  sprintf(str, "%ld", NurbsDialog.nrcover);
  NurbsCoverLabel = XtCreateManagedWidget(str, xmLabelWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, NurbsDialog.pCoverStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, NurbsDialog.anzcover);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 4);
  nArgs++;
  WCoverList = XmCreateScrolledList(WRowCol4, "nurbscover", Aargs, nArgs);
  XtAddCallback(WCoverList, XmNdefaultActionCallback, (XtCallbackProc) CBNurbsCover, NULL);
  XtManageChild(WCoverList);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "nurbsrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBNurbsOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBNurbsCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBNurbsHelp, NULL);
}

void
nurbsmatrixdialog(longint x, longint z)
{
  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[80];
  longint a;

  Widget WButtonOK, WButtonPick, WButtonCancel, WRowCol, WRowCol2, WRowColM,
    WEscrollwin, Wframe;

  WNurbsMatrixDialog = XmCreateDialogShell(WTop, "matrixdialog", NULL, 0);
  XtManageChild(WNurbsMatrixDialog);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 690);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 400);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol = XmCreateRowColumn(WNurbsMatrixDialog, "matrixrow", Aargs, nArgs);
  XtManageChild(WRowCol);

  /* Arbeitsflche */
  Wframe = XtCreateManagedWidget("matrixframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WEscrollwin =
    XtVaCreateManagedWidget("matrixscrol", xmScrolledWindowWidgetClass, Wframe,
			    XmNscrollingPolicy, XmAUTOMATIC,
			    XmNvisualPolicy, XmVARIABLE,
			    XmNwidth, 580,
			    XmNheight, 300,
			    NULL);

  // Eingabezeilen anordnen
  WRowColM = XtVaCreateManagedWidget("matrixrowm", xmRowColumnWidgetClass, WEscrollwin,
				     XmNorientation, XmHORIZONTAL,
				     XmNpacking, XmPACK_COLUMN,
				     XmNnumColumns, z,
				     NULL);

  // Speicher allocieren
  WNurbsMatrix = (Widget *) malloc(sizeof(Widget) * x * z);

  for (a = 0; a < (x * z); a++)
    {
      if (NurbsDialogArt == AENDERN)
	sprintf(str, "%0.1f;%0.1f;%0.1f;%0.1f",
		NurbsDialog.y[a].x, NurbsDialog.y[a].y,
		NurbsDialog.y[a].z, NurbsDialog.y[a].g);
      else
	{
	  if ((NurbsDialog.x == 6) && (NurbsDialog.z == 9))
	    sprintf(str, "%0.1f;%0.1f;%0.1f;%0.1f",
		    control_points[a].x, control_points[a].y,
		    control_points[a].z, control_points[a].w);
	  else
	    strcpy(str, "0;0;0;1");
	}

      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNvalue, str);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNwidth, 100);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNnumColumns, 5);
      nArgs++;
      WNurbsMatrix[a] =
	XtCreateManagedWidget("matrixt", xmTextWidgetClass, WRowColM, Aargs, nArgs);
    }

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(WRowCol, "matrixrow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  WButtonOK = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonOK);
  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBNurbsMatrixOk, NULL);

  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonPick);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);

  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonCancel);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBNurbsMatrixCancel, NULL);
}
