/*  
   Dialogbox fr Muster

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"

STRING helpmusterdialog = "Definition eines Oberflaechenmusters.";
struct musterstruktur MusterDialog;
Widget WMusterDialog, Mustername, WBereich;
GC MusterDialogGCFarbe;
int MusterDialogArt;

void
MusterDialog_init(float R1, float B1, float G1, float R2, float B2, float G2,
	       float Mix, float X, float Y, int Art, int Fehler, char *Name)
{
  MusterDialog.r1 = R1;
  MusterDialog.b1 = B1;
  MusterDialog.g1 = G1;
  MusterDialog.r2 = R2;
  MusterDialog.b2 = B2;
  MusterDialog.g2 = G2;
  MusterDialog.mix = Mix;
  MusterDialog.x = X;
  MusterDialog.y = Y;
  MusterDialog.art = Art;
  MusterDialog.fehler = Fehler;
  strcpy(MusterDialog.name, Name);
}

void
MusterDialog_get(float *R1, float *B1, float *G1, float *R2, float *B2, float *G2,
	  float *Mix, float *X, float *Y, int *Art, int *Fehler, char *Name)
{
  *R1 = MusterDialog.r1;
  *B1 = MusterDialog.b1;
  *G1 = MusterDialog.g1;
  *R2 = MusterDialog.r2;
  *B2 = MusterDialog.b2;
  *G2 = MusterDialog.g2;
  *Mix = MusterDialog.mix;
  *X = MusterDialog.x;
  *Y = MusterDialog.y;
  *Art = MusterDialog.art;
  *Fehler = MusterDialog.fehler;
  strcpy(Name, MusterDialog.name);
}

void
MusterFarbealloc(Widget W, int x)
{
  if (MusterDialog.privat && (x == 1))
    {
      MusterDialog.XCol1.flags = DoRed | DoGreen | DoBlue;
      MusterDialog.XCol1.red = (unsigned) (MusterDialog.r1 * 65535.0);
      MusterDialog.XCol1.green = (unsigned) (MusterDialog.g1 * 65535.0);
      MusterDialog.XCol1.blue = (unsigned) (MusterDialog.b1 * 65535.0);
      XStoreColor(XtDisplay(W), MusterDialog.CMap, &MusterDialog.XCol1);
    }
  else if (MusterDialog.privat && (x == 2))
    {
      MusterDialog.XCol2.flags = DoRed | DoGreen | DoBlue;
      MusterDialog.XCol2.red = (unsigned) (MusterDialog.r2 * 65535.0);
      MusterDialog.XCol2.green = (unsigned) (MusterDialog.g2 * 65535.0);
      MusterDialog.XCol2.blue = (unsigned) (MusterDialog.b2 * 65535.0);
      XStoreColor(XtDisplay(W), MusterDialog.CMap, &MusterDialog.XCol2);
    }
  if (!MusterDialog.privat && (x == 1))
    {
      MusterDialog.XCol1.flags = DoRed | DoGreen | DoBlue;
      MusterDialog.XCol1.red = (unsigned) (MusterDialog.r1 * 65535.0);
      MusterDialog.XCol1.green = (unsigned) (MusterDialog.g1 * 65535.0);
      MusterDialog.XCol1.blue = (unsigned) (MusterDialog.b1 * 65535.0);
      XAllocColor(XtDisplay(W), MusterDialog.CMap, &MusterDialog.XCol1);
    }
  else if (!MusterDialog.privat && (x == 2))
    {
      MusterDialog.XCol2.flags = DoRed | DoGreen | DoBlue;
      MusterDialog.XCol2.red = (unsigned) (MusterDialog.r2 * 65535.0);
      MusterDialog.XCol2.green = (unsigned) (MusterDialog.g2 * 65535.0);
      MusterDialog.XCol2.blue = (unsigned) (MusterDialog.b2 * 65535.0);
      XAllocColor(XtDisplay(W), MusterDialog.CMap, &MusterDialog.XCol2);
    }
}

void
MusterFarbanzeige(int x)
{
  if (MusterDialog.Win && (x == 1))
    {
      XSetForeground(MusterDialog.pD, MusterDialogGCFarbe, MusterDialog.XCol1.pixel);
      XFillRectangle(MusterDialog.pD, MusterDialog.Win, MusterDialogGCFarbe, 1, 1, 150, 70);
    }
  else if (MusterDialog.Win && (x == 2))
    {
      XSetForeground(MusterDialog.pD, MusterDialogGCFarbe, MusterDialog.XCol2.pixel);
      XFillRectangle(MusterDialog.pD, MusterDialog.Win, MusterDialogGCFarbe, 1, 1, 150, 70);
    }
}

void
CBMusterFarbanzeige(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  MusterDialog.Win = ((XmDrawingAreaCallbackStruct *) pCallData)->window;
  if (MusterDialog.Win != 0)
    {
      MusterDialog.pD = XtDisplay(W);
      XSetForeground(MusterDialog.pD, MusterDialogGCFarbe, MusterDialog.XCol1.pixel);
      XFillRectangle(MusterDialog.pD, MusterDialog.Win, MusterDialogGCFarbe, 1, 1, 150, 70);
    }
}

void
CBMusterScaleCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case 1:
      MusterDialog.r1 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      MusterFarbealloc(W, 1);
      MusterFarbanzeige(1);
      break;
    case 2:
      MusterDialog.g1 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      MusterFarbealloc(W, 1);
      MusterFarbanzeige(1);
      break;
    case 3:
      MusterDialog.b1 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      MusterFarbealloc(W, 1);
      MusterFarbanzeige(1);
      break;
    case 4:
      MusterDialog.r2 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      MusterFarbealloc(W, 2);
      MusterFarbanzeige(2);
      break;
    case 5:
      MusterDialog.g2 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      MusterFarbealloc(W, 2);
      MusterFarbanzeige(2);
      break;
    case 6:
      MusterDialog.b2 = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      MusterFarbealloc(W, 2);
      MusterFarbanzeige(2);
      break;
    default:
      fprintf(stderr, "MusterRegler %d\n", *(int *) pClientData);
    }
}

void
CBMusterOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;

  /* Text Widgets auslesen */
  str = XmTextGetString(Mustername);
  sscanf(str, "%s", MusterDialog.name);
  // XmStringFree((XmString)str);

  str = XmTextGetString(WBereich);
  sscanf(str, "%f;%f", &MusterDialog.x, &MusterDialog.y);
  // XmStringFree((XmString)str);

  if (MusterDialogArt == NEU)
    ank_muster(MusterDialog.name, MusterDialog.r1, MusterDialog.b1, MusterDialog.g1,
	       MusterDialog.r2, MusterDialog.b2, MusterDialog.g2,
	       MusterDialog.mix, MusterDialog.art, MusterDialog.fehler,
	       MusterDialog.x, MusterDialog.y);
  else if (MusterDialogArt == AENDER)
    MusterDialog_get(&mustx->r1, &mustx->b1, &mustx->g1,
		     &mustx->r2, &mustx->b2, &mustx->g2,
		     &mustx->mix, &mustx->x, &mustx->y, &mustx->art,
		     &mustx->fehler, mustx->name);

  /* Farbe freigeben */
  if (MusterDialog.privat)
    XFreeColors(MusterDialog.pD, MusterDialog.CMap, &MusterDialog.XCol1.pixel, 1, 0);

  /* Dialog schlieen */
  XtUnmanageChild(WMusterDialog);
  WMusterDialog = NULL;
}

void
CBMusterCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* Farbe freigeben */
  if (MusterDialog.privat)
    XFreeColors(MusterDialog.pD, MusterDialog.CMap, &MusterDialog.XCol1.pixel, 1, 0);

  XtUnmanageChild(WMusterDialog);
  WMusterDialog = NULL;
}

void
CBMusterHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpmusterdialog);
  else
    infobox("helpnureinmal");
}

void
CBProzent(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  MusterDialog.mix = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
}

void
CBRandom(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  MusterDialog.fehler = ((XmToggleButtonCallbackStruct *) pCallData)->set;
}

void
CBButtonM(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /*  nur einschalten ist interresant */
  if (((XmToggleButtonCallbackStruct *) pCallData)->set)
    MusterDialog.art = *(int *) pClientData;
}

void
musterdialog(Widget W, int art)
{
  unsigned long pixel;
  char xystr[256];
  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    WRowCol4, WRowCol6, WScale[6], WLabel1, frame1, frame2, frame4, frame5,
    Wdrawarea,			/* WLabel2, WLabel3, */
    WProzent, WRandom, WRadioBoxM, AWButtonM[6];

  /* Definitionen */
  static int AiButtonID[] =
  {BLANK, KAROS, LINIE, KREIS, APFEL, JULIA, WOLKE};

  /* Definitionen */
  STRING AIScale[] =
  {"musterr1", "musterr2", "musterr3", "musterr4", "musterr5", "musterr6"};
  static int AIScaleID[] =
  {1, 2, 3, 4, 5, 6};

  int nScale;
  int maxScale = 6, nArgs, i;
  Arg Aargs[MAX_ARGS];
  XmString mstr;

  MusterDialogArt = art;
  /* Der Dialog */
  WMusterDialog = XmCreateDialogShell(W, "musterdialog", NULL, 0);
  XtManageChild(WMusterDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 725);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 400);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WMusterDialog, "musterrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  /* fr Regler */
  frame2 = XtCreateManagedWidget("musterframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(frame2, "musterrow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  /* Scalen */
  for (nScale = 0; nScale < maxScale; nScale++)
    {
      nArgs = 0;
      if (nScale == 0)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Rot1", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, MusterDialog.r1 * 100.0);
	}
      else if (nScale == 1)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Grn1", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, MusterDialog.g1 * 100.0);
	}
      else if (nScale == 2)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Blau1", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, MusterDialog.b1 * 100.0);
	}
      else if (nScale == 3)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Rot2", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, MusterDialog.r2 * 100.0);
	}
      else if (nScale == 4)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Grn2", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, MusterDialog.g2 * 100.0);
	}
      else if (nScale == 5)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Blau2", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, MusterDialog.b2 * 100.0);
	}

      nArgs++;
      WScale[nScale] =
	XtCreateManagedWidget(AIScale[nScale], xmScaleWidgetClass, WRowCol2, Aargs, nArgs);
      XtAddCallback(WScale[nScale], XmNvalueChangedCallback,
		    CBMusterScaleCanged, &AIScaleID[nScale]);
    }

  /*  Farbanzeigen */
  MusterDialog.pD = XtDisplay(WTop);
  MusterDialog.CMap = DefaultColormap(MusterDialog.pD, DefaultScreen(MusterDialog.pD));
  MusterDialog.privat = true;
  if (XAllocColor(MusterDialog.pD, MusterDialog.CMap, &MusterDialog.XCol1))
    {
      MusterDialog.privat = false;
      MusterFarbealloc(WTop, 1);
      MusterDialog.XCol2 = MusterDialog.XCol1;
      MusterFarbealloc(WTop, 2);
    }
  else if (!XAllocColorCells(MusterDialog.pD, MusterDialog.CMap, false, NULL, 0, &pixel, 1))
    {
      MusterDialog.privat = false;
      infobox("keinefarbzelle");
    }
  if (MusterDialog.privat)
    {
      MusterDialog.XCol1.pixel = pixel;
      MusterFarbealloc(WTop, 1);
      MusterDialog.XCol2.pixel = pixel;
      MusterFarbealloc(WTop, 2);
    }

  frame4 = XtCreateManagedWidget("musterframe4", xmFrameWidgetClass, WRowCol1, NULL, 0);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNadjustLast, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNmarginWidth, 20);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNspacing, 20);
  nArgs++;
  WRowCol6 = XmCreateRowColumn(frame4, "musterrow6", Aargs, nArgs);
  XtManageChild(WRowCol6);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 20);
  nArgs++;
  frame5 = XtCreateManagedWidget("musterframe5", xmFrameWidgetClass, WRowCol6, Aargs, nArgs);
  Wdrawarea =
    XtCreateManagedWidget("musterdrawcol", xmDrawingAreaWidgetClass, frame5, Aargs, nArgs);
  /* Callbacks um neu zu zeichnen */
  XtAddCallback(Wdrawarea, XmNexposeCallback, (XtCallbackProc) CBMusterFarbanzeige, NULL);
  XtAddCallback(Wdrawarea, XmNresizeCallback, (XtCallbackProc) CBMusterFarbanzeige, NULL);

  /* GC erzeugen um zeichnen zu knnen */
  MusterDialogGCFarbe = CreateSimpleGC(Wdrawarea);


  nArgs = 0;
  /* in Prozent die Sichtbarkeit */
  XtSetArg(Aargs[nArgs], XmNvalue, MusterDialog.mix * 100.0);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNshowValue, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
  nArgs++;
  mstr = XmStringCreateLtoR("Sicht:", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
  nArgs++;
  WProzent = XtCreateManagedWidget("mustersicht", xmScaleWidgetClass, WRowCol6, Aargs, nArgs);
  XtAddCallback(WProzent, XmNvalueChangedCallback, (XtCallbackProc) CBProzent, NULL);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, MusterDialog.fehler);
  nArgs++;
  WRandom =
    XtCreateManagedWidget("Ausflle xy:", xmToggleButtonWidgetClass, WRowCol6, Aargs, nArgs);
  XtAddCallback(WRandom, XmNvalueChangedCallback, (XtCallbackProc) CBRandom, NULL);

  /* WLabel3 = XtCreateManagedWidget("Abs xy:", xmLabelWidgetClass, WRowCol6, NULL, 0); */
  sprintf(xystr, "%0.2f;%0.2f", MusterDialog.x, MusterDialog.y);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, xystr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 9);
  nArgs++;
  WBereich = XtCreateManagedWidget("musterbereich", xmTextWidgetClass, WRowCol6, Aargs, nArgs);

  frame1 = XtCreateManagedWidget("musterframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol4 = XmCreateRowColumn(frame1, "musterrow4", NULL, 0);
  XtManageChild(WRowCol4);

  /*  Welches Muster */
  /* RadioBox erzeugen die Togglebuttons als Kinder hat */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNentryClass, xmToggleButtonWidgetClass);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRadioBoxM = XmCreateRadioBox(WRowCol4, "musterradioboxm", Aargs, nArgs);
  XtManageChild(WRadioBoxM);
  /* 6 Togglebuttons erzeugen */
  i = 0;

  // Sicherheit
  if (MusterDialog.art < 1 || MusterDialog.art > 7)
    MusterDialog.art = 1;
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, MusterDialog.art == BLANK);
  nArgs++;
  AWButtonM[i++] =
    XtCreateManagedWidget("Far", xmToggleButtonWidgetClass, WRadioBoxM, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, MusterDialog.art == KAROS);
  nArgs++;
  AWButtonM[i++] =
    XtCreateManagedWidget("Kar", xmToggleButtonWidgetClass, WRadioBoxM, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, MusterDialog.art == LINIE);
  nArgs++;
  AWButtonM[i++] =
    XtCreateManagedWidget("Lin", xmToggleButtonWidgetClass, WRadioBoxM, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, MusterDialog.art == KREIS);
  nArgs++;
  AWButtonM[i++] =
    XtCreateManagedWidget("Kre", xmToggleButtonWidgetClass, WRadioBoxM, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, MusterDialog.art == APFEL);
  nArgs++;
  AWButtonM[i++] =
    XtCreateManagedWidget("Apf", xmToggleButtonWidgetClass, WRadioBoxM, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, MusterDialog.art == JULIA);
  nArgs++;
  AWButtonM[i++] =
    XtCreateManagedWidget("Man", xmToggleButtonWidgetClass, WRadioBoxM, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, MusterDialog.art == WOLKE);
  nArgs++;
  AWButtonM[i++] =
    XtCreateManagedWidget("Wol", xmToggleButtonWidgetClass, WRadioBoxM, Aargs, nArgs);
  /* Callbacks fr alle Buttons */
  for (i = 0; i < 7; i++)
    XtAddCallback(AWButtonM[i], XmNvalueChangedCallback, (XtCallbackProc) CBButtonM, &AiButtonID[i]);

  WLabel1 = XtCreateManagedWidget("Mustername", xmLabelWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, MusterDialog.name);
  nArgs++;
  Mustername = XtCreateManagedWidget("musterdn", xmTextWidgetClass, WRowCol4, Aargs, nArgs);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "musterrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);
  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBMusterOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBMusterCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBMusterHelp, NULL);
}
