/* Listex zeigt die Erweiterungen des X-Servers an 
   Copyright (C) 1996 Helmut Fahrion
   
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.
   
   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#include <stdio.h>
#include <X11/Xlib.h>

void main(int argc, char **argv)
{
  Display  *pdisp;
  char **extensions = NULL;
  int  num_extensions, major_opcode, first_event, first_error, i;

  if ((pdisp = XOpenDisplay(NULL)) == NULL)
  {
    fprintf(stderr, "Kann Display nicht ffnen!\n");
    exit(1);
  }
  
  extensions = XListExtensions(pdisp, &num_extensions);
  printf("Der Server hat %d Erweiterungen\n", num_extensions);
  
  if (num_extensions > 0)
    for (i=0; i < num_extensions; i++)
    {
      printf("--------------------------------------\n");
      printf("Name: %s\n", extensions[i]);
      if (XQueryExtension(pdisp, extensions[i],
			  &major_opcode, &first_event, &first_error))
      {
	printf("Major Opcode: %d\n", major_opcode);
	if (first_event)
	  printf("First event: %d\n", first_event);
	if (first_error)
	   printf("First error: %d\n", first_error);
      }
    }
  
  if (extensions != NULL)
    XFreeExtensionList(extensions);
  XCloseDisplay(pdisp);
}
