/* Hauptdatenstruktur fuer die Grafischen Elemente
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

// nur hier sichtbar !
static grobjekt *grobjektanf, *grobjektx, *grobjektend;

liste oliste;

liste::liste()
{
  grobjektanf = grobjektend = grobjektx = NULL;
}

void liste::
destroy(void)
{
  delete grobjektanf;
  grobjektend = grobjektanf = grobjektx = NULL;
}

liste::~liste()
{
  delete grobjektanf;
}

grobjekt *liste::
getaktuell(void)
{
  return grobjektx;
}

grobjekt *liste::
getfirst(void)
{
  return (grobjektx = grobjektanf);
}

grobjekt *liste::
readfirst(void)
{
  return (grobjektanf);
}

grobjekt *liste::
getnext(void)
{
  return (grobjektx = grobjektx->next);
}

longint liste::
getlast(grobjekt ** old)
{
  *old = grobjektend;
  return grobjektend->nr + 1;
}

grobjekt *liste::
getobjp(longint x)
{
  if (!grobjektx)
    grobjektx = grobjektanf;

  if (grobjektx)
    {
      if (grobjektx->nr != x)
	if (grobjektx->nr < x)
	  {
	    while (grobjektx && (grobjektx->nr != x))
	      grobjektx = grobjektx->next;
	  }
	else
	  {
	    while (grobjektx && (grobjektx->nr != x))
	      grobjektx = grobjektx->prev;
	  }
    }
  return grobjektx;
}

grobjekt *liste::
readobjp(longint x)
{
  grobjekt *grobjx;

  grobjx = grobjektx;

  if (!grobjx)
    grobjx = grobjektanf;

  if (grobjx)
    {
      if (grobjx->nr != x)
	if (grobjx->nr < x)
	  {
	    while (grobjx && (grobjx->nr != x))
	      grobjx = grobjx->next;
	  }
	else
	  {
	    while (grobjx && (grobjx->nr != x))
	      grobjx = grobjx->prev;
	  }
    }
  return grobjx;
}

longint liste::
insertobj(int obj_art, longint Ank_nr,
	  float R, float B, float G, float E, float Mat, float Sp, float Du,
	  float Dif, float Spec, float High, float Vel, char Ch,
	  longint Cover, vector Ref, vector W)
{
  longint Nr = 1;
  grobjekt *grx, *old = NULL;

  if (grobjektanf == NULL)
    {
      // Zeiger auf Vorgaenger, Nummer der Welle
      grobjektanf = new grobjekt(NULL, obj_art, Nr, Ank_nr, R, B, G, E, Mat, Sp, Du,
				 Dif, Spec, High, Vel, Ch, Cover, Ref, W);
      // speichern um Objekt zu initialisieren
      grobjektend = grobjektx = grobjektanf;
    }
  else
    {
      Nr = getlast(&old);
      // Objekt immer an letzte Stelle anketten,
      // es muss sichergestellt sein das die Nummern eindeutig sind auch 
      // wenn es Luecken gibt!
      old = new grobjekt(old, obj_art, Nr, Ank_nr, R, B, G, E, Mat, Sp, Du,
			 Dif, Spec, High, Vel, Ch, Cover, Ref, W);
      // speichern um Objekt zu initialisieren
      grobjektend = grobjektx = old;
    }


  if (Ank_nr)
    {
      // Zeiger kann nicht uebergeben werden da durch Picken 
      // ueber die Pick_id nur die Nummer bekannt ist.
      grx = grobjektx->isank = readobjp(Ank_nr);

      // dieses Objekt hat dieses an seiner Kette
      if (grx->lanka == NULL)
	{
	  // erzeuge erstes Listenelement
	  grx->lanka = grx->lankx = new alist(NULL, grobjektx);
	}
      else
	{
	  // zum letzten, nicht an das Ende !!!
	  for (grx->lankx = grx->lanka; grx->lankx->next; grx->lankx = grx->lankx->next);
	  // fuege neues Element an
	  grx->lankx = new alist(grx->lankx, grobjektx);
	}
    }
  return Nr;
}

void liste::
deleteobj(grobjekt * grx)
{
  grobjekt *grvorg, *grnach;

  grobjektx = grx;
  grvorg = grobjektx->prev;
  grnach = grobjektx->next;

  if (grobjektx != NULL)
    {
      // nur ein Element
      if ((grobjektx == grobjektanf) && (grobjektx == grobjektend))
	{
	  delete grobjektx;
	  grobjektanf = grobjektend = grobjektx = NULL;
	}
      else
	// steht auf ersten
      if (grobjektx == grobjektanf)
	{
	  grobjektanf = grnach;
	  grobjektanf->prev = NULL;
	  grobjektx->next = NULL;
	  delete grobjektx;
	  grobjektx = grnach;	// am Anfang stehen lassen

	}
      else
	// steht auf letzten
      if (grobjektx == grobjektend)
	{
	  grobjektend = grvorg;
	  grvorg->next = NULL;
	  grobjektx->next = NULL;
	  delete grobjektx;
	  grobjektx = grvorg;	// am Ende stehen lassen

	}
      // Normalfall
      else
	{
	  grvorg->next = grobjektx->next;
	  grnach->prev = grobjektx->prev;
	  grobjektx->next = NULL;
	  delete grobjektx;
	  grobjektx = grnach;	// in der Mitte stehen lassen

	}
    }
  // Falls Null, an Anfang setzen
  if (!grobjektx)
    grobjektx = grobjektanf;
}

void liste::
deleteank(grobjekt * grx)
{
  if (grx->lankx)
    {
      // gehe an das Ende
      for (grx->lankx = grx->lanka; grx->lankx; grx->lankx = grx->lankx->next)
	{
	  // loesche restliche Ketten
	  deleteank(grx->lankx->ankobj);
	  deleteobj(grx->lankx->ankobj);
	}
    }
}
