/*  
   Dialogbox fr Polygon-Lichtquellendefinition und 

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

#define PAINTX 400
#define PAINTY 50

STRING helplichtpolygondialog = "Definition einer Flaechenfoermigen Lichtquelle.\nFarbe der Lichtquelle, Position und Intensitaet.";

struct lichtpolygonstruktur LichtPolygonDialog;
GC LichtPolygonDialogGCFarbe;

Widget WLichtPolygonDialog, WP1, WP2, WP3, WP4;
int LichtPolygonDialogArt;
vector *licht_m;

void
LichtPolygonDialog_init(float R, float G, float B, float I, int XAnz, int YAnz,
			float W, vector P1, vector P2, vector P3, vector P4)
{
  LichtPolygonDialog.r = R;
  LichtPolygonDialog.g = G;
  LichtPolygonDialog.b = B;
  LichtPolygonDialog.i = I;
  LichtPolygonDialog.xanz = XAnz;
  LichtPolygonDialog.yanz = YAnz;
  LichtPolygonDialog.w = W;
  LichtPolygonDialog.p1 = P1;
  LichtPolygonDialog.p2 = P2;
  LichtPolygonDialog.p3 = P3;
  LichtPolygonDialog.p4 = P4;
}

void
LichtPolygonDialog_get(float *R, float *G, float *B, float *I, int *XAnz, int *YAnz,
	       float *W, vector * P1, vector * P2, vector * P3, vector * P4)
{
  *R = LichtPolygonDialog.r;
  *G = LichtPolygonDialog.g;
  *B = LichtPolygonDialog.b;
  *I = LichtPolygonDialog.i;
  *XAnz = LichtPolygonDialog.xanz;
  *YAnz = LichtPolygonDialog.yanz;
  *P1 = LichtPolygonDialog.p1;
  *P2 = LichtPolygonDialog.p2;
  *W = LichtPolygonDialog.w;
  *P3 = LichtPolygonDialog.p3;
  *P4 = LichtPolygonDialog.p4;
}

void
LichtPolygonFarbealloc(Widget W)
{
  LichtPolygonDialog.XCol.flags = DoRed | DoGreen | DoBlue;
  LichtPolygonDialog.XCol.red = (unsigned) (LichtPolygonDialog.r * 65535.0);
  LichtPolygonDialog.XCol.green = (unsigned) (LichtPolygonDialog.g * 65535.0);
  LichtPolygonDialog.XCol.blue = (unsigned) (LichtPolygonDialog.b * 65535.0);
  if (LichtPolygonDialog.privat)
    XStoreColor(XtDisplay(W), LichtPolygonDialog.CMap, &LichtPolygonDialog.XCol);
  else
    XAllocColor(XtDisplay(W), LichtPolygonDialog.CMap, &LichtPolygonDialog.XCol);
}

void
LichtPolygonFarbanzeige()
{
  if (LichtPolygonDialog.Win)
    {
      XSetForeground(LichtPolygonDialog.pD, LichtPolygonDialogGCFarbe,
		     LichtPolygonDialog.XCol.pixel);
      XFillRectangle(LichtPolygonDialog.pD, LichtPolygonDialog.Win, LichtPolygonDialogGCFarbe,
		     1, 1, PAINTX, PAINTY);
    }
}

void
CBLichtPolygonFarbanzeige(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  LichtPolygonDialog.Win = ((XmDrawingAreaCallbackStruct *) pCallData)->window;
  if (LichtPolygonDialog.Win != 0)
    {
      LichtPolygonDialog.pD = XtDisplay(W);
      XSetForeground(LichtPolygonDialog.pD, LichtPolygonDialogGCFarbe,
		     LichtPolygonDialog.XCol.pixel);
      XFillRectangle(LichtPolygonDialog.pD, LichtPolygonDialog.Win,
		     LichtPolygonDialogGCFarbe, 1, 1, PAINTX, PAINTY);
    }
}

void
erz_lichtmatrix(vector p1, vector p2, vector p3, vector p4, int x, int y)
{
  longint xanz, yanz, a, b, ia, ib;
  vector r;
  float l;

  xanz = x + 2;
  yanz = y + 2;

  licht_m = new vector[xanz * yanz];	// inklusive der Polygonpunkte

  // erzeuge Vektor 1
  r |= p2 - p1;
  l = (p2 || p1) / (float) (xanz - 1);
  for (a = 0; a < xanz; a++)
    licht_m[a] = p1 + r * l * a;

  // erzeuge letzten Vektor
  r |= p3 - p4;
  l = (p3 || p4) / (float) (xanz - 1);
  for (a = 0; a < xanz; a++)
    licht_m[(yanz - 1) * xanz + a] = p4 + r * l * a;

  for (a = 0; a < xanz; a++)
    {
      ia = a;
      ib = (yanz - 1) * xanz + a;
      r |= licht_m[ib] - licht_m[ia];
      l = (licht_m[ib] || licht_m[ia]) / (float) (yanz - 1);	// strecke nach b

      for (b = 1; b < yanz - 1; b++)	// nimm 1. und letztes nicht

	licht_m[b * xanz + a] = licht_m[ia] + r * l * b;
    }
}

void
create_lichtmarker(vector p1, vector p2, vector p3, vector p4, int x, int y)
{
  longint i;
  int a, b;
  PEXCoord lp, rv[2];
  vector r, n;

  n |= (p2 - p1) && (p3 - p1);
  n *= 0.1;

  licht_m = NULL;
  erz_lichtmatrix(p1, p2, p3, p4, x, y);
  if (licht_m)
    {
      // zeige Marker
      for (b = 0; b < (y + 2); b++)
	for (a = 0; a < (x + 2); a++)
	  {
	    i = b * (x + 2) + a;
	    // Marker setzen
	    SET_VECTA(licht_m[i], lp);
	    PEXMarkers(pDisplay, lichtpoly_struct, PEXOCStore, 1, &lp);
	    // Richtungslinie
	    SET_VECTA(licht_m[i], rv[0]);
	    r = n + licht_m[i];
	    SET_VECTA(r, rv[1]);
	    PEXPolyline(pDisplay, lichtpoly_struct, PEXOCStore, 2, rv);
	  }
    }
  delete licht_m;
}

void
erz_lichtpolygon(vector p1, vector p2, vector p3, vector p4, int x, int y, longint nr)
{
  // Lichtquelle in der Struktur erzeugen
  PEXSetEditingMode(pDisplay, lichtpoly_struct, PEXStructureInsert);
  PEXSetElementPtr(pDisplay, lichtpoly_struct, PEXEnd, 0);

  // Polymarker
  PEXSetMarkerType(pDisplay, lichtpoly_struct, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(pDisplay, lichtpoly_struct, PEXOCStore, 3.0);
  PEXSetMarkerColor(pDisplay, lichtpoly_struct, PEXOCStore, PEXColorTypeRGB, &echo_color);
  PEXLabel(pDisplay, lichtpoly_struct, PEXOCStore, (long) nr);

  create_lichtmarker(p1, p2, p3, p4, x, y);

  // Polymarker neu zeichnen
  redraw(True);
}

void
aender_lichtpolygon(vector p1, vector p2, vector p3, vector p4, int x, int y, longint nr)
{
  // Zwar Brutal, aber der obige Algorithmus funk. nicht
  neue_lichtpoly_marker();
  // Polymarker neu zeichnen
  redraw(True);
}

void
CBLichtPolygonOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  bool ok;
  longint nr;
  STRING str;

  str = XmTextGetString(WP1);
  if (!(ok = expr_vector(&LichtPolygonDialog.p1, str)))		// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor 1 liefert eine ungueltige Zahl!");
      return;			// gehe zurueck ohne Dialog zu beenden

    }

  str = XmTextGetString(WP2);
  if (!(ok = expr_vector(&LichtPolygonDialog.p2, str)))
    {
      errorbox("Vektor 2 liefert eine ungueltige Zahl!");
      return;
    }

  str = XmTextGetString(WP3);
  if (!(ok = expr_vector(&LichtPolygonDialog.p3, str)))
    {
      errorbox("Vektor 3 liefert eine ungueltige Zahl!");
      return;
    }

  str = XmTextGetString(WP4);
  if (!(ok = expr_vector(&LichtPolygonDialog.p4, str)))
    {
      errorbox("Vektor 4 liefert eine ungueltige Zahl!");
      return;
    }

  if (!testebene(LichtPolygonDialog.p1, LichtPolygonDialog.p2,
		 LichtPolygonDialog.p3, LichtPolygonDialog.p4))
    {
      LichtPolygonDialog.p4 = LichtPolygonDialog.p1
	+ LichtPolygonDialog.p3
	- LichtPolygonDialog.p2;
      errorbox("Keine Ebene!\nrcke nach p4=p1+p3-p2");
    }

  if (LichtPolygonDialogArt == NEU)
    {
      nr = ank_lichtpoly(LichtPolygonDialog.r, LichtPolygonDialog.g, LichtPolygonDialog.b,
      LichtPolygonDialog.i, LichtPolygonDialog.xanz, LichtPolygonDialog.yanz,
	 LichtPolygonDialog.w, LichtPolygonDialog.p1, LichtPolygonDialog.p2,
			 LichtPolygonDialog.p3, LichtPolygonDialog.p4);
      erz_lichtpolygon(LichtPolygonDialog.p1, LichtPolygonDialog.p2,
      LichtPolygonDialog.p3, LichtPolygonDialog.p4, LichtPolygonDialog.xanz,
		       LichtPolygonDialog.yanz, nr);
    }
  else
    {
      if (LichtPolygonDialogArt == AENDER)
	{
	  LichtPolygonDialog_get(&lichtpolyx->r, &lichtpolyx->g, &lichtpolyx->b,
		       &lichtpolyx->i, &lichtpolyx->xanz, &lichtpolyx->yanz,
			   &lichtpolyx->w, &lichtpolyx->p1, &lichtpolyx->p2,
				 &lichtpolyx->p3, &lichtpolyx->p4);
	  aender_lichtpolygon(lichtpolyx->p1, lichtpolyx->p2, lichtpolyx->p3,
			 lichtpolyx->p4, lichtpolyx->xanz, lichtpolyx->yanz,
			      lichtpolyx->nr);
	}
    }

  if (LichtPolygonDialog.privat)
    XFreeColors(LichtPolygonDialog.pD, LichtPolygonDialog.CMap,
		&LichtPolygonDialog.XCol.pixel, 1, 0);

  XtUnmanageChild(WLichtPolygonDialog);
  WLichtPolygonDialog = NULL;
}

void
CBLichtPolygonCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  if (LichtPolygonDialog.privat)
    XFreeColors(LichtPolygonDialog.pD, LichtPolygonDialog.CMap,
		&LichtPolygonDialog.XCol.pixel, 1, 0);

  XtUnmanageChild(WLichtPolygonDialog);
  WLichtPolygonDialog = NULL;
}

void
CBLichtPolygonHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helplichtpolygondialog);
  else
    infobox("helpnureinmal");
}

void
CBLichtPolygonScaleCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case 1:
      LichtPolygonDialog.r = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      LichtPolygonFarbealloc(W);
      LichtPolygonFarbanzeige();
      break;
    case 2:
      LichtPolygonDialog.g = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      LichtPolygonFarbealloc(W);
      LichtPolygonFarbanzeige();
      break;
    case 3:
      LichtPolygonDialog.b = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      LichtPolygonFarbealloc(W);
      LichtPolygonFarbanzeige();
      break;
    case 4:
      LichtPolygonDialog.i = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 5:
      LichtPolygonDialog.xanz = ((XmScaleCallbackStruct *) pCallData)->value;
      break;
    case 6:
      LichtPolygonDialog.yanz = ((XmScaleCallbackStruct *) pCallData)->value;
      break;
    case 7:
      LichtPolygonDialog.w = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    default:
      fprintf(stderr, "LichtPolygonRegler %d\n", *(int *) pClientData);
    }
}

void
lichtpolygondialog(Widget W, int art)
{
  unsigned long pixel;

  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    WRowCol4, WScale[7], frame1, frame2, frame3, Wdrawarea, WLabel, WButtonPick,
    WLabelPunkt;

  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];
  XmString mstr;

  /* Definitionen */
  STRING AIScale[] =
  {"lichtpolygonr1", "lichtpolygonr2", "lichtpolygonr3",
   "lichtpolygonr4", "lichtpolygonr5", "lichtpolygonr6",
   "lichtpolygonr7"};

  static int AIScaleID[] =
  {
    1, 2, 3, 4, 5, 6, 7
  };

  int nScale;
  int maxScale = 7;

  LichtPolygonDialogArt = art;

  /* Der Dialog */
  WLichtPolygonDialog = XmCreateDialogShell(W, "lichtpolygondialog", NULL, 0);
  XtManageChild(WLichtPolygonDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 585);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 460);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WLichtPolygonDialog, "lichtpolygondrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("lichtpolygonframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNnumColumns, 1);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(frame1, "lichtpolygondrow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  frame2 = XtCreateManagedWidget("lichtpolygonframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(frame2, "lichtpolygondrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol4 = XmCreateRowColumn(WRowCol1, "lichtpolygondrow4", Aargs, nArgs);
  XtManageChild(WRowCol4);

  /* Scalen */
  for (nScale = 0; nScale < maxScale; nScale++)
    {
      nArgs = 0;

      switch (nScale)
	{
	case 0:
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("R", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtPolygonDialog.r * 100.0);
	  break;
	case 1:
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("G", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtPolygonDialog.g * 100.0);
	  break;
	case 2:
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("B", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtPolygonDialog.b * 100.0);
	  break;
	case 3:
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("S", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNmaximum, 100);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtPolygonDialog.i * 10.0);
	  break;
	case 4:
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  // XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2); nArgs++;
	  mstr = XmStringCreateLtoR("X", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNmaximum, 10);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtPolygonDialog.xanz);
	  break;
	case 5:
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  //XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2); nArgs++;
	  mstr = XmStringCreateLtoR("Y", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNmaximum, 10);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtPolygonDialog.yanz);
	  break;
	case 6:
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("W", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNmaximum, 314);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtPolygonDialog.w * 100.0);
	  break;
	}

      nArgs++;
      WScale[nScale] =
	XtCreateManagedWidget(AIScale[nScale], xmScaleWidgetClass, WRowCol2, Aargs, nArgs);

      XtAddCallback(WScale[nScale], XmNvalueChangedCallback,
		    CBLichtPolygonScaleCanged, &AIScaleID[nScale]);
    }

  /* Farbanzeige */
  WLabel = XtCreateManagedWidget("Farbe:", xmLabelWidgetClass, WRowCol3, NULL, 0);
  frame3 = XtCreateManagedWidget("lichtpolygonframe3", xmFrameWidgetClass, WRowCol3, NULL, 0);

  /* Fr Farbnderung eine ColorCell holen */
  LichtPolygonDialog.pD = XtDisplay(WTop);
  LichtPolygonDialog.CMap =
    DefaultColormap(LichtPolygonDialog.pD, DefaultScreen(LichtPolygonDialog.pD));
  LichtPolygonDialog.privat = true;

  if (XAllocColor(LichtPolygonDialog.pD, LichtPolygonDialog.CMap, &LichtPolygonDialog.XCol))
    {
      LichtPolygonDialog.privat = false;
      LichtPolygonFarbealloc(WTop);
    }
  else if (!XAllocColorCells(LichtPolygonDialog.pD, LichtPolygonDialog.CMap,
			     false, NULL, 0, &pixel, 1))
    {
      LichtPolygonDialog.privat = false;
      infobox("keinefarbzelle");
    }
  if (LichtPolygonDialog.privat)
    {
      LichtPolygonDialog.XCol.pixel = pixel;
      LichtPolygonFarbealloc(WTop);
    }
  Wdrawarea = XtCreateManagedWidget("lichtpolygondrawcol",
				 xmDrawingAreaWidgetClass, frame3, NULL, 0);
  /* Callbacks um neu zu zeichnen */
  XtAddCallback(Wdrawarea, XmNexposeCallback, (XtCallbackProc) CBLichtPolygonFarbanzeige, NULL);
  XtAddCallback(Wdrawarea, XmNresizeCallback, (XtCallbackProc) CBLichtPolygonFarbanzeige, NULL);

  /* GC erzeugen um zeichnen zu knnen */
  LichtPolygonDialogGCFarbe = CreateSimpleGC(Wdrawarea);

  WLabelPunkt = XtCreateManagedWidget("Punkte:", xmLabelWidgetClass, WRowCol3, NULL, 0);
  sprintf(str, "%0.2f;%0.2f;%0.2f",
  LichtPolygonDialog.p1.x, LichtPolygonDialog.p1.y, LichtPolygonDialog.p1.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  WP1 = XtCreateManagedWidget("lichtpolygonp1", xmTextWidgetClass,
			      WRowCol3, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f",
  LichtPolygonDialog.p2.x, LichtPolygonDialog.p2.y, LichtPolygonDialog.p2.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  WP2 = XtCreateManagedWidget("lichtpolygonp2",
			      xmTextWidgetClass, WRowCol3, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f",
  LichtPolygonDialog.p3.x, LichtPolygonDialog.p3.y, LichtPolygonDialog.p3.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  WP3 = XtCreateManagedWidget("lichtpolygonp3",
			      xmTextWidgetClass, WRowCol3, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f",
  LichtPolygonDialog.p4.x, LichtPolygonDialog.p4.y, LichtPolygonDialog.p4.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  WP4 = XtCreateManagedWidget("lichtpolygonp4",
			      xmTextWidgetClass, WRowCol3, Aargs, nArgs);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonPick);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonCancel);

  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBLichtPolygonOk, NULL);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBLichtPolygonCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBLichtPolygonHelp, NULL);
}
