/*  
   Dialogbox fr Lichtquellendefinition und 

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

STRING helplichtdialog = "Definition einer Lichtquelle.\nFarbe der Lichtquelle und Intensitaet.";

struct lichtstruktur LichtDialog;
GC LichtDialogGCFarbe;
char LichtDialogArt;
Widget LichtDialogWPosition, WLichtDialog;

void
LichtDialog_init(float R, float B, float G, float Intens,
		 float X, float Y, float Z)
{
  LichtDialog.r = R;
  LichtDialog.b = B;
  LichtDialog.g = G;
  LichtDialog.intens = Intens;
  LichtDialog.x = X;
  LichtDialog.y = Y;
  LichtDialog.z = Z;
}

void
LichtDialog_get(float *R, float *B, float *G, float *Intens,
		float *X, float *Y, float *Z)
{
  *R = LichtDialog.r;
  *B = LichtDialog.b;
  *G = LichtDialog.g;
  *Intens = LichtDialog.intens;
  *X = LichtDialog.x;
  *Y = LichtDialog.y;
  *Z = LichtDialog.z;
}

void
LichtFarbealloc(Widget W)
{
  LichtDialog.XCol.flags = DoRed | DoGreen | DoBlue;
  LichtDialog.XCol.red = (unsigned) (LichtDialog.r * 65535.0);
  LichtDialog.XCol.green = (unsigned) (LichtDialog.g * 65535.0);
  LichtDialog.XCol.blue = (unsigned) (LichtDialog.b * 65535.0);

  if (LichtDialog.privat)
    XStoreColor(XtDisplay(W), LichtDialog.CMap, &LichtDialog.XCol);
  else
    XAllocColor(XtDisplay(W), LichtDialog.CMap, &LichtDialog.XCol);

}

void
LichtFarbanzeige()
{
  if (LichtDialog.Win)
    {
      XSetForeground(LichtDialog.pD, LichtDialogGCFarbe, LichtDialog.XCol.pixel);
      XFillRectangle(LichtDialog.pD, LichtDialog.Win, LichtDialogGCFarbe, 1, 1, 245, 25);
    }
}

void
CBLichtFarbanzeige(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  LichtDialog.Win = ((XmDrawingAreaCallbackStruct *) pCallData)->window;
  if (LichtDialog.Win != 0)
    {
      LichtDialog.pD = XtDisplay(W);
      XSetForeground(LichtDialog.pD, LichtDialogGCFarbe, LichtDialog.XCol.pixel);
      XFillRectangle(LichtDialog.pD, LichtDialog.Win, LichtDialogGCFarbe, 1, 1, 245, 25);
    }
}

void
erz_lichtquelle(vector point, longint nr)
{
  PEXCoord lp;

  // Lichtquelle in der Struktur erzeugen
  PEXSetEditingMode(pDisplay, light_struct, PEXStructureInsert);
  PEXSetElementPtr(pDisplay, light_struct, PEXEnd, 0);

  SET_VECT(point.x, point.y, point.z, lp);

  // Polymarker
  PEXSetMarkerType(pDisplay, light_struct, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(pDisplay, light_struct, PEXOCStore, 3.0);
  PEXSetMarkerColor(pDisplay, light_struct, PEXOCStore, PEXColorTypeRGB, &echo_color);
  PEXLabel(pDisplay, light_struct, PEXOCStore, (long) nr);
  PEXMarkers(pDisplay, light_struct, PEXOCStore, 1, &lp);
}

void
aender_lichtquelle(vector point, longint nr)
{
  PEXCoord lp;
  // Lichtquelle in der Struktur erzeugen
  PEXSetEditingMode(pDisplay, light_struct, PEXStructureReplace);
  PEXSetElementPtr(pDisplay, light_struct, PEXBeginning, 0);

  PEXSetElementPtrAtLabel(pDisplay, light_struct, (long) nr, 1);

  SET_VECT(point.x, point.y, point.z, lp);
  PEXMarkers(pDisplay, light_struct, PEXOCStore, 1, &lp);

  // Polymarker neu zeichnen
  redraw(True);
}

void
CBLichtOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;
  longint nr;

  /* Text Widgets auslesen */
  str = XmTextGetString(LichtDialogWPosition);
  sscanf(str, "%f;%f;%f", &LichtDialog.x, &LichtDialog.y, &LichtDialog.z);
  // XmStringFree((XmString)str);

  /* neue Lichtquelle anketten? */
  if (LichtDialogArt == NEU)
    {
      nr = ank_lichtquelle(LichtDialog.r, LichtDialog.g, LichtDialog.b, LichtDialog.intens,
			   LichtDialog.x, LichtDialog.y, LichtDialog.z);
      erz_lichtquelle(vector(LichtDialog.x, LichtDialog.y, LichtDialog.z), nr);
    }
  else
    {
      if (LichtDialogArt == AENDER)
	{
	  LichtDialog_get(&lichtx->r, &lichtx->b, &lichtx->g, &lichtx->s,
			  &lichtx->x, &lichtx->y, &lichtx->z);
	  aender_lichtquelle(vector(LichtDialog.x, LichtDialog.y, LichtDialog.z), lichtx->nr);
	}
    }

  /* Farbe freigeben */
  if (LichtDialog.privat)
    XFreeColors(LichtDialog.pD, LichtDialog.CMap, &LichtDialog.XCol.pixel, 1, 0);

  XtUnmanageChild(WLichtDialog);
  WLichtDialog = NULL;
}

void
CBLichtCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* Farbe freigeben */
  if (LichtDialog.privat)
    XFreeColors(LichtDialog.pD, LichtDialog.CMap, &LichtDialog.XCol.pixel, 1, 0);

  XtUnmanageChild(WLichtDialog);
  WLichtDialog = NULL;
}

void
CBLichtHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helplichtdialog);
  else
    infobox("helpnureinmal");
}

void
CBLichtScaleCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case 1:
      LichtDialog.r = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 2:
      LichtDialog.g = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 3:
      LichtDialog.b = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 4:
      LichtDialog.intens = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    default:
      fprintf(stderr, "LichtRegler %d\n", *(int *) pClientData);
    }
  LichtFarbealloc(W);
  LichtFarbanzeige();
}

void
lichtdialog(Widget W, int art)
{
  unsigned long pixel;

  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    WRowCol4, WScale[4], frame1, frame2, frame3, Wdrawarea, WLabel;

  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];

  /* Definitionen */
  STRING AIScale[] =
  {"lichtr1", "lichtr2", "lichtr3", "lichtr4"};

  static int AIScaleID[] =
  {
    1, 2, 3, 4
  };

  int nScale;
  int maxScale = 4;
  XmString mstr;

  LichtDialogArt = art;

  /* Der Dialog */
  WLichtDialog = XmCreateDialogShell(W, "lichtdialog", NULL, 0);
  XtManageChild(WLichtDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 350);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 300);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WLichtDialog, "lichtdrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("lichtframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 1);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(frame1, "lichtdrow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  frame2 = XtCreateManagedWidget("lichtframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(frame2, "lichtdrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol4 = XmCreateRowColumn(WRowCol1, "lichtdrow4", Aargs, nArgs);
  XtManageChild(WRowCol4);

  /* Scalen */
  for (nScale = 0; nScale < maxScale; nScale++)
    {
      nArgs = 0;
      if (nScale == 0)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("R", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtDialog.r * 100.0);
	}
      else if (nScale == 1)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("G", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtDialog.g * 100.0);
	}
      else if (nScale == 2)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("B", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtDialog.b * 100.0);
	}
      else if (nScale == 3)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("S", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtDialog.intens * 100.0);
	}
      nArgs++;
      WScale[nScale] =
	XtCreateManagedWidget(AIScale[nScale], xmScaleWidgetClass, WRowCol2, Aargs, nArgs);

      XtAddCallback(WScale[nScale], XmNvalueChangedCallback,
		    CBLichtScaleCanged, (caddr_t) & AIScaleID[nScale]);
    }

  /* Farbanzeige */
  WLabel = XtCreateManagedWidget("Farbe:", xmLabelWidgetClass, WRowCol3, NULL, 0);
  frame3 = XtCreateManagedWidget("lichtframe3", xmFrameWidgetClass, WRowCol3, NULL, 0);

  /* Fr Farbnderung eine ColorCell holen */
  LichtDialog.pD = XtDisplay(WTop);
  LichtDialog.CMap = DefaultColormap(LichtDialog.pD, DefaultScreen(LichtDialog.pD));
  LichtDialog.privat = true;

  if (XAllocColor(LichtDialog.pD, LichtDialog.CMap, &LichtDialog.XCol))
    {
      LichtDialog.privat = false;
      LichtFarbealloc(WTop);
    }
  else if (!XAllocColorCells(LichtDialog.pD, LichtDialog.CMap, false, NULL, 0, &pixel, 1))
    {
      LichtDialog.privat = false;
      infobox("keinefarbzelle");
    }
  if (LichtDialog.privat)
    {
      LichtDialog.XCol.pixel = pixel;
      LichtFarbealloc(WTop);
    }
  Wdrawarea = XtCreateManagedWidget("lichtdrawcol", xmDrawingAreaWidgetClass, frame3, NULL, 0);
  /* Callbacks um neu zu zeichnen */
  XtAddCallback(Wdrawarea, XmNexposeCallback, (XtCallbackProc) CBLichtFarbanzeige, NULL);
  XtAddCallback(Wdrawarea, XmNresizeCallback, (XtCallbackProc) CBLichtFarbanzeige, NULL);

  /* GC erzeugen um zeichnen zu knnen */
  LichtDialogGCFarbe = CreateSimpleGC(Wdrawarea);

  sprintf(str, "%0.2f;%0.2f;%0.2f", LichtDialog.x, LichtDialog.y, LichtDialog.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 14);
  nArgs++;
  LichtDialogWPosition =
    XtCreateManagedWidget("lichtpos", xmTextWidgetClass, WRowCol3, Aargs, nArgs);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBLichtOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBLichtCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBLichtHelp, NULL);

  /* Daten auf Grundwerte einstellen */
  // LichtDialog.intens = 10.0;
}
