/*  
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Dialogbox fr die Dateneingabe der Kugel
   Copyright (C) 1996, 1997 Helmut Fahrion
 */

#include "pextool.H"

#define SPHERE_APPROX_ANZ 4

struct kugelstruktur SphereDialog;

STRING helpspheredialog = "Definition einer Kugel.";
Widget WSphereDialog, SphereWText1, SphereWText2, SphereWText3, SphereCoverLabel;
int    SphereArt;
grobjekt *sphere_grobj;
longint sphere_anknr;
PEXVertexNormal sphere_netz[(SPHERE_APPROX_ANZ + 1) * (SPHERE_APPROX_ANZ + 1)];

void
SphereDialog_init(float R, float W1, float W2, longint Nrcover, vector M)
{
  SphereDialog.r = R;
  SphereDialog.m = M;
  SphereDialog.nrcover = Nrcover;
  SphereDialog.w1 = W1;
  SphereDialog.w2 = W2;
}

void
SphereDialog_get(float *R, float *W1, float *W2, longint * Nrcover, vector * M)
{
  *R = SphereDialog.r;
  *M = SphereDialog.m;
  *Nrcover = SphereDialog.nrcover;
  *W1 = SphereDialog.w1;
  *W2 = SphereDialog.w2;
}

void
create_kugel_polyline(Display * D, PEXStructure poly, vector p1, vector p2,
		      vector p3, vector p4, vector pn)
{

  //PEXCoord lp;
  PEXCoord coord[4];

  // Polymareker
  PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(D, poly, PEXOCStore, 3.0);
  PEXSetMarkerColor(D, poly, PEXOCStore, PEXColorTypeRGB, &echo_color);
  //   SET_VECTA(p1, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p2, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p3, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p4, lp); 
  //   PEXMarkers(D, poly, PEXOCStore, 1, &lp);

  // Polyline
  SET_VECTA(p1, coord[0]);
  SET_VECTA(p2, coord[1]);
  SET_VECTA(p3, coord[2]);
  SET_VECTA(p1, coord[3]);
  PEXPolyline(D, poly, PEXOCStore, 4, coord);

  //   PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCross);
  //   SET_VECTA(p4+(pn*0.1), lp); 
  //   PEXMarkers(D, poly, PEXOCStore, 1, &lp);

  //   // Polyline Dreieck
  //   SET_VECTA(p4+(pn*0.1), coord[0]);
  //   SET_VECTA(p4, coord[1]);
  //   PEXPolyline(D, poly, PEXOCStore,  2, coord);
}

/*
void
kugel_listtree(Display * D, PEXStructure obj, vector m, vector n, float r)
{
  PEXCoord lp, coord[2];

  // Polymarker
  PEXSetMarkerType(D, obj, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(D, obj, PEXOCStore, 3.0);
  PEXSetMarkerColor(D, obj, PEXOCStore, PEXColorTypeRGB, &echo_color);

  SET_VECTA(m, lp);
  PEXMarkers(D, obj, PEXOCStore, 1, &lp);

  // Polyline Dreieck
  SET_VECTA(m, coord[0]);
  SET_VECTA(m + (n * r), coord[1]);
  PEXPolyline(D, obj, PEXOCStore, 2, coord);
}

// scanne rekursiv den Baum
void
listkugeltree(patchtree * patr, longint a, longint * z,
	      Display * D, PEXStructure obj)
{
  patchtl *ptl;

  for (ptl = patr->o; ptl; ptl = ptl->next)
    {
      kugel_listtree(D, obj, ptl->p->m, ptl->p->n, ptl->p->r);

      if (abs(ptl->p->m) == 0)
	cerr << "0! anz: " << a + 1 << "\n";

      *z += 1;
      a++;
    }

  // cerr << a << " Elemente im Tree!\n";

  for (char x = 0; x < 8; x++)
    if (patr->pt[x] != NULL)
      listkugeltree(patr->pt[x], 0, z, D, obj);
}

void savepatches(FILE *D, patchtree * patr)
{
  patchtl *ptl;

  for (ptl = patr->o; ptl; ptl = ptl->next)
    {
      fprintf(D, "%f %f %f %f %f %f\n", 
	      ptl->p->m.x, ptl->p->m.y, ptl->p->m.z, 
	      ptl->p->n.x, ptl->p->n.y, ptl->p->n.z);
    }

  // cerr << a << " Elemente im Tree!\n";

  for (char x = 0; x < 8; x++)
    if (patr->pt[x] != NULL)
      savepatches(D, patr->pt[x]);
}
void
kugel_calcpatches(vector m, float r, Display * D, PEXStructure pobj)
{
  longint z = 0;
  cerr << "Erzeuge Patchtree-Kugel!\n";

  patcharray *pa, *pas;
  obj   *kugel, *kugelS;

  // simuliere grobj anlegen
  kugel = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, SPHERE, NONE);
  //  kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, SPHERE, SCHN);
  //  kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, SPHERE, DIFF);
  //   kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, ELIPSOID, SCHN);
  // kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, ELIPSOID, DIFF);
  // kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, POLYGON, DIFF);
  //  kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, POLYGON, SCHN);
  //kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, BLOCK, DIFF);
  // kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, BLOCK, SCHN);
  //kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, CONE, SCHN);
  //kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, CONE, DIFF);
  // kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, TORUS, SCHN);
  // kugelS = new obj(NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, NULL, TORUS, DIFF);

  // simuliere obj init
  ((sphere *) (kugel->grobjp))->setsphere(m, r, 0, 0);
  //((sphere *) (kugelS->grobjp))->setsphere(vector(m.x + 0.15, m.y, m.z), r, 0, 0);
  //   ((elipsoid *) (kugelS->grobjp))->setelip(vector(m.x + 0.2, m.y, m.z), 
  //                                       vector(0,0,0),vector(r, r/2, r));
 
  //((polygon *) (kugelS->grobjp))->setvector(0, vector(0.1, -0.3, -0.3));
  //((polygon *) (kugelS->grobjp))->setvector(1, vector(0.1, -0.3, 0.3));
  //((polygon *) (kugelS->grobjp))->setvector(2, vector(0.1, 0.3, 0.3));
  //((polygon *) (kugelS->grobjp))->setvector(3, vector(0.1, 0.3, -0.3));

  //   ((block *) (kugelS->grobjp))->setvector (0, vector (-.1, -0.1, -.1));
  //   ((block *) (kugelS->grobjp))->setvector (1, vector (0.3, -0.1, -.1));
  //   ((block *) (kugelS->grobjp))->setvector (2, vector (0.3,  0.1, -.1));
  //   ((block *) (kugelS->grobjp))->setvector (3, vector (-.1,  0.1, -.1));
  //   ((block *) (kugelS->grobjp))->setvector (4, vector (-.1, -0.1, 0.1));
  //   ((block *) (kugelS->grobjp))->setvector (5, vector (0.3, -0.1, 0.1));
  //   ((block *) (kugelS->grobjp))->setvector (6, vector (0.3,  0.1, 0.1));
  //   ((block *) (kugelS->grobjp))->setvector (7, vector (-.1,  0.1, 0.1));
  //   ((cone *) (kugelS->grobjp))->setcone (vector (0.0, -0.2, 0.0), 
  // 					vector (0.0, 0.2, 0.0), 
  // 					0.2, 0.1, 0.0);
  // ((torus *) (kugelS->grobjp))->settorus (vector (0.3, 0, 0), 0.3, 0.1, VNULL);

  // ruft radiosity auf
  // pa = kugel->createpatches(Patchweite, kugelS);

  pa = kugel->createpatches(Patchweite);
  //pas = kugelS->createpatches(Patchweite, 0);

  cerr << "Kugel Listtree.\n";

  // anzeige
  listkugeltree(pa->pt, 0, &z, D, pobj);

  //listkugeltree(pas->pt, 0, &z, D, pobj);

  cerr << "Kugel gesamt = " << z << " Patches.\n";


FILE *F;
  if ((F = fopen("patchkugel", "w+")) == NULL)
    {
      cerr << "kugelobj: Fehler beim ffnen der Datei patchkugel !\n";
      exit (1);
    }

  fprintf(F, "%d 0.1\n", z);
  
  savepatches(F, pa->pt);

  fclose(F);

  delete kugel;	// Schnittobjekte werden mit entfernt
}
*/

void
create_sphere_netz(Display * D, PEXStructure obj)
{
  double theta, phi;
  int    index, i, j, anzpoints, anznetz;

  // generiere ein Netz in den Koordinaten einer Kugel
  // dies ist ntig weil PEX keine Kugeln kennt
  theta = phi = 0.0;
  anzpoints = SPHERE_APPROX_ANZ;
  anznetz = anzpoints + 1;

  // in richtigen koordinaten erzeugen!
  for (i = 0; i < anznetz; i++)
    {
      for (j = 0; j < anznetz; j++)
	{
	  index = i * anznetz + j;
	  sphere_netz[index].point.x = sin(phi) * sin(theta) * SphereDialog.r + SphereDialog.m.x;
	  sphere_netz[index].point.y = cos(phi) * SphereDialog.r + SphereDialog.m.y;
	  sphere_netz[index].point.z = sin(phi) * cos(theta) * SphereDialog.r + SphereDialog.m.z;
	  // Normalvektor
	  sphere_netz[index].normal.x = sphere_netz[index].point.x;
	  sphere_netz[index].normal.y = sphere_netz[index].point.y;
	  sphere_netz[index].normal.z = sphere_netz[index].point.z;
	  normal(&sphere_netz[index].normal);

	  theta += (2.0 * pi) / (float)anzpoints;
	}

      phi += pi / (float)anzpoints;

      // Kreis schlieen
      index = i * anznetz + anzpoints;
      sphere_netz[index].point = sphere_netz[index - anzpoints].point;
      sphere_netz[index].normal = sphere_netz[index - anzpoints].normal;
    }

  // Patches anzeigen
  //kugel_calcpatches(SphereDialog.m, SphereDialog.r, D, obj);
}

void
aendere_sphere(Display * D)
{
  int    anzpoints, anznetz;

  // Kugelberechnung
  PEXArrayOfFacetData dummy;
  PEXArrayOfVertex kugel;

  PEXStructure *spherep = &(sphere_grobj->obj_struct);

  anzpoints = SPHERE_APPROX_ANZ;
  anznetz = anzpoints + 1;

  /* Aendern im grobjekt */
  sphere_grobj->cover = SphereDialog.nrcover;	// Covereintrag

  ((cadsphere *) (sphere_grobj->objp))->init(SphereDialog.r, SphereDialog.w1,
					     SphereDialog.w2, SphereDialog.m);

  PEXSetEditingMode(pDisplay, *spherep, PEXStructureReplace);
  PEXSetElementPtr(D, *spherep, PEXBeginning, 0);
  PEXSetElementPtrAtLabel(D, *spherep, OBJ_POLYLINE_LABEL, 1);

  create_sphere_netz(D, *spherep);
  kugel.normal = sphere_netz;
  PEXQuadrilateralMesh(D, *spherep, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANormal, PEXColorTypeRGB, dummy,
		       anznetz, anznetz, kugel);

  un_echo(sphere_grobj, sphere_grobj->ch == 'N');
}

void
create_sphere(Display * D, Widget W, grobjekt * sphere, longint ank_nr, longint pick_id)
{
  bool   echocolor = True;
  int    anzpoints, anznetz;
  PEXCoord ref_point;
  PEXName name[2];
  PEXMatrix matrix;
  PEXVector tr, scale;
  PEXStructure *sphere_element = NULL;
  grobjekt *ankobj = NULL;

  // Kugelberechnung
  PEXArrayOfFacetData dummy;
  PEXArrayOfVertex kugel;

  anzpoints = SPHERE_APPROX_ANZ;
  anznetz = anzpoints + 1;

  // suche strukturpointer zum anhngen
  if (ank_nr == 0L)
    {
      echocolor = True;
      sphere_element = &root_struct;
      ankobj = NULL;
    }
  else
    {
      if ((ankobj = oliste.getobjp(ank_nr)) != NULL)
	{
	  echocolor = ankobj->ch == 'N';
	  sphere_element = &ankobj->obj_struct;
	}
      else
	ankobj = NULL;
    }

  // Nameset und Pickid sind wichtig fr das Picken
  name[0] = (PEXName) GROBJSTR;
  name[1] = (PEXName) SPHERE;
  PEXAddToNameSet(D, sphere->obj_struct, PEXOCStore, 2, name);
  PEXSetPickID(D, sphere->obj_struct, PEXOCStore, pick_id);

  PEXLabel(D, sphere->obj_struct, PEXOCStore, COLORLABEL);
  if (sphere->ch == 'N')
    PEXSetSurfaceColor(D, sphere->obj_struct, PEXOCStore, PEXColorTypeRGB, &normal_color);
  else
    PEXSetSurfaceColor(D, sphere->obj_struct, PEXOCStore, PEXColorTypeRGB, &schnitt_color);

  SET_VECT(0.0, 0.0, 0.0, tr);
  SET_VECT(0.0, 0.0, 0.0, ref_point);
  SET_VECT(1.0, 1.0, 1.0, scale);
  PEXBuildTransform(&ref_point, &tr, 0.0, 0.0, 0.0, &scale, matrix);
  PEXLabel(D, sphere->obj_struct, PEXOCStore, TRANSFORM_LABEL);
  PEXSetLocalTransform(D, sphere->obj_struct, PEXOCStore, PEXReplace, matrix);

  // Hier werden die Pickelemente eingefgt 
  PEXLabel(D, sphere->obj_struct, PEXOCStore, OBJ_PICK_ANF_LABEL);
  PEXLabel(D, sphere->obj_struct, PEXOCStore, OBJ_PICK_END_LABEL);

  PEXLabel(D, sphere->obj_struct, PEXOCStore, OBJ_POLYLINE_LABEL);

  create_sphere_netz(D, sphere->obj_struct);
  kugel.normal = sphere_netz;
  PEXQuadrilateralMesh(D, sphere->obj_struct, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANormal, PEXColorTypeRGB, dummy,
		       anznetz, anznetz, kugel);

  // Kennung das hier die Kette beginnt
  PEXLabel(D, sphere->obj_struct, PEXOCStore, OBJ_KETTE_LABEL);

  /* in Root-Struktur einfgen */
  PEXSetEditingMode(D, *sphere_element, PEXStructureInsert);
  PEXSetElementPtr(D, *sphere_element, PEXEnd, 0);
  PEXLabel(D, *sphere_element, PEXOCStore, GROBJ_LABEL + pick_id);
  PEXExecuteStructure(D, *sphere_element, PEXOCStore, sphere->obj_struct);

  un_echo(ankobj, echocolor);
}

void
delete_cover_kugel_liste(void)
{
  int    x, anzelem;

  for (anzelem = 0, coverx = coveranf; coverx; anzelem++, coverx = coverx->next);

  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(SphereDialog.pCoverStr[x]);
}

void
CBSphereOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;
  grobjekt *sphere;
  longint pick_id;
  vector m;
  float  r, w1, w2;
  char   ok;

  /* Text in Zahlen umwandeln */
  str = XmTextGetString(SphereWText1);
  // sscanf(str, "%f;%f;%f", &m.x, &m.y, &m.z);
  if (!(ok = expr_vector(&m, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor m liefert eine ungltige Zahl!");
      return;			// gehe zurck ohne Dialog zu beenden

    }

  // XmStringFree((XmString)str);
  SphereDialog.m = m;

  str = XmTextGetString(SphereWText2);
  sscanf(str, "%f", &r);
  XmStringFree((XmString) str);
  SphereDialog.r = r;

  str = XmTextGetString(SphereWText3);
  sscanf(str, "%f;%f", &w1, &w2);

  // XmStringFree((XmString)str);
  SphereDialog.w1 = w1;
  SphereDialog.w2 = w2;

  /* neues Polygon anketten? */
  if (SphereArt == NEU)
    {
      pick_id = ank_grobjekt(SPHERE, sphere_anknr,
	    ObjDialog.r, ObjDialog.g, ObjDialog.b, ObjDialog.e, ObjDialog.mat,
		    ObjDialog.sp, ObjDialog.du, ObjDialog.dif, ObjDialog.spec,
			     ObjDialog.high, ObjDialog.vel, ObjDialog.ch,
			     SphereDialog.nrcover,
			     vector(0.0, 0.0, 0.0), vector(0.0, 0.0, 0.0));

      sphere = ank_sphere(SphereDialog.r, SphereDialog.w1, SphereDialog.w2, SphereDialog.m);

      create_sphere(XtDisplay(W), W, sphere, sphere_anknr, pick_id);
    }
  else
    aendere_sphere(XtDisplay(W));

  delete_cover_kugel_liste();
  /* erst hier!!! */
  WObjDialog = NULL;

  XtUnmanageChild(WSphereDialog);
  WSphereDialog = NULL;
}

void
CBSphereCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  delete_cover_kugel_liste();
  XtUnmanageChild(WSphereDialog);

  /*  erst hier!!! */
  WObjDialog = NULL;

  WSphereDialog = NULL;
}

void
CBSphereHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpspheredialog);
  else
    infobox("helpnureinmal");
}

void
CBSphereCover(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char   cpos[5];
  XmString anzstr;
  Arg    Aargs;

  SphereDialog.nrcover = (((XmListCallbackStruct *) pCallData)->item_position) - 1;
  sprintf(cpos, "%ld", SphereDialog.nrcover);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(SphereCoverLabel, &Aargs, 1);
  strcpy(SphereDialog.coverlabel, cpos);
}

void
create_sphere_listen(void)
{
  char   str[256];
  longint x = 0, anzelem = 0;

  /* CoverListe */
  if (coveranf)
    {
      coverx = coveranf;
      while (coverx)
	{
	  anzelem = coverx->nr;
	  coverx = coverx->next;
	}
      SphereDialog.anzcover = anzelem + 1;
      SphereDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      coverx = coveranf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      SphereDialog.pCoverStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (coverx)
	{
	  sprintf(str, "%ld: Cover", coverx->nr);	/* C String erzeugen */
	  SphereDialog.pCoverStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  coverx = coverx->next;
	  x++;
	}
    }
  else
    {
      /* nur Dummy */
      SphereDialog.anzcover = 1;
      SphereDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString));
      strcpy(str, "0: keine");
      SphereDialog.pCoverStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }
}

void
spheredialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art)
{
  Widget WButtonOK, WButtonPick, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2,
         WRowCol3, WRowCol4, frame1, frame2, WLabel, WCoverList;

  Arg    Aargs[MAX_ARGS];
  int    nArgs;
  char   str[256];

  SphereArt = art;
  sphere_anknr = ank_nr;
  sphere_grobj = grobjp;

  if (SphereArt == AENDERN)
    {
      ((cadsphere *) (sphere_grobj->objp))->get(&SphereDialog.r, &SphereDialog.w1,
					   &SphereDialog.w2, &SphereDialog.m);
      // zustzlich
      SphereDialog.nrcover = sphere_grobj->cover;
    }
  else
    SphereDialog_init(0.2, 0.0, 0.0, 0L, vector(0.0, 0.0, 0.0));

  /* Strings fr Listen Aufbauen */
  create_sphere_listen();

  WSphereDialog = XmCreateDialogShell(W, "spheredialog", NULL, 0);
  XtManageChild(WSphereDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 360);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 340);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WSphereDialog, "sphererow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("sphereframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "sphererow2", NULL, 0);
  XtManageChild(WRowCol2);

  WLabel = XtCreateManagedWidget("Vektor x;y;z :", xmLabelWidgetClass, WRowCol2, NULL, 0);

  sprintf(str, "%0.2f;%0.2f;%0.2f", SphereDialog.m.x, SphereDialog.m.y, SphereDialog.m.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  SphereWText1 = XtCreateManagedWidget("spherem", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f", SphereDialog.r);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  SphereWText2 = XtCreateManagedWidget("spherer", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f", SphereDialog.w1, SphereDialog.w2);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  SphereWText3 = XtCreateManagedWidget("spherew", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  /* Cover Auswahl */
  frame2 = XtCreateManagedWidget("spherecoverf", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol4 = XmCreateRowColumn(frame2, "spherec4", NULL, 0);
  XtManageChild(WRowCol4);

  sprintf(str, "%ld", SphereDialog.nrcover);

  SphereCoverLabel = XtCreateManagedWidget(str, xmLabelWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, SphereDialog.pCoverStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, SphereDialog.anzcover);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 4);
  nArgs++;
  WCoverList = XmCreateScrolledList(WRowCol4, "spherecover", Aargs, nArgs);
  XtManageChild(WCoverList);
  XtAddCallback(WCoverList, XmNdefaultActionCallback, (XtCallbackProc) CBSphereCover, NULL);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "sphererow3", Aargs, nArgs);
//   XtManageChild(WRowCol3);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonPick);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);

  // Erst am Ende da sonst Ma nicht stimmt
  XtManageChild(WRowCol3);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBSphereOk, NULL);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBSphereCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBSphereHelp, NULL);

}
