/*  
   Dialogbox zur Definition einer Kamerafhrung
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

STRING kameradialogstr = "Definition der Kamerafhrung.";

Widget WKameraDialog, WKameraMatrixDialog, WAnzahl, WKameramasse, *WKameraMatrix;

struct kameradialogstruktur kameradialogs;
kameral *kameraliste, *kameralistex;

void matrixdialog(Widget W);

// Konstruktor, im Header cadtool.H definierte Kameraklasse
kameral::kameral(kameral * L, vector P, float V, vector B)
{
  if (L != NULL)
    L->next = this;
  next = NULL;
  punkt = P;
  geschw = V;
  blickrichtung = B;
}

void
Kamera_init(float Masse, unsigned long Anzbilder)
{
  kameradialogs.masse = Masse;
  kameradialogs.anzbilder = Anzbilder;

  if (kameraliste != NULL)
    {
      delete kameraliste;
      kameraliste = NULL;
    }
}

void
Kamera_get(float *Masse, unsigned long *Anzbilder, kameral ** L)
{
  *Masse = kameradialogs.masse;
  *Anzbilder = kameradialogs.anzbilder;
  *L = kameraliste;
}

void
CBKameraOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;
  float masse;
  longint anz;

  str = XmTextGetString(WAnzahl);
  sscanf(str, "%ld", &anz);

  str = XmTextGetString(WKameramasse);
  sscanf(str, "%f", &masse);

  Kamera_init(masse, anz);

  // Speicher fr Eingabezeilen
  WKameraMatrix = (Widget *) malloc(sizeof(Widget) * kameradialogs.anzbilder * 3);

  // Matrixdialog aufbauen
  matrixdialog(W);

  XtUnmanageChild(WKameraDialog);
  WKameraDialog = NULL;
}

void
CBKameraCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  XtUnmanageChild(WKameraDialog);
  WKameraDialog = NULL;
}

void
CBKameraHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, kameradialogstr);
  else
    infobox("helpnureinmal");
}

void
create_kamera(void)
{
  longint x;
  vector r;
  PEXCoord *coordr, *coordb, cam[2];

  PEXDeleteElements(pDisplay, kamera_struct, PEXBeginning, 0, PEXEnd, 0);
  PEXSetElementPtr(pDisplay, kamera_struct, PEXBeginning, 0);
  PEXSetEditingMode(pDisplay, kamera_struct, PEXStructureInsert);

  coordr = new PEXCoord[kameradialogs.anzbilder];
  coordb = new PEXCoord[kameradialogs.anzbilder];

  for (x = 0, kameralistex = kameraliste;
       (x < kameradialogs.anzbilder) && kameralistex;
       x++, kameralistex = kameralistex->next)
    {
      SET_VECTA(kameralistex->punkt, coordr[x]);
      SET_VECTA(kameralistex->blickrichtung, coordb[x]);
    }
  // Linie
  PEXPolyline(pDisplay, kamera_struct, PEXOCStore, kameradialogs.anzbilder, coordr);
  // Markers
  PEXSetMarkerType(pDisplay, kamera_struct, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(pDisplay, kamera_struct, PEXOCStore, 2.0);
  PEXSetMarkerColor(pDisplay, kamera_struct, PEXOCStore, PEXColorTypeRGB, &echo_color);
  PEXMarkers(pDisplay, kamera_struct, PEXOCStore, kameradialogs.anzbilder, coordr);

  // Richtung anzeigen
  for (x = 0, kameralistex = kameraliste;
       (x < kameradialogs.anzbilder) && kameralistex;
       x++, kameralistex = kameralistex->next)
    {
      SET_VECTA(kameralistex->punkt, cam[0]);
      r |= kameralistex->blickrichtung - kameralistex->punkt;
      r *= 0.1;			// Lnge des Normalvektors

      r += kameralistex->punkt;
      SET_VECTA(r, cam[1]);
      PEXPolyline(pDisplay, kamera_struct, PEXOCStore, 2, cam);
    }
  redraw(false);

  delete coordr;
  delete coordb;
}

void
ank_kamera(vector p, vector r, float v)
{
  if (!kameraliste)
    kameraliste = kameralistex = new kameral(NULL, p, v, r);
  else
    kameralistex = new kameral(kameralistex, p, v, r);
}

void
CBKameraMatrixOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  longint x;
  STRING str;
  char err[256];
  bool ok;
  vector punkt, blickrichtung, punkto, blickrichtungo;
  float v;

  if (kameraliste != NULL)
    {
      delete kameraliste;
      kameraliste = NULL;
    }

  for (x = 0; x < kameradialogs.anzbilder * 3; x += 3)
    {
      str = XmTextGetString(WKameraMatrix[x]);
      if (!(ok = expr_vector(&punkt, str)))	// 0 Fehler, 1 OK, 2 Relativ

	{
	  sprintf(err, "Vektor Position %ld ist ungltig!", x);
	  errorbox(str);
	  return;		// gehe zurck ohne Dialog zu beenden

	}
      if ((ok == 2) && (x))
	punkt += punkto;
      punkto = punkt;

      str = XmTextGetString(WKameraMatrix[x + 1]);
      sscanf(str, "%f", &v);

      str = XmTextGetString(WKameraMatrix[x + 2]);
      if (!(ok = expr_vector(&blickrichtung, str)))	// 0 Fehler, 1 OK, 2 Relativ

	{
	  sprintf(err, "Vektor Blick-Richtung %ld ist ungltig!", x);
	  errorbox(str);
	  return;		// gehe zurck ohne Dialog zu beenden

	}
      if ((ok == 2) && (x))
	blickrichtung += blickrichtungo;
      blickrichtungo = blickrichtung;

      if (!kameraliste)
	kameraliste = kameralistex = new kameral(NULL, punkt, v, blickrichtung);
      else
	kameralistex = new kameral(kameralistex, punkt, v, blickrichtung);
    }
  create_kamera();
  free(WKameraMatrix);
  XtUnmanageChild(WKameraMatrixDialog);
  WKameraMatrixDialog = NULL;
}

void
CBKameraMatrixCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  free(WKameraMatrix);
  XtUnmanageChild(WKameraMatrixDialog);
  WKameraMatrixDialog = NULL;
}

void
matrixdialog(Widget W)
{
  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[80];
  longint zz;
  char x;

  Widget WButtonOK, WButtonPick, WButtonCancel, WRowCol, WRowCol2, WRowColM,
    WEscrollwin, Wframe;

  WKameraMatrixDialog = XmCreateDialogShell(WTop, "matrixdialog", NULL, 0);
  XtManageChild(WKameraMatrixDialog);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 690);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 400);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol = XmCreateRowColumn(WKameraMatrixDialog, "matrixrow", Aargs, nArgs);
  XtManageChild(WRowCol);

  /* Arbeitsflche */
  Wframe = XtCreateManagedWidget("matrixframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WEscrollwin =
    XtVaCreateManagedWidget("matrixscrol", xmScrolledWindowWidgetClass, Wframe,
			    XmNscrollingPolicy, XmAUTOMATIC,
			    XmNvisualPolicy, XmVARIABLE,
			    XmNwidth, 580,
			    XmNheight, 300,
			    NULL);

  // Eingabezeilen anordnen, diesmal senkrecht
  WRowColM = XtVaCreateManagedWidget("matrixrowm", xmRowColumnWidgetClass, WEscrollwin,
				     XmNorientation, XmHORIZONTAL,
				     XmNpacking, XmPACK_COLUMN,
				     XmNnumColumns, kameradialogs.anzbilder,
				     NULL);
  // erst die alte Liste einfgen
  for (kameralistex = kameraliste, zz = 0;
       kameralistex && zz < kameradialogs.anzbilder * 3;
       kameralistex = kameralistex->next, zz += 3)
    {
      sprintf(str, "%0.2f;%0.2f;%0.2f",
       kameralistex->punkt.x, kameralistex->punkt.y, kameralistex->punkt.z);
      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNvalue, str);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNwidth, 180);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNnumColumns, 5);
      nArgs++;
      WKameraMatrix[zz] =
	XtCreateManagedWidget("matrixt", xmTextWidgetClass, WRowColM, Aargs, nArgs);

      sprintf(str, "%0.2f", kameralistex->geschw);

      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNvalue, str);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNwidth, 150);
      nArgs++;
      WKameraMatrix[zz + 1] =
	XtCreateManagedWidget("matrixt", xmTextWidgetClass, WRowColM, Aargs, nArgs);

      sprintf(str, "%0.2f;%0.2f;%0.2f",
	      kameralistex->blickrichtung.x, kameralistex->blickrichtung.y,
	      kameralistex->blickrichtung.z);
      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNvalue, str);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNwidth, 150);
      nArgs++;
      WKameraMatrix[zz + 2] =
	XtCreateManagedWidget("matrixt", xmTextWidgetClass, WRowColM, Aargs, nArgs);
    }

  // dann neue Elemente einfgen, oder nur neue Elemente einf.
  for (x = 0; zz < kameradialogs.anzbilder * 3; zz++, x++)
    {
      if (zz == 0)
	{
	  sprintf(str, "0;0;-1.0");
	}
      else
	{
	  switch (x)
	    {
	    case 0:
	      sprintf(str, "@0.05;0;0.1");
	      break;
	    case 1:
	      sprintf(str, "1");
	      break;
	    case 2:
	      sprintf(str, "0;0;0");
	      x = -1;		// da x++ dann 0 ergibt!

	      break;
	    default:
	      sprintf(str, "interner Fehler!");
	    }
	}
      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNvalue, str);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNwidth, 150);
      nArgs++;
      WKameraMatrix[zz] =
	XtCreateManagedWidget("matrixt", xmTextWidgetClass, WRowColM, Aargs, nArgs);
    }

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(WRowCol, "matrixrow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  WButtonOK = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonOK);
  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBKameraMatrixOk, NULL);

  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonPick);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);

  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonCancel);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBKameraMatrixCancel, NULL);
}

void
kameradialog(Widget W)
{
  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];

  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    frame1, frame2, WLabel, WLabelv;

  // Da dieser Dialog die Kameraliste lscht mu der Animationsdialog
  // geschlossen werden.
  if (WAnimationDialog)
    {
      XtUnmanageChild(WAnimationDialog);
      WAnimationDialog = NULL;
    }

  /* Der Dialog */
  WKameraDialog = XmCreateDialogShell(W, "kameradialog", NULL, 0);
  XtManageChild(WKameraDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 260);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 200);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WKameraDialog, "kamerarow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("kameraframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "kamerarow2", NULL, 0);
  XtManageChild(WRowCol2);

  frame2 = XtCreateManagedWidget("kameraframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(frame2, "kamerarow3", Aargs, nArgs);
  XtManageChild(WRowCol3);

  WLabel = XtCreateManagedWidget("kameramasse", xmLabelWidgetClass, WRowCol2, NULL, 0);

  if (kameradialogs.masse == 0)
    kameradialogs.masse = 1.5;

  sprintf(str, "%0.2f", kameradialogs.masse);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  WKameramasse = XtCreateManagedWidget("kameram", xmTextWidgetClass, WRowCol2,
				       Aargs, nArgs);

  WLabelv = XtCreateManagedWidget("kameraanzahl", xmLabelWidgetClass, WRowCol2, NULL, 0);

  if (kameradialogs.anzbilder == 0)
    kameradialogs.anzbilder = 12;

  sprintf(str, "%ld", kameradialogs.anzbilder);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  WAnzahl = XtCreateManagedWidget("kameraa", xmTextWidgetClass, WRowCol2,
				  Aargs, nArgs);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);
  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBKameraOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBKameraCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBKameraHelp, NULL);
}
