/*----------------------------------------------------------------*\
 | init_pb.c
 | @(#) initialisiert Push und Cascade Button Widget
\*----------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>

#include "types.h"
#include "defs.h"
#include "init_pb.h"

Widget
InitPushButton(Widget WParent, STRING szInstance,
	       STRING szName, char cMnemonic, CALLBACK CB, int *pID)

{
  Arg AArgs[MAX_ARGS];
  Widget WCreated;
  int nArgs;

  nArgs = 0;
  XtSetArg(AArgs[nArgs], XmNmnemonic, cMnemonic);
  nArgs++;
  XtSetArg(AArgs[nArgs], XmNlabelString,
	   XmStringCreate(szName, XmSTRING_DEFAULT_CHARSET));
  nArgs++;
  WCreated = XmCreatePushButton(WParent, szInstance, AArgs, nArgs);
  XtAddCallback(WCreated, XmNactivateCallback, CB, pID);
  return WCreated;
}

/*
   * initialisiert Cascade Button mit seinem Namen und seinem Mnemonic
   * ausserdem wird die Resource XmNsubMenuId gesetzt
 */
Widget
InitCascadeButton(Widget WParent, Widget WSubMenu,
		  STRING szInstance, STRING szName, char cMnemonic)
{
  Arg AArgs[MAX_ARGS];
  int nArgs;

  nArgs = 0;
  XtSetArg(AArgs[nArgs], XmNsubMenuId, WSubMenu);
  nArgs++;
  XtSetArg(AArgs[nArgs], XmNmnemonic, cMnemonic);
  nArgs++;
  XtSetArg(AArgs[nArgs], XmNlabelString,
	   XmStringCreate(szName, XmSTRING_DEFAULT_CHARSET));
  nArgs++;
  return XmCreateCascadeButton(WParent, szInstance, AArgs, nArgs);
}


