
/*
   Hilfefenster

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"
Widget WHelpDialog;


void
CBHelpOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  XtUnmanageChild(WHelpDialog);
  WHelpDialog = NULL;
}

void
helpfiledialog(Widget Parent, char *str)
{
  Arg Aargs[5];
  int nArgs;

  Widget WButtonOK, WRowCol, WRowCol2, helptext, Wframe;

  WHelpDialog = XmCreateDialogShell(Parent, "helpfiledialog", NULL, 0);
  XtManageChild(WHelpDialog);

  WRowCol = XtVaCreateManagedWidget("helpfilerow", xmRowColumnWidgetClass, WHelpDialog,
				    XmNorientation, XmVERTICAL,
				    XmNpacking, XmPACK_TIGHT,
				    XmNwidth, 600,
				    XmNheight, 390,
				    XmNnumColumns, 1,
				    NULL);


  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNshadowType, XmSHADOW_ETCHED_IN);
  nArgs++;
  Wframe = XtCreateManagedWidget("helpframe", xmFrameWidgetClass, WRowCol, Aargs, nArgs);
  WRowCol2 = XmCreateRowColumn(Wframe, "helpfilerow2", NULL, 0);
  XtManageChild(WRowCol2);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNeditMode, XmMULTI_LINE_EDIT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNeditable, false);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNrows, 15);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 40);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNwordWrap, true);
  nArgs++;
  helptext = XmCreateScrolledText(WRowCol2, "helptext", Aargs, nArgs);

  XmTextSetString(helptext, str);
  XtManageChild(helptext);

  WButtonOK = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol, NULL, 0);
  XtManageChild(WButtonOK);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBHelpOk, NULL);
}
