 /*----------------------------------------------------------------*\
 | gc.c
 | @(#) Erzeugung eines Graphics Context 
 |      (universell fuer alle Demo Programme)
\*----------------------------------------------------------------*/


#include "skelett.H"

GC CreateSimpleGC(Widget W);	/* in gc.C definiert */

/* um Global darauf zugreifen zu knnen, nur allerwichtigste!
   Dialoge und andere in skelett.h als extern */

Widget WTop;
XtAppContext context;		/* Application Context */
Display *pDisplay;

PEXExtensionInfo *pexinfo;
PEXRendererAttributes PEXattributes;

/*
   * Erzeugung eines einfachen GC fuer ein Widget
   * Der GC wird mit den Farben des Widget erzeugt, der Font "fixed" wird
   * geladen, alle anderen Werte behalten Default Wert bei
 */

GC
CreateSimpleGC(Widget W)
{
  Arg Aargs[MAX_ARGS];
  Cardinal nArgs;
  Pixel ForeGround, BackGround;
  Window WWRoot;
  XGCValues Xgc;
  unsigned long ulMask;

  /*
     * Die Farben des Widgets holen, fuer das GC erzeugt werden soll
   */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNforeground, &ForeGround);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNbackground, &BackGround);
  nArgs++;
  XtGetValues(W, Aargs, nArgs);

  /*
     * das Window, fuer das Widget muss noch nicht bestehen, also
     * Root Window des Bildschirms benutzen, weil es dieselbe Farbtiefe
     * besitzt und die Austauschbarkeit von GCs nur von der Farbtiefe
     * eines Windows bestimmt wird, i.e. alle GCs eines Bildschirms sind
     * austauschbar
   */
  WWRoot = RootWindowOfScreen(XtScreen(W));

  /*
     * Farben und Font auf sinnvollen Wert einstellen
   */
  Xgc.foreground = ForeGround;
  Xgc.background = BackGround;

  /*
     * Font muss unbedingt geladen werden, wenn mit FontLists und XmStringDraw
     * gearbeitet wird, sonst Xlib Error 56 (XChangeGC)
   */
  Xgc.font = XLoadFont(XtDisplay(W), "fixed");

  /* 
     * die Maske bestimmt, welche Werte von XGCValues sinnvoll
     * sind und deshalb gesetzt werden sollen
   */
  ulMask = GCForeground | GCBackground | GCFont;
  return XCreateGC(XtDisplay(W), WWRoot, ulMask, &Xgc);
}
