/*  
   Dialogbox fr die Dateneingabe eines Elipsoiden

   Copyright (C) 1996 Helmut Fahrion


   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

#define ELIPSOID_APPROX_ANZ 4

struct elipsoidstruktur ElipsoidDialog;
STRING helpelipsoiddialog = "Definition eines Elipsoiden.";
Widget WElipsoidDialog, ElipsoidWText1, ElipsoidWText2, ElipsoidWText3,
  ElipsoidCoverLabel;
int ElipsoidArt;
grobjekt *elipsoid_grobj;
longint elipsoid_anknr;
PEXVertexNormal elipsoid_netz[(ELIPSOID_APPROX_ANZ + 1) * (ELIPSOID_APPROX_ANZ + 1)];

void
ElipsoidDialog_init(longint Nrcover, vector M, vector R, vector W)
{
  ElipsoidDialog.m = M;
  ElipsoidDialog.r = R;
  ElipsoidDialog.w = W;
  ElipsoidDialog.nrcover = Nrcover;
}

void
ElipsoidDialog_get(longint * Nrcover, vector * M, vector * R, vector * W)
{
  *M = ElipsoidDialog.m;
  *R = ElipsoidDialog.r;
  *W = ElipsoidDialog.w;
  *Nrcover = ElipsoidDialog.nrcover;
}

// ##########  Hier die Patches berechnen  #####################
void
create_ellip_polyline(Display * D, PEXStructure poly, vector p1, vector p2, vector p3,
		      vector p4, vector pn)
{
  PEXCoord lp, coord[4];

  // Polymarker
  PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(D, poly, PEXOCStore, 3.0);
  PEXSetMarkerColor(D, poly, PEXOCStore, PEXColorTypeRGB, &echo_color);
//   SET_VECTA(p1, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p2, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p3, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p4, lp); 
  //   PEXMarkers(D, poly, PEXOCStore, 1, &lp);

  // Polyline
  SET_VECTA(p1, coord[0]);
  SET_VECTA(p2, coord[1]);
  SET_VECTA(p3, coord[2]);
  SET_VECTA(p1, coord[3]);
  PEXPolyline(D, poly, PEXOCStore, 4, coord);


//   PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCross);
  //   SET_VECTA(p4+(pn*0.1), lp); 
  //   PEXMarkers(D, poly, PEXOCStore, 1, &lp);

//   // Polyline Dreieck
  //   SET_VECTA(p4+(pn*0.1), coord[0]);
  //   SET_VECTA(p4, coord[1]);
  //   PEXPolyline(D, poly, PEXOCStore,  2, coord);
}

/*
void
ellip_listtree(Display * D, PEXStructure obj, vector m, vector n, float r)
{
  PEXCoord lp, coord[2];

  // Polymarker
  PEXSetMarkerType(D, obj, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(D, obj, PEXOCStore, 3.0);
  PEXSetMarkerColor(D, obj, PEXOCStore, PEXColorTypeRGB, &echo_color);

  SET_VECTA(m, lp);
  PEXMarkers(D, obj, PEXOCStore, 1, &lp);

  // Polyline Dreieck
  SET_VECTA(m, coord[0]);
  SET_VECTA(m + (n * r), coord[1]);
  PEXPolyline(D, obj, PEXOCStore, 2, coord);
}

// scanne rekursiv den Baum
void
listelliptree(patchtree * patr, longint a, longint * z,
	      Display * D, PEXStructure obj)
{
  patchtl *ptl;

  for (ptl = patr->o; ptl; ptl = ptl->next)
    {
      ellip_listtree(D, obj, ptl->p->m, ptl->p->n, ptl->p->r);
      *z += 1;
      a++;
    }

  // cerr << a << " Elemente im Tree!\n";

  for (char x = 0; x < 8; x++)
    if (patr->pt[x] != NULL)
      listelliptree(patr->pt[x], 0, z, D, obj);
}


void
ellip_calcpatches(vector m, vector r, vector w,
		  Display * D, PEXStructure obj)
{
  cerr << "Erzeuge Patchtree-Ellip!\n";
  patcharray pt(Patchweite, true, NULL, m, r, w);

//   patchl *pl; 
  //   for (pl = pt.pla; pl; pl = pl->next) 
  //       ellip_listtree(D, obj, pl->m, pl->n, pl->r);
  longint z = 0;

//   patch *pat = pt.pa;
  //   // teste Array
  //   for (long x=0; x<pt.anz; x++) ellip_listtree(D, obj, pat[x].m, pat[x].n, pat[x].r);

  pt.bilde_at();
  listelliptree(pt.pt, 0, &z, D, obj);

  cerr << "Ellipsoid gesamt = " << z << " Patches.\n";
}
*/
//#########################################################################################


void
create_elipsoid_netz(Display * D, PEXStructure obj)
{
  double theta, phi;
  int index, i, j, anzpoints, anznetz;
  vector w;

  // generiere ein Netz in den Koordinaten eins Elipsoiden
  theta = phi = 0.0;
  anzpoints = ELIPSOID_APPROX_ANZ;
  anznetz = anzpoints + 1;

  // in richtigen koordinaten erzeugen!
  for (i = 0; i < anznetz; i++)
    {
      for (j = 0; j < anznetz; j++)
	{
	  index = i * anznetz + j;
	  elipsoid_netz[index].point.x = sin(phi) * sin(theta) * ElipsoidDialog.r.x;
	  elipsoid_netz[index].point.y = cos(phi) * ElipsoidDialog.r.y;
	  elipsoid_netz[index].point.z = sin(phi) * cos(theta) * ElipsoidDialog.r.z;

	  // Rotation der Punkte
	  w = vector(elipsoid_netz[index].point.x, elipsoid_netz[index].point.y,
		     elipsoid_netz[index].point.z);
	  rotation(&w, vector(0.0, 0.0, 0.0), ElipsoidDialog.w);

	  // Verschieben
	  w += ElipsoidDialog.m;

	  elipsoid_netz[index].point.x = w.x;
	  elipsoid_netz[index].point.y = w.y;
	  elipsoid_netz[index].point.z = w.z;

	  // Normalvektor
	  elipsoid_netz[index].normal.x = elipsoid_netz[index].point.x;
	  elipsoid_netz[index].normal.y = elipsoid_netz[index].point.y;
	  elipsoid_netz[index].normal.z = elipsoid_netz[index].point.z;
	  normal(&elipsoid_netz[index].normal);

	  theta += (2.0 * pi) / (float) anzpoints;
	}

      phi += pi / (float) anzpoints;

      // Kreis schlieen
      index = i * anznetz + anzpoints;
      elipsoid_netz[index].point = elipsoid_netz[index - anzpoints].point;
      elipsoid_netz[index].normal = elipsoid_netz[index - anzpoints].normal;
    }

  /*
  ellip_calcpatches(ElipsoidDialog.m, ElipsoidDialog.r, ElipsoidDialog.w,
		    D, obj);
		    */
}

void
aendere_elipsoid(Display * D)
{
  int anzpoints, anznetz;

  // Elipsoidberechnung
  PEXArrayOfFacetData dummy;
  PEXArrayOfVertex elipsoid_vertex;

  PEXStructure *elipsoidp = &(elipsoid_grobj->obj_struct);

  anzpoints = ELIPSOID_APPROX_ANZ;
  anznetz = anzpoints + 1;

  /* Aendern im grobjekt */
  elipsoid_grobj->cover = ElipsoidDialog.nrcover;	// Covereintrag

  ((cadelipsoid *) (elipsoid_grobj->objp))->
    init(ElipsoidDialog.m, ElipsoidDialog.r, ElipsoidDialog.w);

  PEXSetEditingMode(pDisplay, *elipsoidp, PEXStructureReplace);
  PEXSetElementPtr(D, *elipsoidp, PEXBeginning, 0);
  PEXSetElementPtrAtLabel(D, *elipsoidp, OBJ_POLYLINE_LABEL, 1);

  create_elipsoid_netz(D, *elipsoidp);
  elipsoid_vertex.normal = elipsoid_netz;
  PEXQuadrilateralMesh(D, *elipsoidp, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANormal, PEXColorTypeRGB, dummy,
		       anznetz, anznetz, elipsoid_vertex);

  un_echo(elipsoid_grobj, elipsoid_grobj->ch == 'N');
}

void
create_elipsoid(Display * D, Widget W, grobjekt * elipsoid, longint ank_nr, longint pick_id)
{
  bool echocolor = True;
  int anzpoints, anznetz;
  PEXCoord ref_point;
  PEXName name[2];
  PEXMatrix matrix;
  PEXVector tr, scale;
  PEXStructure *elipsoid_element = NULL;
  grobjekt *ankobj = NULL;

  // Elipsoidberechnung
  PEXArrayOfFacetData dummy;
  PEXArrayOfVertex elipsoid_vertex;

  anzpoints = ELIPSOID_APPROX_ANZ;
  anznetz = anzpoints + 1;

  // suche strukturpointer zum anhngen
  if (ank_nr == 0L)
    {
      echocolor = True;
      elipsoid_element = &root_struct;
      ankobj = NULL;
    }
  else
    {
      if ((ankobj = oliste.getobjp(ank_nr)) != NULL)
	{
	  echocolor = ankobj->ch == 'N';
	  elipsoid_element = &ankobj->obj_struct;
	}
      else
	ankobj = NULL;
    }

  // Nameset und Pickid sind wichtig fr das Picken
  name[0] = (PEXName) GROBJSTR;
  name[1] = (PEXName) ELIPSOID;
  PEXAddToNameSet(D, elipsoid->obj_struct, PEXOCStore, 2, name);
  PEXSetPickID(D, elipsoid->obj_struct, PEXOCStore, pick_id);

  PEXLabel(D, elipsoid->obj_struct, PEXOCStore, COLORLABEL);
  if (elipsoid->ch == 'N')
    PEXSetSurfaceColor(D, elipsoid->obj_struct, PEXOCStore, PEXColorTypeRGB, &normal_color);
  else
    PEXSetSurfaceColor(D, elipsoid->obj_struct, PEXOCStore, PEXColorTypeRGB, &schnitt_color);

  SET_VECT(0.0, 0.0, 0.0, tr);
  SET_VECT(0.0, 0.0, 0.0, ref_point);
  SET_VECT(1.0, 1.0, 1.0, scale);
  PEXBuildTransform(&ref_point, &tr, 0.0, 0.0, 0.0, &scale, matrix);
  PEXLabel(D, elipsoid->obj_struct, PEXOCStore, TRANSFORM_LABEL);
  PEXSetLocalTransform(D, elipsoid->obj_struct, PEXOCStore, PEXReplace, matrix);
  // Hier werden die Pickelemente eingefgt 
  PEXLabel(D, elipsoid->obj_struct, PEXOCStore, OBJ_PICK_ANF_LABEL);
  PEXLabel(D, elipsoid->obj_struct, PEXOCStore, OBJ_PICK_END_LABEL);

  PEXLabel(D, elipsoid->obj_struct, PEXOCStore, OBJ_POLYLINE_LABEL);

  create_elipsoid_netz(D, elipsoid->obj_struct);
  elipsoid_vertex.normal = elipsoid_netz;
  PEXQuadrilateralMesh(D, elipsoid->obj_struct, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANormal, PEXColorTypeRGB, dummy,
		       anznetz, anznetz, elipsoid_vertex);

  // Kennung das hier die Kette beginnt
  PEXLabel(D, elipsoid->obj_struct, PEXOCStore, OBJ_KETTE_LABEL);

  /* in Root-Struktur einfgen */
  PEXSetEditingMode(D, *elipsoid_element, PEXStructureInsert);
  PEXSetElementPtr(D, *elipsoid_element, PEXEnd, 0);
  PEXLabel(D, *elipsoid_element, PEXOCStore, GROBJ_LABEL + pick_id);
  PEXExecuteStructure(D, *elipsoid_element, PEXOCStore, elipsoid->obj_struct);

  un_echo(ankobj, echocolor);
}

void
delete_cover_elipsoid_liste(void)
{
  int x, anzelem;

  for (anzelem = 0, coverx = coveranf; coverx; anzelem++, coverx = coverx->next);

  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(ElipsoidDialog.pCoverStr[x]);
}

void
CBElipsoidOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;
  grobjekt *elipsoid;
  longint pick_id;
  vector m, r, w;
  char ok;

  /* Text in Zahlen umwandeln */
  str = XmTextGetString(ElipsoidWText1);
  if (!(ok = expr_vector(&m, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor m liefert eine ungltige Zahl!");
      return;			// gehe zurck ohne Dialog zu beenden

    }
  // XmStringFree((XmString)str);
  ElipsoidDialog.m = m;

  str = XmTextGetString(ElipsoidWText2);
  if (!(ok = expr_vector(&r, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor r liefert eine ungltige Zahl!");
      return;			// gehe zurck ohne Dialog zu beenden

    }

  // XmStringFree((XmString)str);
  ElipsoidDialog.r = r;

  str = XmTextGetString(ElipsoidWText3);
  if (!(ok = expr_vector(&w, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor w liefert eine ungltige Zahl!");
      return;			// gehe zurck ohne Dialog zu beenden

    }
  // XmStringFree((XmString)str);
  ElipsoidDialog.w = w;

  /* neues Polygon anketten? */
  if (ElipsoidArt == NEU)
    {
      pick_id = ank_grobjekt(ELIPSOID, elipsoid_anknr,
	  ObjDialog.r, ObjDialog.g, ObjDialog.b, ObjDialog.e, ObjDialog.mat,
		  ObjDialog.sp, ObjDialog.du, ObjDialog.dif, ObjDialog.spec,
			     ObjDialog.high, ObjDialog.vel, ObjDialog.ch,
			     ElipsoidDialog.nrcover,
			     vector(0.0, 0.0, 0.0), vector(0.0, 0.0, 0.0));
      elipsoid =
	ank_elipsoid(ElipsoidDialog.m, ElipsoidDialog.r, ElipsoidDialog.w);

      create_elipsoid(XtDisplay(W), W, elipsoid, elipsoid_anknr, pick_id);
    }
  else
    aendere_elipsoid(XtDisplay(W));

  delete_cover_elipsoid_liste();
  /* erst hier!!! */
  WObjDialog = NULL;

  XtUnmanageChild(WElipsoidDialog);
  WElipsoidDialog = NULL;
}

void
CBElipsoidCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  delete_cover_elipsoid_liste();

  XtUnmanageChild(WElipsoidDialog);

  /*  erst hier!!! */
  WObjDialog = NULL;

  WElipsoidDialog = NULL;
}

void
CBElipsoidHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpelipsoiddialog);
  else
    infobox("helpnureinmal");
}

void
CBElipsoidCover(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  ElipsoidDialog.nrcover = (((XmListCallbackStruct *) pCallData)->item_position) - 1;
  sprintf(cpos, "%ld", ElipsoidDialog.nrcover);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(ElipsoidCoverLabel, &Aargs, 1);
  strcpy(ElipsoidDialog.coverlabel, cpos);
}

void
create_elipsoid_listen(void)
{
  char str[256];
  longint x = 0, anzelem = 0;

  /* CoverListe */
  if (coveranf)
    {
      coverx = coveranf;
      while (coverx)
	{
	  anzelem = coverx->nr;
	  coverx = coverx->next;
	}
      ElipsoidDialog.anzcover = anzelem + 1;
      ElipsoidDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      coverx = coveranf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      ElipsoidDialog.pCoverStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (coverx)
	{
	  sprintf(str, "%ld: Cover", coverx->nr);	/* C String erzeugen */
	  ElipsoidDialog.pCoverStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  coverx = coverx->next;
	  x++;
	}
    }
  else
    {
      /* nur Dummy */
      ElipsoidDialog.anzcover = 1;
      ElipsoidDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString));
      strcpy(str, "0: keine");
      ElipsoidDialog.pCoverStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }
}

void
elipsoiddialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art)
{
  Widget WButtonOK, WButtonPick, WButtonCancel, WButtonHelp, WRowCol1,
    WRowCol2, WRowCol3, WRowCol4, frame1, frame2, WLabel, WCoverList;

  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];

  ElipsoidArt = art;
  elipsoid_anknr = ank_nr;
  elipsoid_grobj = grobjp;

  if (ElipsoidArt == AENDERN)
    {
      ((cadelipsoid *) (elipsoid_grobj->objp))->
	get(&ElipsoidDialog.m, &ElipsoidDialog.r, &ElipsoidDialog.w);
      // zustzlich
      ElipsoidDialog.nrcover = elipsoid_grobj->cover;
    }
  else
    ElipsoidDialog_init(0L, vector(0.0, 0.0, 1.0), vector(0.2, 0.3, 0.4),
			vector(0.0, 0.0, 0.0));

  /* Strings fr Listen Aufbauen */
  create_elipsoid_listen();

  WElipsoidDialog = XmCreateDialogShell(W, "elipsoiddialog", NULL, 0);
  XtManageChild(WElipsoidDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 350);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 340);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WElipsoidDialog, "elipsoidrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("elipsoidframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "elipsoidrow2", NULL, 0);
  XtManageChild(WRowCol2);

  WLabel = XtCreateManagedWidget("Vektor x;y;z :", xmLabelWidgetClass, WRowCol2, NULL, 0);

  sprintf(str, "%0.2f;%0.2f;%0.2f", ElipsoidDialog.m.x, ElipsoidDialog.m.y, ElipsoidDialog.m.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  ElipsoidWText1 = XtCreateManagedWidget("elipsoidm", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f", ElipsoidDialog.r.x, ElipsoidDialog.r.y, ElipsoidDialog.r.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  ElipsoidWText2 = XtCreateManagedWidget("elipsoidr", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f", ElipsoidDialog.w.x, ElipsoidDialog.w.y, ElipsoidDialog.w.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  ElipsoidWText3 = XtCreateManagedWidget("elipsoidw", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  /* Cover Auswahl */
  frame2 = XtCreateManagedWidget("elipsoidf", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol4 = XmCreateRowColumn(frame2, "elipsoid4", NULL, 0);
  XtManageChild(WRowCol4);

  sprintf(str, "%ld", ElipsoidDialog.nrcover);
  ElipsoidCoverLabel = XtCreateManagedWidget(str, xmLabelWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, ElipsoidDialog.pCoverStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, ElipsoidDialog.anzcover);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 4);
  nArgs++;
  WCoverList = XmCreateScrolledList(WRowCol4, "elipsoidcover", Aargs, nArgs);
  XtAddCallback(WCoverList, XmNdefaultActionCallback, (XtCallbackProc) CBElipsoidCover, NULL);
  XtManageChild(WCoverList);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "elipsoidrow3", Aargs, nArgs);
  // XtManageChild(WRowCol3);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonPick);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);
  XtManageChild(WRowCol3);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBElipsoidOk, NULL);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBElipsoidCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBElipsoidHelp, NULL);
}
