/*
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
 */

#ifndef __DEFS_H
#define __DEFS_H

#define MAX_ARGS        10	/* maximale Anzahl Args Array (XtSetArg) */

#ifndef BAD			/* Codes fr exit(...) */
#define BAD             1
#endif

#ifndef GOOD
#define GOOD            0
#endif


/* Hilfstypen zum Programmieren */
#define uns     unsigned

#ifndef _G_HAVE_BOOL
#define bool    uns char
#define true    1
#define false   0
#endif 

#define NEU    1
#define AENDER 2

/* Werte zur Unterscheidung der einzelnen Menpunkte des Pulldown Mens */

/* FileMen */
#define IDM_OPEN      11
#define IDM_SAVE      12
#define IDM_SAVEAS    13
#define IDM_SAVERAY   14
#define IDM_SAVESTAR  15
#define IDM_SHOWSCENE 16
#define IDM_EXIT      17
#define MC_FILE       IDM_EXIT - IDM_OPEN + 1
/* EditMen */
#define IDM_NEU       20
#define IDM_LOESCHEN  21
#define IDM_AENDERN   22
#define IDM_TRANSFORM 23
#define IDM_ANHAENGEN 24
#define IDM_REDIT     25
#define MC_EDIT       IDM_REDIT - IDM_NEU +1
/* Objektmen */
#define IDM_SPHERE    30
#define IDM_POLYGON   31
#define IDM_BLOCK     32
#define IDM_ELIPSOID  33
#define IDM_TORUS     34
#define IDM_ZYLINDER  35
#define IDM_YBUFFER   36
//#define IDM_BEZIER   
#define IDM_NURBS     37
#define MC_OBJ        IDM_NURBS - IDM_SPHERE +1
/* Licht und Texturen */
#define IDM_LIGHTSOURCE   40
#define IDM_AMBIENT       41
#define IDM_LIGHTSTRAHLER 42
#define IDM_LIGHTPOLYGON  43
#define IDM_BACKGROUND    44
#define IDM_NEBEL         45
#define IDM_TEXTURE       46
#define IDM_TEXTURE3D     47
#define IDM_MUSTER        48
#define IDM_WAVE          49
#define IDM_COVER         50
#define MC_LICHT          IDM_COVER - IDM_LIGHTSOURCE +1
/* Optionen */
#define IDM_KAMERA      60
#define IDM_ANIMATION   61
#define IDM_FUELLEN     62
#define IDM_SCHRITT     63
#define IDM_PATCH       64
#define MC_OPTION       IDM_PATCH - IDM_KAMERA +1
/* QuickButtons */
#define QB_LOAD       70
#define QB_SAVE       71
#define QB_RAY        72
#define QB_SPHERE     73
#define QB_POLYGON    74
#define QB_BLOCK      75
#define QB_ELIPSOID   76
#define QB_TORUS      77
#define QB_ZYLINDER   78
#define QB_YBUFFER    79
//#define QB_BEZIER     
#define QB_NURBS      80
#define MC_QUICK      QB_NURBS - QB_LOAD +1

#define IDM_VERSION     90
#define IDM_VERSION_PEX 91
#define IDM_ALLGEMEIN   92
#define IDM_DOKUMENT    93
#define IDM_RAYTRACING  94
#define IDM_HTML        95
#define MC_HELP         IDM_HTML  - IDM_VERSION +1

/* Quickbuttons, verschieben, winkel, scalierung  */
#define QB_W_X          100
#define QB_W_Y          101
#define QB_W_Z          102
#define QB_W_XW         103
#define QB_W_YW         104
#define QB_W_ZW         105
#define QB_W_S          106
#define QB_W_Plus       107
#define QB_W_Minus      108
#define QB_W_Pick       109

/* Anzahl der Pulldown Mens */
#define MC_PULLDOWN     6

/*  Objecttypen  */
#define GROBJSTR        0
#define SPHERE          1
#define LAMP            3
#define TEXTURE         4
#define AMBIENT         5
#define BACKGRND        6
#define STAR            7
#define SUNLAMP         8
#define ELIPSOID        9
#define CONE            10
#define TORUS           11
#define BLOCK           12
#define COVER           14
#define WAVE            15
#define MUSTER          16
#define YBUFFER         17
#define YCOVER          18
#define POLYGON         19
#define AENDEROPTIK     20
#define STRAHLER        21
#define NURBS           22
#define NEBEL           23
#define TEXTURE3D       24
//#define BEZIER         
#define KAMERA          25
#define LICHTPOLYGON    26
#define PATCHOBJ        27

#define NONE            0
#define NEU             1
#define LOESCHEN        2
#define AENDERN         3
#define TRANSFORMIEREN  4
#define ANHAENGEN       5
#define REDIT           6

#define NORMALTXT       0
#define VECTORTXT       1
#define SPIEGTXT        2
#define BRECHTXT        3

/* Labels fr Dialog OK Abbruch Hilfe */
#define OK_BUTTON            0
#define ABBRUCH_BUTTON       1
#define HELP_BUTTON          2

/* ****** Structur Labels ******* */
#define COLORLABEL           1
#define TRANSFORM_LABEL      2

#define OBJ_POLYLINE_LABEL   8
#define OBJ_KETTE_LABEL      9
#define OBJ_LIGHT_LABEL      10
#define OBJ_MARKER_LABEL     11
#define OBJ_NURBS_LABEL      12
//#define OBJ_BEZIER_LABEL     

#define OBJ_PICK_ANF_LABEL   13
#define OBJ_PICK_END_LABEL   14

#define OBJ_STRAHLER_LABEL   15
#define OBJ_KAMERA_LABEL     16
#define OBJ_LIGHTPOLY_LABEL  17

/* Label um Grafische Objekte zu finden, grer als andere Label!!! */
#define GROBJ_LABEL          100


// Lichtquellenarten
#define AMBIENT_LIGHT        1
#define POINT_LIGHT          2

// Musterarten
#define BLANK    1
#define KAROS    2
#define LINIE    3
#define KREIS    4
#define APFEL    5
#define JULIA    6
#define WOLKE    7

// 3D-Texturen
#define KUGELM    1
#define ZYLINDERM 2


// aus ../raywin/defs.H damit nicht alle
// geladen werden muessen
// Anzahl der Zufallszahlen fr Rauschen
#define ANZ_TPTS     512


#define  NONE 0
#define  SCHN 1
#define  DIFF 2

#endif
