/*
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Programmmodul fr Dateiarbeit
   Copyright (C) 1996, 1997 Helmut Fahrion
*/

#include <stdlib.h>
#include <string.h>

#include "pextool.H"

// Scenenverschiebung wegen unterschiedlicher Projektion des CAD und des RAY
// Verflscht !
#define Ray_Z  0

void
print_cover_x(FILE * D, cadcover * objx)
{
  fprintf(D, "cover\n");
  fprintf(D, "%d %d %d %d %f %f %f %f\n",
      objx->text1, objx->text2, objx->text3, objx->text4, 
	  objx->tx1, objx->tx2, objx->ty1, objx->ty2);
  fprintf(D, "%u %u %u %u %f %f\n", objx->must1, objx->must2, objx->must3, objx->must4, 
	  objx->movx, objx->movy);
  fprintf(D, "%u %u %u %f\n", objx->turbart, objx->normalv, objx->freq, objx->scal);
  fprintf(D, "%ld\n", objx->wavenr);
  fprintf(D, "%ld\n", objx->text3dnr);
}

void
print_covernr(FILE * D, bool ray, longint nr)
{
  fprintf(D, "%ld\n", nr);
}

// luft die angeketteten Objekte durch und berechnet die Postition der Vektoren
void
get_transform(longint anknr, vector * p1,...)
{
  vector **parmv;
  grobjekt *objx;

  while (anknr)
    {
      // bei jeden Durchlauf wieder an den Anfang setzen
      parmv = &p1;

      // gehe zum Objekt, mu readobjp verwenden da ansonsten
      // Der Zeiger verrckt wurd und die aufrufende Funktion nicht
      // mehr luft
      objx = oliste.readobjp(anknr);
      if (objx && (objx->nr == anknr))
	{
	  // gehe alle Parameter durch
	  while (*parmv != NULL)
	    {
	      transform(*parmv, objx->s, objx->v, objx->w, objx->ref);
	      parmv++;
	    }
	  // anknr = objx->ank_nr;
	}
      if (objx)
	anknr = objx->ank_nr;
      else
	anknr = 0;
    }
}

// Transformiert die Punkte nochmals nach der Globalen Transformation
void
get_global_transform(vector * p1,...)
{
  vector **parmv;
  // Laufe alle Parameter durch
  for (parmv = &p1; *parmv; parmv++)
    transform(*parmv, DrawareaData.s, DrawareaData.v, DrawareaData.w,
	      vector(0.0, 0.0, 0.0));
}

// setze die alte Ankettnummern zu der neuen
void
setze_anknr(longint old_nr, longint new_nr)
{
  grobjekt *grx;
  for (grx = oliste.readfirst(); grx != NULL; grx = grx->next)
    if (grx->ank_nr == old_nr)
      grx->ank_nr = new_nr;
}

// durchsuche alle nach einer Lcke, ndere die Lcke zu der laufenden Nummer
void
sortiere(void)
{
  grobjekt *grx;
  longint a;

  for (grx = oliste.getfirst(), a = 1L; grx; grx = oliste.getnext(), a++)
    if (grx->nr != a)
      {
	// beachte die Ankettnummer
	setze_anknr(grx->nr, a);
	grx->nr = a;
      }
}

void
calc_zylinder(FILE * D, vector p1, vector p2, float r1, float r2, float w1, long cnr)
{
  float h, hg;
  vector vx1, vx2, vy1, vy2, i;

  // tauschen, da Raytracer Linkssystem ist
  vx1 = p2;
  p2 = p1;
  p1 = vx1;

  if (fabs(r1 - r2) > eps4)	// r1 != r2

    {
      // ermittle den fehlenden Abstand
      h = abs(p1 - p2);
      hg = (h * r1) / (r1 - r2);
      h = hg - h;

      // Da Punkte getauscht, andere Richtung
      i |= p1 - p2;
      vx1 = i * h;

      // schiebe p2 weiter, (p1 <-> p2)
      vy1 = vx1 + p1;
      vy2 = p2;

      // berechne neue Punkte damit es ein Kegelstumpf wird
      // ist Kegelstumpf, Kennung ist negativer Radius
      fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
	      vy1.x, vy1.y, vy1.z, vy2.x, vy2.y, vy2.z, -r1, r2, w1);
    }
  else
    // ist Zylinder
    fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
	    p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, r1, r2, w1);

  // Berechne Begrenzungsebene
  // Drehe Vektor zur Z-Achse dann ist X-Achse ein Vektor und Y-Achse der 2. Vektor der Ebene
  vx1 = vector(1.0, 0.0, 0.0);
  vy1 = vector(0.0, 1.0, 0.0);
  i |= p2 - p1;

  rotationVN(&vx1, i);
  rotationVN(&vy1, i);

  vx2 = vx1;
  vy2 = vy1;

  vx1 += p1;
  vy1 += p1;
  vx2 += p2;
  vy2 += p2;

  // Schreibe Convernummer
  fprintf(D, "%ld\n", cnr);

  // ############# Noch zu Untersuchen inwieweit fuer die Patches
  //               die Geometrie anzupassen ist ##############
  // Schreibe Begrenzungsebene 1
  fprintf(D, "polygon\n");
  fprintf(D, "1 0 0 0 1 0 0 1 1 100 1 S\n");	// zum Testen aus S -> N machen

  fprintf(D, "3\n");
  fprintf(D, "%0.4f %0.4f %0.4f\n", vx1.x, vx1.y, vx1.z);
  fprintf(D, "%0.4f %0.4f %0.4f\n", p1.x, p1.y, p1.z);
  fprintf(D, "%0.4f %0.4f %0.4f\n", vy1.x, vy1.y, vy1.z);

  // Schreibe Begrenzungsebene 2
  fprintf(D, "polygon\n");
  fprintf(D, "0 1 0 0 1 0 0 1 1 100 1 S\n");	// zum Testen aus S -> N machen

  fprintf(D, "3\n");
  fprintf(D, "%0.4f %0.4f %0.4f\n", vx2.x, vx2.y, vx2.z);
  fprintf(D, "%0.4f %0.4f %0.4f\n", vy2.x, vy2.y, vy2.z);
  fprintf(D, "%0.4f %0.4f %0.4f\n", p2.x, p2.y, p2.z);
}

void
printgrobjx(FILE * D, grobjekt * grobjektx)
{
  fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %c\n",
     grobjektx->r, grobjektx->g, grobjektx->b, grobjektx->e, grobjektx->mat,
	  grobjektx->sp, grobjektx->du, grobjektx->dif, grobjektx->spec,
	  grobjektx->high, grobjektx->vel, grobjektx->ch);
}


void
save_obj(FILE * D, bool ray, grobjekt * grobjektx)
{
  vector p1, p2, p3, p4, p5, p6, p7, p8;
  vector bpuf[4][4];

  vector ref, mov, winkel;
  float scal, r1, r2, w1, w2;
  float *py;

  int anzvect;

  longint anknr, xl, zl, a, b, pos;
  int cu, cv, ou, ov, x;
  float *i, *j;
  vect4d *y;

  switch (grobjektx->type)
    {
    case POLYGON:
      fprintf(D, "polygon\n");

      // Nummer des Objektes und Nummer an welches es angekettet ist
      if (!ray)
	{
	  fprintf(D, "%ld %ld\n", grobjektx->nr, grobjektx->ank_nr);

	  // Referenzpunkt fr Transformation
	  fprintf(D, "%f %f %f\n", grobjektx->ref.x, grobjektx->ref.y, grobjektx->ref.z);
	}

      printgrobjx(D, grobjektx);

      // Daten holen
      ((cadpolygon *) (grobjektx->objp))->get(&anzvect, &p1, &p2, &p3, &p4);

      anknr = grobjektx->ank_nr;

      fprintf(D, "%d\n", (anzvect == 0) ? 3 : 4);

      // abhaengige Trasformation erfragen
      mov = grobjektx->v;
      ref = grobjektx->ref;
      winkel = grobjektx->w;
      scal = grobjektx->s;

      transform(&p1, scal, mov, winkel, ref);
      transform(&p2, scal, mov, winkel, ref);
      transform(&p3, scal, mov, winkel, ref);

      if (anzvect)
	transform(&p4, scal, mov, winkel, ref);

      // Transformationskette durchrechnen
      get_transform(anknr, &p1, &p2, &p3, &p4, NULL);

      // Globale Transformation addieren
      get_global_transform(&p1, &p2, &p3, &p4, NULL);

      fprintf(D, "%0.4f %0.4f %0.4f\n", p1.x, p1.y, p1.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p2.x, p2.y, p2.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p3.x, p3.y, p3.z);
      if (anzvect)
	fprintf(D, "%0.4f %0.4f %0.4f\n", p4.x, p4.y, p4.z);

      // ist Cover vorhanden?
      print_covernr(D, ray, grobjektx->cover);
      break;

    case SPHERE:
      fprintf(D, "sphere\n");

      // Nummer des Objektes und Nummer an welches es angekettet ist
      if (!ray)
	{
	  fprintf(D, "%ld %ld\n", grobjektx->nr, grobjektx->ank_nr);

	  // Referenzpunkt fuer Transformation
	  fprintf(D, "%f %f %f\n", grobjektx->ref.x, grobjektx->ref.y, grobjektx->ref.z);
	}

      printgrobjx(D, grobjektx);
      // Daten holen
      ((cadsphere *) (grobjektx->objp))->get(&r1, &w1, &w2, &p1);

      anknr = grobjektx->ank_nr;

      // abhaengige Trasformation erfragen
      mov = grobjektx->v;
      ref = grobjektx->ref;
      winkel = grobjektx->w;
      scal = grobjektx->s;

      transform(&p1, scal, mov, winkel, ref);
      r1 *= scal;

      // Transformationskette durchrechnen
      get_transform(anknr, &p1, NULL);

      // Globale Transformation addieren
      get_global_transform(&p1, NULL);

      // schreibe Kugel
      fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n", p1.x, p1.y, p1.z, r1, w1, w2);

      // ist Cover vorhanden?
      print_covernr(D, ray, grobjektx->cover);
      break;			// SPHERE

    case ELIPSOID:
      fprintf(D, "elipsoid\n");

      // Nummer des Objektes und Nummer an welches es angekettet ist
      if (!ray)
	{
	  fprintf(D, "%ld %ld\n", grobjektx->nr, grobjektx->ank_nr);

	  // Referenzpunkt fr Transformation
	  fprintf(D, "%f %f %f\n", grobjektx->ref.x, grobjektx->ref.y, grobjektx->ref.z);
	}

      printgrobjx(D, grobjektx);

      // Daten holen
      ((cadelipsoid *) (grobjektx->objp))->get(&p1, &p2, &p3);

      anknr = grobjektx->ank_nr;

      // abhngige Trasformation erfragen
      mov = grobjektx->v;
      ref = grobjektx->ref;
      winkel = grobjektx->w;
      scal = grobjektx->s;

      transform(&p1, scal, mov, winkel, ref);
      p2 *= scal;

      // Transformationskette durchrechnen
      get_transform(anknr, &p1, NULL);

      // Winkel des Elipsoid mit addieren
      p3 += winkel;

      // Globale Transformation addieren
      get_global_transform(&p1, NULL);

      // schreibe Elipsoid
      fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
	      p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, p3.x, p3.y, p3.z);

      // ist Cover vorhanden?
      print_covernr(D, ray, grobjektx->cover);
      break;			// Elipsoid

    case BLOCK:
      fprintf(D, "block\n");

      // Nummer des Objektes und Nummer an welches es angekettet ist
      if (!ray)
	{
	  fprintf(D, "%ld %ld\n", grobjektx->nr, grobjektx->ank_nr);

	  // Referenzpunkt fr Transformation
	  fprintf(D, "%f %f %f\n", grobjektx->ref.x, grobjektx->ref.y, grobjektx->ref.z);
	}

      printgrobjx(D, grobjektx);
      // Daten holen
      ((cadblock *) (grobjektx->objp))->get(&p1, &p2, &p3, &p4, &p5, &p6, &p7, &p8);

      anknr = grobjektx->ank_nr;

      // abhngige Trasformation erfragen
      mov = grobjektx->v;
      ref = grobjektx->ref;
      winkel = grobjektx->w;
      scal = grobjektx->s;

      transform(&p1, scal, mov, winkel, ref);
      transform(&p2, scal, mov, winkel, ref);
      transform(&p3, scal, mov, winkel, ref);
      transform(&p4, scal, mov, winkel, ref);
      transform(&p5, scal, mov, winkel, ref);
      transform(&p6, scal, mov, winkel, ref);
      transform(&p7, scal, mov, winkel, ref);
      transform(&p8, scal, mov, winkel, ref);

      // Transformationskette durchrechnen
      get_transform(anknr, &p1, &p2, &p3, &p4, &p5, &p6, &p7, &p8, NULL);

      // Globale Transformation addieren
      get_global_transform(&p1, &p2, &p3, &p4, &p5, &p6, &p7, &p8, NULL);

      fprintf(D, "%0.4f %0.4f %0.4f\n", p1.x, p1.y, p1.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p2.x, p2.y, p2.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p3.x, p3.y, p3.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p4.x, p4.y, p4.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p5.x, p5.y, p5.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p6.x, p6.y, p6.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p7.x, p7.y, p7.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p8.x, p8.y, p8.z);

      // ist Cover vorhanden?
      print_covernr(D, ray, grobjektx->cover);
      break;			// Block

    case TORUS:
      fprintf(D, "torus\n");

      // Nummer des Objektes und Nummer an welches es angekettet ist
      if (!ray)
	{
	  fprintf(D, "%ld %ld\n", grobjektx->nr, grobjektx->ank_nr);

	  // Referenzpunkt fr Transformation
	  fprintf(D, "%f %f %f\n", grobjektx->ref.x, grobjektx->ref.y, grobjektx->ref.z);
	}

      printgrobjx(D, grobjektx);

      // Daten holen
      ((cadtorus *) (grobjektx->objp))->get(&p1, &w1, &w2, &p2);

      anknr = grobjektx->ank_nr;

      // abhngige Trasformation erfragen
      mov = grobjektx->v;
      ref = grobjektx->ref;
      winkel = grobjektx->w;
      scal = grobjektx->s;

      transform(&p1, scal, mov, winkel, ref);
      w1 *= scal;
      w2 *= scal;

      // Transformationskette durchrechnen
      get_transform(anknr, &p1, NULL);

      // Winkel mit sichern!
      p2 += winkel;

      // Globale Transformation addieren
      get_global_transform(&p1, NULL);

      // schreibe Torus
      fprintf(D, "%.4f %.4f %.4f %.4f %.4f %.4f %.4f %.4f\n",
	      p1.x, p1.y, p1.z, w1, w2, p2.x, p2.y, p2.z);

      // ist Cover vorhanden?
      print_covernr(D, ray, grobjektx->cover);
      break;			// Torus

    case CONE:
      fprintf(D, "cone\n");

      // Nummer des Objektes und Nummer an welches es angekettet ist
      if (!ray)
	{
	  fprintf(D, "%ld %ld\n", grobjektx->nr, grobjektx->ank_nr);

	  // Referenzpunkt fr Transformation
	  fprintf(D, "%f %f %f\n", grobjektx->ref.x, grobjektx->ref.y, grobjektx->ref.z);
	}

      printgrobjx(D, grobjektx);

      // Daten holen
      ((cadzylinder *) (grobjektx->objp))->get(&p1, &p2, &r1, &r2, &w1);

      anknr = grobjektx->ank_nr;

      // abhngige Trasformation erfragen
      mov = grobjektx->v;
      ref = grobjektx->ref;
      winkel = grobjektx->w;
      scal = grobjektx->s;

      transform(&p1, scal, mov, winkel, ref);
      transform(&p2, scal, mov, winkel, ref);
      r1 *= scal;
      r2 *= scal;

      // Transformationskette durchrechnen
      get_transform(anknr, &p1, &p2, NULL);

      // Globale Transformation addieren
      get_global_transform(&p1, &p2, NULL);

      // schreibe Zylinder
      if (!ray)
	{
	fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
		p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, r1, r2, w1);
	print_covernr(D, ray, grobjektx->cover);
	}
      else
	// fr Raytracer werden Begrenzungsplatten bentigt
	calc_zylinder(D, p1, p2, r1, r2, w1, grobjektx->cover);

      // ist Cover vorhanden?
      // print_covernr(D, ray, grobjektx->cover);
      break;			// ZYLINDER

    case YBUFFER:
      // Hier mal zuerst das YCover
      // ist Cover vorhanden?
      // if (ray) print_y_covernr(D, ray, grobjektx->cover);
      fprintf(D, "ybuffer\n");

      // Nummer des Objektes und Nummer an welches es angekettet ist
      if (!ray)
	{
	  fprintf(D, "%ld %ld\n", grobjektx->nr, grobjektx->ank_nr);

	  // Referenzpunkt fr Transformation
	  fprintf(D, "%f %f %f\n", grobjektx->ref.x, grobjektx->ref.y, grobjektx->ref.z);
	}

      printgrobjx(D, grobjektx);

      // Daten holen
      ((cadybuffer *) (grobjektx->objp))->get(&p1, &p2, &p3, &p4, &xl, &zl, &py);

      anknr = grobjektx->ank_nr;

      // abhngige Trasformation erfragen
      mov = grobjektx->v;
      ref = grobjektx->ref;
      winkel = grobjektx->w;
      scal = grobjektx->s;

      transform(&p1, scal, mov, winkel, ref);
      transform(&p2, scal, mov, winkel, ref);
      transform(&p3, scal, mov, winkel, ref);
      transform(&p4, scal, mov, winkel, ref);

      // Transformationskette durchrechnen
      get_transform(anknr, &p1, &p2, &p3, &p4, NULL);

      // Globale Transformation addieren
      get_global_transform(&p1, &p2, &p3, &p4, NULL);

      // schreibe YBUFFER
      fprintf(D, "%f %f %f\n", p1.x, p1.y, p1.z);
      fprintf(D, "%f %f %f\n", p2.x, p2.y, p2.z);
      fprintf(D, "%f %f %f\n", p3.x, p3.y, p3.z);
      fprintf(D, "%f %f %f\n", p4.x, p4.y, p4.z);

      fprintf(D, "%ld %ld\n", xl, zl);

      // schreibe YBuffer
      for (a = 0; a < zl; a++)
	{
	  for (b = 0; b < xl; b++)
	    fprintf(D, "%0.4f ", py[a * xl + b]);
	  fprintf(D, "\n");
	}
      print_covernr(D, ray, grobjektx->cover);
      break;			// ybuffer

    case NURBS:
      fprintf(D, "nurbs\n");

      // Nummer des Objektes und Nummer an welches es angekettet ist
      if (!ray)
	{
	  fprintf(D, "%ld %ld\n", grobjektx->nr, grobjektx->ank_nr);

	  // Referenzpunkt fr Transformation
	  fprintf(D, "%f %f %f\n", grobjektx->ref.x, grobjektx->ref.y, grobjektx->ref.z);
	}

      printgrobjx(D, grobjektx);

      // Daten holen
      ((nurbs *) (grobjektx->objp))->get(&a, &b, &cu, &cv, &ou, &ov, &y, &i, &j);

      anknr = grobjektx->ank_nr;

      // abhngige Trasformation erfragen
      mov = grobjektx->v;
      ref = grobjektx->ref;
      winkel = grobjektx->w;
      scal = grobjektx->s;

      fprintf(D, "%ld %ld %d %d %d %d\n", a, b, cu, cv, ou, ov);
      // xanz, zanz, anz approx, order

      // u Knoten + Anzahl
      for (x = 0; x <= i[0]; x++)
	fprintf(D, "%1.1f ", i[x]);
      fprintf(D, "\n");

      // v Knoten + Anzahl
      for (x = 0; x <= j[0]; x++)
	fprintf(D, "%1.1f ", j[x]);
      fprintf(D, "\n");

      // schreibe Knoten
      for (zl = 0; zl < b; zl++)
	{
	  for (xl = 0; xl < a; xl++)
	    {
	      pos = zl * a + xl;
	      p1 = vector(y[pos].x, y[pos].y, y[pos].z);
	      transform(&p1, scal, mov, winkel, ref);
	      // Transformationskette durchrechnen
	      get_transform(anknr, &p1, NULL);
	      // Globale Transformation addieren
	      get_global_transform(&p1, NULL);

	      fprintf(D, "%0.4f %0.4f %0.4f %0.4f ", p1.x, p1.y, p1.z, y[pos].g);
	    }
	  fprintf(D, "\n");
	}

      print_covernr(D, ray, grobjektx->cover);
      break;			// nurbs
      /*
    case BEZIER:
      fprintf(D, "bezier\n");

      // Nummer des Objektes und Nummer an welches es angekettet ist
      if (!ray)
	{
	  fprintf(D, "%ld %ld\n", grobjektx->nr, grobjektx->ank_nr);

	  // Referenzpunkt fr Transformation
	  fprintf(D, "%f %f %f\n", grobjektx->ref.x, grobjektx->ref.y, grobjektx->ref.z);
	}

      printgrobjx(D, grobjektx);

      // Daten holen
      ((cadbezier *) (grobjektx->objp))->get(&a, &b, &bpuf);

      anknr = grobjektx->ank_nr;

      // abhngige Trasformation erfragen
      mov = grobjektx->v;
      ref = grobjektx->ref;
      winkel = grobjektx->w;
      scal = grobjektx->s;

      fprintf(D, "%ld %ld\n", a, b);
      // xanz, zanz, anz approx, order

      // schreibe Knotenpunkte
      for (zl = 0; zl < 4; zl++)
	{
	  for (xl = 0; xl < 4; xl++)
	    {
	      p1 = bpuf[xl][zl];
	      transform(&p1, scal, mov, winkel, ref);
	      // Transformationskette durchrechnen
	      get_transform(anknr, &p1, NULL);
	      // Globale Transformation addieren
	      get_global_transform(&p1, NULL);

	      fprintf(D, "%0.4f %0.4f %0.4f ", p1.x, p1.y, p1.z);
	    }
	  fprintf(D, "\n");
	}

      print_covernr(D, ray, grobjektx->cover);
      break;			// bezier
      */
    }
}

void
save_schnitt(FILE * D, bool ray, longint nr)
{
  grobjekt *grobjx;

  // grafische Objekte, die Schnittkrper sind
  // Listenpointer nicht ndern!
  for (grobjx = oliste.readfirst(); grobjx; grobjx = grobjx->next)
    if (grobjx->ank_nr == nr)
      {
	save_obj(D, ray, grobjx);

	// wurde an Ankettobj ein anderes angekettet?
	save_schnitt(D, true, grobjx->nr);
      }
}

bool
save_data(char *dateiname, bool ray, bool star)
{
  longint x;
  float m;
  kameral *kx, *kl;

  int himmel, boden;
  vector p1, p2, p3, p4;
  grobjekt *grobjp;

  FILE *D, *D_ray;

  // gib allen Objekten neue Nummern, da diese durch das Lschen lckenhaft
  // sein knnen, dadurch stimmen dann die Ankettnummern nicht mehr!
  sortiere();

  // Datei ffnen
  if ((D = fopen(dateiname, "w+")) == NULL)
    return false;

  // in Koordinaten des Raytracers umrechnen !!!!!!!
  if (ray)
    DrawareaData.v.z += Ray_Z;

  // Umgebungs - Licht, immer vorhanden
  fprintf(D, "ambient\n");
  fprintf(D, "%0.4f %0.4f %0.4f\n", AmbDialog.r, AmbDialog.g, AmbDialog.b);

  // Nebel speichern
  if (DrawareaData.nebel > 0.0)
    {
      fprintf(D, "nebel\n");
      fprintf(D, "%0.4f\n", DrawareaData.nebel);
    }

  // Texturen 2D
  for (textx = textanf; textx != NULL; textx = textx->next)
    {
      fprintf(D, "textur\n");
      if (!ray)
	fprintf(D, "%s\n", textx->name);
      fprintf(D, "%ld %0.4f %s\n", textx->nr, textx->prozent, textx->dname);
    }

  // Texturen 3D
  for (text3dx = text3danf; text3dx != NULL; text3dx = text3dx->next)
    {
      fprintf(D, "textur3d\n");
      if (!ray)
	fprintf(D, "%s\n", text3dx->name);
      fprintf(D, "%ld %d %d %d %0.4f %0.4f\n",
	      text3dx->nr, text3dx->art, text3dx->anz, text3dx->fehler,
	      text3dx->mix, text3dx->abs);
      fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
	      text3dx->d.x, text3dx->d.y, text3dx->d.z, text3dx->r.x, text3dx->r.y, text3dx->r.z);
      fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
	      text3dx->r1, text3dx->g1, text3dx->b1, text3dx->r2, text3dx->g2, text3dx->b2);
    }

  // Muster
  for (mustx = mustanf; mustx != NULL; mustx = mustx->next)
    {
      fprintf(D, "muster\n");
      if (!ray)
	fprintf(D, "%s\n", mustx->name);
      fprintf(D, "%lu %u %u %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
       mustx->nr, mustx->art, mustx->fehler, mustx->mix, mustx->x, mustx->y,
	  mustx->r1, mustx->g1, mustx->b1, mustx->r2, mustx->g2, mustx->b2);
    }

  // Hintergrund
  fprintf(D, "backgrnd\n");
  fprintf(D, "%0.4f %0.4f %0.4f\n", BackgDialog.rh, BackgDialog.gh, BackgDialog.bh);
  fprintf(D, "%0.4f %0.4f %0.4f\n", BackgDialog.rb, BackgDialog.gb, BackgDialog.bb);
  fprintf(D, "%0.4f %d\n", BackgDialog.entfernung, BackgDialog.zufall);
  fprintf(D, "%d %d %0.4f %0.4f %d %d %d %0.4f\n",
	  BackgDialog.textnrh, BackgDialog.mustnrh,
	  BackgDialog.verschxh, BackgDialog.verschyh,
	  BackgDialog.turbarth, BackgDialog.rauschh, BackgDialog.freqh, BackgDialog.scalh);
  fprintf(D, "%d %d %0.4f %0.4f %d %d %d %0.4f\n",
	  BackgDialog.textnrb, BackgDialog.mustnrb,
	  BackgDialog.verschxb, BackgDialog.verschyb,
	  BackgDialog.turbartb, BackgDialog.rauschb, BackgDialog.freqb, BackgDialog.scalb);

  // Kamerafhrung
  if (kameraliste && !ray)
    {
      fprintf(D, "kamera\n");
      Kamera_get(&m, &x, &kl);
      fprintf(D, "%f %ld\n", m, x);	// Schreibe Masse, Anzahl der Punkte
      // Zhle Anzahl der Elemente

      for (x = 0, kx = kl; kx; kx = kx->next, x++);
      fprintf(D, "%ld\n", x);	// Schreibe Anzahl der Elemente
      // schreibe Daten

      for (kx = kl; kx; kx = kx->next)
	{
	  fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
		  kx->punkt.x, kx->punkt.y, kx->punkt.z,
	      kx->blickrichtung.x, kx->blickrichtung.y, kx->blickrichtung.z,
		  kx->geschw);
	}
    }
  else if (kameraliste && ray)
    {
      // Datei ffnen
      if ((D_ray = fopen("scene_kameras", "w+")) == NULL)
	{
	  fclose(D);
	  return false;
	}

      // fprintf(D_ray, "kamera\n");
      Kamera_get(&m, &x, &kl);
      // fprintf(D_ray, "%f %ld\n", m, x); // Schreibe Masse, Anzahl der Punkte
      // Zhle Anzahl der Elemente
      for (x = 0, kx = kl; kx; kx = kx->next, x++);
      fprintf(D_ray, "%ld\n", x);	// Schreibe Anzahl der Elemente
      // schreibe Daten

      for (kx = kl; kx; kx = kx->next)
	{
	  p1 = kx->blickrichtung;
	  p2 = kx->punkt;
	  p1 |= p1 - p2;
	  fprintf(D_ray, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
		  p2.x, p2.y, p2.z, p1.x, p1.y, p1.z);
	}
      fclose(D_ray);
    }
  else if (!kameraliste && ray)
    {
      // Falls keine Kameraliste existiert mu die alte Liste
      // gelscht werden!
      if ((D_ray = fopen("scene_kameras", "w+")) == NULL)
	{
	  fclose(D);
	  return false;
	}
      fprintf(D_ray, "1\n");	// Schreibe Anzahl der Elemente

      fprintf(D_ray, "0.0 0.0 -1.0 0.0 0.0 1.0\n");
      fclose(D_ray);
    }

  if (ray)
    {
      // schreiben ob Himmel oder Boden als Erdhalbkugel dargestellt wird
      if (BackgDialog.textnrh || BackgDialog.mustnrh)
	himmel = 1;
      else
	himmel = 0;
      if (himmel || BackgDialog.textnrb || BackgDialog.mustnrb)
	boden = 1;
      else
	boden = 0;
      fprintf(D, "%d %d\n", himmel, boden);
    }

  // Lichtquellen
  for (lichtx = lichtanf; lichtx != NULL; lichtx = lichtx->next)
    {
      p1 = vector(lichtx->x, lichtx->y, lichtx->z);
      // Globale Transformation addieren
      get_global_transform(&p1, NULL);

      fprintf(D, "lampe\n");
      fprintf(D, "%0.4f %0.4f %0.4f\n", p1.x, p1.y, p1.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", lichtx->r, lichtx->g, lichtx->b);
      fprintf(D, "%0.4f\n", lichtx->s);
    }

  // Strahler
  for (strahlerx = strahleranf; strahlerx != NULL; strahlerx = strahlerx->next)
    {
      p1 = strahlerx->pos;
      p2 = strahlerx->richtung;

      // Globale Transformation addieren
      get_global_transform(&p1, NULL);

      // Richtungsvektor nur drehen!
      rotation(&p2, vector(0.0, 0.0, 0.0), DrawareaData.w);

      fprintf(D, "spotlight\n");
      fprintf(D, "%0.4f %0.4f %0.4f\n", p1.x, p1.y, p1.z);	// Punkt

      fprintf(D, "%0.4f %0.4f %0.4f\n", p2.x, p2.y, p2.z);	// Richtung

      fprintf(D, "%0.4f %0.4f %0.4f\n", strahlerx->r, strahlerx->g, strahlerx->b);	// Farbe

      fprintf(D, "%0.4f %0.4f\n", strahlerx->s, strahlerx->winkel);	// Strke, Winkel

    }

  // Licht-Polygon
  for (lichtpolyx = lichtpolyanf; lichtpolyx; lichtpolyx = lichtpolyx->next)
    {
      p1 = lichtpolyx->p1;
      p2 = lichtpolyx->p2;
      p3 = lichtpolyx->p3;
      p4 = lichtpolyx->p4;

      // Globale Transformation addieren
      get_global_transform(&p1, &p2, &p3, &p4, NULL);

      fprintf(D, "lightpoly\n");
      fprintf(D, "%0.4f %0.4f %0.4f\n", p1.x, p1.y, p1.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p2.x, p2.y, p2.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p3.x, p3.y, p3.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", p4.x, p4.y, p4.z);
      fprintf(D, "%0.4f %0.4f %0.4f\n", lichtpolyx->r, lichtpolyx->g, lichtpolyx->b);
      fprintf(D, "%0.4f %d %d %0.2f\n", lichtpolyx->i, lichtpolyx->xanz,
	      lichtpolyx->yanz, lichtpolyx->w);
    }

  // Wellen
  for (wavex = waveanf; wavex != NULL; wavex = wavex->next)
    {
      fprintf(D, "wave\n");
      fprintf(D, "%ld 3\n", wavex->nr);
      if (!ray)
	fprintf(D, "%s\n", wavex->name);

      // Globale Transformation addieren
      p1 = vector(wavex->x1, wavex->y1, wavex->z1);
      get_global_transform(&p1, NULL);
      fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
      p1.x, p1.y, p1.z, wavex->freq1, wavex->amp1, wavex->damp1, wavex->d1);

      // Globale Transformation addieren
      p1 = vector(wavex->x2, wavex->y2, wavex->z2);
      get_global_transform(&p1, NULL);
      fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
      p1.x, p1.y, p1.z, wavex->freq2, wavex->amp2, wavex->damp2, wavex->d2);

      // Globale Transformation addieren
      p1 = vector(wavex->x3, wavex->y3, wavex->z3);
      get_global_transform(&p1, NULL);
      fprintf(D, "%0.4f %0.4f %0.4f %0.4f %0.4f %0.4f %0.4f\n",
      p1.x, p1.y, p1.z, wavex->freq3, wavex->amp3, wavex->damp3, wavex->d3);
    }

  // Covers speichern
  for (coverx = coveranf; coverx; coverx = coverx->next)
    print_cover_x(D, coverx);

  // Sterne fr Simulation
  if (star)
    {
      fprintf(D, "star\n1.0000 1.0000 1.0000 0.0000 1.0000 0.0000 0.0000 1.0000 1.0000 100.0000 1.0000 N\n1 10.0 0.2 0.0\n0\nstar\n1.0000 1.0000 1.0000 0.0000 1.0000 0.0000 0.0000 1.0000 1.0000 100.0000 1.0000 N\n2 10.0 0.2 0.0\n0\nstar\n1.0000 1.0000 1.0000 0.0000 1.0000 0.0000 0.0000 1.0000 1.0000 100.0000 1.0000 N\n3 10.0 0.2 0.0\n0\nstar\n1.0000 1.0000 1.0000 0.0000 1.0000 0.0000 0.0000 1.0000 1.0000 100.0000 1.0000 N\n4 10.0 0.2 0.0\n0\nstar\n1.0000 1.0000 1.0000 0.0000 1.0000 0.0000 0.0000 1.0000 1.0000 100.0000 1.0000 N\n5 10.0 0.2 0.0\n0\nstar\n1.0000 1.0000 1.0000 0.0000 1.0000 0.0000 0.0000 1.0000 1.0000 100.0000 1.0000 N\n6 10.0 0.1 0.0\n\nstar\n1.0000 1.0000 1.0000 0.0000 1.0000 0.0000 0.0000 1.0000 1.0000 100.0000 1.0000 N\n7 10.0 0.1 0.0\n0\nstar\n.0000 1.0000 1.0000 0.0000 1.0000 0.0000 0.0000 1.0000 1.0000 100.0000 1.0000 N\n8 10.0 0.1 0.0\n0\nstar\n1.0000 1.0000 1.0000 0.0000 1.0000 0.0000 0.0000 1.0000 1.0000 100.0000 1.0000 N\n9 10.0 0.1 0.0\n0\nstar\n1.0000 1.0000 1.0000 0.0000 1.0000 0.0000 0.0000 1.0000 1.0000 100.0000 1.0000 N\n0 10.0 0.4 0.0\n1\nstar\n1.0000 1.0000 .8000 0.0000 1.0000 0.0000 0.0000 1.0000 1.0000 100.0000 1.0000 N\n11 10.0 0.6 1.0\n0\n");
    }

  // grafische Objekte,  mit Cover fuer RAY
  for (grobjp = oliste.getfirst(); grobjp; grobjp = oliste.getnext())
    {
      if (ray)
	{
	  // damit fuer den Raytracer die richtige Reihenfolge eingehalten wird
	  // ist kein Schnittkoerper -> speichern und zugehoerige Schnittkoerper suchen
	  //   ansonsten weiter
	  if (grobjp->ch == 'N')
	    {
	      save_obj(D, ray, grobjp);
	      save_schnitt(D, ray, grobjp->nr);
	    }
	}
      else
	save_obj(D, ray, grobjp);
    }
  fclose(D);

  // in Koordinaten des Raytracers ruecksetzen
  if (ray)
    DrawareaData.v.z -= Ray_Z;

  return true;
}

bool
open_data(char *dateiname)
{
  FILE *D;
  longint satz = 0L, pick_id, anknr, nr, x, z, a, b, acover, pos;
  char str[256], error[80], objecttyp = 0xFF, c;
  float f[31], k, k1;
  int anzvect, ou, ov, cu, cv, zz;
  grobjekt *poly, *sphere, *block, *elipsoid, *torus, *zylinder, *pybuffer,
    *pnurbs; //, *pbezier;

  // test ob Daten eingegeben wurden
  if (lichtanf || lichtpolyanf || textanf || mustanf
      || waveanf || coveranf || oliste.getfirst())
    {
      // einfach alle Loeschen und neu aufbauen
      PEXDeleteElements(pDisplay, root_struct, PEXBeginning, 0, PEXEnd, 0);

      delete lichtanf;
      delete strahleranf;
      delete lichtpolyanf;
      delete textanf;
      delete text3danf;
      delete mustanf;
      delete waveanf;
      delete coveranf;
      delete kameraliste;
      oliste.destroy();

      // neu erzeugen
      create_structure();

      init_listpointers();

      // Globale Transformation loeschen
      Transformstruct_init(1.0, vector(0.0, 0.0, 0.0), vector(0.0, 0.0, 0.0),
			   vector(0.0, 0.0, 0.0));
      // Globale Daten fuer Transformation loeschen, dabei Einstellungen belassen
      DrawareaData_init(1.0, vector(0.0, 0.0, 0.0), vector(0.0, 0.0, 0.0),
	vector(0.0, 0.0, 0.0), DrawareaData.schalter, DrawareaData.schrittw,
			DrawareaData.nebel);

      redraw(true);
    }

  // Datei ffnen
  if ((D = fopen(dateiname, "r+")) == NULL)
    return false;

  while (!feof(D))
    {
      fscanf(D, "%s\n", str);
      satz++;

      if (!strcmp(str, "ambient"))
	objecttyp = AMBIENT;
      else if (!strcmp(str, "backgrnd"))
	objecttyp = BACKGRND;
      else if (!strcmp(str, "nebel"))
	objecttyp = NEBEL;
      else if (!strcmp(str, "lampe"))
	objecttyp = LAMP;
      else if (!strcmp(str, "spotlight"))
	objecttyp = STRAHLER;
      else if (!strcmp(str, "muster"))
	objecttyp = MUSTER;
      else if (!strcmp(str, "textur"))
	objecttyp = TEXTURE;
      else if (!strcmp(str, "textur3d"))
	objecttyp = TEXTURE3D;
      else if (!strcmp(str, "wave"))
	objecttyp = WAVE;
      else if (!strcmp(str, "cover"))
	objecttyp = COVER;
      else if (!strcmp(str, "polygon"))
	objecttyp = POLYGON;
      else if (!strcmp(str, "sphere"))
	objecttyp = SPHERE;
      else if (!strcmp(str, "block"))
	objecttyp = BLOCK;
      else if (!strcmp(str, "elipsoid"))
	objecttyp = ELIPSOID;
      else if (!strcmp(str, "torus"))
	objecttyp = TORUS;
      else if (!strcmp(str, "cone"))
	objecttyp = CONE;
      else if (!strcmp(str, "ybuffer"))
	objecttyp = YBUFFER;
      else if (!strcmp(str, "nurbs"))
	objecttyp = NURBS;
//       else if (!strcmp(str, "bezier"))
// 	objecttyp = BEZIER;
      else if (!strcmp(str, "kamera"))
	objecttyp = KAMERA;
      else if (!strcmp(str, "lightpoly"))
	objecttyp = LICHTPOLYGON;

      // Auswahl der Objekte
      switch (objecttyp)
	{
	case AMBIENT:
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;
	  AmbDialog.r = f[0];
	  AmbDialog.g = f[1];
	  AmbDialog.b = f[2];
	  break;		// AMBIENT

	case NEBEL:
	  fscanf(D, "%f\n", &f[0]);
	  satz++;
	  DrawareaData.nebel = f[0];
	  break;		// NEBEL

	case BACKGRND:
	  // Hintergrund
	  fscanf(D, "%f %f %f\n", &BackgDialog.rh, &BackgDialog.gh, &BackgDialog.bh);
	  fscanf(D, "%f %f %f\n", &BackgDialog.rb, &BackgDialog.gb, &BackgDialog.bb);
	  fscanf(D, "%f %d\n", &BackgDialog.entfernung, &BackgDialog.zufall);
	  satz++;
	  fscanf(D, "%d %d %f %f %d %d %d %f\n",
		 &BackgDialog.textnrh, &BackgDialog.mustnrh,
		 &BackgDialog.verschxh, &BackgDialog.verschyh,
		 &BackgDialog.turbarth, &BackgDialog.rauschh,
		 &BackgDialog.freqh, &BackgDialog.scalh);
	  satz++;
	  fscanf(D, "%d %d %f %f %d %d %d %f\n",
		 &BackgDialog.textnrb, &BackgDialog.mustnrb,
		 &BackgDialog.verschxb, &BackgDialog.verschyb,
		 &BackgDialog.turbartb, &BackgDialog.rauschb,
		 &BackgDialog.freqb, &BackgDialog.scalb);
	  satz++;
	  break;		// BACKGRND

	case LAMP:
	  fscanf(D, "%f %f %f\n", &LichtDialog.x, &LichtDialog.y, &LichtDialog.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &LichtDialog.r, &LichtDialog.g, &LichtDialog.b);
	  satz++;
	  fscanf(D, "%f\n", &LichtDialog.intens);
	  satz++;
	  nr = ank_lichtquelle(LichtDialog.r, LichtDialog.g, LichtDialog.b, LichtDialog.intens,
			       LichtDialog.x, LichtDialog.y, LichtDialog.z);
	  erz_lichtquelle(vector(LichtDialog.x, LichtDialog.y, LichtDialog.z), nr);
	  break;

	case STRAHLER:
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;		// Punkt

	  fscanf(D, "%f %f %f\n", &f[3], &f[4], &f[5]);
	  satz++;		// Richtung

	  fscanf(D, "%f %f %f\n",
		 &StrahlerDialog.r, &StrahlerDialog.g, &StrahlerDialog.b);
	  satz++;		// Farbe

	  fscanf(D, "%f %f\n", &StrahlerDialog.intens,
		 &StrahlerDialog.winkel);
	  satz++;		// Strke, Winkel

	  StrahlerDialog.pos = vector(f[0], f[1], f[2]);
	  StrahlerDialog.richtung = vector(f[3], f[4], f[5]);
	  nr = ank_strahler(StrahlerDialog.r, StrahlerDialog.g, StrahlerDialog.b,
			    StrahlerDialog.intens,
			    StrahlerDialog.pos, StrahlerDialog.richtung, StrahlerDialog.winkel);
	  erz_strahler(StrahlerDialog.pos, StrahlerDialog.richtung, nr);
	  break;

	case LICHTPOLYGON:
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;		// Punkt

	  fscanf(D, "%f %f %f\n", &f[3], &f[4], &f[5]);
	  satz++;		// Punkt

	  fscanf(D, "%f %f %f\n", &f[6], &f[7], &f[8]);
	  satz++;		// Punkt

	  fscanf(D, "%f %f %f\n", &f[9], &f[10], &f[11]);
	  satz++;		// Punkt

	  fscanf(D, "%f %f %f\n", &LichtPolygonDialog.r, &LichtPolygonDialog.g,
		 &LichtPolygonDialog.b);
	  satz++;		// Punkt

	  fscanf(D, "%f %d %d %f\n",
		 &LichtPolygonDialog.i, &LichtPolygonDialog.xanz,
		 &LichtPolygonDialog.yanz, &LichtPolygonDialog.w);
	  satz++;		// Farbe

	  LichtPolygonDialog.p1 = vector(f[0], f[1], f[2]);
	  LichtPolygonDialog.p2 = vector(f[3], f[4], f[5]);
	  LichtPolygonDialog.p3 = vector(f[6], f[7], f[8]);
	  LichtPolygonDialog.p4 = vector(f[9], f[10], f[11]);

	  nr = ank_lichtpoly(LichtPolygonDialog.r, LichtPolygonDialog.g, LichtPolygonDialog.b,
			     LichtPolygonDialog.i, LichtPolygonDialog.xanz,
			     LichtPolygonDialog.yanz, LichtPolygonDialog.w,
			     LichtPolygonDialog.p1, LichtPolygonDialog.p2,
			     LichtPolygonDialog.p3, LichtPolygonDialog.p4);
	  erz_lichtpolygon(LichtPolygonDialog.p1, LichtPolygonDialog.p2,
			   LichtPolygonDialog.p3, LichtPolygonDialog.p4,
			   LichtPolygonDialog.xanz, LichtPolygonDialog.yanz,
			   nr);
	  break;		// Lichtpolygon

	case MUSTER:
	  fscanf(D, "%s\n", MusterDialog.name);
	  satz++;
	  fscanf(D, "%lu %u %u %f %f %f %f %f %f %f %f %f\n",
		 &nr, &MusterDialog.art, &MusterDialog.fehler,
		 &MusterDialog.mix, &MusterDialog.x, &MusterDialog.y,
		 &MusterDialog.r1, &MusterDialog.g1, &MusterDialog.b1, &MusterDialog.r2,
		 &MusterDialog.g2, &MusterDialog.b2);
	  satz++;
	  ank_muster(MusterDialog.name, MusterDialog.r1, MusterDialog.b1, MusterDialog.g1,
		     MusterDialog.r2, MusterDialog.b2, MusterDialog.g2,
		     MusterDialog.mix, MusterDialog.art, MusterDialog.fehler,
		     MusterDialog.x, MusterDialog.y);
	  break;

	case TEXTURE:
	  fscanf(D, "%s\n", TextDialog.name);
	  satz++;
	  fscanf(D, "%lu %f %s\n", &nr, &TextDialog.prozent, (char *) &TextDialog.dateiname);
	  satz++;
	  ank_texturen(TextDialog.prozent, TextDialog.dateiname, TextDialog.name);
	  break;

	case TEXTURE3D:
	  fscanf(D, "%s\n", Text3dDialog.name);
	  satz++;
	  fscanf(D, "%ld %d %d %d %f %f\n",
	    &nr, &Text3dDialog.art, &Text3dDialog.anz, &Text3dDialog.fehler,
		 &Text3dDialog.mix, &Text3dDialog.abs);
	  satz++;
	  fscanf(D, "%f %f %f %f %f %f\n",
		 &Text3dDialog.d.x, &Text3dDialog.d.y, &Text3dDialog.d.z,
		 &Text3dDialog.r.x, &Text3dDialog.r.y, &Text3dDialog.r.z);
	  satz++;
	  fscanf(D, "%f %f %f %f %f %f\n",
		 &Text3dDialog.r1, &Text3dDialog.g1, &Text3dDialog.b1,
		 &Text3dDialog.r2, &Text3dDialog.g2, &Text3dDialog.b2);
	  satz++;

	  ank_text3d(Text3dDialog.r1, Text3dDialog.b1, Text3dDialog.g1, Text3dDialog.r2,
		     Text3dDialog.b2, Text3dDialog.g2, Text3dDialog.mix, Text3dDialog.abs,
		     Text3dDialog.art, Text3dDialog.fehler, Text3dDialog.anz, Text3dDialog.d,
		     Text3dDialog.r, Text3dDialog.name);
	  break;

	case WAVE:
	  fscanf(D, "%lu 3\n", &nr);
	  satz++;
	  fscanf(D, "%s\n", WaveDialog.name);
	  satz++;
	  fscanf(D, "%f %f %f %f %f %f %f\n",
		 &WaveDialog.x1, &WaveDialog.y1, &WaveDialog.z1,
		 &WaveDialog.freq1, &WaveDialog.amp1, &WaveDialog.damp1, &WaveDialog.d1);
	  satz++;
	  fscanf(D, "%f %f %f %f %f %f %f\n",
		 &WaveDialog.x2, &WaveDialog.y2, &WaveDialog.z2,
		 &WaveDialog.freq2, &WaveDialog.amp2, &WaveDialog.damp2, &WaveDialog.d2);
	  satz++;
	  fscanf(D, "%f %f %f %f %f %f %f\n",
		 &WaveDialog.x3, &WaveDialog.y3, &WaveDialog.z3,
		 &WaveDialog.freq3, &WaveDialog.amp3, &WaveDialog.damp3, &WaveDialog.d3);
	  satz++;

	  ank_wave(WaveDialog.name,
		   WaveDialog.x1, WaveDialog.y1, WaveDialog.z1,
	  WaveDialog.freq1, WaveDialog.amp1, WaveDialog.damp1, WaveDialog.d1,
		   WaveDialog.x2, WaveDialog.y2, WaveDialog.z2,
	  WaveDialog.freq2, WaveDialog.amp2, WaveDialog.damp2, WaveDialog.d2,
		   WaveDialog.x3, WaveDialog.y3, WaveDialog.z3,
		   WaveDialog.freq3, WaveDialog.amp3, WaveDialog.damp3, WaveDialog.d3);
	  break;

	case COVER:
	  fscanf(D, "%d %d %d %d %f %f %f %f\n", &CoverDialog.text1, &CoverDialog.text2,
		 &CoverDialog.text3, &CoverDialog.text4,
		 &CoverDialog.tx1, &CoverDialog.tx2, &CoverDialog.ty1, &CoverDialog.ty2);
	  satz++;
	  fscanf(D, "%d %d %d %d %f %f\n", &CoverDialog.must1, &CoverDialog.must2,
		 &CoverDialog.must3, &CoverDialog.must4,
		 &CoverDialog.movx, &CoverDialog.movy);
	  satz++;
	  fscanf(D, "%d %d %d %f\n", &CoverDialog.turbart, &CoverDialog.normalv,
		 &CoverDialog.freq, &CoverDialog.scal);
	  satz++;
	  fscanf(D, "%ld\n", &CoverDialog.wavenr);
	  satz++;
	  fscanf(D, "%ld\n", &CoverDialog.text3dnr);
	  satz++;

	  ank_cover(CoverDialog.tx1, CoverDialog.tx2, CoverDialog.ty1, CoverDialog.ty2,
		    CoverDialog.movx, CoverDialog.movy, CoverDialog.scal,
		    CoverDialog.text1, CoverDialog.text2, CoverDialog.text3, CoverDialog.text4, 
		    CoverDialog.must1, CoverDialog.must2,CoverDialog.must3, CoverDialog.must4,
		 CoverDialog.turbart, CoverDialog.normalv, CoverDialog.freq,
		    CoverDialog.wavenr, CoverDialog.text3dnr);
	  break;

	case POLYGON:
	  // Nummer und Ankettnummer
	  fscanf(D, "%ld %ld\n", &nr, &anknr);
	  satz++;

	  // Referenzpunkt fr Transformation
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;

	  // Optische Eigenschaften
	  fscanf(D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
		 &f[3], &f[4], &f[5], &f[6],
		 &f[7], &f[8], &f[9], &f[10],
		 &f[11], &f[12], &f[13], &c);
	  satz++;

	  fscanf(D, "%d\n", &anzvect);
	  satz++;
	  PolygonDialog.anz_vect = (anzvect == 4) ? 1 : 0;
	  fscanf(D, "%f %f %f\n", &PolygonDialog.p1.x, &PolygonDialog.p1.y, &PolygonDialog.p1.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &PolygonDialog.p2.x, &PolygonDialog.p2.y, &PolygonDialog.p2.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &PolygonDialog.p3.x, &PolygonDialog.p3.y, &PolygonDialog.p3.z);
	  satz++;
	  if (anzvect == 4)
	    {
	      fscanf(D, "%f %f %f\n", &PolygonDialog.p4.x, &PolygonDialog.p4.y, &PolygonDialog.p4.z);
	      satz++;
	    }
	  fscanf(D, "%ld\n", &a);
	  satz++;
	  pick_id = ank_grobjekt(POLYGON, anknr,
				 f[3], f[4], f[5], f[6],
				 f[7], f[8], f[9], f[10],
				 f[11], f[12], f[13], c,
				 a,
				 vector(f[0], f[1], f[2]),
				 vector(0.0, 0.0, 0.0));
	  poly = ank_polygon((anzvect == 4) ? 1 : 0,
			     PolygonDialog.p1,
			     PolygonDialog.p2,
			     PolygonDialog.p3,
			     PolygonDialog.p4);
	  create_polygon(pDisplay, WGdrawarea, poly, anknr, pick_id);
	  break;

	case SPHERE:
	  // Nummer und Ankettnummer
	  fscanf(D, "%ld %ld\n", &nr, &anknr);
	  satz++;

	  // Referenzpunkt fr Transformation
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;

	  // Optische Eigenschaften
	  fscanf(D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
		 &f[3], &f[4], &f[5], &f[6],
		 &f[7], &f[8], &f[9], &f[10],
		 &f[11], &f[12], &f[13], &c);
	  satz++;

	  // lese Kugel
	  fscanf(D, "%f %f %f %f %f %f\n",
		 &SphereDialog.m.x, &SphereDialog.m.y, &SphereDialog.m.z,
		 &SphereDialog.r, &SphereDialog.w1, &SphereDialog.w2);

	  fscanf(D, "%ld\n", &a);
	  satz++;
	  pick_id = ank_grobjekt(SPHERE, anknr,
				 f[3], f[4], f[5], f[6],
				 f[7], f[8], f[9], f[10],
				 f[11], f[12], f[13], c,
				 a, vector(f[0], f[1], f[2]),
				 vector(0.0, 0.0, 0.0));

	  sphere = ank_sphere(SphereDialog.r, SphereDialog.w1, SphereDialog.w2, SphereDialog.m);

	  create_sphere(pDisplay, WGdrawarea, sphere, anknr, pick_id);
	  break;		// sphere

	case BLOCK:
	  // Nummer und Ankettnummer
	  fscanf(D, "%ld %ld\n", &nr, &anknr);
	  satz++;

	  // Referenzpunkt fr Transformation
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;

	  // Optische Eigenschaften
	  fscanf(D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
		 &f[3], &f[4], &f[5], &f[6],
		 &f[7], &f[8], &f[9], &f[10],
		 &f[11], &f[12], &f[13], &c);
	  satz++;

	  fscanf(D, "%f %f %f\n", &BlockDialog.p1.x, &BlockDialog.p1.y, &BlockDialog.p1.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &BlockDialog.p2.x, &BlockDialog.p2.y, &BlockDialog.p2.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &BlockDialog.p3.x, &BlockDialog.p3.y, &BlockDialog.p3.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &BlockDialog.p4.x, &BlockDialog.p4.y, &BlockDialog.p4.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &BlockDialog.p5.x, &BlockDialog.p5.y, &BlockDialog.p5.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &BlockDialog.p6.x, &BlockDialog.p6.y, &BlockDialog.p6.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &BlockDialog.p7.x, &BlockDialog.p7.y, &BlockDialog.p7.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &BlockDialog.p8.x, &BlockDialog.p8.y, &BlockDialog.p8.z);
	  satz++;

	  fscanf(D, "%ld\n", &a);
	  satz++;
	  pick_id = ank_grobjekt(BLOCK, anknr,
				 f[3], f[4], f[5], f[6],
				 f[7], f[8], f[9], f[10],
				 f[11], f[12], f[13], c,
				 a, vector(f[0], f[1], f[2]),
				 vector(0.0, 0.0, 0.0));

	  block = ank_block(BlockDialog.p1, BlockDialog.p2, BlockDialog.p3, BlockDialog.p4,
	    BlockDialog.p5, BlockDialog.p6, BlockDialog.p7, BlockDialog.p8);
	  create_block(pDisplay, WGdrawarea, block, anknr, pick_id);
	  break;
	case ELIPSOID:
	  // Nummer und Ankettnummer
	  fscanf(D, "%ld %ld\n", &nr, &anknr);
	  satz++;

	  // Referenzpunkt fr Transformation
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;

	  // Optische Eigenschaften
	  fscanf(D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
		 &f[3], &f[4], &f[5], &f[6],
		 &f[7], &f[8], &f[9], &f[10],
		 &f[11], &f[12], &f[13], &c);
	  satz++;

	  // lese Elipsoid
	  fscanf(D, "%f %f %f %f %f %f %f %f %f\n",
	      &ElipsoidDialog.m.x, &ElipsoidDialog.m.y, &ElipsoidDialog.m.z,
	      &ElipsoidDialog.r.x, &ElipsoidDialog.r.y, &ElipsoidDialog.r.z,
	       &ElipsoidDialog.w.x, &ElipsoidDialog.w.y, &ElipsoidDialog.w.z
	    );
	  satz++;

	  fscanf(D, "%ld\n", &a);
	  satz++;
	  pick_id = ank_grobjekt(ELIPSOID, anknr,
				 f[3], f[4], f[5], f[6],
				 f[7], f[8], f[9], f[10],
				 f[11], f[12], f[13], c,
				 a, vector(f[0], f[1], f[2]),
				 vector(0.0, 0.0, 0.0));

	  elipsoid = ank_elipsoid(ElipsoidDialog.m, ElipsoidDialog.r, ElipsoidDialog.w);

	  create_elipsoid(pDisplay, WGdrawarea, elipsoid, anknr, pick_id);
	  break;		// Elipsoid

	case TORUS:
	  // Nummer und Ankettnummer
	  fscanf(D, "%ld %ld\n", &nr, &anknr);
	  satz++;

	  // Referenzpunkt fr Transformation
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;

	  // Optische Eigenschaften
	  fscanf(D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
		 &f[3], &f[4], &f[5], &f[6],
		 &f[7], &f[8], &f[9], &f[10],
		 &f[11], &f[12], &f[13], &c);
	  satz++;

	  // lese Torus
	  fscanf(D, "%f %f %f %f %f %f %f %f\n",
		 &TorusDialog.m.x, &TorusDialog.m.y, &TorusDialog.m.z,
		 &TorusDialog.r1, &TorusDialog.r2,
		 &TorusDialog.w.x, &TorusDialog.w.y, &TorusDialog.w.z);

	  fscanf(D, "%ld\n", &a);
	  satz++;
	  pick_id = ank_grobjekt(TORUS, anknr,
				 f[3], f[4], f[5], f[6],
				 f[7], f[8], f[9], f[10],
				 f[11], f[12], f[13], c,
				 a,
				 vector(f[0], f[1], f[2]),
				 vector(0.0, 0.0, 0.0));
	  //TorusDialog.w);

	  torus = ank_torus(TorusDialog.m, TorusDialog.r1, TorusDialog.r2, TorusDialog.w);

	  create_torus(pDisplay, WGdrawarea, torus, anknr, pick_id);

	  break;		// torus

	case CONE:
	  // Nummer und Ankettnummer
	  fscanf(D, "%ld %ld\n", &nr, &anknr);
	  satz++;

	  // Referenzpunkt fr Transformation
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;

	  // Optische Eigenschaften
	  fscanf(D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
		 &f[3], &f[4], &f[5], &f[6],
		 &f[7], &f[8], &f[9], &f[10],
		 &f[11], &f[12], &f[13], &c);
	  satz++;

	  // lese Zylinder
	  fscanf(D, "%f %f %f %f %f %f %f %f %f\n",
	   &ZylinderDialog.p1.x, &ZylinderDialog.p1.y, &ZylinderDialog.p1.z,
	   &ZylinderDialog.p2.x, &ZylinderDialog.p2.y, &ZylinderDialog.p2.z,
		 &ZylinderDialog.r1, &ZylinderDialog.r2, &ZylinderDialog.w);

	  fscanf(D, "%ld\n", &a);
	  satz++;
	  pick_id = ank_grobjekt(CONE, anknr,
				 f[3], f[4], f[5], f[6],
				 f[7], f[8], f[9], f[10],
				 f[11], f[12], f[13], c,
				 a, vector(f[0], f[1], f[2]),
				 vector(0.0, 0.0, 0.0));

	  zylinder = ank_zylinder(ZylinderDialog.p1, ZylinderDialog.p2,
		    ZylinderDialog.r1, ZylinderDialog.r2, ZylinderDialog.w);

	  create_zylinder(pDisplay, WGdrawarea, zylinder, anknr, pick_id);
	  break;		// zylinder

	case YBUFFER:
	  // Nummer und Ankettnummer
	  fscanf(D, "%ld %ld\n", &nr, &anknr);
	  satz++;

	  // Referenzpunkt fr Transformation
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;

	  // Optische Eigenschaften
	  fscanf(D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
		 &f[3], &f[4], &f[5], &f[6],
		 &f[7], &f[8], &f[9], &f[10],
		 &f[11], &f[12], &f[13], &c);
	  satz++;

	  // lese YBUFFER
	  fscanf(D, "%f %f %f\n", &YBufferDialog.p1.x, &YBufferDialog.p1.y, &YBufferDialog.p1.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &YBufferDialog.p2.x, &YBufferDialog.p2.y, &YBufferDialog.p2.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &YBufferDialog.p3.x, &YBufferDialog.p3.y, &YBufferDialog.p3.z);
	  satz++;
	  fscanf(D, "%f %f %f\n", &YBufferDialog.p4.x, &YBufferDialog.p4.y, &YBufferDialog.p4.z);
	  satz++;

	  // lese Y-Buffer
	  fscanf(D, "%ld %ld\n", &x, &z);
	  YBufferDialog.x = x;
	  YBufferDialog.z = z;

	  // Speicher allocieren
	  YBufferDialog.y = (float *) malloc(sizeof(float) * YBufferDialog.x * YBufferDialog.z);

	  // schreibe YBuffer
	  for (a = 0; a < z; a++)
	    {
	      for (b = 0; b < x; b++)
		fscanf(D, "%f", &YBufferDialog.y[a * x + b]);
	      fscanf(D, "\n");
	      satz++;
	    }

	  // Cover lesen
	  fscanf(D, "%ld\n", &acover);
	  satz++;
	  pick_id = ank_grobjekt(YBUFFER, anknr,
				 f[3], f[4], f[5], f[6],
				 f[7], f[8], f[9], f[10],
				 f[11], f[12], f[13], c,
				 acover, vector(f[0], f[1], f[2]),
				 vector(0.0, 0.0, 0.0));

	  pybuffer =
	    ank_ybuffer(YBufferDialog.p1, YBufferDialog.p2, YBufferDialog.p3, YBufferDialog.p4,
			YBufferDialog.x, YBufferDialog.z, YBufferDialog.y);

	  create_ybuffer(pDisplay, WGdrawarea, pybuffer, anknr, pick_id);
	  free(YBufferDialog.y);	// Speicher freigeben

	  break;		// ybuffer

	case NURBS:
	  // Nummer und Ankettnummer
	  fscanf(D, "%ld %ld\n", &nr, &anknr);
	  satz++;

	  // Referenzpunkt fr Transformation
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;

	  // Optische Eigenschaften
	  fscanf(D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
		 &f[3], &f[4], &f[5], &f[6],
		 &f[7], &f[8], &f[9], &f[10],
		 &f[11], &f[12], &f[13], &c);
	  satz++;

	  // lese anz x, anz z, approx, order
	  fscanf(D, "%ld %ld %d %d %d %d\n", &x, &z, &cu, &cv, &ou, &ov);
	  satz++;
	  NurbsDialog.x = x;
	  NurbsDialog.z = z;
	  NurbsDialog.cu = cu;
	  NurbsDialog.cv = cv;
	  NurbsDialog.ou = ou;
	  NurbsDialog.ov = ov;

	  // lese anz u - knoten
	  fscanf(D, "%f ", &k);
	  NurbsDialog.i = (float *) malloc(sizeof(float) * ((int) k + 1));
	  NurbsDialog.i[0] = (int) k;
	  for (zz = 1; zz <= (int) k; zz++)
	    {
	      fscanf(D, "%f ", &k1);
	      NurbsDialog.i[zz] = k1;
	    }
	  fscanf(D, "\n");
	  satz++;


	  // lese anz v - knoten
	  fscanf(D, "%f ", &k);
	  NurbsDialog.j = (float *) malloc(sizeof(float) * ((int) k + 1));
	  NurbsDialog.j[0] = (int) k;
	  for (zz = 1; zz <= (int) k; zz++)
	    {
	      fscanf(D, "%f ", &k1);
	      NurbsDialog.j[zz] = k1;
	    }
	  fscanf(D, "\n");
	  satz++;

	  // Speicher allocieren
	  NurbsDialog.y = (vect4d *) malloc(sizeof(vect4d) * NurbsDialog.x * NurbsDialog.z);

	  // lese Nurbs
	  for (b = 0; b < NurbsDialog.z; b++)
	    {
	      for (a = 0; a < NurbsDialog.x; a++)
		{
		  pos = b * NurbsDialog.x + a;
		  fscanf(D, "%f %f %f %f ", &NurbsDialog.y[pos].x, &NurbsDialog.y[pos].y,
			 &NurbsDialog.y[pos].z, &NurbsDialog.y[pos].g);
		}
	      fscanf(D, "\n");
	      satz++;
	    }
	  // Cover lesen
	  fscanf(D, "%ld\n", &acover);
	  satz++;

	  pick_id = ank_grobjekt(NURBS, anknr, f[3], f[4], f[5], f[6], f[7], f[8], f[9], f[10],
		   f[11], f[12], f[13], c, acover, vector(f[0], f[1], f[2]),
				 vector(0.0, 0.0, 0.0));
	  pnurbs =
	    ank_nurbs(NurbsDialog.x, NurbsDialog.z, NurbsDialog.cu, NurbsDialog.cv,
		      NurbsDialog.ou, NurbsDialog.ov,
		      NurbsDialog.y, NurbsDialog.i, NurbsDialog.j);

	  create_nurbs(pDisplay, WGdrawarea, pnurbs, anknr, pick_id);

	  free(NurbsDialog.y);	// Speicher Vektoren freigeben

	  free(NurbsDialog.i);	// Speicher Knoten   freigeben

	  free(NurbsDialog.j);	// Speicher Knoten   freigeben

	  break;		// nurbs
	  /*
	case BEZIER:
	  // Nummer und Ankettnummer
	  fscanf(D, "%ld %ld\n", &nr, &anknr);
	  satz++;

	  // Referenzpunkt fr Transformation
	  fscanf(D, "%f %f %f\n", &f[0], &f[1], &f[2]);
	  satz++;

	  // Optische Eigenschaften
	  fscanf(D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
		 &f[3], &f[4], &f[5], &f[6],
		 &f[7], &f[8], &f[9], &f[10],
		 &f[11], &f[12], &f[13], &c);
	  satz++;

	  // lese anz x, anz z, approx, order
	  fscanf(D, "%ld %ld\n", &x, &z);
	  satz++;
	  BezierDialog.x = x;
	  BezierDialog.z = z;

	  // lese Knoten
	  for (b = 0; b < 4; b++)
	    {
	      for (a = 0; a < 4; a++)
		{
		  fscanf(D, "%f %f %f ", &BezierDialog.pbuf[a][b].x, &BezierDialog.pbuf[a][b].y,
			 &BezierDialog.pbuf[a][b].z);
		}
	      fscanf(D, "\n");
	      satz++;
	    }
	  // Cover lesen
	  fscanf(D, "%ld\n", &acover);
	  satz++;

	  pick_id = ank_grobjekt(BEZIER, anknr, f[3], f[4], f[5], f[6], f[7], f[8], f[9], f[10],
		   f[11], f[12], f[13], c, acover, vector(f[0], f[1], f[2]),
				 vector(0.0, 0.0, 0.0));
	  pbezier =
	    ank_bezier(BezierDialog.x, BezierDialog.z, BezierDialog.pbuf);

	  create_bezier(pDisplay, WGdrawarea, pbezier, anknr, pick_id);

	  break;		// bezier
	  */
	case KAMERA:
	  fscanf(D, "%f %ld\n", &f[0], &x);	// Lese Masse, Anzahl der Punkte

	  Kamera_init(f[0], x);

	  fscanf(D, "%ld\n", &x);	// Lese Anzahl der Elemente

	  // lese Daten
	  for (z = 0; z < x; z++)
	    {
	      fscanf(D, "%f %f %f %f %f %f %f\n", &f[0], &f[1], &f[2], &f[3], &f[4], &f[5], &f[6]);
	      ank_kamera(vector(f[0], f[1], f[2]), vector(f[3], f[4], f[5]), f[6]);
	    }
	  create_kamera();
	  break;

	default:
	  sprintf(error, "Undef. Objekttyp gelesen! Zeile %ld", satz);
	  errorbox(error);
	  break;		// fehler      

	}			// switch (objecttyp)

    }				// while (!feof(D))

  fclose(D);
  return true;
}
