#ifndef __DATALIST_H
#define __DATALIST_H

/*
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

class liste;
class grobjekt;

// neue Listklasse in liste.C
extern liste oliste;

class liste
{
  public:
  liste ();
  ~liste ();
  void destroy (void);		// Destruktor fuer die Laufzeit

  // setzt Zeiger auf Objekt mit Nr. x
  grobjekt *getobjp (longint x);

  // ermittelt Zeiger ohne Listenzeiger zu verruecken
  grobjekt *readobjp (longint x);

  // liefert aktuelle Position
  grobjekt *getaktuell (void);
  // setzt Zeiger auf Objekt 1
  grobjekt *getfirst (void);
  // liest Zeiger 1
  grobjekt *readfirst (void);

  // setzt Zeiger auf naechstes Objekt
  grobjekt *getnext (void);
  // setzt Zeiger auf letztes Objekt und uebergiebt Nr. und Zeiger
  longint getlast (grobjekt ** old);
  // fuegt Objekt hinten an
  longint insertobj (int obj_art, longint Ank_nr,
	  float R, float B, float G, float E, float Mat, float Sp, float Du,
		     float Dif, float Spec, float High, float Vel, char Ch,
		     longint Cover, vector Ref, vector W);
  // loescht Objekt
  void deleteobj (grobjekt * grx);
  void deleteank (grobjekt * grx);
};

// Listen am Anfang auf NULL setzen
void init_listpointers (void);


// Virtuelle Klasse um Zugriff auf Zeiger zu ermoeglichen
class virgrobj
{
  public:
  // virgrobj()=0;
  virtual ~ virgrobj ()
  {
  };
};

// Listenobjekt
class virliobj
{
  public:
  virtual ~ virliobj ()
  {
  };
};

class cadpolygon:
  public virgrobj
{
  public:
  cadpolygon ()
  {
  };

  void init (int anz_p, vector P1, vector P2, vector P3, vector P4);
  void get (int *anz_p, vector * P1, vector * P2, vector * P3, vector * P4);

private:
  int anz_vect;
  vector p1, p2, p3, p4;
};

class cadsphere:
  public virgrobj
{
  public:
  cadsphere ()
  {
  };

  void init (float R, float W1, float W2, vector M);
  void get (float *R, float *W1, float *W2, vector * M);

private:
  vector m;
  float r, w1, w2;
};

class cadblock:
  public virgrobj
{
  public:
  cadblock ()
  {
  };

  void init (vector P1, vector P2, vector P3, vector P4,
	     vector P5, vector P6, vector P7, vector P8);
  void get (vector * P1, vector * P2, vector * P3, vector * P4,
	    vector * P5, vector * P6, vector * P7, vector * P8);

private:
  vector p1, p2, p3, p4, p5, p6, p7, p8;
};

class cadelipsoid:public virgrobj
{
  public:
  // cadelipsiod() {};

  void init (vector M, vector R, vector W);
  void get (vector * M, vector * R, vector * W);

    private:
    vector m, r, w;
};

class cadtorus:
  public virgrobj
{
  public:
  cadtorus ()
  {
  };

  void init (vector M, float R1, float R2, vector W);
  void get (vector * M, float *R1, float *R2, vector * W);

private:
  vector m, w;
  float r1, r2;
};

class cadzylinder:
  public virgrobj
{
  public:
  cadzylinder ()
  {
  };

  void init (vector P1, vector P2, float R1, float R2, float W);
  void get (vector * P1, vector * P2, float *R1, float *R2, float *W);

private:
  vector p1, p2;
  float r1, r2, w;
};

class cadybuffer:
  public virgrobj
{
  public:
  cadybuffer ()
  {
  };
  ~cadybuffer ()
  {
    delete y;
  };

  void init (vector P1, vector P2, vector P3, vector P4, longint X, longint Z, float *Y);
  void get (vector * P1, vector * P2, vector * P3, vector * P4, longint * X, longint * Z, float **Y);

private:
  vector p1, p2, p3, p4;
  longint x, z;
  float *y;
};

class nurbs:
  public virgrobj
{
  public:
  nurbs ()
  {
  };
  ~nurbs ()
  {
    delete y;
    delete i;
    delete j;			// lsche Puffer

  };

  void init (longint X, longint Z, int CU, int CV, int OU, int OV,
	     vect4d * Y, float *I, float *J);
  void get (longint * X, longint * Z, int *CU, int *CV, int *OU, int *OV,
	    vect4d ** Y, float **I, float **J);

  int ou, ov;			// Order der Kurve

  longint x, z;
  int cu, cv;			// Anz x,z, Genauigkeit

  vect4d *y;			// Puffer fr die 4-Dimensionalen Vektoren

  float *i, *j;			// Puffer fr die Knotenvektoren, erste Element ist die Anzahl

};
/*
class cadbezier:
  public virgrobj
{
  public:
  cadbezier ()
  {
  };
  ~cadbezier ()
  {
  };

  void init (longint X, longint Z, vector Pbuf[4][4]);
  void get (longint * X, longint * Z, vector (*Pbuf)[4][4]);

  longint x, z;			// Anz x,z, Genauigkeit

  vector pbuf[4][4];		// Puffer fuer die Vektoren

};
*/

// Hier alle weiteren 3D-Grafikobjekte
// ...
// Hilfsliste
class alist
{
  friend liste;

    public:
    alist (alist * Lx, grobjekt * Ox)
  {
    // einketten
    if (Lx != NULL)
      Lx->next = this;
    next = NULL;
    ankobj = Ox;
  }
   ~alist ()
  {
    delete next;
    // ankobj werden in Hauptliste geloescht
  }

private:
  grobjekt * ankobj;
  alist *next;
};				// Sind angekettet

// Listenobjekt welches die Optischen Eigenschaften als Memberdaten hat
// und einen Pointer auf das grobj
class grobjekt
{
  public:
  grobjekt (grobjekt * Nx, int artnr, longint Nr, longint Ank_nr,
	  float R, float G, float B, float E, float Mat, float Sp, float Du,
       float Dif, float Spec, float High, float Vel, char Ch, longint Cover,
	    vector Ref, vector W);

   ~grobjekt ();

  int type;			// Objekttyp

  virgrobj *objp;		// Zeiger auf Objekt

  PEXStructure obj_struct;	// Pexstruktur

  grobjekt *next;		// Naechste in der Liste

  grobjekt *prev;		// Vorherige in der Liste

  grobjekt *isank;		// Angekettet an

  alist *lanka, *lankx;		// Sind angekettet

  longint nr, ank_nr;		// Nummer des Objektes, Nummer an welchen angekettet

  float s;
  vector w, v, ref;		// Transformation, Referenzpunkt fuer Transformation

  // Alle Optischen Eigenschaften aus dem ersten Dialog
  float r, g, b, e, mat, sp, du, dif, spec, high, vel;
  // Covernummer
  longint cover;
  // Schnittkoerper ja/nein
  char ch;
};

// Nichtgrafische Objekte
class lichtquelle
{
  public:
  lichtquelle (lichtquelle * Lx, longint Nr, float R, float G, float B, float S,
	       float X, float Y, float Z);
   ~lichtquelle ()
  {
    delete next;
  }

  float r, g, b, s, x, y, z;
  longint nr;			// Nummer der Lichtquelle

  lichtquelle *next;		// Zeiger auf nchste

};

class cadlichtpoly
{
  public:
  cadlichtpoly (cadlichtpoly * Lx, longint Nr, float R, float G, float B,
		float I, int XAnz, int YAnz, float W, vector P1, vector P2,
		vector P3, vector P4);
   ~cadlichtpoly ()
  {
    delete next;
  }

  float r, g, b;
  float i, w;
  int xanz, yanz;
  vector p1, p2, p3, p4;

  longint nr;
  cadlichtpoly *next;
};

class strahler
{
  public:
  strahler (strahler * Lx, longint Nr, float R, float G, float B, float S,
	    vector Pos, vector Richtung, float Winkel);
   ~strahler ()
  {
    delete next;
  }

  float r, g, b, s, winkel;
  vector pos, richtung;
  longint nr;			// Nummer der Lichtquelle

  strahler *next;		// Zeiger auf nchste

};

class texturen
{
  public:
  texturen (texturen * Tx, longint Nr, char *Name, char *Dname, float S);
   ~texturen ()
  {
    delete next;
  }

  char name[256], dname[256];
  float prozent;
  longint nr;			// Nummer der Texture

  texturen *next;		// Zeiger auf nchste

};

class text3d
{
  public:
  text3d (text3d * Mx, longint Nr, float R1, float B1, float G1, float R2,
	  float B2, float G2,
	  float Mix, float Abs, int Art, int Fehler, int Anz,
	  vector D, vector R, char *Name);
   ~text3d ()
  {
    delete next;
  }


  longint nr;			// Nummer der Texture

  float r1, b1, g1, r2, b2, g2, mix, abs;
  int art, fehler, anz;
  vector d, r;
  char name[256];

  text3d *next;			// Zeiger auf nchste

};

class cadmuster
{
  public:
  cadmuster (cadmuster * Mx, longint Nr, char *Name, float R1, float B1, float G1,
	     float R2, float B2, float G2, float Mix, int Art, int Fehler, float X, float Y);
   ~cadmuster ()
  {
    delete next;
  }

  char name[256];
  longint nr;			// Nummer der Texture

  float r1, b1, g1, r2, b2, g2, mix, x, y;
  int art, fehler;

  cadmuster *next;		// Zeiger auf nchste

};

class cadwave
{
  public:
  cadwave (cadwave * Mx, longint Nr, char *Name,
	   float X1, float Y1, float Z1, float Freq1, float Amp1, float Damp1, float D1,
	   float X2, float Y2, float Z2, float Freq2, float Amp2, float Damp2, float D2,
	   float X3, float Y3, float Z3, float Freq3, float Amp3, float Damp3, float D3);
   ~cadwave ()
  {
    delete next;
  }

  float x1, y1, z1, freq1, amp1, damp1, d1;
  float x2, y2, z2, freq2, amp2, damp2, d2;
  float x3, y3, z3, freq3, amp3, damp3, d3;

  char name[256];
  longint nr;

  cadwave *next;		// Zeiger auf nchste

};

class cadcover
{
  public:
  cadcover (cadcover * Mx, longint Nr, float Tx1, float Tx2, float Ty1, float Ty2,
	    float Movx, float Movy, float Scal,
	    int Text1, int Text2, int Text3, int Text4, int Must1, int Must2,int Must3, int Must4,
      int Turbart, int Normalv, int Freq, longint Wavenr, longint Text3dnr);

   ~cadcover ()
  {
    delete next;
  }

  float tx1, tx2,  ty1, ty2, movx, movy, scal;
  int text1, text2, text3, text4, must1, must2, must3, must4, turbart, normalv, freq;
  longint nr, wavenr, text3dnr;

  cadcover *next;		// Zeiger auf nchste

};


// Funktion um die Objekte miteinander zu verketten
longint ank_lichtquelle (float R, float G, float B, float S, float X, float Y, float Z);
longint ank_strahler (float R, float G, float B, float S,
		      vector Pos, vector Richtung, float Winkel);
longint ank_lichtpoly (float R, float G, float B, float I, int XAnz, int YAnz,
		       float W, vector P1, vector P2, vector P3, vector P4);

void ank_texturen (float prozent, char *dateiname, char *name);

void ank_muster (char *Name, float R1, float B1, float G1,
	       float R2, float B2, float G2, float Mix, int Art, int Fehler,
		 float X, float Y);

void ank_text3d (float R1, float B1, float G1, float R2, float B2, float G2,
		 float Mix, float Abs, int Art, int Fehler, int Anz,
		 vector D, vector R, char *Name);

void ank_wave (char *Name,
float X1, float Y1, float Z1, float Freq1, float Amp1, float Damp1, float D1,
float X2, float Y2, float Z2, float Freq2, float Amp2, float Damp2, float D2,
	       float X3, float Y3, float Z3, float Freq3, float Amp3, float Damp3, float D3);

void ank_cover (float Tx1, float Tx2, float Ty1, float Ty2,
		float Movx, float Movy, float Scal,
		int Text1, int Text2, int Text3, int Text4,
		int Must1, int Must2, int Must3, int Must4,
		int Turbart, int Normalv, int Freq, longint Wavenr, longint Text3dnr);

longint ank_grobjekt (int obj_art, longint Ank_nr,
	  float R, float B, float G, float E, float Mat, float Sp, float Du,
       float Dif, float Spec, float High, float Vel, char Ch, longint Cover,
		      vector Ref, vector W);

// Objekte in die Liste einketten
grobjekt *ank_polygon (int anz_p, vector p1, vector p2, vector p3, vector p4);
grobjekt *ank_sphere (float R, float W1, float W2, vector M);
grobjekt *ank_block (vector P1, vector P2, vector P3, vector P4,
		     vector P5, vector P6, vector P7, vector P8);
grobjekt *ank_elipsoid (vector M, vector R, vector W);
grobjekt *ank_torus (vector M, float R1, float R2, vector W);
grobjekt *ank_zylinder (vector P1, vector P2, float R1, float R2, float W);
grobjekt *ank_ybuffer (vector P1, vector P2, vector P3, vector P4, longint X, longint Z, float *Y);
grobjekt *ank_nurbs (longint X, longint Z, int CU, int CV, int OU, int OV, vect4d * Y,
		     float *I, float *J);
//grobjekt *ank_bezier (longint X, longint Z, vector Pbuf[4][4]);

// Funktion um Objekte lschen zu knnen
void entf_lichtquelle (longint Nr);
void entf_strahler (longint Nr);
void entf_lichtpoly (longint Nr);
void entf_texturen (longint Nr);
void entf_text3d (longint Nr);
void entf_muster (longint Nr);
void entf_wave (longint Nr);
void entf_cover (longint Nr);
void entf_grobjekt (longint Nr);

// Globale Zeiger auf die Listenstrukturen
extern lichtquelle *lichtanf, *lichtx;
extern strahler *strahleranf, *strahlerx;
extern cadlichtpoly *lichtpolyanf, *lichtpolyx;
extern texturen *textanf, *textx;
extern text3d *text3danf, *text3dx;
extern cadmuster *mustanf, *mustx;
extern cadwave *waveanf, *wavex;
extern cadcover *coveranf, *coverx;

#endif
