/*
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion

 */

#include <stdlib.h>
#include <string.h>
#include "cadtool.H"

// Datalist, Definition der Objekte dynamisch im Speicher
// Globale Zeiger auf die Listenstrukturen
lichtquelle *lichtanf, *lichtx;
strahler *strahleranf, *strahlerx;
cadlichtpoly *lichtpolyanf, *lichtpolyx;
texturen *textanf, *textx;
text3d *text3danf, *text3dx;
cadmuster *mustanf, *mustx;
cadwave *waveanf, *wavex;
cadcover *coveranf, *coverx;


void
allocerror(void *p)
{
  if (!p)
    {
      fprintf(stderr, "Fehler beim allocieren von Speicher!\n");
      exit(1);
    }
}

void
init_listpointers(void)
{
  lichtanf = lichtx = NULL;
  strahleranf = strahlerx = NULL;
  lichtpolyanf = lichtpolyx = NULL;
  textanf = textx = NULL;
  text3danf = text3dx = NULL;
  mustanf = mustx = NULL;
  waveanf = wavex = NULL;
  coveranf = coverx = NULL;
  kameraliste = kameralistex = NULL;
}

// Objektdefinitionen

// GROBJEKT
grobjekt::grobjekt(grobjekt * Nx, int artnr, longint Nr, longint Ank_nr,
	 float R, float G, float B, float E, float Mat, float Sp, float Du,
	 float Dif, float Spec, float High, float Vel, char Ch, longint Cover,
	 vector Ref, vector W)
{
  // einketten
  if (Nx != NULL)
    Nx->next = this;
  prev = Nx;
  next = NULL;

  // Ankettlistpointer init
  lanka = lankx = NULL;
  isank = NULL;

  type = artnr;
  switch (type)
    {
    case POLYGON:
      objp = new cadpolygon();
      break;
    case SPHERE:
      objp = new cadsphere();
      break;
    case BLOCK:
      objp = new cadblock();
      break;
    case ELIPSOID:
      objp = new cadelipsoid();
      break;
    case TORUS:
      objp = new cadtorus();
      break;
    case CONE:
      objp = new cadzylinder();
      break;
    case YBUFFER:
      objp = new cadybuffer();
      break;
      /*
    case BEZIER:
      objp = new cadbezier();
      break; */
    case NURBS:
      objp = new nurbs();
      break;
    default:
      objp = NULL;
      break;
    }
  allocerror(objp);

  obj_struct = PEXCreateStructure(pDisplay);

  nr = Nr;
  ank_nr = Ank_nr;

  r = R;
  g = G;
  b = B;
  e = E;
  mat = Mat;
  sp = Sp;
  du = Du;
  dif = Dif;
  spec = Spec;
  high = High;
  vel = Vel;
  ch = Ch;
  cover = Cover;

  // Transformation
  s = 1.0;
  v = vector(0.0, 0.0, 0.0);
  ref = Ref;
  w = W;
}

grobjekt::~grobjekt()
{
  delete objp;
  delete next;
  // Wird eigentlich beim loeschen gemacht
  PEXDeleteElements(pDisplay, obj_struct, PEXBeginning, 0, PEXEnd, 0);
}

longint
ank_grobjekt(int obj_art, longint Ank_nr,
	     float R, float B, float G, float E, float Mat, float Sp, float Du,
	     float Dif, float Spec, float High, float Vel, char Ch, longint Cover,
	     vector Ref, vector W)
{
  return oliste.insertobj(obj_art, Ank_nr, R, B, G, E, Mat, Sp, Du, Dif, Spec, High, Vel, Ch,
			  Cover, Ref, W);
}

// Polygon
void   cadpolygon::
init(int anz_p, vector P1, vector P2, vector P3, vector P4)
{
  anz_vect = anz_p;
  p1 = P1;
  p2 = P2;
  p3 = P3;
  p4 = P4;
}

void   cadpolygon::
get(int *anz_p, vector * P1, vector * P2, vector * P3, vector * P4)
{
  *anz_p = anz_vect;
  *P1 = p1;
  *P2 = p2;
  *P3 = p3;
  *P4 = p4;
}

// Polygon an grobjekt anketten, musz gleich nach dem Erzeugen des Objektes
// aufgerufen werden!
// dies ist zwar unsauber aber moeglich!!!!!!!
grobjekt *
ank_polygon(int anz_p, vector p1, vector p2, vector p3, vector p4)
{
  grobjekt *grx = oliste.getaktuell();
  ((cadpolygon *) (grx->objp))->init(anz_p, p1, p2, p3, p4);
  return (grx);
}

// Kugel
void   cadsphere::
init(float R, float W1, float W2, vector M)
{
  r = R;
  m = M;
  w1 = W1;
  w2 = W2;
}

void   cadsphere::
get(float *R, float *W1, float *W2, vector * M)
{
  *R = r;
  *M = m;
  *W1 = w1;
  *W2 = w2;
}

// Kugel an grobjekt anketten, muss gleich nach dem Erzeugen des Objektes
// aufgerufen werden!
grobjekt *
ank_sphere(float R, float W1, float W2, vector M)
{
  grobjekt *grx = oliste.getaktuell();
  ((cadsphere *) (grx->objp))->init(R, W1, W2, M);
  return (grx);
}

// Block
void   cadblock::
init(vector P1, vector P2, vector P3, vector P4,
     vector P5, vector P6, vector P7, vector P8)
{
  p1 = P1;
  p2 = P2;
  p3 = P3;
  p4 = P4;
  p5 = P5;
  p6 = P6;
  p7 = P7;
  p8 = P8;
}

void   cadblock::
get(vector * P1, vector * P2, vector * P3, vector * P4,
    vector * P5, vector * P6, vector * P7, vector * P8)
{
  *P1 = p1;
  *P2 = p2;
  *P3 = p3;
  *P4 = p4;
  *P5 = p5;
  *P6 = p6;
  *P7 = p7;
  *P8 = p8;
}

grobjekt *
ank_block(vector P1, vector P2, vector P3, vector P4,
	  vector P5, vector P6, vector P7, vector P8)
{
  grobjekt *grx = oliste.getaktuell();
  ((cadblock *) (grx->objp))->init(P1, P2, P3, P4, P5, P6, P7, P8);
  return (grx);
}

// Elipsoid
void   cadelipsoid::
init(vector M, vector R, vector W)
{
  m = M;
  r = R;
  w = W;
}

void   cadelipsoid::
get(vector * M, vector * R, vector * W)
{
  *M = m;
  *R = r;
  *W = w;
}

grobjekt *
ank_elipsoid(vector M, vector R, vector W)
{
  grobjekt *grx = oliste.getaktuell();
  ((cadelipsoid *) (grx->objp))->init(M, R, W);
  return (grx);
}

// Torus
void   cadtorus::
init(vector M, float R1, float R2, vector W)
{
  m = M;
  r1 = R1;
  r2 = R2;
  w = W;
}

void   cadtorus::
get(vector * M, float *R1, float *R2, vector * W)
{
  *M = m;
  *R1 = r1;
  *R2 = r2;
  *W = w;
}

grobjekt *
ank_torus(vector M, float R1, float R2, vector W)
{
  grobjekt *grx = oliste.getaktuell();
  ((cadtorus *) (grx->objp))->init(M, R1, R2, W);
  return (grx);
}

// Zylinder
void   cadzylinder::
init(vector P1, vector P2, float R1, float R2, float W)
{
  p1 = P1;
  p2 = P2;
  r1 = R1;
  r2 = R2;
  w = W;
}

void   cadzylinder::
get(vector * P1, vector * P2, float *R1, float *R2, float *W)
{
  *P1 = p1;
  *P2 = p2;
  *R1 = r1;
  *R2 = r2;
  *W = w;
}

grobjekt *
ank_zylinder(vector P1, vector P2, float R1, float R2, float W)
{
  grobjekt *grx = oliste.getaktuell();
  ((cadzylinder *) (grx->objp))->init(P1, P2, R1, R2, W);
  return (grx);
}

// Y- Puffer
void   cadybuffer::
init(vector P1, vector P2, vector P3, vector P4, longint X, longint Z, float *Y)
{
  longint a;
  p1 = P1;
  p2 = P2;
  p3 = P3;
  p4 = P4;
  x = X;
  z = Z;
  y = new float[x * z];
  for (a = 0; a < (x * z); a++)
    y[a] = Y[a];
}

void   cadybuffer::
get(vector * P1, vector * P2, vector * P3, vector * P4,
    longint * X, longint * Z, float **Y)
{
  *P1 = p1;
  *P2 = p2;
  *P3 = p3;
  *P4 = p4;
  *X = x;
  *Z = z;
  *Y = y;
}

grobjekt *
ank_ybuffer(vector P1, vector P2, vector P3, vector P4, longint X, longint Z, float *Y)
{
  grobjekt *grx = oliste.getaktuell();
  ((cadybuffer *) (grx->objp))->init(P1, P2, P3, P4, X, Z, Y);
  return (grx);
}


// NURBS - Puffer
void   nurbs::
init(longint X, longint Z, int CU, int CV, int OU, int OV,
     vect4d * Y, float *I, float *J)
{
  longint a;
  int    u;

  // Matrix x*y
  x = X;
  z = Z;
  cu = CU;
  cv = CV;
  ou = OU;
  ov = OV;

  // Puffer erzeugen und kopieren
  y = new vect4d[x * z];
  for (a = 0; a < (x * z); a++)
    {
      y[a].x = Y[a].x;
      y[a].y = Y[a].y;
      y[a].z = Y[a].z;
      y[a].g = Y[a].g;
    }

  // Knotenvektoren erzeugen und kopieren, anz +1 da 1. Lnge !
  i = new float[(int) I[0] + 1];
  for (u = 0; u <= (int) I[0]; u++)
    i[u] = I[u];
  // Knotenvektoren erzeugen und kopieren
  j = new float[(int) J[0] + 1];
  for (u = 0; u <= (int) J[0]; u++)
    j[u] = J[u];
}

void   nurbs::
get(longint * X, longint * Z, int *CU, int *CV, int *OU, int *OV, vect4d ** Y,
    float **I, float **J)
{
  *X = x;
  *Z = z;
  *Y = y;
  *I = i;
  *J = j;
  *CU = cu;
  *CV = cv;
  *OU = ou;
  *OV = ov;
}

grobjekt *
ank_nurbs(longint X, longint Z, int CU, int CV, int OU, int OV,
	  vect4d * Y, float *I, float *J)
{
  grobjekt *grx = oliste.getaktuell();
  ((nurbs *) (grx->objp))->init(X, Z, CU, CV, OU, OV, Y, I, J);
  return (grx);
}

// BEZIER
/*
void   cadbezier::
init(longint X, longint Z, vector Pbuf[4][4])
{
  int    zy, zx;

  x = X;
  z = Z;

  // Matrix kopieren
  for (zy = 0; zy < 4; zy++)
    for (zx = 0; zx < 4; zx++)
      pbuf[zy][zx] = Pbuf[zy][zx];
}

void   cadbezier::
get(longint * X, longint * Z, vector(*Pbuf)[4][4])
{
  int    zy, zx;
  *X = x;
  *Z = z;
  // Matrix kopieren
  for (zy = 0; zy < 4; zy++)
    for (zx = 0; zx < 4; zx++)
      (*Pbuf)[zy][zx] = pbuf[zy][zx];	// (*Pbuf) immer in Klammern !!!

}

grobjekt *
ank_bezier(longint X, longint Z, vector Pbuf[4][4])
{
  grobjekt *grx = oliste.getaktuell();
  ((cadbezier *) (grx->objp))->init(X, Z, Pbuf);
  return (grx);
}
*/

// LICHTQUELLE
lichtquelle::lichtquelle(lichtquelle * Lx, longint Nr, float R, float G, float B, float S,
	    float X, float Y, float Z)
{
  // einketten
  if (Lx != NULL)
    Lx->next = this;
  next = NULL;

  r = R;
  g = G;
  b = B;
  s = S;
  nr = Nr;
  x = X;
  y = Y;
  z = Z;
}

longint
ank_lichtquelle(float R, float G, float B, float S, float X, float Y, float Z)
{
  longint Nr = 0;
  lichtquelle *old = NULL;

  if (lichtanf == NULL)
    {
      Nr = 1L;
      // Zeiger auf Vorgnger, Nummer der Welle
      lichtanf = new lichtquelle(NULL, Nr, R, G, B, S, X, Y, Z);
      allocerror(lichtanf);
    }
  else
    {
      lichtx = lichtanf;
      while (lichtx)
	{
	  Nr = lichtx->nr + 1;
	  old = lichtx;
	  lichtx = lichtx->next;
	}
      old = new lichtquelle(old, Nr, R, G, B, S, X, Y, Z);
      allocerror(old);
    }

  return Nr;
}

void
entf_lichtquelle(longint Nr)
{
  lichtquelle *old = NULL;
  int    x;

  if (lichtanf)
    {
      if (Nr == 1)
	{
	  old = lichtanf;
	  lichtanf = lichtanf->next;
	  old->next = NULL;
	  delete old;
	}
      else
	{
	  old = lichtx = lichtanf;
	  while (lichtx && (lichtx->nr != Nr))
	    {
	      old = lichtx;
	      lichtx = lichtx->next;
	    }
	  old->next = lichtx->next;
	  lichtx->next = NULL;
	  delete lichtx;
	}

      // neu Durchnummerieren!
      lichtx = lichtanf;
      x = 1;
      while (lichtx)
	{
	  lichtx->nr = x++;
	  lichtx = lichtx->next;
	}
    }
}

// STRAHLER
strahler::strahler(strahler * Lx, longint Nr, float R, float G, float B, float S,
	 vector Pos, vector Richtung, float Winkel)
{
  // einketten
  if (Lx != NULL)
    Lx->next = this;
  next = NULL;

  r = R;
  g = G;
  b = B;
  s = S;
  nr = Nr;
  pos = Pos;
  richtung = Richtung, winkel = Winkel;
}

longint
ank_strahler(float R, float G, float B, float S,
	     vector Pos, vector Richtung, float Winkel)
{
  longint Nr = 0;
  strahler *old = NULL;

  if (strahleranf == NULL)
    {
      Nr = 1L;
      // Zeiger auf Vorgnger, Nummer der Welle
      strahleranf = new strahler(NULL, Nr, R, G, B, S, Pos, Richtung, Winkel);
      allocerror(strahleranf);
    }
  else
    {
      strahlerx = strahleranf;
      while (strahlerx)
	{
	  Nr = strahlerx->nr + 1;
	  old = strahlerx;
	  strahlerx = strahlerx->next;
	}
      old = new strahler(old, Nr, R, G, B, S, Pos, Richtung, Winkel);
      allocerror(old);
    }
  return Nr;
}

void
entf_strahler(longint Nr)
{
  strahler *old = NULL;
  int    x;

  if (strahleranf)
    {
      if (Nr == 1)
	{
	  old = strahleranf;
	  strahleranf = strahleranf->next;
	  old->next = NULL;
	  delete old;
	}
      else
	{
	  old = strahlerx = strahleranf;
	  while (strahlerx && (strahlerx->nr != Nr))
	    {
	      old = strahlerx;
	      strahlerx = strahlerx->next;
	    }
	  old->next = strahlerx->next;
	  strahlerx->next = NULL;
	  delete strahlerx;
	}

      // neu Durchnummerieren!
      for (strahlerx = strahleranf, x = 1; strahlerx; strahlerx = strahlerx->next)
	strahlerx->nr = x++;
    }
}

// POLYGONLICHTQUELLE
cadlichtpoly::cadlichtpoly(cadlichtpoly * Lx, longint Nr, float R, float G, float B, float I,
			   int XAnz, int YAnz, float W, 
			   vector P1, vector P2, vector P3, vector P4)
{
  // einketten
  if (Lx != NULL)
    Lx->next = this;
  next = NULL;

  r = R;
  g = G;
  b = B;
  i = I;
  xanz = XAnz;
  yanz = YAnz;
  w = W;
  p1 = P1;
  p2 = P2;
  p3 = P3;
  p4 = P4;

  nr = Nr;
}

longint
ank_lichtpoly(float R, float G, float B, float I, int XAnz, int YAnz, float W,
	      vector P1, vector P2, vector P3, vector P4)
{
  longint Nr = 0;
  cadlichtpoly *old = NULL;

  if (lichtpolyanf == NULL)
    {
      Nr = 1L;
      // Zeiger auf Vorgnger, Nummer der Welle
      lichtpolyanf = new cadlichtpoly(NULL, Nr, R, G, B, I, XAnz, YAnz, W, P1, P2, P3, P4);
      allocerror(lichtpolyanf);
    }
  else
    {
      lichtpolyx = lichtpolyanf;
      while (lichtpolyx)
	{
	  Nr = lichtpolyx->nr + 1;
	  old = lichtpolyx;
	  lichtpolyx = lichtpolyx->next;
	}
      old = new cadlichtpoly(old, Nr, R, G, B, I, XAnz, YAnz, W, P1, P2, P3, P4);
      allocerror(old);
    }

  return Nr;
}

void
entf_lichtpoly(longint Nr)
{
  cadlichtpoly *old = NULL;
  int    x;

  if (lichtpolyanf)
    {
      if (Nr == 1)
	{
	  old = lichtpolyanf;
	  lichtpolyanf = lichtpolyanf->next;
	  old->next = NULL;
	  delete old;
	}
      else
	{
	  old = lichtpolyx = lichtpolyanf;
	  while (lichtpolyx && (lichtpolyx->nr != Nr))
	    {
	      old = lichtpolyx;
	      lichtpolyx = lichtpolyx->next;
	    }
	  old->next = lichtpolyx->next;
	  lichtpolyx->next = NULL;
	  delete lichtpolyx;
	}

      // neu Durchnummerieren!
      lichtpolyx = lichtpolyanf;
      x = 1;
      while (lichtpolyx)
	{
	  lichtpolyx->nr = x++;
	  lichtpolyx = lichtpolyx->next;
	}
    }
}

texturen::texturen(texturen * Tx, longint Nr, char *Name, char *Dname, float S)
{
  // einketten
  if (Tx != NULL)
    Tx->next = this;
  next = NULL;

  nr = Nr;
  prozent = S;
  strcpy(name, Name);
  strcpy(dname, Dname);
}

void
ank_texturen(float prozent, char *dateiname, char *name)
{
  longint Nr = 0;
  texturen *old = NULL;

  if (textanf == NULL)
    {
      textanf = new texturen(NULL, 1, name, dateiname, prozent);
      allocerror(textanf);
    }
  else
    {
      textx = textanf;
      while (textx)
	{
	  Nr = textx->nr + 1;
	  old = textx;
	  textx = textx->next;
	}
      old = new texturen(old, Nr, name, dateiname, prozent);
      allocerror(old);
    }
}

void
entf_texturen(longint Nr)
{
  texturen *old = NULL;
  longint x;

  if (textanf)
    {
      if (Nr == 1)
	{
	  old = textanf;
	  textanf = textanf->next;
	  old->next = NULL;
	  delete old;
	}
      else
	{
	  old = textx = textanf;
	  while (textx && (textx->nr != Nr))
	    {
	      old = textx;
	      textx = textx->next;
	    }
	  old->next = textx->next;
	  textx->next = NULL;
	  delete textx;
	}

      // neu Durchnummerieren!
      textx = textanf;
      x = 1;
      while (textx)
	{
	  textx->nr = x++;
	  textx = textx->next;
	}
    }
}

cadmuster::cadmuster(cadmuster * Mx, longint Nr, char *Name, float R1, float B1, float G1,
	  float R2, float B2, float G2, float Mix, int Art, int Fehler,
	  float X, float Y)
{
  // einketten
  if (Mx != NULL)
    Mx->next = this;
  next = NULL;

  nr = Nr;
  strcpy(name, Name);

  r1 = R1;
  b1 = B1;
  g1 = G1;
  r2 = R2;
  b2 = B2;
  g2 = G2;
  mix = Mix;
  x = X;
  y = Y;
  art = Art;
  fehler = Fehler;
}

void
ank_muster(char *Name, float R1, float B1, float G1,
	   float R2, float B2, float G2, float Mix, int Art, int Fehler,
	   float X, float Y)
{
  longint Nr = 0;
  cadmuster *old = NULL;

  if (mustanf == NULL)
    {
      mustanf = new cadmuster(NULL, 1, Name, R1, B1, G1, R2, B2, G2, Mix, Art, Fehler, X, Y);
      allocerror(mustanf);
    }
  else
    {
      mustx = mustanf;
      while (mustx)
	{
	  Nr = mustx->nr + 1;
	  old = mustx;
	  mustx = mustx->next;
	}
      old = new cadmuster(old, Nr, Name, R1, B1, G1, R2, B2, G2, Mix, Art, Fehler, X, Y);
      allocerror(old);
    }
}

void
entf_muster(longint Nr)
{
  cadmuster *old = NULL;
  longint x;

  if (mustanf)
    {
      if (Nr == 1)
	{
	  old = mustanf;
	  mustanf = mustanf->next;
	  old->next = NULL;
	  delete old;
	}
      else
	{
	  old = mustx = mustanf;
	  while (mustx && (mustx->nr != Nr))
	    {
	      old = mustx;
	      mustx = mustx->next;
	    }
	  old->next = mustx->next;
	  mustx->next = NULL;
	  delete mustx;
	}

      // neu Durchnummerieren!
      mustx = mustanf;
      x = 1;
      while (mustx)
	{
	  mustx->nr = x++;
	  mustx = mustx->next;
	}
    }
}

text3d::text3d(text3d * Mx, longint Nr, float R1, float B1, float G1, float R2,
       float B2, float G2,
       float Mix, float Abs, int Art, int Fehler, int Anz,
       vector D, vector R, char *Name)
{
  // einketten
  if (Mx != NULL)
    Mx->next = this;
  next = NULL;

  nr = Nr;

  r1 = R1;
  b1 = B1;
  g1 = G1;
  r2 = R2;
  b2 = B2;
  g2 = G2;
  mix = Mix;
  abs = Abs;
  art = Art;
  fehler = Fehler;
  anz = Anz;
  d = D;
  r = R;
  strcpy(name, Name);
}

void
ank_text3d(float R1, float B1, float G1, float R2,
	   float B2, float G2,
	   float Mix, float Abs, int Art, int Fehler, int Anz,
	   vector D, vector R, char *Name)
{
  longint Nr = 0;
  text3d *old = NULL;

  if (text3danf == NULL)
    {
      text3danf = new text3d(NULL, 1, R1, B1, G1, R2, B2, G2, Mix, Abs, Art, Fehler, Anz, D, R,
			     Name);
      allocerror(text3danf);
    }
  else
    {
      text3dx = text3danf;
      while (text3dx)
	{
	  Nr = text3dx->nr + 1;
	  old = text3dx;
	  text3dx = text3dx->next;
	}
      old = new text3d(old, Nr, R1, B1, G1, R2, B2, G2, Mix, Abs, Art, Fehler, Anz, D, R,
		       Name);
      allocerror(old);
    }
}

void
entf_text3d(longint Nr)
{
  text3d *old = NULL;
  longint x;

  if (text3danf)
    {
      if (Nr == 1)
	{
	  old = text3danf;
	  text3danf = text3danf->next;
	  old->next = NULL;
	  delete old;
	}
      else
	{
	  old = text3dx = text3danf;
	  while (text3dx && (text3dx->nr != Nr))
	    {
	      old = text3dx;
	      text3dx = text3dx->next;
	    }
	  old->next = text3dx->next;
	  text3dx->next = NULL;
	  delete text3dx;
	}

      // neu Durchnummerieren!
      text3dx = text3danf;
      x = 1;
      while (text3dx)
	{
	  text3dx->nr = x++;
	  text3dx = text3dx->next;
	}
    }
}

cadwave::cadwave(cadwave * Mx, longint Nr, char *Name,
	float X1, float Y1, float Z1, float Freq1, float Amp1, float Damp1, float D1,
	float X2, float Y2, float Z2, float Freq2, float Amp2, float Damp2, float D2,
	float X3, float Y3, float Z3, float Freq3, float Amp3, float Damp3, float D3)
{
  // einketten
  if (Mx != NULL)
    Mx->next = this;
  next = NULL;

  nr = Nr;
  strcpy(name, Name);

  x1 = X1;
  y1 = Y1;
  z1 = Z1;
  freq1 = Freq1;
  amp1 = Amp1;
  damp1 = Damp1;
  d1 = D1;
  x2 = X2;
  y2 = Y2;
  z2 = Z2;
  freq2 = Freq2;
  amp2 = Amp2;
  damp2 = Damp2;
  d2 = D2;
  x3 = X3;
  y3 = Y3;
  z3 = Z3;
  freq3 = Freq3;
  amp3 = Amp3;
  damp3 = Damp3;
  d3 = D3;
}

void
ank_wave(char *Name,
	 float X1, float Y1, float Z1, float Freq1, float Amp1, float Damp1, float D1,
	 float X2, float Y2, float Z2, float Freq2, float Amp2, float Damp2, float D2,
	 float X3, float Y3, float Z3, float Freq3, float Amp3, float Damp3, float D3)
{
  longint Nr = 0;
  cadwave *old = NULL;

  if (waveanf == NULL)
    {
      waveanf = new cadwave(NULL, 1, Name,
			    X1, Y1, Z1, Freq1, Amp1, Damp1, D1,
			    X2, Y2, Z2, Freq2, Amp2, Damp2, D2,
			    X3, Y3, Z3, Freq3, Amp3, Damp3, D3);
      allocerror(waveanf);
    }
  else
    {
      wavex = waveanf;
      while (wavex)
	{
	  Nr = wavex->nr + 1;
	  old = wavex;
	  wavex = wavex->next;
	}
      old = new cadwave(old, Nr, Name,
			X1, Y1, Z1, Freq1, Amp1, Damp1, D1,
			X2, Y2, Z2, Freq2, Amp2, Damp2, D2,
			X3, Y3, Z3, Freq3, Amp3, Damp3, D3);
      allocerror(old);
    }
}

void
entf_wave(longint Nr)
{
  cadwave *old = NULL;
  longint x;

  if (waveanf)
    {
      if (Nr == 1)
	{
	  old = waveanf;
	  waveanf = waveanf->next;
	  old->next = NULL;
	  delete old;
	}
      else
	{
	  old = wavex = waveanf;
	  while (wavex && (wavex->nr != Nr))
	    {
	      old = wavex;
	      wavex = wavex->next;
	    }
	  old->next = wavex->next;
	  wavex->next = NULL;
	  delete wavex;
	}

      // neu Durchnummerieren!
      wavex = waveanf;
      x = 1;
      while (wavex)
	{
	  wavex->nr = x++;
	  wavex = wavex->next;
	}
    }
}


cadcover::cadcover(cadcover * Mx, longint Nr, float Tx1, float Tx2, float Ty1, float Ty2,
	 float Movx, float Movy, float Scal,
	 int Text1, int Text2, int Text3, int Text4, int Must1, int Must2,
		   int Must3, int Must4,
	 int Turbart, int Normalv, int Freq, longint Wavenr, longint Text3dnr)
{
  // einketten
  if (Mx != NULL)
    Mx->next = this;
  next = NULL;

  nr = Nr;

  tx1 = Tx1;
  tx2 = Tx2;
  ty1 = Ty1;
  ty2 = Ty2;
  movx = Movx;
  movy = Movy;
  scal = Scal;
  text1 = Text1;
  text2 = Text2;
  text3 = Text3;
  text4 = Text4;
  must1 = Must1;
  must2 = Must2;
  must3 = Must3;
  must4 = Must4;
  turbart = Turbart;
  normalv = Normalv;
  freq = Freq;
  wavenr = Wavenr;
  text3dnr = Text3dnr;
}


void
ank_cover(float Tx1, float Tx2, float Ty1, float Ty2,
	  float Movx, float Movy, float Scal,
	  int Text1, int Text2, int Text3, int Text4, int Must1, int Must2,int Must3, int Must4,
	  int Turbart, int Normalv, int Freq, longint Wavenr, longint Text3dnr)
{
  longint Nr = 0;
  cadcover *old = NULL;

  if (coveranf == NULL)
    {
      coveranf = new cadcover(NULL, 1, Tx1, Tx2, Ty1, Ty2,
			      Movx, Movy, Scal, Text1, Text2, Text3, Text4, 
			      Must1, Must2, Must3, Must4,
			      Turbart, Normalv, Freq, Wavenr, Text3dnr);
      allocerror(coveranf);
    }
  else
    {
      coverx = coveranf;
      while (coverx)
	{
	  Nr = coverx->nr + 1;
	  old = coverx;
	  coverx = coverx->next;
	} 
      old = new cadcover(old, Nr, Tx1, Tx2, Ty1, Ty2,
			 Movx, Movy, Scal, Text1, Text2, Text3, Text4, Must1, Must2,Must3, Must4,
			 Turbart, Normalv, Freq, Wavenr, Text3dnr);
      allocerror(old);
    }
}

void
entf_cover(longint Nr)
{
  cadcover *old = NULL;
  longint x;

  if (coveranf)
    {
      if (Nr == 1)
	{
	  old = coveranf;
	  coveranf = coveranf->next;
	  old->next = NULL;
	  delete old;
	}
      else
	{
	  old = coverx = coveranf;
	  while (coverx && (coverx->nr != Nr))
	    {
	      old = coverx;
	      coverx = coverx->next;
	    }
	  old->next = coverx->next;
	  coverx->next = NULL;
	  delete coverx;
	}

      // neu Durchnummerieren!
      coverx = coveranf;
      x = 1;
      while (coverx)
	{
	  coverx->nr = x++;
	  coverx = coverx->next;
	}
    }
}
