/*  
   Dialogbox fr Cover
   Copyright (C) 1996, 1997 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"

STRING helpcoverdialog =
"Definition der Oberflchenstruktur fr Objekte.";

struct coverstruktur CoverDialog;
Widget WCoverDialog, Coverxp1, Coverxp2, Coverxp3, Coverxp4, Coveryp1, Coveryp2, Coververx,
  Coververy, Coverscal, Coveranzf, CoverTextureMLabel, CoverTextureVLabel,
  CoverTextureSLabel,  CoverTextureBLabel,
  CoverMusterMLabel, CoverMusterVLabel, CoverMusterSLabel, CoverMusterBLabel, 
  CoverWaveLabel, CoverText3dLabel;

int Art;

void
CoverDialog_init(float Tx1, float Tx2, float Ty1, float Ty2, float Movx, float Movy,
		 float Scal, 
		 int Text1, int Text2, int Text3, int Text4, 
		 int Must1, int Must2, int Must3, int Must4, 
		 int Turbart, int Normalv, int Freq, longint Wavenr, longint Text3dnr)
{
  CoverDialog.tx1 = Tx1;
  CoverDialog.tx2 = Tx2;
  CoverDialog.ty1 = Ty1;
  CoverDialog.ty2 = Ty2;
  CoverDialog.movx = Movx;
  CoverDialog.movy = Movy;
  CoverDialog.scal = Scal;
  CoverDialog.text1 = Text1;
  CoverDialog.text2 = Text2;
  CoverDialog.text3 = Text3;
  CoverDialog.text4 = Text4;
  CoverDialog.must1 = Must1;
  CoverDialog.must2 = Must2;
  CoverDialog.must3 = Must3;
  CoverDialog.must4 = Must4;
  CoverDialog.turbart = Turbart;
  CoverDialog.normalv = Normalv;
  CoverDialog.freq = Freq;
  CoverDialog.wavenr = Wavenr;
  CoverDialog.text3dnr = Text3dnr;
}

void
CoverDialog_get(float *Tx1, float *Tx2, float *Ty1, float *Ty2, float *Movx,
		float *Movy, float *Scal, 
		int *Text1, int *Text2, int *Text3, int *Text4, 
		int *Must1, int *Must2, int *Must3, int *Must4, 
		int *Turbart, int *Normalv, int *Freq, longint * Wavenr,
		longint * Text3dnr)
{
  *Tx1 = CoverDialog.tx1;
  *Tx2 = CoverDialog.tx2;
  *Ty1 = CoverDialog.ty1;
  *Ty2 = CoverDialog.ty2;
  *Movx = CoverDialog.movx;
  *Movy = CoverDialog.movy;
  *Scal = CoverDialog.scal;
  *Text1 = CoverDialog.text1;
  *Text2 = CoverDialog.text2;
  *Text3 = CoverDialog.text3;
  *Text4 = CoverDialog.text4;
  *Must1 = CoverDialog.must1;
  *Must2 = CoverDialog.must2;
  *Must3 = CoverDialog.must3;
  *Must4 = CoverDialog.must4;
  *Turbart = CoverDialog.turbart;
  *Normalv = CoverDialog.normalv;
  *Freq = CoverDialog.freq;
  *Wavenr = CoverDialog.wavenr;
  *Text3dnr = CoverDialog.text3dnr;
}

void
delete_cover_listen(void)
{
  int x, anzelem;

  for (anzelem = 0, mustx = mustanf; mustx; anzelem++, mustx = mustx->next);
  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(CoverDialog.pMusterStr[x]);

  for (anzelem = 0, textx = textanf; textx; anzelem++, textx = textx->next);
  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(CoverDialog.pTextureStr[x]);

  for (anzelem = 0, wavex = waveanf; wavex; anzelem++, wavex = wavex->next);
  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(CoverDialog.pWaveStr[x]);

  for (anzelem = 0, text3dx = text3danf; text3dx; anzelem++, text3dx = text3dx->next);
  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(CoverDialog.pText3dStr[x]);

  anzelem = 0;
}

void
CBCoverOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;

  /* Text Widgets auslesen */
  str = XmTextGetString(Coverxp1);
  sscanf(str, "%f", &CoverDialog.tx1);

  str = XmTextGetString(Coverxp2);
  sscanf(str, "%f", &CoverDialog.tx2);

  str = XmTextGetString(Coveryp1);
  sscanf(str, "%f", &CoverDialog.ty1);

  str = XmTextGetString(Coveryp2);
  sscanf(str, "%f", &CoverDialog.ty2);

  str = XmTextGetString(Coververx);
  sscanf(str, "%f", &CoverDialog.movx);
  // XmStringFree((XmString)str);

  str = XmTextGetString(Coververy);
  sscanf(str, "%f", &CoverDialog.movy);
  // XmStringFree((XmString)str);

  str = XmTextGetString(Coveranzf);
  sscanf(str, "%d", &CoverDialog.freq);
  // XmStringFree((XmString)str);

  str = XmTextGetString(Coverscal);
  sscanf(str, "%f", &CoverDialog.scal);
  // XmStringFree((XmString)str);

  if (Art == NEU)
    ank_cover(CoverDialog.tx1, CoverDialog.tx2, CoverDialog.ty1, CoverDialog.ty2,
	      CoverDialog.movx, CoverDialog.movy, CoverDialog.scal,
	      CoverDialog.text1, CoverDialog.text2, CoverDialog.text2, CoverDialog.text3, 
	      CoverDialog.must1, CoverDialog.must2, CoverDialog.must3, CoverDialog.must4,
	      CoverDialog.turbart, CoverDialog.normalv, CoverDialog.freq, CoverDialog.wavenr,
	      CoverDialog.text3dnr);
  else if (Art == AENDER)
    {
      CoverDialog_get(&coverx->tx1, &coverx->tx2, &coverx->ty1, &coverx->ty2,
		      &coverx->movx, &coverx->movy, &coverx->scal,
	     &coverx->text1, &coverx->text2, &coverx->text3, &coverx->text4, 
		      &coverx->must1, &coverx->must2,&coverx->must3, &coverx->must4,
	 &coverx->turbart, &coverx->normalv, &coverx->freq, &coverx->wavenr,
		      &coverx->text3dnr);
    }

  delete_cover_listen();

  /* Dialog schlieen */
  XtUnmanageChild(WCoverDialog);
  WCoverDialog = NULL;
}

void
CBCoverCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  delete_cover_listen();
  XtUnmanageChild(WCoverDialog);
  WCoverDialog = NULL;
}

void
CBCoverHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpcoverdialog);
  else
    infobox("helpnureinmal");
}

void
CBTextureMuster(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[80];
  XmString anzstr;
  Arg Aargs;

  CoverDialog.text1 = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", CoverDialog.text1);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(CoverTextureMLabel, &Aargs, 1);
  strcpy(CoverDialog.texturelabelf, cpos);
}

void
CBMusterM(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[80];
  XmString anzstr;
  Arg Aargs;

  CoverDialog.must1 = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", CoverDialog.must1);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(CoverMusterMLabel, &Aargs, 1);
  strcpy(CoverDialog.musterlabelf, cpos);
}

void
CBTextureVector(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[80];
  XmString anzstr;
  Arg Aargs;

  CoverDialog.text2 = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", CoverDialog.text2);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(CoverTextureVLabel, &Aargs, 1);
  strcpy(CoverDialog.texturelabelv, cpos);
}

void CBTextureSpiegelnd(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[80];
  XmString anzstr;
  Arg Aargs;

  CoverDialog.text3 = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", CoverDialog.text3);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(CoverTextureSLabel, &Aargs, 1);
  strcpy(CoverDialog.texturelabels, cpos);
}

void
CBTextureBrechend(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[80];
  XmString anzstr;
  Arg Aargs;

  CoverDialog.text4 = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", CoverDialog.text4);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(CoverTextureBLabel, &Aargs, 1);
  strcpy(CoverDialog.texturelabelb, cpos);
}

void
CBMusterV(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[80];
  XmString anzstr;
  Arg Aargs;

  CoverDialog.must2 = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", CoverDialog.must2);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(CoverMusterVLabel, &Aargs, 1);
  strcpy(CoverDialog.musterlabelv, cpos);
}

void
CBMusterS(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[80];
  XmString anzstr;
  Arg Aargs;

  CoverDialog.must3 = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", CoverDialog.must3);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(CoverMusterSLabel, &Aargs, 1);
  strcpy(CoverDialog.musterlabels, cpos);
}

void
CBMusterB(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[80];
  XmString anzstr;
  Arg Aargs;

  CoverDialog.must4 = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", CoverDialog.must4);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(CoverMusterBLabel, &Aargs, 1);
  strcpy(CoverDialog.musterlabelb, cpos);
}

void
CBWave(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[80];
  XmString anzstr;
  Arg Aargs;

  CoverDialog.wavenr = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%ld", CoverDialog.wavenr);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(CoverWaveLabel, &Aargs, 1);
  strcpy(CoverDialog.wavelabel, cpos);
}

void
CBText3d(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[80];
  XmString anzstr;
  Arg Aargs;

  CoverDialog.text3dnr = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%ld", CoverDialog.text3dnr);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(CoverText3dLabel, &Aargs, 1);
  strcpy(CoverDialog.text3dlabel, cpos);
}

void
CBButtonT(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /*  nur einschalten ist interresant */
  if (((XmToggleButtonCallbackStruct *) pCallData)->set)
    CoverDialog.turbart = *(int *) pClientData - 1;
}

void
CBNormalv(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  CoverDialog.normalv = ((XmToggleButtonCallbackStruct *) pCallData)->set;
}

void
create_cover_listen(void)
{
  char str[256];
  int x = 0, anzelem = 0;

  /* TextureListe */
  if (textanf)
    {
      textx = textanf;
      while (textx)
	{
	  anzelem = textx->nr;
	  textx = textx->next;
	}
      CoverDialog.anztexture = anzelem + 1;
      CoverDialog.pTextureStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Texturen durchlaufen */
      textx = textanf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      CoverDialog.pTextureStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (textx)
	{
	  sprintf(str, "%ld: %s", textx->nr, textx->name);	/* C String erzeugen */
	  CoverDialog.pTextureStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  textx = textx->next;
	  x++;
	}
    }
  else
    {
      /* nur Dummy */
      CoverDialog.anztexture = 1;
      CoverDialog.pTextureStr = (XmString *) XtMalloc(sizeof(XmString));
      strcpy(str, "0: keine");
      CoverDialog.pTextureStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }


  /* Musterliste */
  if (mustanf)
    {
      mustx = mustanf;
      while (mustx)
	{
	  anzelem = mustx->nr;
	  mustx = mustx->next;
	}
      CoverDialog.anzmuster = anzelem + 1;
      CoverDialog.pMusterStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      mustx = mustanf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "kein");	/* C String erzeugen */
      CoverDialog.pMusterStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (mustx)
	{
	  sprintf(str, "%ld: %s", mustx->nr, mustx->name);	/* C String erzeugen */
	  CoverDialog.pMusterStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  mustx = mustx->next;
	  x++;
	}
    }
  else
    {
      CoverDialog.anzmuster = 1;
      CoverDialog.pMusterStr = (XmString *) XtMalloc(sizeof(XmString));
      /* Dummy fr kein */
      strcpy(str, "0: kein");
      CoverDialog.pMusterStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }

  /* Waveliste */
  if (waveanf)
    {
      wavex = waveanf;
      while (wavex)
	{
	  anzelem = wavex->nr;
	  wavex = wavex->next;
	}
      CoverDialog.anzwave = anzelem + 1;
      CoverDialog.pWaveStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      wavex = waveanf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      CoverDialog.pWaveStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (wavex)
	{
	  sprintf(str, "%ld: %s", wavex->nr, wavex->name);	/* C String erzeugen */
	  CoverDialog.pWaveStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  wavex = wavex->next;
	  x++;
	}
    }
  else
    {
      CoverDialog.anzwave = 1;
      CoverDialog.pWaveStr = (XmString *) XtMalloc(sizeof(XmString));
      /* Dummy fr kein */
      strcpy(str, "0: keine");
      CoverDialog.pWaveStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }

  /* Text3dliste */
  if (text3danf)
    {
      text3dx = text3danf;
      while (text3dx)
	{
	  anzelem = text3dx->nr;
	  text3dx = text3dx->next;
	}
      CoverDialog.anztext3d = anzelem + 1;
      CoverDialog.pText3dStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      text3dx = text3danf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      CoverDialog.pText3dStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (text3dx)
	{
	  sprintf(str, "%ld: %s", text3dx->nr, text3dx->name);	/* C String erzeugen */
	  CoverDialog.pText3dStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  text3dx = text3dx->next;
	  x++;
	}
    }
  else
    {
      CoverDialog.anztext3d = 1;
      CoverDialog.pText3dStr = (XmString *) XtMalloc(sizeof(XmString));
      /* Dummy fr kein */
      strcpy(str, "0: keine");
      CoverDialog.pText3dStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }
}

void
coverdialog(Widget W, int art)
{

  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    WRowCol4, WRowCol5, WRowCol6, WRowCol7, WRowCol8, WRowCol9, WRowCol10,
    WRowCol11, WRowCol12, WRowCol13, WRowCol14, WLabel1, WLabel2, WLabel3,
    frame1, frame2, frame3, frame4, frame5, frame6, frame7, frame8, frame9,
    frame10, frame11, frame12, WTextM, WTextV, WMusterM, WMusterV, AWButtonT[4],
    WRadioBoxT, WNorm, WWave, WText3d, frame31, WRowCol51, WRowCol52, WTextS, frame32,
    WTextB, frame71, WRowCol91, WMusterS, frame72, WRowCol92, WMusterB;

  Arg Aargs[MAX_ARGS];
  int nArgs, nButton;
  char str[15];

  /* Definitionen */
  static int AiButtonID[] =
  {
    1, 2, 3, 4
  };

  Art = art;

  /* Textur und Musterlisten erzeugen */
  create_cover_listen();
  sprintf(CoverDialog.texturelabelf, "%d", CoverDialog.text1);
  sprintf(CoverDialog.texturelabelv, "%d", CoverDialog.text2);
  sprintf(CoverDialog.texturelabels, "%d", CoverDialog.text3);
  sprintf(CoverDialog.texturelabelb, "%d", CoverDialog.text4);
  sprintf(CoverDialog.musterlabelf, "%d", CoverDialog.must1);
  sprintf(CoverDialog.musterlabelv, "%d", CoverDialog.must2);
  sprintf(CoverDialog.musterlabels, "%d", CoverDialog.must3);
  sprintf(CoverDialog.musterlabelb, "%d", CoverDialog.must4);
  sprintf(CoverDialog.wavelabel, "%ld", CoverDialog.wavenr);
  sprintf(CoverDialog.text3dlabel, "%ld", CoverDialog.text3dnr);

  /* Der Dialog */
  WCoverDialog = XmCreateDialogShell(W, "coverdialog", NULL, 0);
  XtManageChild(WCoverDialog);

  /* Umrahmung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 700);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 550);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WCoverDialog, "coverrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  /* Umrahmung fr Texturen */
  frame1 = XtCreateManagedWidget("coverframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(frame1, "coverrow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  /* Texture fr Muster auswhlen */
  frame2 = XtCreateManagedWidget("coverframe2", xmFrameWidgetClass, WRowCol2, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol4 = XmCreateRowColumn(frame2, "coverrow4", Aargs, nArgs);
  XtManageChild(WRowCol4);

  CoverTextureMLabel =
    XtCreateManagedWidget(CoverDialog.texturelabelf, xmLabelWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, CoverDialog.pTextureStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, CoverDialog.anztexture);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WTextM = XmCreateScrolledList(WRowCol4, "covertextmlist", Aargs, nArgs);
  XtAddCallback(WTextM, XmNdefaultActionCallback, (XtCallbackProc) CBTextureMuster, NULL);
  XtManageChild(WTextM);

  /* Texture fr Farbnderung auswhlen */
  frame3 = XtCreateManagedWidget("coverframe3", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol5 = XmCreateRowColumn(frame3, "coverrow5", NULL, 0);
  XtManageChild(WRowCol5);
  CoverTextureVLabel =
    XtCreateManagedWidget(CoverDialog.texturelabelv, xmLabelWidgetClass, WRowCol5, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, CoverDialog.pTextureStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, CoverDialog.anztexture);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WTextV = XmCreateScrolledList(WRowCol5, "covertextvlist", Aargs, nArgs);
  XtAddCallback(WTextV, XmNdefaultActionCallback, (XtCallbackProc) CBTextureVector, NULL);
  XtManageChild(WTextV);

  /* Texture fr Spiegelung auswhlen */
  frame31 = XtCreateManagedWidget("coverframe31", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol51 = XmCreateRowColumn(frame31, "coverrow5", NULL, 0);
  XtManageChild(WRowCol51);
  CoverTextureSLabel =
    XtCreateManagedWidget(CoverDialog.texturelabels, xmLabelWidgetClass, WRowCol51, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, CoverDialog.pTextureStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, CoverDialog.anztexture);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WTextS = XmCreateScrolledList(WRowCol51,"covertextslist", Aargs, nArgs);
  XtAddCallback(WTextS, XmNdefaultActionCallback, (XtCallbackProc) CBTextureSpiegelnd, NULL);
  XtManageChild(WTextS);

  /* Texture fr Brechnung auswhlen */
  frame32 = XtCreateManagedWidget("coverframe32", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol52 = XmCreateRowColumn(frame32, "coverrow5", NULL, 0);
  XtManageChild(WRowCol52);
  CoverTextureBLabel =
    XtCreateManagedWidget(CoverDialog.texturelabelb, xmLabelWidgetClass, WRowCol52, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, CoverDialog.pTextureStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, CoverDialog.anztexture);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WTextB = XmCreateScrolledList(WRowCol52, "covertextblist", Aargs, nArgs);
  XtAddCallback(WTextB, XmNdefaultActionCallback, (XtCallbackProc) CBTextureBrechend, NULL);
  XtManageChild(WTextB);


  /* den Ausschnitt einlesen */
  frame4 = XtCreateManagedWidget("coverframe4", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol6 = XmCreateRowColumn(frame4, "coverrow6", NULL, 0);
  XtManageChild(WRowCol6);
  WLabel1 = XtCreateManagedWidget("x1, x2, y1, y2", xmLabelWidgetClass, WRowCol6, NULL, 0);
  sprintf(str, "%0.2f", CoverDialog.tx1);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 14);
  nArgs++;
  Coverxp1 = XtCreateManagedWidget("coverx1", xmTextWidgetClass, WRowCol6, Aargs, nArgs);
  sprintf(str, "%0.2f", CoverDialog.tx2);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 14);
  nArgs++;
  Coverxp2 = XtCreateManagedWidget("coverx2", xmTextWidgetClass, WRowCol6, Aargs, nArgs);
  sprintf(str, "%0.2f", CoverDialog.ty1);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 14);
  nArgs++;
  Coveryp1 = XtCreateManagedWidget("covery1", xmTextWidgetClass, WRowCol6, Aargs, nArgs);
  sprintf(str, "%0.2f", CoverDialog.ty2);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 14);
  nArgs++;
  Coveryp2 = XtCreateManagedWidget("covery2", xmTextWidgetClass, WRowCol6, Aargs, nArgs);

  /* Oberflchengestaltung mit Muster */
  frame5 = XtCreateManagedWidget("coverframe5", xmFrameWidgetClass, WRowCol1, NULL, 0);
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol7 = XmCreateRowColumn(frame5, "coverrow7", Aargs, nArgs);
  XtManageChild(WRowCol7);

  /* Muster fr Farbnderung auswhlen */
  frame6 = XtCreateManagedWidget("coverframe6", xmFrameWidgetClass, WRowCol7, NULL, 0);
  WRowCol8 = XmCreateRowColumn(frame6, "coverrow8", NULL, 0);
  XtManageChild(WRowCol8);
  CoverMusterMLabel =
    XtCreateManagedWidget(CoverDialog.musterlabelf, xmLabelWidgetClass, WRowCol8, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, CoverDialog.pMusterStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, CoverDialog.anzmuster);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WMusterM = XmCreateScrolledList(WRowCol8, "covermustmlist", Aargs, nArgs);
  XtAddCallback(WMusterM, XmNdefaultActionCallback, (XtCallbackProc) CBMusterM, NULL);
  XtManageChild(WMusterM);

  /* Muster fr Vector auswhlen */
  frame7 = XtCreateManagedWidget("coverframe7", xmFrameWidgetClass, WRowCol7, NULL, 0);
  WRowCol9 = XmCreateRowColumn(frame7, "coverrow9", NULL, 0);
  XtManageChild(WRowCol9);
  CoverMusterVLabel =
    XtCreateManagedWidget(CoverDialog.musterlabelv, xmLabelWidgetClass, WRowCol9, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, CoverDialog.pMusterStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, CoverDialog.anzmuster);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WMusterV = XmCreateScrolledList(WRowCol9, "covermustvlist", Aargs, nArgs);
  XtAddCallback(WMusterV, XmNdefaultActionCallback, (XtCallbackProc) CBMusterV, NULL);
  XtManageChild(WMusterV);

  /* Muster fr Spiegelung auswhlen */
  frame71 = XtCreateManagedWidget("coverframe71", xmFrameWidgetClass, WRowCol7, NULL, 0);
  WRowCol91 = XmCreateRowColumn(frame71, "coverrow91", NULL, 0);
  XtManageChild(WRowCol91);
  CoverMusterSLabel =
    XtCreateManagedWidget(CoverDialog.musterlabels, xmLabelWidgetClass, WRowCol91, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, CoverDialog.pMusterStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, CoverDialog.anzmuster);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WMusterS = XmCreateScrolledList(WRowCol91, "covermustvlist", Aargs, nArgs);
  XtAddCallback(WMusterS, XmNdefaultActionCallback, (XtCallbackProc) CBMusterS, NULL);
  XtManageChild(WMusterS);

  /* Muster fr Brechung auswhlen */
  frame72 = XtCreateManagedWidget("coverframe72", xmFrameWidgetClass, WRowCol7, NULL, 0);
  WRowCol92 = XmCreateRowColumn(frame72, "coverrow91", NULL, 0);
  XtManageChild(WRowCol92);
  CoverMusterBLabel =
    XtCreateManagedWidget(CoverDialog.musterlabelb, xmLabelWidgetClass, WRowCol92, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, CoverDialog.pMusterStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, CoverDialog.anzmuster);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WMusterB = XmCreateScrolledList(WRowCol92, "covermustvlist", Aargs, nArgs);
  XtAddCallback(WMusterB, XmNdefaultActionCallback, (XtCallbackProc) CBMusterB, NULL);
  XtManageChild(WMusterB);



  frame8 = XtCreateManagedWidget("coverframe8", xmFrameWidgetClass, WRowCol7, NULL, 0);
  WRowCol10 = XmCreateRowColumn(frame8, "coverrow10", NULL, 0);
  XtManageChild(WRowCol10);
  WLabel2 = XtCreateManagedWidget("x y Versch.", xmLabelWidgetClass, WRowCol10, NULL, 0);
  sprintf(str, "%0.2f", CoverDialog.movx);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 14);
  nArgs++;
  Coververx = XtCreateManagedWidget("coververx", xmTextWidgetClass, WRowCol10, Aargs, nArgs);
  sprintf(str, "%0.2f", CoverDialog.movy);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNcolumns, 14);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  Coververy = XtCreateManagedWidget("coververy", xmTextWidgetClass, WRowCol10, Aargs, nArgs);

  /* Text3d Wave und Turbolenzen */
  frame9 = XtCreateManagedWidget("coverframe9", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol11 = XmCreateRowColumn(frame9, "coverrow11", Aargs, nArgs);
  XtManageChild(WRowCol11);

  /* Texture 3D */
  frame11 = XtCreateManagedWidget("coverframe10", xmFrameWidgetClass, WRowCol11, NULL, 0);
  WRowCol13 = XmCreateRowColumn(frame11, "coverrow13", NULL, 0);
  XtManageChild(WRowCol13);
  CoverText3dLabel =
    XtCreateManagedWidget(CoverDialog.text3dlabel, xmLabelWidgetClass, WRowCol13, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, CoverDialog.pText3dStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, CoverDialog.anztext3d);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WText3d = XmCreateScrolledList(WRowCol13, "covertext3dlist", Aargs, nArgs);
  XtAddCallback(WText3d, XmNdefaultActionCallback, (XtCallbackProc) CBText3d, NULL);
  XtManageChild(WText3d);

  /* Wave */
  frame12 = XtCreateManagedWidget("coverframe11", xmFrameWidgetClass, WRowCol11, NULL, 0);
  WRowCol14 = XmCreateRowColumn(frame12, "coverrow13", NULL, 0);
  XtManageChild(WRowCol14);
  CoverWaveLabel =
    XtCreateManagedWidget(CoverDialog.wavelabel, xmLabelWidgetClass, WRowCol14, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, CoverDialog.pWaveStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, CoverDialog.anzwave);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WWave = XmCreateScrolledList(WRowCol14, "coverwavelist", Aargs, nArgs);
  XtAddCallback(WWave, XmNdefaultActionCallback, (XtCallbackProc) CBWave, NULL);
  XtManageChild(WWave);

  /* Turbolenzarten */
  /* RadioBox erzeugen die Togglebuttons als Kinder hat */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNentryClass, xmToggleButtonWidgetClass);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRadioBoxT = XmCreateRadioBox(WRowCol11, "coverradiobox", Aargs, nArgs);
  XtManageChild(WRadioBoxT);
  /* 4 Togglebuttons erzeugen */
  if (CoverDialog.turbart < 0 || CoverDialog.turbart > 4)
    CoverDialog.turbart = 0;
  nButton = 0;
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (CoverDialog.turbart + 1) == 1);
  nArgs++;
  AWButtonT[nButton++] =
    XtCreateManagedWidget("kein", xmToggleButtonWidgetClass, WRadioBoxT, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (CoverDialog.turbart + 1) == 2);
  nArgs++;
  AWButtonT[nButton++] =
    XtCreateManagedWidget("Muster", xmToggleButtonWidgetClass, WRadioBoxT, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (CoverDialog.turbart + 1) == 3);
  nArgs++;
  AWButtonT[nButton++] =
    XtCreateManagedWidget("Farbe", xmToggleButtonWidgetClass, WRadioBoxT, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (CoverDialog.turbart + 1) == 4);
  nArgs++;
  AWButtonT[nButton++] =
    XtCreateManagedWidget("Beides", xmToggleButtonWidgetClass, WRadioBoxT, Aargs, nArgs);
  /* Callbacks fr alle Buttons */
  for (nButton = 0; nButton < 4; nButton++)
    XtAddCallback(AWButtonT[nButton], XmNvalueChangedCallback, CBButtonT, &AiButtonID[nButton]);

  /* ndern des Normalvektors */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, CoverDialog.normalv);
  nArgs++;
  WNorm =
    XtCreateManagedWidget("NormalVelt", xmToggleButtonWidgetClass, WRowCol11, Aargs, nArgs);
  XtAddCallback(WNorm, XmNvalueChangedCallback, (XtCallbackProc) CBNormalv, NULL);

  /* Scalierung */
  frame10 = XtCreateManagedWidget("coverframe10", xmFrameWidgetClass, WRowCol11, NULL, 0);
  WRowCol12 = XmCreateRowColumn(frame10, "coverrow6", NULL, 0);
  XtManageChild(WRowCol12);
  WLabel3 = XtCreateManagedWidget("Fq. S.", xmLabelWidgetClass, WRowCol12, NULL, 0);
  sprintf(str, "%d", CoverDialog.freq);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 14);
  nArgs++;
  Coveranzf = XtCreateManagedWidget("coveranzf", xmTextWidgetClass, WRowCol12, Aargs, nArgs);
  sprintf(str, "%0.2f", CoverDialog.scal);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 14);
  nArgs++;
  Coverscal = XtCreateManagedWidget("coverscal", xmTextWidgetClass, WRowCol12, Aargs, nArgs);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "coverrow3", Aargs, nArgs);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);

  XtManageChild(WButtonHelp);
  XtManageChild(WButtonCancel);
  XtManageChild(WButtonOK);
  XtManageChild(WRowCol3);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBCoverOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBCoverCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBCoverHelp, NULL);
}
