/*
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */
/* Callback-Funktionen fuer CAD-Tool */
//  Copyright (C) 1996 Helmut Fahrion

#include "cadtool.H"
#include "pextool.H"

#include <unistd.h>		// getlogin
#include <pwd.h>

char *LIZENZSTR =
"     Das CAD- Tool fr den Raytracer\n                Version 0.1\n\nWenn ich %s, \ndas Programm (oder eine darauf basierende \nArbeit) modifiziere oder verbreite, erklre ich \nmein Einverstndnis mit dieser Lizenz und allen \nihren Begriffen und Bedingungen zum Kopieren, \nVerbreiten und Modifizieren des Programms oder \neiner darauf basierenden Arbeit.\n\nThis program ist free software; you can redistribute \nist and/or modify it under the terms of the GNU \nGeneral Public License as publisched by the Free \nSoftware Foundation; either version 2 of the License, \nor (at your opption) any later version.\n\nThis program is distributed in the hope that it well \nbe useful, but WITHOUT ANY WARRANTY; without even the \nimplied warranty of MERCHANTABILITY or FITNESS FOR A \nPARTICULAR PURPOSE. See the GNU General Public License \nfor more details.\n\nYou should have received a copy of the GNU General \nPublic License along with this program; if not, write \nto the Free Software Foundation, Inc., 675 Mass Ave, \nCambridge, MA 02139, USA.\n\nDie GPL finden Sie in der HTML-Dokumentation.\n\nCopyright (C) 1996 Helmut Fahrion\n\nAls Student (ev. bis Januar 1997) bin ich erreichbar \nunter:\n   sfa2002@informatik.htw-dresden.de\n\nIn Verbindung mit dem Softwareprojekt:\n   nazca@vermessung.htw-dresden.de\n\nPost:\n   Helmut Fahrion jun.\n   An der Wyhra 35\n   04552 Borna\n   Germany\n";

char filehelptext[] =
"Der FileDialog\n\nMit Tab und Leertaste bewegen Sie sich von einem Element zum anderen.\nUnter Filter koennen Sie eine UNIX Suchmaske angeben.\nWenn Sie dan den Schalter Filter druecken werden nur die Dateien angezeigt die dieser Maske entsprechen.\nMit Fertig koennen Sie diesen Dialog schlieszen.";

/* die anzuwendende Operation auf ein grafisches Objekt */
int operation;
bool lichton, wurde_geloescht;

void
showhinweis(void)
{
  char text[3072], *un;		/* Puffer fr Text */
  char anonymous[] = "ANONYMOUS";
  struct passwd *pwd;

  if (!(pwd = getpwuid(getuid())))
    un = anonymous;
  else
    un = pwd->pw_gecos;

  if (!strlen(un))
    un = pwd->pw_name;		/* 0 Lnge in passwd */
  if (!strlen(un))
    un = anonymous;		/* 0 Lnge in passwd */

  sprintf(text, LIZENZSTR, un);
  helpfiledialog(WTop, text);
}

/* Exitroutine */
void
cadtoolexit()
{
  // gibt Speicher frei, eigentlich nicht noetig
  delete lichtanf;
  delete textanf;
  delete mustanf;
  delete waveanf;
  delete coveranf;
  oliste.destroy();

  XtCloseDisplay(XtDisplay(WTop));
  exit(GOOD);
}

/* Callbacks fuer die verschiedenen Menues */
void
CBRedraw(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* in pextool.c definiert */
  redraw(false);
}

void
CBsavemb(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  if (save_data(datei_name, false, false))
    cadtoolexit();
  else
    errorbox("Konnte Daten nicht sichern!");
}

void
CBnosavemb(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* Daten nicht gesichert */
  cadtoolexit();
}

void
CBhelpsavemb(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* MessageBox beenden! */
  XtUnmanageChild(W);
}

// void CBsaveSelect(Widget W, caddr_T pClientData, 
//                XmFileSelectionBoxCallbackStruct *pCallData)
void
CBsaveSelect(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING file_name;

  if (XmStringGetLtoR(((XmFileSelectionBoxCallbackStruct *) pCallData)->value,
		      XmSTRING_DEFAULT_CHARSET, &file_name))
    {
      strcpy(datei_name, file_name);

      if (save_data(datei_name, false, false))
	gespeichert = true;
      else
	{
	  gespeichert = false;
	  errorbox("Konnte Daten nicht sichern!");
	}
    }
  else
    errorbox("Filebox: kein File selektiert!\n");

  /* FileBox beenden! */
  XtUnmanageChild(W);
}

void
CBopenSelect(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING file_name;

  if (XmStringGetLtoR(((XmFileSelectionBoxCallbackStruct *) pCallData)->value,
		      XmSTRING_DEFAULT_CHARSET, &file_name))
    {
      strcpy(datei_name, file_name);

      if (open_data(datei_name))
	{
	  redraw(true);
	  gespeichert = true;
	}
      else
	{
	  gespeichert = false;
	  errorbox("Konnte Datei nicht ffnen!");
	}
    }
  else
    errorbox("Filebox: kein File selektiert!\n");
  /* FileBox beenden! */
  XtUnmanageChild(W);
}

void
CBsaveCancelSelect(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* FileBox beenden! */
  XtUnmanageChild(W);
}

void
CBFileHelpSelect(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal oeffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, filehelptext);
  else
    infobox("nureinmal");
}

void
starteditor(char *str)
{
  char xedit[] = "xedit";
  char command[80], *ed;
  char x;

  ed = getenv("EDITOR");

  if (!ed)
    {
      ed = xedit;
      fprintf(stderr, "startm: Bitte setzen sie die Umgebungsvariable EDITOR !\n");
    }

  x = strlen(ed);
  x += strlen(str);
  if (x >= 80)
    fprintf(stderr, "startm: Variable EDITOR ist zu gross!?\n");
  else
    {
      sprintf(command, "%s %s&\n", ed, str);
      system(command);
    }
}

void CBFile(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  Arg Aargs[MAX_ARGS];
  int nArgs;
  XmString mask, mstr;

  static Widget AWDialog, WFileSel;

  char kommando[256];

  switch (*(int *) pClientData)
    {
    case IDM_EXIT:
      if (!gespeichert)
	{
	  mstr = XmStringCreateLtoR("Abbruch", XmSTRING_DEFAULT_CHARSET);
	  nArgs = 0;
	  XtSetArg(Aargs[nArgs], XmNhelpLabelString, mstr);
	  nArgs++;
	  AWDialog = XmCreateQuestionDialog(WTop, "savefrage", Aargs, nArgs);

	  XtAddCallback(AWDialog, XmNokCallback, (XtCallbackProc) CBsavemb, (XtPointer) AWDialog);
	  XtAddCallback(AWDialog, XmNcancelCallback, (XtCallbackProc) CBnosavemb, (XtPointer) AWDialog);

	  /* Helpbutton als Abbruchbutton miszbrauchen */
	  XtAddCallback(AWDialog, XmNhelpCallback, (XtCallbackProc) CBhelpsavemb, (XtPointer) AWDialog);
	  XtManageChild(AWDialog);
	}
      else
	cadtoolexit();
      break;

    case IDM_SAVE:
      strcpy(datei_name, "scene.cad");
      if (!save_data(datei_name, false, false))
	errorbox("Konnte nicht speichern!");
      else
	gespeichert = true;
      break;

    case IDM_SAVERAY:
      strcpy(datei_name, "scene");
      if (!save_data(datei_name, true, false))
	errorbox("Konnte nicht speichern!");
      else
	gespeichert = true;
      break;

    case IDM_SAVESTAR:
      strcpy(datei_name, "scene");
      if (!save_data(datei_name, true, true))
	errorbox("Konnte nicht speichern!");
      else
	gespeichert = true;
      break;

    case IDM_SAVEAS:
      mask = XmStringCreateLtoR("*.cad", XmSTRING_DEFAULT_CHARSET);
      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNdirMask, mask);
      nArgs++;
      WFileSel = XmCreateFileSelectionDialog(WTop, "filesaveas", Aargs, nArgs);
      XtAddCallback(WFileSel, XmNokCallback, (XtCallbackProc) CBsaveSelect, NULL);
      XtAddCallback(WFileSel, XmNcancelCallback, (XtCallbackProc) CBsaveCancelSelect, NULL);
      XtAddCallback(WFileSel, XmNhelpCallback, (XtCallbackProc) CBFileHelpSelect, NULL);
      XtManageChild(WFileSel);
      break;

    case IDM_OPEN:
      mask = XmStringCreateLtoR("*.cad", XmSTRING_DEFAULT_CHARSET);
      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNdirMask, mask);
      nArgs++;
      WFileSel = XmCreateFileSelectionDialog(WTop, "fileopen", Aargs, nArgs);
      XtAddCallback(WFileSel, XmNokCallback, (XtCallbackProc) CBopenSelect, NULL);
      XtAddCallback(WFileSel, XmNcancelCallback, (XtCallbackProc) CBsaveCancelSelect, NULL);
      XtAddCallback(WFileSel, XmNhelpCallback, (XtCallbackProc) CBFileHelpSelect, NULL);
      XtManageChild(WFileSel);
      break;

    case IDM_SHOWSCENE:
      // getenv EDITOR
      starteditor(datei_name);
      //sprintf(kommando, "xedit %s&", datei_name);
      //system(kommando);
      break;

    default:
      fprintf(stderr, "MenuID: %d\n", *(int *) pClientData);
    }
}

void
CBEdit(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case IDM_NEU:
      operation = NEU;
      sprintf(statusstr, "Eingabe: %s", "Neu");
      break;
    case IDM_AENDERN:
      operation = AENDERN;
      /* Objekt je Typ aendern */
      sprintf(statusstr, "Eingabe: %s", "aendern, jedes Objekt picken...");
      break;
    case IDM_LOESCHEN:
      operation = LOESCHEN;
      sprintf(statusstr, "Eingabe: %s", "Loeschen, zu loeschendes Objekt picken...");
      break;
    case IDM_TRANSFORM:
      operation = TRANSFORMIEREN;
      /* Objekt transformieren */
      sprintf(statusstr, "Eingabe: %s", "Transformation, jedes Objekt picken...");
      break;
    case IDM_ANHAENGEN:
      operation = ANHAENGEN;
      sprintf(statusstr, "Eingabe: %s", "Anhaengen, Objekt zum anhaengen picken..");
      break;
    case IDM_REDIT:
      operation = REDIT;
      sprintf(statusstr, "Eingabe: %s", "aendern der Welt-Einstellungen...");

      if (!WObjAenderDialog)
	objaenderdialog(WTop, NULL, NULL);
      else
	infobox("nureinmal");

      break;
    default:
      operation = NONE;
      sprintf(statusstr, "Eingabe: %s", "Nichts");
      fprintf(stderr, "MenuID: %d\n", *(int *) pClientData);
    }
  statuszeile(statusstr);
}

void
obj_anhaengen(PEXPickPath * path, int objart)
{
  longint ank_nr;

  /* Struktur */
  if (path)
    {
      ank_nr = path->elements[path->count - 1].pick_id;
      /* neues Element erzeugen und anhaengen, es wird element uebergeben! */
      if (!WObjDialog)
	objdialog(WTop, NULL, ank_nr, objart, NEU);
      else
	infobox("nureinmal");
    }
}


// Callbackfunktion zum loeschen eines Grafischen Elementes
static ObjLoeschDaten objloeschdaten;

void
loesche_ank(longint nr)
{
  longint labelnr;
  grobjekt *objp, *objpk;

  objp = oliste.getobjp(nr);

  if (!objp)
    return;

  for (objpk = objp; objpk->isank; objpk = objpk->isank);

  objp = objpk;

  labelnr = objp->nr + GROBJ_LABEL;

  // gehe an Anfang damit Label gefunden wird
  PEXSetElementPtr(pDisplay, root_struct, PEXBeginning, 0);
  PEXSetElementPtrAtLabel(pDisplay, root_struct, labelnr, 0);
  // Loesche Label und Element, von Current bis Current und noch 1, also
  // Label mit Element!
  PEXDeleteElements(pDisplay, root_struct, PEXCurrent, 0, PEXCurrent, 1);

  // Falls es ein Ankettobjekt gibt, loesche den ganzen Baum
  oliste.deleteank(objp);
  oliste.deleteobj(objp);
}


void
CBloeschen(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case OK_BUTTON:
      // gehe Strukturen durch
      loesche_ank(objloeschdaten.pickgrobj->nr);
      // die Statische Anwahl von Pick koennte geloescht werden
      wurde_geloescht = true;
      // Neuaufbau
      redraw(true);
      break;
    case ABBRUCH_BUTTON:
      break;
    }
}

void
loesch_dialog(PEXPickPath * path, grobjekt * pgrobj)
{
  /* Datenuebergabe an Callbackfunktion */
  static button[] =
  {OK_BUTTON, ABBRUCH_BUTTON};

  Widget AWDialog;
  Arg Aargs[MAX_ARGS];
  int nArgs;
  XmString labelstr, okstr, cancelstr;

  objloeschdaten.pickpath = path;
  objloeschdaten.pickgrobj = pgrobj;

  /* Grafischens Objekt loeschen */
  labelstr = XmStringCreateLtoR("Wirklich loeschen?", XmSTRING_DEFAULT_CHARSET);
  okstr = XmStringCreateLtoR("Ja", XmSTRING_DEFAULT_CHARSET);
  cancelstr = XmStringCreateLtoR("Nein", XmSTRING_DEFAULT_CHARSET);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNokLabelString, okstr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcancelLabelString, cancelstr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNmessageString, labelstr);
  nArgs++;

  AWDialog = XmCreateQuestionDialog(WTop, "question", Aargs, nArgs);
  XtAddCallback(AWDialog, XmNokCallback, (XtCallbackProc) CBloeschen, &button[0]);
  XtAddCallback(AWDialog, XmNcancelCallback, (XtCallbackProc) CBloeschen, &button[1]);
  /* Helpbutton abstellen */
  XtUnmanageChild(XmMessageBoxGetChild(AWDialog, XmDIALOG_HELP_BUTTON));
  XtManageChild(AWDialog);
}

void
CBObj(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  PEXPickPath *path;
  grobjekt *pgrobj = NULL;
  int objtype = 0;

  gespeichert = false;
  switch (*(int *) pClientData)
    {
    case IDM_POLYGON:
      objtype = POLYGON;
      break;
    case IDM_SPHERE:
      objtype = SPHERE;
      break;
    case IDM_BLOCK:
      objtype = BLOCK;
      break;
    case IDM_ELIPSOID:
      objtype = ELIPSOID;
      break;
    case IDM_TORUS:
      objtype = TORUS;
      break;
    case IDM_ZYLINDER:
      objtype = CONE;
      break;
    case IDM_YBUFFER:
      objtype = YBUFFER;
      break;
      /*
    case IDM_BEZIER:
      objtype = BEZIER;
      break;*/
    case IDM_NURBS:
      objtype = NURBS;
      break;
    default:
      objtype = 0;
    }

  switch (*(int *) pClientData)
    {
    case IDM_POLYGON:
    case IDM_SPHERE:
    case IDM_BLOCK:
    case IDM_ELIPSOID:
    case IDM_TORUS:
    case IDM_ZYLINDER:
    case IDM_YBUFFER:
      //case IDM_BEZIER:
    case IDM_NURBS:

      // Falls noch ein Element durch die Transformation geechot war 
      un_echo_all();

      if (operation == NEU)
	{
	  if (!WObjDialog)
	    objdialog(WTop, NULL, 0, objtype, NEU);
	  else
	    infobox("nureinmal");
	}
      else if (operation == LOESCHEN)
	{
	  /* Objekt Picken */
	  path = pick(&pgrobj, objtype);

	  if (path)
	    loesch_dialog(path, pgrobj);
	}
      else if (operation == AENDERN)
	{
	  /* Objekt Picken */
	  path = pick(&pgrobj, objtype);

	  /* Objekt aendern */
	  if (path)
	    {
	      /* Optische Eigenschaften */
	      if (!WObjDialog)
		objdialog(WTop, pgrobj, 0, *(int *) pClientData, AENDERN);
	      else
		infobox("nureinmal");
	    }
	}
      else if (operation == ANHAENGEN)
	{
	  /* Objekt Picken */
	  // path = pick(&pgrobj, type);
	  // Da eine Kugel an ein Polygon haengen kann wird der Picktyp = 0 gewaehlt!

	  path = pick(&pgrobj, 0);
	  obj_anhaengen(path, *(int *) pClientData);
	}
      else if (operation == TRANSFORMIEREN)
	{
	  /* Objekt Picken */
	  path = pick(&pgrobj, objtype);
	  if (path)
	    if (!WObjAenderDialog)
	      objaenderdialog(WTop, path, pgrobj);
	    else
	      infobox("nureinmal");
	}
      break;
    default:
      fprintf(stderr, "MenuID: %d\n", *(int *) pClientData);
    }
}

void
CBLicht(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  gespeichert = false;
  switch (*(int *) pClientData)
    {
    case IDM_LIGHTSOURCE:
      if (!WAusDialog)
	ausdialog(WTop, IDM_LIGHTSOURCE);
      else
	infobox("nureinmal");
      break;
    case IDM_LIGHTSTRAHLER:
      if (!WAusDialog)
	ausdialog(WTop, IDM_LIGHTSTRAHLER);
      else
	infobox("nureinmal");
      break;
    case IDM_LIGHTPOLYGON:
      if (!WAusDialog)
	ausdialog(WTop, IDM_LIGHTPOLYGON);
      else
	infobox("nureinmal");
      break;
    case IDM_AMBIENT:
      if (!WAmbDialog)
	ambdialog(WTop);
      else
	infobox("nureinmal");
      break;
    case IDM_BACKGROUND:
      if (!WBackgDialog)
	backgdialog(WTop);
      else
	infobox("nureinmal");
      break;
    case IDM_NEBEL:
      if (!WNebelDialog)
	nebeldialog(WTop);
      else
	infobox("nureinmal");
      break;
    case IDM_TEXTURE:
      if (!WAusDialog)
	ausdialog(WTop, IDM_TEXTURE);
      else
	infobox("nureinmal");
      break;
    case IDM_TEXTURE3D:
      if (!WAusDialog)
	ausdialog(WTop, IDM_TEXTURE3D);
      else
	infobox("nureinmal");
      break;
    case IDM_MUSTER:
      if (!WAusDialog)
	ausdialog(WTop, IDM_MUSTER);
      else
	infobox("nureinmal");
      break;
    case IDM_WAVE:
      if (!WAusDialog)
	ausdialog(WTop, IDM_WAVE);
      else
	infobox("nureinmal");
      break;
    case IDM_COVER:
      if (!((textanf == NULL) && (mustanf == NULL)))
	{
	  if (!WAusDialog)
	    ausdialog(WTop, IDM_COVER);
	  else
	    infobox("nureinmal");
	}
      else
	errorbox("Cover ohne Textur oder Muster?");
      break;
    default:
      fprintf(stderr, "MenuID: %d\n", *(int *) pClientData);
    }
}

void
CBOption(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case IDM_FUELLEN:
      if (lichton)
	{
	  lichton = false;
	  delete_lichtquellen(true);
	}
      else
	{
	  lichton = true;
	  create_lichtquellen();
	}
      break;
    case IDM_SCHRITT:
      if (!WSchrittDialog)
	schrittdialog(WTop);
      else
	infobox("nureinmal");
      break;
    case IDM_KAMERA:
      if (!WKameraDialog)
	kameradialog(WTop);
      else
	infobox("nureinmal");
      break;
    case IDM_ANIMATION:
      if (!WAnimationDialog)
	animationdialog(WTop);
      else
	infobox("nureinmal");
      break;
    case IDM_PATCH:
      if (!WPatchDialog)
	patchdialog(WTop);
      else
	infobox("nureinmal");
      break;
    default:
      fprintf(stderr, "MenuID: %d\n", *(int *) pClientData);
    }
}

void
CBHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  Widget AWDialog;

  switch (*(int *) pClientData)
    {
    case IDM_VERSION:
      // helpfiledialog(WTop, LIZENZSTR);
      showhinweis();
      break;
    case IDM_VERSION_PEX:
      AWDialog = NULL;
      if VERSION_5_0
	(pexinfo)
	  AWDialog = XmCreateInformationDialog(WTop, "pexinfo_50", NULL, 0);
      else if VERSION_5_1
	(pexinfo)
	  AWDialog = XmCreateInformationDialog(WTop, "pexinfo_51", NULL, 0);
      /*  Helpbutton Cancelbutton Abstellen */
      XtUnmanageChild(XmMessageBoxGetChild(AWDialog, XmDIALOG_HELP_BUTTON));
      XtUnmanageChild(XmMessageBoxGetChild(AWDialog, XmDIALOG_CANCEL_BUTTON));
      XtManageChild(AWDialog);
      break;
    case IDM_ALLGEMEIN:
      system("cad_liesmich&");
      break;
    case IDM_DOKUMENT:
      system("cad_doku&");
      break;
    case IDM_HTML:
      system("cad_mosaic&");
      break;
    case IDM_RAYTRACING:
      system("ray_doku&");
      break;
    default:
      fprintf(stderr, "MenuID: %d\n", *(int *) pClientData);
    }
}

void
CBDButton(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  PEXCoord ref_point;
  PEXMatrix matrix;
  PEXVector tr, scale;
  PEXPickPath *path;
  vector m, w;
  float r1, r2;
  static PEXStructure *element = NULL, *pick_struct = NULL;

  // Dies fuehrt zu Fehlern wenn das Objekt geloescht wird!
  static grobjekt *pgrobj = NULL;

  // Deshalb wird ein Test mit einem Loesch-Schalter gemacht!
  if (wurde_geloescht)
    {
      pick_struct = &root_struct;
      pgrobj = NULL;
      wurde_geloescht = false;
      Transformstruct_init(DrawareaData.s, DrawareaData.w, DrawareaData.v, DrawareaData.r);
    }

  // Beim ersten mal
  if (!pick_struct)
    pick_struct = &root_struct;

  gespeichert = false;
  switch (*(int *) pClientData)
    {
    case QB_W_X:
    case QB_W_Y:
    case QB_W_Z:
    case QB_W_XW:
    case QB_W_YW:
    case QB_W_ZW:
    case QB_W_S:
      if (((XmToggleButtonCallbackStruct *) pCallData)->set)
	DrawareaData.schalter = *(int *) pClientData;
      break;
    case QB_W_Minus:
      if (pgrobj)
	{
	  // Referenzpunkt auch mitverschieben!!!
	  switch (DrawareaData.schalter)
	    {
	    case QB_W_X:
	      Transformstruct.v.x -= DrawareaData.schrittw;
	      break;
	    case QB_W_Y:
	      Transformstruct.v.y -= DrawareaData.schrittw;
	      break;
	    case QB_W_Z:
	      Transformstruct.v.z -= DrawareaData.schrittw;
	      break;
	    case QB_W_XW:
	      Transformstruct.w.x -= DrawareaData.schrittw;
	      break;
	    case QB_W_YW:
	      Transformstruct.w.y -= DrawareaData.schrittw;
	      break;
	    case QB_W_ZW:
	      Transformstruct.w.z -= DrawareaData.schrittw;
	      break;
	    case QB_W_S:
	      Transformstruct.s -= DrawareaData.schrittw;
	      break;
	    }
	  // Keine negativen Winkel
	  if (Transformstruct.w.x < 0.0 - eps3)
	    Transformstruct.w.x = pi2;
	  if (Transformstruct.w.y < 0.0 - eps3)
	    Transformstruct.w.y = pi2;
	  if (Transformstruct.w.z < 0.0 - eps3)
	    Transformstruct.w.z = pi2;
	}
      else
	{
	  switch (DrawareaData.schalter)
	    {
	    case QB_W_X:
	      DrawareaData.v.x -= DrawareaData.schrittw;
	      break;
	    case QB_W_Y:
	      DrawareaData.v.y -= DrawareaData.schrittw;
	      break;
	    case QB_W_Z:
	      DrawareaData.v.z -= DrawareaData.schrittw;
	      break;
	    case QB_W_XW:
	      DrawareaData.w.x -= DrawareaData.schrittw;
	      break;
	    case QB_W_YW:
	      DrawareaData.w.y -= DrawareaData.schrittw;
	      break;
	    case QB_W_ZW:
	      DrawareaData.w.z -= DrawareaData.schrittw;
	      break;
	    case QB_W_S:
	      DrawareaData.s -= DrawareaData.schrittw;
	      break;
	    }
	  // Keine negativen Winkel
	  if (DrawareaData.w.x < 0.0 - eps3)
	    DrawareaData.w.x = pi2;
	  if (DrawareaData.w.y < 0.0 - eps3)
	    DrawareaData.w.y = pi2;
	  if (DrawareaData.w.z < 0.0 - eps3)
	    DrawareaData.w.z = pi2;
	}
      break;
    case QB_W_Plus:
      if (pgrobj)
	{
	  switch (DrawareaData.schalter)
	    {
	    case QB_W_X:
	      Transformstruct.v.x += DrawareaData.schrittw;
	      break;
	    case QB_W_Y:
	      Transformstruct.v.y += DrawareaData.schrittw;
	      break;
	    case QB_W_Z:
	      Transformstruct.v.z += DrawareaData.schrittw;
	      break;
	    case QB_W_XW:
	      Transformstruct.w.x += DrawareaData.schrittw;
	      break;
	    case QB_W_YW:
	      Transformstruct.w.y += DrawareaData.schrittw;
	      break;
	    case QB_W_ZW:
	      Transformstruct.w.z += DrawareaData.schrittw;
	      break;
	    case QB_W_S:
	      Transformstruct.s += DrawareaData.schrittw;
	      break;
	    }
	  // Keine Winkel > 2pi
	  //       if (Transformstruct.w.x > pi2) Transformstruct.w.x -= DrawareaData.schrittw;
	  //       if (Transformstruct.w.y > pi2) Transformstruct.w.y -= DrawareaData.schrittw;
	  //       if (Transformstruct.w.z > pi2) Transformstruct.w.z -= DrawareaData.schrittw;
	  if (Transformstruct.w.x > pi2)
	    Transformstruct.w.x = 0.0;
	  if (Transformstruct.w.y > pi2)
	    Transformstruct.w.y = 0.0;
	  if (Transformstruct.w.z > pi2)
	    Transformstruct.w.z = 0.0;
	}
      else
	{
	  switch (DrawareaData.schalter)
	    {
	    case QB_W_X:
	      DrawareaData.v.x += DrawareaData.schrittw;
	      break;
	    case QB_W_Y:
	      DrawareaData.v.y += DrawareaData.schrittw;
	      break;
	    case QB_W_Z:
	      DrawareaData.v.z += DrawareaData.schrittw;
	      break;
	    case QB_W_XW:
	      DrawareaData.w.x += DrawareaData.schrittw;
	      break;
	    case QB_W_YW:
	      DrawareaData.w.y += DrawareaData.schrittw;
	      break;
	    case QB_W_ZW:
	      DrawareaData.w.z += DrawareaData.schrittw;
	      break;
	    case QB_W_S:
	      DrawareaData.s += DrawareaData.schrittw;
	      break;
	    }
	  // Keine Winkel > 2pi
	  if (DrawareaData.w.x > pi2)
	    DrawareaData.w.x = 0.0;
	  if (DrawareaData.w.y > pi2)
	    DrawareaData.w.y = 0.0;
	  if (DrawareaData.w.z > pi2)
	    DrawareaData.w.z = 0.0;
//       if (DrawareaData.w.x > pi2) DrawareaData.w.x -= DrawareaData.schrittw;
	  //       if (DrawareaData.w.y > pi2) DrawareaData.w.y -= DrawareaData.schrittw;
	  //       if (DrawareaData.w.z > pi2) DrawareaData.w.z -= DrawareaData.schrittw;
	}
      break;

    case QB_W_Pick:
      /* beliebiges Element Picken */
      if (pgrobj)
	un_echo(pgrobj, pgrobj->ch == 'N');

      path = pick(&pgrobj, 0);

      if (path && pgrobj)
	{
	  // fprintf(stderr, "obj und path\n");
	  /* alte Transformation holen */
	  if (pgrobj)
	    Transformstruct_init(pgrobj->s, pgrobj->w, pgrobj->v, pgrobj->ref);
	  element = &path->elements[path->count - 1].sid;
	  pick_struct = element;
	}
      else
	{
	  pick_struct = &root_struct;
	  pgrobj = NULL;
	  Transformstruct_init(DrawareaData.s, DrawareaData.w, DrawareaData.v, DrawareaData.r);
	}
    };				/* switch */

  // wurde [+] oder [-] gedrueckt dann Objekt transformieren
  if ((((*(int *) pClientData) == QB_W_Plus) ||
       ((*(int *) pClientData) == QB_W_Minus)))
    {
      if (pgrobj)
	{
	  Transformstruct_get(&pgrobj->s, &pgrobj->w, &pgrobj->v, &pgrobj->ref);

	  // Transformation gilt nicht fr das scalieren vom Torus
	  if ((pgrobj->type == TORUS) && (pgrobj->s != 1.0))
	    {
	      ((cadtorus *) (pgrobj->objp))->get(&m, &r1, &r2, &w);
	      r1 *= pgrobj->s;
	      r2 *= pgrobj->s;
	      pgrobj->s = 1.0;

	      TorusDialog_init(pgrobj->cover, m, r1, r2, w);
	      aendere_torus(pgrobj);

	      Transformstruct.s = 1.0;
	    }
	}
      else
	Transformstruct_init(DrawareaData.s, DrawareaData.w, DrawareaData.v, DrawareaData.r);

      /* Globale Transformation */
      PEXSetEditingMode(pDisplay, *pick_struct, PEXStructureReplace);
      PEXSetElementPtr(pDisplay, *pick_struct, PEXBeginning, 0);

      /* Globale Transformation, da root Stuktur */
      SET_VECT(Transformstruct.r.x, Transformstruct.r.y, Transformstruct.r.z, ref_point);
      SET_VECT(Transformstruct.v.x, Transformstruct.v.y, Transformstruct.v.z, tr);
      SET_VECT(Transformstruct.s, Transformstruct.s, Transformstruct.s, scale);
      PEXBuildTransform(&ref_point, &tr, Transformstruct.w.x, Transformstruct.w.y,
			Transformstruct.w.z, &scale, matrix);
      PEXSetElementPtrAtLabel(pDisplay, *pick_struct, TRANSFORM_LABEL, 1);
      PEXSetLocalTransform(pDisplay, *pick_struct, PEXOCStore, PEXReplace, matrix);

      redraw(true);
    }
}

void
CBQButtons(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  PEXPickPath *path;
  int objekt_art;
  grobjekt *pgrobj = NULL;

  gespeichert = false;

  switch (*(int *) pClientData)
    {
    case QB_SPHERE:
      objekt_art = SPHERE;
      break;
    case QB_POLYGON:
      objekt_art = POLYGON;
      break;
    case QB_BLOCK:
      objekt_art = BLOCK;
      break;
    case QB_ELIPSOID:
      objekt_art = ELIPSOID;
      break;
    case QB_TORUS:
      objekt_art = TORUS;
      break;
    case QB_ZYLINDER:
      objekt_art = CONE;
      break;
    case QB_YBUFFER:
      objekt_art = YBUFFER;
      break;
      /*
    case QB_BEZIER:
      objekt_art = BEZIER;
      break;*/

    case QB_NURBS:
      objekt_art = NURBS;
      break;
    default:
      objekt_art = 0;
    }

  switch (*(int *) pClientData)
    {
    case QB_SAVE:
      strcpy(datei_name, "scene.cad");
      if (!save_data(datei_name, false, false))
	errorbox("Konnte nicht speichern!");
      else
	gespeichert = true;
      break;
    case QB_LOAD:
      strcpy(datei_name, "scene.cad");
      if (!open_data(datei_name))
	errorbox("Konnte nicht finden!");
      else
	gespeichert = true;
      break;

    case QB_RAY:
      system("start_ray");
      break;
    case QB_SPHERE:
    case QB_POLYGON:
    case QB_BLOCK:
    case QB_ELIPSOID:
    case QB_TORUS:
    case QB_ZYLINDER:
    case QB_YBUFFER:
      //case QB_BEZIER:
    case QB_NURBS:

      // Falls noch ein Element durch die Transformation geechot war 
      un_echo_all();

      if (operation == NEU)
	{
	  ObjDialog_init(1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 100.0, 1.0, 'N');
	  /* ankettnr = 0 ist neu */
	  if (!WObjDialog)
	    objdialog(WTop, NULL, 0L, objekt_art, NEU);
	  else
	    infobox("nureinmal");
	}
      else if (operation == AENDERN)
	{
	  /* Objekt Picken */
	  path = pick(&pgrobj, objekt_art);
	  /* fprintf(stderr, "aendern %ld %ld\n", pgrobj->nr, pgrobj->ank_nr); */

	  /* Objekt aendern */
	  if (path)
	    {
	      /* Optische Eigenschaften */
	      if (!WObjDialog)
		objdialog(WTop, pgrobj, 0, objekt_art, AENDERN);
	      else
		infobox("nureinmal");
	    }
	}
      else if (operation == LOESCHEN)
	{
	  /* Objekt Picken */
	  path = pick(&pgrobj, objekt_art);

	  /* Objekt aendern */
	  if (path)
	    loesch_dialog(path, pgrobj);
	}
      else if (operation == ANHAENGEN)
	{
	  path = pick(&pgrobj, 0);
	  obj_anhaengen(path, (int) objekt_art);
	}
      else if (operation == TRANSFORMIEREN)
	{
	  /* Objekt Picken */
	  path = pick(&pgrobj, objekt_art);
	  if (path)
	    if (!WObjAenderDialog)
	      objaenderdialog(WTop, path, pgrobj);
	    else
	      infobox("nureinmal");
	}
      break;
    default:
      fprintf(stderr, "QButtonID: %d\n", *(int *) pClientData);
    }
}


