#ifndef _CADTOOL_IST_INCLUDE_
#define _CADTOOL_IST_INCLUDE_

/*
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996 Helmut Fahrion
 */

#include "skelett.H"
#include "datalist.H"


// fuer Alpha cxx !!!!!!!
// typedef void *caddr_t;
typedef void *caddr_T;
// sonst in types.h char *caddr_t;

// zum Testen
extern float Patchweite;

/* Globale Widges fuer Ausgabe */
extern bool gespeichert;
extern Widget WGdrawarea;
extern PEXRenderer renderer;
extern PEXLookupTable view_table;
extern PEXViewEntry view;

// Haupt Struktur
extern PEXStructure root_struct;

// Struktur fuer Lichtquellen Polymarker
extern PEXStructure light_struct;

// Struktur fuer Lichtstrahler
extern PEXStructure strahler_struct;

// Struktur fuer LichtPolygon
extern PEXStructure lichtpoly_struct;

// Struktur zum Picken
extern PEXStructure pick_struct;

// Struktur fr Kamerafhrung
extern PEXStructure kamera_struct;

// Status Licht on oder off
extern bool lichton;

/* Statuszeilenanzeige */
extern Widget SWStatuslabel;
extern char statusstr[256];

// Dateiname fuer Datenfile
extern char datei_name[256];

/* die anzuwendende Operation auf ein grafisches Objekt */
extern int operation;

/*  Dialog Widgets  */
extern Widget WHelpDialog, WObjDialog, WLichtDialog, WStrahlerDialog, WAmbDialog,
       WBackgDialog, WNebelDialog, WTexturDialog, WText3dDialog, WMusterDialog,
       WWaveDialog, WCoverDialog, WAusDialog, WObjAenderDialog, WSchrittDialog,
       WPolygonDialog, WSphereDialog, WBlockDialog, WElipsoidDialog, WTorusDialog,
       WZylinderDialog, WYBufferDialog, WNurbsDialog, WBezierDialog, WKameraDialog,
       WAnimationDialog, WLichtPolygonDialog, WPatchDialog;


#define TEXTURE_MAX_STRING 20
// Datenstruktur fr das Lichtquellenpolygon

struct lichtpolygonstruktur
  {
    // Farbe
    float  r, g, b;
    // Intensitt
    float  i;
    // ffnungswinkel
    float  w;
    // Approximation
    int    xanz, yanz;

    vector p1, p2, p3, p4;

    /* Farbanzeige */
    XColor XCol;
    Colormap CMap;
    Display *pD;
    Window Win;
    bool   privat;		/*  Private Farbzelle? */
  };
extern struct lichtpolygonstruktur LichtPolygonDialog;
void   LichtPolygonDialog_init(float R, float G, float B, float I, int Xanz, int Yanz,
			 float W, vector P1, vector P2, vector P3, vector P4);
void   LichtPolygonDialog_get(float *R, float *G, float *B, float *I, int *Anz, int *Yanz,
		float *W, vector * P1, vector * P2, vector * P3, vector * P4);

// Datenstruktur dessen Adresse beim lschen eines Grafischen Objektes bergeben wird
class  kameral
{
  public:
  kameral(kameral * L, vector P, float V, vector B);
        ~kameral()
  {
    delete next;
  };

public:
  vector punkt, blickrichtung;
  float  geschw;
  kameral *next;
};
extern kameral *kameraliste;
extern kameral *kameralistex;

struct kameradialogstruktur
  {
    float  masse;
    unsigned long anzbilder;
    kameral *kamerap;
  };
extern struct kameradialogstruktur kameradialogs;

void   Kamera_init(float Masse, unsigned long Anzbilder);
void   Kamera_get(float *Masse, unsigned long *Anzbilder, kameral ** L);

// typedef struct
// {
//   PEXPickPath *pickpath;
//   grobjekt *pickgrobj;
// } ObjLoeschDaten;

class  ObjLoeschDaten
{
  public:

  PEXPickPath * pickpath;
  grobjekt *pickgrobj;
};


struct transformstruktur
  {
    float  s;
    vector w, v, r;
  };
extern struct transformstruktur Transformstruct;

void   Transformstruct_init(float S, vector W, vector V, vector R);
void   Transformstruct_get(float *S, vector * W, vector * V, vector * R);


struct drawareastruktur
  {
    vector r, w, v;
    float  s;			// Transformation

    int    schalter;
    float  schrittw, nebel;
  };
extern struct drawareastruktur DrawareaData;

void   DrawareaData_init(float S, vector W, vector V, vector R, int Schalter, float Schrittw,
			 float Nebel);
void   DrawareaData_get(float *S, vector * W, vector * V, vector * R,
			int *Schalter, float *Schrittw, float *Nebel);


struct objaenderstruktur
  {
    float  s;
    vector r, w, v;
  };
extern struct objaenderstruktur ObjAenderDialog;

void   ObjAenderDialog_init(float S, vector W, vector V, vector R);
void   ObjAenderDialog_get(float *S, vector W, vector V, vector * R);

/* Allgemein fr alle Grafischen Objekte */
struct objstruktur
  {
    float  r, b, g, e, mat, sp, du, dif, spec, high, vel;
    char   ch;

    /* Farbanzeige */
    XColor XCol;
    Colormap CMap;
    Display *pD;
    Window Win;
    bool   privat;		/*  Private Farbzelle? */

  };
extern struct objstruktur ObjDialog;

void   ObjDialog_init(float R, float B, float G, float E, float Mat, float Sp, float Du,
		      float Dif, float Spec, float High, float Vel, char Ch);
void   ObjDialog_get(float *R, float *B, float *G, float *E, float *Mat, float *Sp, float *Du,
		  float *Dif, float *Spec, float *High, float *Vel, char *Ch);


/* Polygon */
struct polygonstruktur
  {
    XmString *pCoverStr;
    longint anzcover;
    char   coverlabel[80];

    longint nrcover;
    int    anz_vect;
    vector p1, p2, p3, p4;

  };
extern struct polygonstruktur PolygonDialog;

void   PolygonDialog_init(int Anz_vect, longint Nrcover,
			  vector P1, vector P2, vector P3, vector P4);

void   PolygonDialog_get(int *Anz_vect, longint * Nrcover,
			 vector * P1, vector * P2, vector * P3, vector * P4);

/* Kugel */
struct kugelstruktur
  {
    XmString *pCoverStr;
    longint anzcover;
    char   coverlabel[80];

    longint nrcover;
    float  r, w1, w2;
    vector m;
  };
extern struct kugelstruktur SphereDialog;

void   SphereDialog_init(float R, float W1, float W2, longint Nrcover, vector M);
void   SphereDialog_get(float *R, float *W1, float *W2, longint * Nrcover, vector * M);

/* Block */
struct blockstruktur
  {
    XmString *pCoverStr;
    longint anzcover;
    char   coverlabel[80];

    longint nrcover;

    vector p1, p2, p3, p4, p5, p6, p7, p8;
    float  l;
  };
extern struct blockstruktur BlockDialog;

void   BlockDialog_init(longint Nrcover,
			vector P1, vector P2, vector P3, vector P4,
			vector P5, vector P6, vector P7, vector P8);

void   BlockDialog_get(longint * Nrcover,
		       vector * P1, vector * P2, vector * P3, vector * P4,
		       vector * P5, vector * P6, vector * P7, vector * P8);
/* Elipsoid */
struct elipsoidstruktur
  {
    XmString *pCoverStr;
    longint anzcover;
    char   coverlabel[80];

    longint nrcover;

    vector m, r, w;
  };
extern struct elipsoidstruktur ElipsoidDialog;

void   ElipsoidDialog_init(longint Nrcover, vector M, vector R, vector W);
void   ElipsoidDialog_get(longint * Nrcover, vector * M, vector * R, vector * W);

/* Torus */
struct torusstruktur
  {
    XmString *pCoverStr;
    longint anzcover;
    char   coverlabel[80];

    longint nrcover;

    vector m, w;
    float  r1, r2;
  };
extern struct torusstruktur TorusDialog;

void   TorusDialog_init(longint Nrcover, vector M, float R1, float R2, vector W);
void   TorusDialog_get(longint * Nrcover, vector * M, float *R1, float *R2, vector * W);

/* Zylinder */
struct zylinderstruktur
  {
    XmString *pCoverStr;
    longint anzcover;
    char   coverlabel[80];

    longint nrcover;

    vector p1, p2;
    float  r1, r2, w;
  };
extern struct zylinderstruktur ZylinderDialog;

void   ZylinderDialog_init(longint Nrcover, vector P1, vector P2, float R1, float R2, float W);
void   ZylinderDialog_get(longint * Nrcover, vector * P1, vector * P2,
			  float *R1, float *R2, float *W);

/* Y-Puffer */
struct ybufferstruktur
  {
    XmString *pCoverStr;
    longint anzcover;
    char   coverlabel[80];

    longint nrcover;

    vector p1, p2, p3, p4;
    longint x, z;
    float *y;			// Array der y - Koordinaten

  };
extern struct ybufferstruktur YBufferDialog;

void   YBufferDialog_init(longint Nrcover, vector P1, vector P2, vector P3, vector P4,
			  longint X, longint Z, float *Y);
void   YBufferDialog_get(longint * Nrcover, vector * P1, vector * P2, vector * P3, vector * P4,
			 longint * X, longint * Z, float **Y);

/* Nurbs-Puffer */
struct nurbsstruktur
  {
    XmString *pCoverStr;
    longint anzcover;
    char   coverlabel[80], knotenstr1[256], knotenstr2[256];

    longint nrcover;

    int    ou, ov;		// Grad der Kurve

    longint x, z;		// Anz x , y 

    int    cu, cv;		// Genauigkeit

    vect4d *y;			// Array der y - Koordinaten

    float *i, *j;		// Array der Knotenvektoren, erstes ist Anzahl

  };
extern struct nurbsstruktur NurbsDialog;

void   NurbsDialog_init(longint Nrcover, longint X, longint Z, int CU, int CV, int OU, int OV,
			vect4d * Y, float *I, float *J);
void   NurbsDialog_get(longint * Nrcover, longint * X, longint * Z, int *CU, int *CV,
		       int *OU, int *OV, vect4d ** Y, float **I, float **J);

/* Bezier-Puffer */
/*
struct bezierstruktur
  {
    XmString *pCoverStr;
    longint anzcover;
    char   coverlabel[80];

    longint nrcover;

    longint x, z;		// Anz x , y 

    vector pbuf[4][4];		// Puffer fuer die Matrix

  };
extern struct bezierstruktur BezierDialog;
*/

// (*Pbuf) immer in Klammern !!! auch beim Rechnen !!!
void   BezierDialog_init(longint Nrcover, longint X, longint Z, vector(*Pbuf)[4][4]);
void   BezierDialog_get(longint * Nrcover, longint * X, longint * Z, vector(*Pbuf)[4][4]);

struct lichtstruktur
  {
    float  r, b, g, intens, x, y, z;

    XColor XCol;
    Colormap CMap;
    Display *pD;
    Window Win;
    bool   privat;
  };
extern struct lichtstruktur LichtDialog;

void   LichtDialog_init(float R, float B, float G, float Intens,
			float X, float Y, float Z);
void   LichtDialog_get(float *R, float *B, float *G, float *Intens,
		       float *X, float *Y, float *Z);

struct strahlerstruktur
  {
    float  r, b, g, intens, winkel;
    vector pos, richtung;

    XColor XCol;
    Colormap CMap;
    Display *pD;
    Window Win;
    bool   privat;

  };
extern struct strahlerstruktur StrahlerDialog;

void   StrahlerDialog_init(float R, float B, float G, float Intens,
			   vector Pos, vector Richtung, float Winkel);
void   StrahlerDialog_get(float *R, float *B, float *G, float *Intens,
			  vector * Pos, vector * Richtung, float *Winkel);

struct ambstruktur
  {
    float  r, b, g;


    XColor XCol;
    Colormap CMap;
    Display *pD;
    Window Win;
    bool   privat;

  };
extern struct ambstruktur AmbDialog;

struct backgstruktur
  {
    float  rh, gh, bh, rb, gb, bb;

    /* Himmel */
    int    textnrh, mustnrh, turbarth, rauschh, freqh;
    float  verschxh, verschyh, scalh;

    /* Boden */
    int    textnrb, mustnrb, turbartb, rauschb, freqb;
    float  verschxb, verschyb, scalb;

    // Entfernung des Himmels und der Erde
    float entfernung;

    // Zufallszahlen Anfangswert
    int  zufall;

    /* Array mit Compound Strings */
    XmString *pBackgTextureHStr;
    int    anztexture;
    char   texthlabel[80];
    char   textblabel[80];

    XmString *pBackgMusterHStr;
    int    anzmuster;
    char   musthlabel[80];
    char   mustblabel[80];

    /* Farbanzeige */
    XColor XCol;
    Colormap CMap;
    Display *pD;
    Window Win;
    bool   privat;		/*  Private Farbzelle? */

  };
extern struct backgstruktur BackgDialog;

struct texturestruktur
  {
    float  prozent;
    char   dateiname[256];
    char   name[256];

  };
extern struct texturestruktur TextDialog;

void   TextDialog_init(float Prozent, char *Dateiname, char *Name);
void   TextDialog_get(float *Prozent, char *Dateiname, char *Name);

struct musterstruktur
  {
    float  r1, b1, g1, r2, b2, g2, mix, x, y;
    int    art, fehler;

    char   name[256];

    /* Farbanzeige */
    XColor XCol1, XCol2;
    Colormap CMap;
    Display *pD;
    Window Win;
    bool   privat;		/*  Private Farbzelle? */

  };
extern struct musterstruktur MusterDialog;

void   MusterDialog_init(float R1, float B1, float G1, float R2, float B2, float G2,
		float Mix, float X, float Y, int Art, int Fehler, char *Name);
void   MusterDialog_get(float *R1, float *B1, float *G1, float *R2, float *B2, float *G2,
	   float *Mix, float *X, float *Y, int *Art, int *Fehler, char *Name);

struct text3dstruktur
  {
    float  r1, b1, g1, r2, b2, g2, mix, abs;
    int    art, fehler, anz;
    vector d, r;

    char   name[256];

    /* Farbanzeige */
    XColor XCol1, XCol2;
    Colormap CMap;
    Display *pD;
    Window Win;
    bool   privat;		/*  Private Farbzelle? */
  };
extern struct text3dstruktur Text3dDialog;

void   Text3dDialog_init(float R1, float B1, float G1, float R2, float B2, float G2,
			 float Mix, float Abs, int Art, int Fehler, int Anz,
			 vector D, vector R, char *Name);
void   Text3dDialog_get(float *R1, float *B1, float *G1, float *R2, float *B2, float *G2,
		      float *Mix, float *Abs, int *Art, int *Fehler, int *Anz,
			vector * D, vector * R, char **Name);

struct wavestruktur
  {
    float  x1, y1, z1, freq1, amp1, damp1, d1, x2, y2, z2, freq2, amp2, damp2,
           d2, x3, y3, z3, freq3, amp3, damp3, d3;

    char   name[256];
    int    nr;
  };
extern struct wavestruktur WaveDialog;

void   WaveDialog_init(
 float X1, float Y1, float Z1, float Freq1, float Amp1, float Damp1, float D1,
 float X2, float Y2, float Z2, float Freq2, float Amp2, float Damp2, float D2,
 float X3, float Y3, float Z3, float Freq3, float Amp3, float Damp3, float D3,
			char *Name);


void   WaveDialog_get(
		       float *X1, float *Y1, float *Z1, float *Freq1, float *Amp1, float *Damp1, float *D1,
		       float *X2, float *Y2, float *Z2, float *Freq2, float *Amp2, float *Damp2, float *D2,
		       float *X3, float *Y3, float *Z3, float *Freq3, float *Amp3, float *Damp3, float *D3,
		       char *Name);


struct coverstruktur
  {
    float  tx1, tx2, ty1, ty2, movx, movy, scal;
    int    text1, text2, text3, text4, must1, must2, must3, must4, turbart, normalv, freq;
    longint wavenr, text3dnr;

    int    nr;

    XmString *pMusterStr, *pTextureStr, *pWaveStr, *pText3dStr;
    int    anzmuster, anztexture, anzwave, anztext3d;
    char   musterlabelf[80], texturelabelf[80], texturelabelb[80], texturelabels[80], 
      musterlabelv[80], musterlabels[80], musterlabelb[80], texturelabelv[80],
           wavelabel[80], text3dlabel[80];

  };
extern struct coverstruktur CoverDialog;

void   CoverDialog_init(float Tx1, float Tx2, float Ty1, float Ty2, float Movx, float Movy,
	  float Scal, int Text1, int Text2, int Text3, int Text4, 
			int Must1, int Must2, int Must3, int Must4, int Turbart,
		     int Normalv, int Freq, longint Wavenr, longint Text3dnr);

void   CoverDialog_get(float *Tx1, float *Tx2, float *Ty1, float *Ty2, float *Movx,
		       float *Movy, float *Scal,
		       int *Text1, int *Text2, int *Text3, int *Text4, 
		       int *Must1, int *Must2, int *Must3, int *Must4, 
		       int *Turbart, int *Normalv, int *Freq, longint * Wavenr,
		       longint * Text3dnr);

void   CreateApplicationWidgets(Widget WParent);

/* Callback Funktionen */
void   CBRedraw(Widget W, caddr_T pClientData, caddr_T pCallData);
void   CBsavemb(Widget W, caddr_T pClientData, caddr_T pCallData);
void   CBnosavemb(Widget W, caddr_T pClientData, caddr_T pCallData);
void   CBFile(Widget W, caddr_T pClientData, caddr_T pCallData);
void   CBEdit(Widget W, caddr_T pClientData, caddr_T pCallData);
void   CBObj(Widget W, caddr_T pClientData, caddr_T pCallData);
void   CBLicht(Widget W, caddr_T pClientData, caddr_T pCallData);
void   CBOption(Widget W, caddr_T pClientData, caddr_T pCallData);
void   CBHelp(Widget W, caddr_T pClientData, caddr_T pCallData);
void   CBQButtons(Widget W, caddr_T pClientData, caddr_T pCallData);
void   CBDButton(Widget W, caddr_T pClientData, caddr_T pCallData);

/*  Dialog zur nderung von Objekten */
void   objaenderdialog(Widget W, PEXPickPath * path, class grobjekt * pgrobj);

/* Datendefinition eines Objektes */
/*        anhngen an,  ndere obj,  anketten an, obj Art,  neu | ndern */
void   objdialog(Widget W, class grobjekt * grobjp, longint ank_nr, int art, int editart);

/* Datendefinition eine Polygons */
void   polygondialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art);

// Erzeugen der PEX-Struktur eines Polygones
void   create_polygon(Display * D, Widget W, class grobjekt * poly, longint ank_nr, longint pick_id);

// Erzeugen einer Kugel
void   spheredialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art);
// Erzeugen der PEX-Struktur einer Kugel
void   create_sphere(Display * D, Widget W, class grobjekt * sphere, longint ank_nr,
		     longint pick_id);

// Erzeugen eines Blockes
void   blockdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art);
void   create_block(Display * D, Widget W, class grobjekt * block, longint ank_nr, longint pick_id);

// Erzeugen eines Elipsoiden
void   elipsoiddialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art);
void   create_elipsoid(Display * D, Widget W, class grobjekt * sphere, longint ank_nr, longint pick_id);

// Erzeugen eines Torus
void   torusdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art);
void   create_torus(Display * D, Widget W, class grobjekt * torus, longint ank_nr, longint pick_id);
void   aendere_torus(grobjekt * torusgrobj);

// Erzeugen eines Zylinders
void   zylinderdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art);
void   create_zylinder(Display * D, Widget W, class grobjekt * zylinder, longint ank_nr,
		       longint pick_id);
// void aendere_zylinder(grobjekt *zylindergrobj);

// Erzeugen einer Dreiecksflche
void   ybufferdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art);
void   create_ybuffer(Display * D, Widget W, class grobjekt * pybuffer, longint ank_nr,
		      longint pick_id);

// Erzeugen einer Nurbskurve
void   nurbsdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art);
void   create_nurbs(Display * D, Widget W, class grobjekt * pybuffer, longint ank_nr, longint pick_id);

// Erzeugen einer Bezierkurve
//void   bezierdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art);
//void   create_bezier(Display * D, Widget W, class grobjekt * pybuffer, longint ank_nr, longint pick_id);

/* Datendefinition einer Lichtquelle */
void   lichtdialog(Widget W, int art);
// erzeugt die Lichtquelle als Marker
void   erz_lichtquelle(vector point, longint nr);

/* Datendefinition einer Strahler-Lichtquelle */
void   strahlerdialog(Widget W, int art);
void   erz_strahler(vector point, vector richtung, longint nr);

// Dialog zum definieren einer Flchenlichtquelle
void   lichtpolygondialog(Widget W, int art);
void   erz_lichtpolygon(vector p1, vector p2, vector p3, vector p4, int x, int y, longint nr);

/* Datendefinition des Hintergrundlichtes */
void   ambdialog(Widget W);

/* Datendefinition des Hintergrundmusters */
void   backgdialog(Widget W);

/* Datendefinition der Nebelsichtweite */
void   nebeldialog(Widget W);

/* Datendefinition der Textur */
void   texturdialog(Widget W, int art);

/* Datendefinition fr ein Oberflchendialog */
void   musterdialog(Widget W, int art);

/* Datendefinition fr ein 3D Musterdialog */
void   text3ddialog(Widget W, int art);

/* Datendefinition fr Wellen */
void   wavedialog(Widget W, int art);

/* Datendefinition fr Cover  */
void   coverdialog(Widget W, int art);

/* Auswahl aus einer vorhandenen Liste */
void   ausdialog(Widget W, int art);

/* Zeigt ein Textwidget mit Hilfeinformationen an */
void   helpfiledialog(Widget Parent, char *str);

/* oeffnet eine Infobox mit nur einem OK Button */
void   infobox(char *str);

/* oeffnet eine Errorbox mit nur einem OK Button */
void   errorbox(char *str);

// Eingabe der Schrittweite fr Buttonleiste
void   schrittdialog(Widget W);

// Dialog zum Testen der Patchaufteilung
void   patchdialog(Widget W);


// Dialog zum definieren der Kameraanimation
void   kameradialog(Widget W);
// Kamera einlesen
void   ank_kamera(vector p, vector r, float v);
// Kamera zeichnen
void   create_kamera(void);

// Dialog zum durchfhren der Animation
void   animationdialog(Widget W);

// Prozedur zum Daten speichern
bool   save_data(char *dateiname, bool ray, bool star);

// Prozedur zum Daten laden
bool   open_data(char *dateiname);

// Parsing fuer Eingabezeilen
bool   expr_vector(vector * v, char *str);
bool   expr_vector4d(float *x, float *y, float *z, float *g, char *str);

// Picking Callback Funktion
void   CBGetPick(Widget W, caddr_T pClientData, caddr_T pCallData);

// Pickung fuer das Verschieben von Objekten
PEXPickPath *pick(class grobjekt ** pgrobj, int type);
// Zeigt gepickte Objekte
void   echo(PEXPickPath * path);

// in Pextool zum setzen des Orginal Views
void   set_view();

#endif
