/*  
   Widgetbaum, CAD-Tool 
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

Widget WGdrawarea;
struct transformstruktur Transformstruct;
struct drawareastruktur DrawareaData;

/* Statuszeilenanzeige */
Widget SWStatuslabel;
char statusstr[256];
char datei_name[256];
bool gespeichert;

/* Testzwecke */
char teststr[10];

void
Transformstruct_init(float S, vector W, vector V, vector R)
{
  Transformstruct.s = S;
  Transformstruct.w = W;
  Transformstruct.v = V;
  Transformstruct.r = R;
}

void
Transformstruct_get(float *S, vector * W, vector * V, vector * R)
{
  *S = Transformstruct.s;
  *W = Transformstruct.w;
  *V = Transformstruct.v;
  *R = Transformstruct.r;
}

void
DrawareaData_init(float S, vector W, vector V, vector R, int Schalter, float Schrittw,
		  float Nebel)
{
  DrawareaData.s = S;
  DrawareaData.w = W;
  DrawareaData.v = V;
  DrawareaData.r = R;
  DrawareaData.schalter = Schalter;
  DrawareaData.schrittw = Schrittw;
  DrawareaData.nebel = Nebel;
}

void
DrawareaData_get(float *S, vector * W, vector * V, vector * R,
		 int *Schalter, float *Schrittw, float *Nebel)
{
  *S = DrawareaData.s;
  *W = DrawareaData.w;
  *V = DrawareaData.v;
  *R = DrawareaData.r;
  *Schalter = DrawareaData.schalter;
  *Schrittw = DrawareaData.schrittw;
  *Nebel = DrawareaData.nebel;
}

void
CreateApplicationWidgets(Widget WParent)
{
  Widget
  /*  Menuebalken */
    WMenuBar, WRowCol,
    AWPulldown[MC_PULLDOWN], AWCascade[MC_PULLDOWN],
    AWFile[MC_FILE], AWEdit[MC_EDIT], AWObj[MC_OBJ], AWLicht[MC_LICHT], AWOption[MC_OPTION],
    AWHelp[MC_HELP],

  /* Statuszeile */
    QWframe, QWButtons[MC_QUICK],

  /* Quickbuttons */
    WQBox, SWStatusframe,

  /* Grafikarbeitsflaeche */
    WSframe, WGscrollwin,

  // Auswahlschalter fuer Rotation, Scalierung, Verschiebung
    WRadioBox, WRadioFrame, WRadioRow, AWButtonD[10];


  Arg Aargs[MAX_ARGS];
  int i, nArgs;
  // char   c;

  static int AiButtonID[] =
  {
    QB_W_X, QB_W_Y, QB_W_Z, QB_W_XW, QB_W_YW, QB_W_ZW, QB_W_S,
    QB_W_Plus, QB_W_Minus, QB_W_Pick
  };

  /* Instanzvariablen der Buttons und Pulldownmenuepanes */
  STRING AIPulldown[] =
  {
    "file", "edit", "obj", "licht", "option", "helpfiles"
  };
  STRING AICascade[] =
  {
    "filecascade", "editcascade", "objcascade", "lichtcascade", "optioncascade", "helpcascade"
  };
  STRING AIFile[] =
  {
    "open", "save", "save_as", "save_ray", "save_star", "showscene", "exit"
  };
  STRING AIEdit[] =
  {
    "neu", "loeschen", "aender", "transform", "anhae", "root_edit"
  };
  STRING AIObj[] =
  {
    "kugel", "polygon", "block", "elipsoid", "torus", "zylinder", "ybuffer", 
    //"bezier", 
    "nurbs"
  };
  STRING AILicht[] =
  {
    "lichtquelle", "lichtstrahler", "lichtpolygon", "ambient", "background", "nebel",
    "texture", "texture3d", "muster", "wave", "cover"
  };
  STRING AIOption[] =
  {
    "kamera", "animation", "fuellen", "schrittweite", "patchabs"
  };

  STRING AIHelp[] =
  {"version_cad", "version_pex", "allgemein", "dokumentation",
   "raytracing", "html"};

  STRING AIQuick[] =
  {
    "qload", "qsave", "qray", "qkugel", "qpolygon", "qblock", "qelipsoid",
    "qtorus", "qzylinder", "qybuffer", 
    //"qbezier", 
    "qnurbs"
  };

  STRING SFLabel = "statusframe";
  STRING SSLabel = "statusstring";

  /* Werte zur Unterscheidung der Menuepunkte */
  static int AiFileMenuID[] =
  {
    IDM_OPEN, IDM_SAVE, IDM_SAVEAS, IDM_SAVERAY, IDM_SAVESTAR, IDM_SHOWSCENE, IDM_EXIT
  };

  static int AiEditMenuID[] =
  {
  IDM_NEU, IDM_LOESCHEN, IDM_AENDERN, IDM_TRANSFORM, IDM_ANHAENGEN, IDM_REDIT
  };

  static int AiObjMenuID[] =
  {
    IDM_SPHERE, IDM_POLYGON, IDM_BLOCK, IDM_ELIPSOID, IDM_TORUS, IDM_ZYLINDER, IDM_YBUFFER,
    //IDM_BEZIER, 
    IDM_NURBS
  };

  static int AiLichtMenuID[] =
  {
    IDM_LIGHTSOURCE, IDM_LIGHTSTRAHLER, IDM_LIGHTPOLYGON, IDM_AMBIENT,
    IDM_BACKGROUND, IDM_NEBEL, IDM_TEXTURE, IDM_TEXTURE3D, IDM_MUSTER, IDM_WAVE, IDM_COVER
  };

  static int AiOptionMenuID[] =
  {
    IDM_KAMERA, IDM_ANIMATION, IDM_FUELLEN, IDM_SCHRITT, IDM_PATCH
  };

  static int AiHelpMenuID[] =
  {
    IDM_VERSION, IDM_VERSION_PEX, IDM_ALLGEMEIN, IDM_DOKUMENT, IDM_RAYTRACING, IDM_HTML
  };

  static int AiQButtonsID[] =
  {
    QB_LOAD, QB_SAVE, QB_RAY, QB_SPHERE, QB_POLYGON, QB_BLOCK, QB_ELIPSOID, QB_TORUS,
    QB_ZYLINDER, QB_YBUFFER, 
    //QB_BEZIER, 
    QB_NURBS
  };

  bool pex51 = false;

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNadjustLast, True);
  nArgs++;
  WRowCol = XmCreateRowColumn(WParent, "rowcol", Aargs, nArgs);
  XtManageChild(WRowCol);

  /* 1. MenuBar mit PulldownMenu als Kind erzeugen */

  WMenuBar = XmCreateMenuBar(WRowCol, "menubar", NULL, 0);
  XtManageChild(WMenuBar);

  /* Pulldown MenuPanes erzeugen */

  for (i = 0; i < MC_PULLDOWN; i++)
    AWPulldown[i] = XmCreatePulldownMenu(WMenuBar, AIPulldown[i], NULL, 0);

  /* 2. PulldownMens an CascadeButtons binden */
  for (i = 0; i < MC_PULLDOWN; i++)
    {
      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNsubMenuId, AWPulldown[i]);
      nArgs++;
      AWCascade[i] = XmCreateCascadeButton(WMenuBar, AICascade[i], Aargs, nArgs);
    }

  /* Hilfe Menue steht ganz rechts */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNmenuHelpWidget, (XtArgVal) AWCascade[i - 1]);
  nArgs++;
  XtSetValues(WMenuBar, Aargs, nArgs);
  XtManageChildren(AWCascade, i);

  /* 3. Buttons fuer alle PulldownMenus erzeugen */

  for (i = 0; i < MC_FILE; i++)
    {
      AWFile[i] = XmCreatePushButton(AWPulldown[0], AIFile[i], NULL, 0);
      XtAddCallback(AWFile[i], XmNactivateCallback, (XtCallbackProc) CBFile, &AiFileMenuID[i]);
    }
  XtManageChildren(AWFile, i);

  if VERSION_5_1
    (pexinfo)
      pex51 = true;

  for (i = 0; i < MC_EDIT; i++)
    {
      // erst in PEX 5.1 ist Picken impl.
      if (!((i == 1) && !pex51))
	{
	  AWEdit[i] = XmCreatePushButton(AWPulldown[1], AIEdit[i], NULL, 0);
	  XtAddCallback(AWEdit[i], XmNactivateCallback, (XtCallbackProc) CBEdit, &AiEditMenuID[i]);
	}
    }
  XtManageChildren(AWEdit, i);

  for (i = 0; i < MC_OBJ; i++)
    {
      AWObj[i] = XmCreatePushButton(AWPulldown[2], AIObj[i], NULL, 0);
      XtAddCallback(AWObj[i], XmNactivateCallback, (XtCallbackProc) CBObj, &AiObjMenuID[i]);
    }
  XtManageChildren(AWObj, i);

  for (i = 0; i < MC_LICHT; i++)
    {
      AWLicht[i] = XmCreatePushButton(AWPulldown[3], AILicht[i], NULL, 0);
      XtAddCallback(AWLicht[i], XmNactivateCallback, (XtCallbackProc) CBLicht, &AiLichtMenuID[i]);
    }
  XtManageChildren(AWLicht, i);

  for (i = 0; i < MC_OPTION; i++)
    {
      AWOption[i] = XmCreatePushButton(AWPulldown[4], AIOption[i], NULL, 0);
      XtAddCallback(AWOption[i], XmNactivateCallback, (XtCallbackProc) CBOption, &AiOptionMenuID[i]);
    }
  XtManageChildren(AWOption, i);

  for (i = 0; i < MC_HELP; i++)
    {
      AWHelp[i] = XmCreatePushButton(AWPulldown[5], AIHelp[i], NULL, 0);
      XtAddCallback(AWHelp[i], XmNactivateCallback, (XtCallbackProc) CBHelp, &AiHelpMenuID[i]);
    }
  XtManageChildren(AWHelp, i);

  /* Quickbuttons */
  QWframe = XtCreateManagedWidget("quickframe", xmFrameWidgetClass, WRowCol, NULL, 0);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNadjustLast, False);
  nArgs++;
  WQBox = XmCreateRowColumn(QWframe, "qbox", Aargs, nArgs);

  XtManageChild(WQBox);
  /* QWframe = XtCreateManagedWidget(QFLabel, xmFrameWidgetClass, WQBox, NULL, 0); */
  for (i = 0; i < MC_QUICK; i++)
    {
      QWButtons[i] =
	XtCreateManagedWidget(AIQuick[i], xmPushButtonWidgetClass, WQBox, NULL, 0);
      XtAddCallback(QWButtons[i], XmNactivateCallback, (XtCallbackProc) CBQButtons, &AiQButtonsID[i]);
    }

  /* Arbeitsflche */
  WSframe = XtCreateManagedWidget("wsframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WGscrollwin =
    XtVaCreateManagedWidget("scrolwin", xmScrolledWindowWidgetClass, WSframe,
			    XmNscrollingPolicy, XmAUTOMATIC,
			    XmNvisualPolicy, XmVARIABLE,
			    XmNheight, 510,
			    NULL);
  WGdrawarea =
    XtVaCreateManagedWidget("drawwin", xmDrawingAreaWidgetClass, WGscrollwin,
			    XmNheight, 500,
			    XmNwidth, 500,
			    NULL);

  /* dem ScrolledWindow seinen Arbeitsbereich (WorkArea) mitteilen */
  XmScrolledWindowSetAreas(WGscrollwin, NULL, NULL, WGdrawarea);
  /* GCDraw = XmCreateSimpleGC(WGdrawarea); */
  XtAddCallback(WGdrawarea, XmNexposeCallback, (XtCallbackProc) CBRedraw, NULL);

  /* RadioBox erzeugen die Togglebuttons als Kinder hat */
  WRadioFrame = XtCreateManagedWidget("wrframe", xmFrameWidgetClass, WRowCol, NULL, 0);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRadioRow = XmCreateRowColumn(WRadioFrame, "wrrow", Aargs, nArgs);
  XtManageChild(WRadioRow);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNentryClass, xmToggleButtonWidgetClass);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRadioBox = XmCreateRadioBox(WRadioRow, "drawradio", Aargs, nArgs);
  XtManageChild(WRadioBox);

  /* 7 Togglebuttons erzeugen */
  i = 0;
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, True);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("x", xmToggleButtonWidgetClass, WRadioBox, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("y", xmToggleButtonWidgetClass, WRadioBox, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("z", xmToggleButtonWidgetClass, WRadioBox, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("xw", xmToggleButtonWidgetClass, WRadioBox, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("yw", xmToggleButtonWidgetClass, WRadioBox, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("zw", xmToggleButtonWidgetClass, WRadioBox, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[i++] =
    XtCreateManagedWidget("s", xmToggleButtonWidgetClass, WRadioBox, Aargs, nArgs);

  /* Callbacks fr alle Buttons */
  for (i = 0; i < 7; i++)
    XtAddCallback(AWButtonD[i], XmNvalueChangedCallback, (XtCallbackProc) CBDButton, &AiButtonID[i]);

  i = 7;
  AWButtonD[i] =
    XtCreateManagedWidget("[ + ]", xmPushButtonWidgetClass, WRadioRow, NULL, 0);
  XtAddCallback(AWButtonD[i], XmNactivateCallback, (XtCallbackProc) CBDButton, &AiButtonID[i]);

  i++;
  AWButtonD[i] =
    XtCreateManagedWidget("[ - ]", xmPushButtonWidgetClass, WRadioRow, NULL, 0);
  XtAddCallback(AWButtonD[i], XmNactivateCallback, (XtCallbackProc) CBDButton, &AiButtonID[i]);

  i++;
  AWButtonD[i] =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRadioRow, NULL, 0);
  XtAddCallback(AWButtonD[i], XmNactivateCallback, (XtCallbackProc) CBDButton, &AiButtonID[i]);

  /* Statuszeile */
  SWStatusframe = XtCreateManagedWidget(SFLabel, xmFrameWidgetClass, WRowCol, NULL, 0);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  SWStatuslabel = XtCreateManagedWidget(SSLabel, xmLabelWidgetClass, SWStatusframe,
					Aargs, nArgs);

  /* Globale Variable setzen Programm */
  gespeichert = true;

  /*  Listenpointer init */
  init_listpointers();

  /* Label init */
  strcpy(BackgDialog.texthlabel, "0");
  strcpy(BackgDialog.textblabel, "0");
  strcpy(BackgDialog.musthlabel, "0");
  strcpy(BackgDialog.mustblabel, "0");

  strcpy(CoverDialog.musterlabelf, "0");
  strcpy(CoverDialog.musterlabelv, "0");
  strcpy(CoverDialog.texturelabelf, "0");
  strcpy(CoverDialog.texturelabelv, "0");

  strcpy(PolygonDialog.coverlabel, "0");
  PolygonDialog.anzcover = PolygonDialog.nrcover = 0L;

  /* Statuszeile init */
  strcpy(statusstr, "Eingabe: Neu");
  statuszeile(statusstr);

  // Menueeinstellung
  operation = NEU;

  DrawareaData_init(1.0, vector(0.0, 0.0, 0.0), vector(0.0, 0.0, 0.0),
		    vector(0.0, 0.0, 0.0), QB_W_X, 0.1, -1.0);

  ObjAenderDialog_init(1.0, vector(0.0, 0.0, 0.0), vector(0.0, 0.0, 0.0),
		       vector(0.0, 0.0, 0.0));

  Transformstruct_init(1.0, vector(0.0, 0.0, 0.0), vector(0.0, 0.0, 0.0),
		       vector(0.0, 0.0, 0.0));

  ObjDialog_init(1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 'N');

  // Umgebungslicht
  AmbDialog.r = AmbDialog.g = AmbDialog.b = 0.2;

  // Datei zum laden und speichern muss angegeben werden
  strcpy(datei_name, "scene.cad");

  // Background
  BackgDialog.rb = BackgDialog.gb = BackgDialog.rh = BackgDialog.gh = 0.0;
  BackgDialog.bh = BackgDialog.bb = 0.5;
  BackgDialog.scalh = 1.0;
  BackgDialog.scalb = 1.0;

  // Status Licht aus
  lichton = false;

  // Dialog oeffnen
  // c = IDM_OPEN;     
  // CBFile(WGdrawarea, (caddr_t) &c, (caddr_t) NULL);
}
