/*  
   Dialogbox fr die Dateneingabe von Blcken
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

struct blockstruktur BlockDialog;

STRING helpblockdialog = "Definition eines Blockes.";
Widget WBlockDialog, BlockWText1, BlockWText2, BlockWText3, BlockWText4,
  BlockWText5, BlockCoverLabel;
int BlockArt;
grobjekt *block_grobj;
longint block_anknr;


// fr Block
PEXArrayOfVertex vert_array;
PEXCoord vertices[8];
PEXConnectivityData contour_lists[6];
PEXListOfUShort contours[6];
PEXArrayOfFacetData dummy;
unsigned short indices[6][4];


void blocksetvect(vector v1, vector v2, vector v3, vector v4, float l)
{
  vector n, a, b;

  a = v2 - v1;
  b = v3 - v1;
  n |= a && b;

  BlockDialog.p1 = v1;
  BlockDialog.p2 = v2;
  BlockDialog.p3 = v3;
  BlockDialog.p4 = v4;

  BlockDialog.p5 = v1 + n * l;
  BlockDialog.p6 = v2 + n * l;
  BlockDialog.p7 = v3 + n * l;
  BlockDialog.p8 = v4 + n * l;

  BlockDialog.l = l;
}

void
BlockDialog_init(longint Nrcover,
		 vector P1, vector P2, vector P3, vector P4,
		 vector P5, vector P6, vector P7, vector P8)
{
  BlockDialog.nrcover = Nrcover;
  BlockDialog.p1 = P1;
  BlockDialog.p2 = P2;
  BlockDialog.p3 = P3;
  BlockDialog.p4 = P4;
  BlockDialog.p5 = P5;
  BlockDialog.p6 = P6;
  BlockDialog.p7 = P7;
  BlockDialog.p8 = P8;

  BlockDialog.l = abs(P5 - P1);
}

void
BlockDialog_get(longint * Nrcover,
		vector * P1, vector * P2, vector * P3, vector * P4,
		vector * P5, vector * P6, vector * P7, vector * P8)
{
  *Nrcover = BlockDialog.nrcover;
  *P1 = BlockDialog.p1;
  *P2 = BlockDialog.p2;
  *P3 = BlockDialog.p3;
  *P4 = BlockDialog.p4;
  *P5 = BlockDialog.p5;
  *P6 = BlockDialog.p6;
  *P7 = BlockDialog.p7;
  *P8 = BlockDialog.p8;
}

// ##########  Hier die Patches berechnen  #####################
void
create_block_polyline(Display * D, PEXStructure poly, vector p1, vector p2, vector p3,
		      vector p4, vector pn)
{
  //PEXCoord lp, 
  PEXCoord coord[4];

  // Polymarker
  PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(D, poly, PEXOCStore, 3.0);
  PEXSetMarkerColor(D, poly, PEXOCStore, PEXColorTypeRGB, &echo_color);

//   SET_VECTA(p1, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p2, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p3, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);

//   SET_VECTA(p4, lp); 
  //   PEXMarkers(D, poly, PEXOCStore, 1, &lp);

  // Polyline
  SET_VECTA(p1, coord[0]);
  SET_VECTA(p2, coord[1]);
  SET_VECTA(p3, coord[2]);
  SET_VECTA(p1, coord[3]);
  PEXPolyline(D, poly, PEXOCStore, 4, coord);

//   PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCross);
  //   // Normalvektor zeigen
  //   SET_VECTA(p4+(pn*0.1), lp); 
  //   PEXMarkers(D, poly, PEXOCStore, 1, &lp);

//   // Polyline Dreieck
  //   SET_VECTA(p4+(pn*0.1), coord[0]);
  //   SET_VECTA(p4, coord[1]);
  //   PEXPolyline(D, poly, PEXOCStore,  2, coord);
}

void create_block_points(Display * D, PEXStructure obj)
{

  SET_VERTEX_COORD(vertices[0], BlockDialog.p1);
  SET_VERTEX_COORD(vertices[1], BlockDialog.p2);
  SET_VERTEX_COORD(vertices[2], BlockDialog.p3);
  SET_VERTEX_COORD(vertices[3], BlockDialog.p4);
  SET_VERTEX_COORD(vertices[4], BlockDialog.p5);
  SET_VERTEX_COORD(vertices[5], BlockDialog.p6);
  SET_VERTEX_COORD(vertices[6], BlockDialog.p7);
  SET_VERTEX_COORD(vertices[7], BlockDialog.p8);

  vert_array.no_data = vertices;

  // Verbindungsliste
  // Front Face
  contour_lists[0].count = 1;
  contour_lists[0].lists = &contours[0];
  contours[0].count = 4;
  contours[0].shorts = indices[0];
  indices[0][0] = 0;
  indices[0][1] = 1;
  indices[0][2] = 5;
  indices[0][3] = 4;
  // Right Face
  contour_lists[1].count = 1;
  contour_lists[1].lists = &contours[1];
  contours[1].count = 4;
  contours[1].shorts = indices[1];
  indices[1][0] = 1;
  indices[1][1] = 2;
  indices[1][2] = 6;
  indices[1][3] = 5;
  // Back  Face
  contour_lists[2].count = 1;
  contour_lists[2].lists = &contours[2];
  contours[2].count = 4;
  contours[2].shorts = indices[2];
  indices[2][0] = 2;
  indices[2][1] = 3;
  indices[2][2] = 7;
  indices[2][3] = 6;
  // Left  Face
  contour_lists[3].count = 1;
  contour_lists[3].lists = &contours[3];
  contours[3].count = 4;
  contours[3].shorts = indices[3];
  indices[3][0] = 3;
  indices[3][1] = 0;
  indices[3][2] = 4;
  indices[3][3] = 7;
  // Bottom Face
  contour_lists[4].count = 1;
  contour_lists[4].lists = &contours[4];
  contours[4].count = 4;
  contours[4].shorts = indices[4];
  indices[4][0] = 0;
  indices[4][1] = 3;
  indices[4][2] = 2;
  indices[4][3] = 1;
  // Top    Face
  contour_lists[5].count = 1;
  contour_lists[5].lists = &contours[5];
  contours[5].count = 4;
  contours[5].shorts = indices[5];
  indices[5][0] = 4;
  indices[5][1] = 5;
  indices[5][2] = 6;
  indices[5][3] = 7;

}

void aendere_block(Display * D)
{
  PEXStructure *blockp = &(block_grobj->obj_struct);

  /* Aendern */
  block_grobj->cover = BlockDialog.nrcover;	// Covereintrag

  ((cadblock *) (block_grobj->objp))->
    init(BlockDialog.p1, BlockDialog.p2, BlockDialog.p3, BlockDialog.p4,
	 BlockDialog.p5, BlockDialog.p6, BlockDialog.p7, BlockDialog.p8);

  PEXSetEditingMode(D, *blockp, PEXStructureReplace);
  PEXSetElementPtr(D, *blockp, PEXBeginning, 0);
  PEXSetElementPtrAtLabel(D, *blockp, OBJ_POLYLINE_LABEL, 1);

  create_block_points(D, *blockp);

  PEXSetOfFillAreaSets(D, *blockp, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANone, PEXGANone,
		       PEXContourDisjoint, True, PEXColorTypeRGB,
		       6, dummy, 8, vert_array, 24,
		       (PEXSwitch *) NULL, contour_lists);

  un_echo(block_grobj, block_grobj->ch == 'N');
}

void
create_block(Display * D, Widget W, grobjekt * block, longint ank_nr, longint pick_id)
{
  bool echocolor = True;
  PEXCoord ref_point;
  PEXName name[2];
  PEXMatrix matrix;
  PEXVector tr, scale;
  PEXStructure *block_element = NULL;
  grobjekt *ankobj = NULL;

  block->obj_struct = PEXCreateStructure(D);

  // suche strukturpointer zum anhngen
  if (ank_nr == 0L)
    {
      echocolor = True;
      block_element = &root_struct;
      ankobj = NULL;
    }
  else
    {
      if ((ankobj = oliste.getobjp(ank_nr)) != NULL)
	{
	  echocolor = ankobj->ch == 'N';
	  block_element = &ankobj->obj_struct;
	}
      else
	ankobj = NULL;
    }

  // Nameset und Pickid sind wichtig fr das Picken
  name[0] = (PEXName) GROBJSTR;
  name[1] = (PEXName) BLOCK;
  PEXAddToNameSet(D, block->obj_struct, PEXOCStore, 2, name);
  PEXSetPickID(D, block->obj_struct, PEXOCStore, pick_id);

  PEXLabel(D, block->obj_struct, PEXOCStore, COLORLABEL);
  if (block->ch == 'N')
    PEXSetSurfaceColor(D, block->obj_struct, PEXOCStore, PEXColorTypeRGB, &normal_color);
  else
    PEXSetSurfaceColor(D, block->obj_struct, PEXOCStore, PEXColorTypeRGB, &schnitt_color);

  SET_VECT(0.0, 0.0, 0.0, ref_point);
  SET_VECT(0.0, 0.0, 0.0, tr);
  SET_VECT(1.0, 1.0, 1.0, scale);
  PEXBuildTransform(&ref_point, &tr, 0.0, 0.0, 0.0, &scale, matrix);
  PEXLabel(D, block->obj_struct, PEXOCStore, TRANSFORM_LABEL);
  PEXSetLocalTransform(D, block->obj_struct, PEXOCStore, PEXReplace, matrix);
  // Hier werden die Pickelemente eingefgt 
  PEXLabel(D, block->obj_struct, PEXOCStore, OBJ_PICK_ANF_LABEL);
  PEXLabel(D, block->obj_struct, PEXOCStore, OBJ_PICK_END_LABEL);

  PEXLabel(D, block->obj_struct, PEXOCStore, OBJ_POLYLINE_LABEL);

  create_block_points(D, block->obj_struct);

  PEXSetOfFillAreaSets(D, block->obj_struct, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANone, PEXGANone,
		       PEXContourDisjoint, True, PEXColorTypeRGB,
		       6, dummy, 8, vert_array, 24,
		       (PEXSwitch *) NULL, contour_lists);

  // Kennung das hier die Kette beginnt
  PEXLabel(D, block->obj_struct, PEXOCStore, OBJ_KETTE_LABEL);

  /* in Root-Struktur einfgen */
  PEXSetEditingMode(D, *block_element, PEXStructureInsert);
  PEXSetElementPtr(D, *block_element, PEXEnd, 0);
  PEXLabel(D, *block_element, PEXOCStore, GROBJ_LABEL + pick_id);
  PEXExecuteStructure(D, *block_element, PEXOCStore, block->obj_struct);

  un_echo(ankobj, echocolor);
}

void
delete_cover_block_liste(void)
{
  int x, anzelem;

  for (anzelem = 0, coverx = coveranf; coverx; anzelem++, coverx = coverx->next);

  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(BlockDialog.pCoverStr[x]);
}

void
CBBlockOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;
  grobjekt *block;
  longint pick_id;
  vector v1, v2, v3, v4;
  float l;
  char ok;

  /* Text in Zahlen umwandeln */
  str = XmTextGetString(BlockWText1);
  // sscanf(str, "%f;%f;%f", &v1.x, &v1.y, &v1.z);
  if (!(ok = expr_vector(&v1, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor 1 liefert eine ungltige Zahl!");
      return;			// gehe zurck ohne Dialog zu beenden

    }

  str = XmTextGetString(BlockWText2);
  // sscanf(str, "%f;%f;%f", &v2.x, &v2.y, &v2.z);
  if (!(ok = expr_vector(&v2, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor 2 liefert eine ungltige Zahl!");
      return;			// gehe zurck ohne Dialog zu beenden

    }
  if (ok == 2)
    v2 += v1;

  //XmStringFree((XmString)str);
  str = XmTextGetString(BlockWText3);
  // sscanf(str, "%f;%f;%f", &v3.x, &v3.y, &v3.z);
  if (!(ok = expr_vector(&v3, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor 3 liefert eine ungltige Zahl!");
      return;			// gehe zurck ohne Dialog zu beenden

    }
  if (ok == 2)
    v3 += v2;

  // XmStringFree((XmString)str);
  str = XmTextGetString(BlockWText4);
  // sscanf(str, "%f;%f;%f", &v4.x, &v4.y, &v4.z);
  if (!(ok = expr_vector(&v4, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor 4 liefert eine ungltige Zahl!");
      return;			// gehe zurck ohne Dialog zu beenden

    }
  if (ok == 2)
    v4 += v3;

  // XmStringFree((XmString)str);
  str = XmTextGetString(BlockWText5);
  sscanf(str, "%f", &l);
  // XmStringFree((XmString)str);

  blocksetvect(v1, v2, v3, v4, l);

  /* neues Polygon anketten? */
  if (BlockArt == NEU)
    {
      pick_id = ank_grobjekt(BLOCK, block_anknr,
	  ObjDialog.r, ObjDialog.g, ObjDialog.b, ObjDialog.e, ObjDialog.mat,
		  ObjDialog.sp, ObjDialog.du, ObjDialog.dif, ObjDialog.spec,
			     ObjDialog.high, ObjDialog.vel, ObjDialog.ch,
			     BlockDialog.nrcover,
			     vector(0.0, 0.0, 0.0), vector(0.0, 0.0, 0.0));

      block = ank_block(BlockDialog.p1, BlockDialog.p2, BlockDialog.p3, BlockDialog.p4,
	    BlockDialog.p5, BlockDialog.p6, BlockDialog.p7, BlockDialog.p8);

      create_block(XtDisplay(W), W, block, block_anknr, pick_id);
    }
  else
    aendere_block(XtDisplay(W));

  delete_cover_block_liste();

  /* erst hier!!! */
  WObjDialog = NULL;

  XtUnmanageChild(WBlockDialog);
  WBlockDialog = NULL;
}

void
CBBlockCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  delete_cover_block_liste();

  XtUnmanageChild(WBlockDialog);

  /*  erst hier!!! */
  WObjDialog = NULL;

  WBlockDialog = NULL;
}

void
CBBlockHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpblockdialog);
  else
    infobox("helpnureinmal");
}

void
CBBlockCover(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  BlockDialog.nrcover = (((XmListCallbackStruct *) pCallData)->item_position) - 1;
  sprintf(cpos, "%ld", BlockDialog.nrcover);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(BlockCoverLabel, &Aargs, 1);
  strcpy(BlockDialog.coverlabel, cpos);
}

void
create_block_listen(void)
{
  char str[256];
  longint x = 0, anzelem = 0;

  /* CoverListe */
  if (coveranf)
    {
      coverx = coveranf;
      while (coverx)
	{
	  anzelem = coverx->nr;
	  coverx = coverx->next;
	}
      BlockDialog.anzcover = anzelem + 1;
      BlockDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      coverx = coveranf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      BlockDialog.pCoverStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (coverx)
	{
	  sprintf(str, "%ld: Cover", coverx->nr);	/* C String erzeugen */
	  BlockDialog.pCoverStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  coverx = coverx->next;
	  x++;
	}
    }
  else
    {
      /* nur Dummy */
      BlockDialog.anzcover = 1;
      BlockDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString));
      strcpy(str, "0: keine");
      BlockDialog.pCoverStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }
}

void
blockdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art)
{
  Widget WButtonOK, WButtonPick, WButtonCancel, WButtonHelp, WRowCol1,
    WRowCol2, WRowCol3, WRowCol4, frame1, frame2, WLabel, WCoverList;

  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];

  BlockArt = art;
  block_anknr = ank_nr;
  block_grobj = grobjp;

  if (BlockArt == AENDERN)
    {

      ((cadblock *) (block_grobj->objp))->
	get(&BlockDialog.p1, &BlockDialog.p2, &BlockDialog.p3, &BlockDialog.p4,
	&BlockDialog.p5, &BlockDialog.p6, &BlockDialog.p7, &BlockDialog.p8);

      BlockDialog.nrcover = block_grobj->cover;
    }
  else
    BlockDialog_init(0L,
		     vector(0.1, 0.1, 0.1), vector(1.0, 0.10, 0.1),
		     vector(1.00, 1.00, 0.1), vector(0.10, 1.00, 0.1),
		     vector(0.1, 0.1, 0.9), vector(1.0, 0.10, 0.9),
		     vector(1.00, 1.00, 0.9), vector(0.10, 1.00, 0.9));
  /* Nur fr Testzwecke vectorwerte */

  /* Strings fr Listen Aufbauen */
  create_block_listen();

  WBlockDialog = XmCreateDialogShell(W, "blockdialog", NULL, 0);
  XtManageChild(WBlockDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 400);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 430);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WBlockDialog, "blockrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("blockframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "blockrow2", NULL, 0);
  XtManageChild(WRowCol2);

  WLabel = XtCreateManagedWidget("Vektoren x;y;z :", xmLabelWidgetClass, WRowCol2, NULL, 0);

  sprintf(str, "%0.2f;%0.2f;%0.2f", BlockDialog.p1.x, BlockDialog.p1.y, BlockDialog.p1.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  BlockWText1 = XtCreateManagedWidget("blockp1", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f", BlockDialog.p2.x, BlockDialog.p2.y, BlockDialog.p2.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  BlockWText2 = XtCreateManagedWidget("blockp2", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f", BlockDialog.p3.x, BlockDialog.p3.y, BlockDialog.p3.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  BlockWText3 = XtCreateManagedWidget("blockp3", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f", BlockDialog.p4.x, BlockDialog.p4.y, BlockDialog.p4.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  BlockWText4 = XtCreateManagedWidget("blockp4", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f", BlockDialog.l);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  BlockWText5 = XtCreateManagedWidget("blockl", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  /* Cover Auswahl */
  frame2 = XtCreateManagedWidget("blockcoverf", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol4 = XmCreateRowColumn(frame2, "blockc", NULL, 0);
  XtManageChild(WRowCol4);

  sprintf(str, "%ld", BlockDialog.nrcover);

  BlockCoverLabel = XtCreateManagedWidget(str, xmLabelWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, BlockDialog.pCoverStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, BlockDialog.anzcover);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 4);
  nArgs++;
  WCoverList = XmCreateScrolledList(WRowCol4, "blockcover", Aargs, nArgs);
  XtAddCallback(WCoverList, XmNdefaultActionCallback, (XtCallbackProc) CBBlockCover, NULL);
  XtManageChild(WCoverList);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "blockrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonPick);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBBlockOk, NULL);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBBlockCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBBlockHelp, NULL);
}
