/*  
   Dialogbox fr die Dateneingabe einer Bezierflaeche
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"

STRING helpbezierdialog = "Bezier Flchen.";
struct bezierstruktur BezierDialog;

Widget WBezierDialog, BezierDialogWText1, BezierDialogWText2, BezierDialogWText3,
  BezierCoverLabel, WBezierMatrixDialog, WBezierMatrix[4][4];

int BezierDialogArt;
grobjekt *bezier_grobj;
longint bezier_anknr;

// zur Matrixeingabe
void beziermatrixdialog(void);

// Zur Darstellung der Kurve
static float uknots[8] =
{0, 0, 0, 0, 1, 1, 1, 1};
static float vknots[8] =
{0, 0, 0, 0, 1, 1, 1, 1};

// fr Demo
static vector control_points[4][4] =
{
  {vector(-0.5, -0.3, 0.5), vector(-0.2, -0.3, 0.5), vector(0.2, -0.3, 0.5), vector(0.5, -0.3, 0.5)},
  {vector(-0.5, -0.5, 0.7), vector(-0.2, -0.1, 0.7), vector(0.2, -0.1, 0.7), vector(0.5, -0.5, 0.7)},
  {vector(-0.5, -0.5, 1.3), vector(-0.2, -0.1, 1.3), vector(0.2, -0.1, 1.3), vector(0.5, -0.5, 1.3)},
  {vector(-0.5, -0.3, 1.5), vector(-0.2, -0.3, 1.5), vector(0.2, -0.3, 1.5), vector(0.5, -0.3, 1.5)}
};

/*
   static vector control_points[4][4] = 
   {
   { {-0.5,-0.3,0.5},{-0.2,-0.3,0.5},{0.2,-0.3,0.5},{0.5,-0.3,0.5}},
   { {-0.5,-0.5,0.7},{-0.2,-0.1,0.7},{0.2,-0.1,0.7},{0.5,-0.5,0.7}},
   { {-0.5,-0.5,1.3},{-0.2,-0.1,1.3},{0.2,-0.1,1.3},{0.5,-0.5,1.3}},
   { {-0.5,-0.3,1.5},{-0.2,-0.3,1.5},{0.2,-0.3,1.5},{0.5,-0.3,1.5}}
   };
 */
void
BezierDialog_init(longint Nrcover, longint X, longint Z, vector(*Pbuf)[4][4])
{
  int zy, zx;

  BezierDialog.nrcover = Nrcover;
  BezierDialog.x = X;
  BezierDialog.z = Z;

  // Matrix kopieren
  if (Pbuf)
    {
      for (zy = 0; zy < 4; zy++)
	for (zx = 0; zx < 4; zx++)
	  BezierDialog.pbuf[zy][zx] = (*Pbuf)[zy][zx];
    }
  else
    for (zy = 0; zy < 4; zy++)
      for (zx = 0; zx < 4; zx++)
	BezierDialog.pbuf[zy][zx] = control_points[zy][zx];
}

void
BezierDialog_get(longint * Nrcover, longint * X, longint * Z, vector(*Pbuf)[4][4])
{
  int zy, zx;

  *Nrcover = BezierDialog.nrcover;
  *X = BezierDialog.x;
  *Z = BezierDialog.z;

  // Matrix kopieren
  for (zy = 0; zy < 4; zy++)
    for (zx = 0; zx < 4; zx++)
      (*Pbuf)[zy][zx] = BezierDialog.pbuf[zy][zx];
}


void
aendere_bezier(grobjekt * beziero)
{
  PEXPSCData psc;
  PEXArrayOfCoord grid;
  PEXStructure *pbezier = &(beziero->obj_struct);

  // Aendern
  beziero->cover = BezierDialog.nrcover;	// Covereintrag

  ((cadbezier *) (beziero->objp))->
    init(BezierDialog.x, BezierDialog.z, BezierDialog.pbuf);

  PEXSetEditingMode(pDisplay, *pbezier, PEXStructureReplace);
  PEXSetElementPtr(pDisplay, *pbezier, PEXBeginning, 0);
  PEXSetElementPtrAtLabel(pDisplay, *pbezier, OBJ_BEZIER_LABEL, 1);

  // Set the parametric surface characteristics.
  psc.iso_curves.placement_type = PEXUniformPlacement;
  psc.iso_curves.u_count = ((cadbezier *) (beziero->objp))->x - 1;	// Genauigkeit

  psc.iso_curves.v_count = ((cadbezier *) (beziero->objp))->z - 1;	// Genauigkeit

  PEXSetParaSurfCharacteristics(pDisplay, *pbezier, PEXOCStore, PEXPSCIsoCurves, &psc);

  // Set the surface approximation criteria.
  PEXSetSurfaceApprox(pDisplay, *pbezier, PEXOCStore,
		      PEXApproxConstantBetweenKnots,
		      (double) ((cadbezier *) (beziero->objp))->x - 1,	// Genauigkeit Bildschirm
		       (double) ((cadbezier *) (beziero->objp))->z - 1);

  // Create the surface.
  grid.point = (PEXCoord *) & ((cadbezier *) (beziero->objp))->pbuf;

  PEXNURBSurface(pDisplay, *pbezier, PEXOCStore, PEXNonRational,
		 4, 4,		// Grad
		  uknots, vknots,	// Knotenvektoren
		  4, 4,		// Anzahl der Punket in der Matrix
		  grid, 0, (PEXListOfTrimCurve *) NULL);

  un_echo(beziero, beziero->ch == 'N');
}

void
create_bezier(Display * D, Widget W, grobjekt * pbezier, longint ank_nr, longint pick_id)
{
  bool echocolor = True;
  PEXName name[2];
  PEXMatrix matrix;
  PEXVector tr, scale;
  PEXCoord ref_point;
  PEXStructure *bezier_element = NULL;
  grobjekt *ankobj = NULL;

  PEXPSCData psc;
  PEXArrayOfCoord grid;

  // suche strukturpointer zum anhngen
  if (ank_nr == 0L)
    {
      echocolor = True;
      bezier_element = &root_struct;
      ankobj = NULL;
    }
  else
    {
      if ((ankobj = oliste.getobjp(ank_nr)) != NULL)
	{
	  echocolor = ankobj->ch == 'N';
	  bezier_element = &ankobj->obj_struct;
	}
      else
	ankobj = NULL;
    }

  // Nameset und Pickid sind wichtig fr das Picken
  name[0] = (PEXName) GROBJSTR;
  name[1] = (PEXName) BEZIER;
  PEXAddToNameSet(D, pbezier->obj_struct, PEXOCStore, 2, name);
  PEXSetPickID(D, pbezier->obj_struct, PEXOCStore, pick_id);

  PEXLabel(D, pbezier->obj_struct, PEXOCStore, COLORLABEL);
  if (pbezier->ch == 'N')
    PEXSetSurfaceColor(D, pbezier->obj_struct, PEXOCStore, PEXColorTypeRGB, &normal_color);
  else
    PEXSetSurfaceColor(D, pbezier->obj_struct, PEXOCStore, PEXColorTypeRGB, &schnitt_color);

  SET_VECT(0.0, 0.0, 0.0, tr);
  SET_VECT(0.0, 0.0, 0.0, ref_point);
  SET_VECT(1.0, 1.0, 1.0, scale);
  PEXBuildTransform(&ref_point, &tr, 0.0, 0.0, 0.0, &scale, matrix);
  PEXLabel(D, pbezier->obj_struct, PEXOCStore, TRANSFORM_LABEL);
  PEXSetLocalTransform(D, pbezier->obj_struct, PEXOCStore, PEXReplace, matrix);

  // Hier werden die Pickelemente eingefgt 
  PEXLabel(D, pbezier->obj_struct, PEXOCStore, OBJ_PICK_ANF_LABEL);
  PEXLabel(D, pbezier->obj_struct, PEXOCStore, OBJ_PICK_END_LABEL);

  PEXLabel(D, pbezier->obj_struct, PEXOCStore, OBJ_BEZIER_LABEL);

  // Set the parametric surface characteristics.
  psc.iso_curves.placement_type = PEXUniformPlacement;
  psc.iso_curves.u_count = ((cadbezier *) (pbezier->objp))->x - 1;	// Genauigkeit

  psc.iso_curves.v_count = ((cadbezier *) (pbezier->objp))->z - 1;	// Genauigkeit

  PEXSetParaSurfCharacteristics(D, pbezier->obj_struct, PEXOCStore, PEXPSCIsoCurves, &psc);

  // Set the surface approximation criteria.
  PEXSetSurfaceApprox(D, pbezier->obj_struct, PEXOCStore,
		      PEXApproxConstantBetweenKnots,
		      (double) ((cadbezier *) (pbezier->objp))->x - 1,	// Genauigkeit Bildschirm
		       (double) ((cadbezier *) (pbezier->objp))->z - 1);

  // Create the surface
  grid.point = (PEXCoord *) & ((cadbezier *) (pbezier->objp))->pbuf;

  PEXNURBSurface(D, pbezier->obj_struct, PEXOCStore, PEXNonRational,
		 4, 4,		// Grad
		  uknots, vknots,	// Knotenvektoren
		  4, 4,		// Anzahl der Punket in d Matrix
		  grid, 0, (PEXListOfTrimCurve *) NULL);

  // Kennung das hier die Kette beginnt
  PEXLabel(D, pbezier->obj_struct, PEXOCStore, OBJ_KETTE_LABEL);

  // in Root-Struktur einfgen 
  PEXSetEditingMode(D, *bezier_element, PEXStructureInsert);
  PEXSetElementPtr(D, *bezier_element, PEXEnd, 0);
  PEXLabel(D, *bezier_element, PEXOCStore, GROBJ_LABEL + pick_id);
  PEXExecuteStructure(D, *bezier_element, PEXOCStore, pbezier->obj_struct);

  un_echo(ankobj, echocolor);
}

void
delete_cover_bezier_liste(void)
{
  int x, anzelem;
  for (anzelem = 0, coverx = coveranf; coverx; anzelem++, coverx = coverx->next);
  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(BezierDialog.pCoverStr[x]);
}

void
CBBezierMatrixOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  int zx, zz;
  grobjekt *pbezier;
  STRING str;
  longint pick_id;
  char ok;

  for (zz = 0; zz < 4; zz++)
    for (zx = 0; zx < 4; zx++)
      {
	str = XmTextGetString(WBezierMatrix[zx][zz]);
	if (!(ok = expr_vector(&BezierDialog.pbuf[zx][zz], str)))	// 0 Fehler, 1 OK, 2 Relativ

	  {
	    errorbox("Vektor p1 liefert eine ungltige Zahl!");
	    return;		// gehe zurck ohne Dialog zu beenden

	  }
	if (ok == 2)
	  BezierDialog.pbuf[zx][zz] += BezierDialog.pbuf[zx - 1][zz - 1];
      }

  // erst hier Datenstruktur erzeugen
  if (BezierDialogArt == NEU)
    {
      pick_id = ank_grobjekt(BEZIER, bezier_anknr,
	  ObjDialog.r, ObjDialog.g, ObjDialog.b, ObjDialog.e, ObjDialog.mat,
		  ObjDialog.sp, ObjDialog.du, ObjDialog.dif, ObjDialog.spec,
			     ObjDialog.high, ObjDialog.vel, ObjDialog.ch,
			     BezierDialog.nrcover, vector(0.0, 0.0, 0.0),
			     vector(0.0, 0.0, 0.0));
      pbezier = ank_bezier(BezierDialog.x, BezierDialog.z, BezierDialog.pbuf);
      create_bezier(XtDisplay(W), W, pbezier, bezier_anknr, pick_id);
    }
  else
    aendere_bezier(bezier_grobj);

  delete_cover_bezier_liste();
  XtUnmanageChild(WBezierMatrixDialog);
  WBezierMatrixDialog = NULL;
}

void
CBBezierMatrixCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  XtUnmanageChild(WBezierMatrixDialog);

  WBezierMatrixDialog = NULL;
}

void
CBBezierOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{

  STRING str;
  int x, z;

  //  Text in Zahlen umwandeln
  str = XmTextGetString(BezierDialogWText1);
  sscanf(str, "%d;%d", &x, &z);
  BezierDialog.x = x;
  BezierDialog.z = z;

  // Dialog zur Eingabe der Matrix
  beziermatrixdialog();

  /* erst hier!!! */
  WObjDialog = NULL;

  XtUnmanageChild(WBezierDialog);
  WBezierDialog = NULL;
}

void
CBBezierCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  delete_cover_bezier_liste();
  XtUnmanageChild(WBezierDialog);

  /*  erst hier!!! */
  WObjDialog = NULL;

  WBezierDialog = NULL;
}

void
CBBezierHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpbezierdialog);
  else
    infobox("helpnureinmal");
}

void
CBBezierCover(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  BezierDialog.nrcover = (((XmListCallbackStruct *) pCallData)->item_position) - 1;
  sprintf(cpos, "%ld", BezierDialog.nrcover);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(BezierCoverLabel, &Aargs, 1);
  strcpy(BezierDialog.coverlabel, cpos);
}

void
create_bezier_listen(void)
{
  char str[256];
  longint x = 0, anzelem = 0;

  /* CoverListe */
  if (coveranf)
    {
      coverx = coveranf;
      while (coverx)
	{
	  anzelem = coverx->nr;
	  coverx = coverx->next;
	}
      BezierDialog.anzcover = anzelem + 1;
      BezierDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      coverx = coveranf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      BezierDialog.pCoverStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (coverx)
	{
	  sprintf(str, "%ld: Cover", coverx->nr);	/* C String erzeugen */
	  BezierDialog.pCoverStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  coverx = coverx->next;
	  x++;
	}
    }
  else
    {
      /* nur Dummy */
      BezierDialog.anzcover = 1;
      BezierDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString));
      strcpy(str, "0: keine");
      BezierDialog.pCoverStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }
}

void
bezierdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art)
{
  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    WRowCol4, frame1, frame2, WLabel, WCoverList;

  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];

  BezierDialogArt = art;
  bezier_anknr = ank_nr;
  bezier_grobj = grobjp;

  if (BezierDialogArt == AENDERN)
    {
      ((cadbezier *) (bezier_grobj->objp))->
	get(&BezierDialog.x, &BezierDialog.z, &BezierDialog.pbuf);
      // zustzlich
      BezierDialog.nrcover = bezier_grobj->cover;
    }
  else
    BezierDialog_init(0L, 6, 6, NULL);

  /* Strings fr Listen Aufbauen */
  create_bezier_listen();

  WBezierDialog = XmCreateDialogShell(W, "bezierdialog", NULL, 0);
  XtManageChild(WBezierDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 350);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 260);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WBezierDialog, "bezierrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("bezierframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "bezierrow2", NULL, 0);
  XtManageChild(WRowCol2);

  WLabel = XtCreateManagedWidget("Punkte x,z:",
				 xmLabelWidgetClass, WRowCol2, NULL, 0);

  sprintf(str, "%ld;%ld", BezierDialog.x, BezierDialog.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  BezierDialogWText1 =
    XtCreateManagedWidget("bezierp", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  /* Cover Auswahl */
  frame2 = XtCreateManagedWidget("beziercoverf", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol4 = XmCreateRowColumn(frame2, "bezierc4", NULL, 0);
  XtManageChild(WRowCol4);

  sprintf(str, "%ld", BezierDialog.nrcover);
  BezierCoverLabel = XtCreateManagedWidget(str, xmLabelWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, BezierDialog.pCoverStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, BezierDialog.anzcover);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 4);
  nArgs++;
  WCoverList = XmCreateScrolledList(WRowCol4, "beziercover", Aargs, nArgs);
  XtAddCallback(WCoverList, XmNdefaultActionCallback, (XtCallbackProc) CBBezierCover, NULL);
  XtManageChild(WCoverList);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "bezierrow3", Aargs, nArgs);
  // XtManageChild(WRowCol3);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);

  XtManageChild(WRowCol3);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBBezierOk, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBBezierCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBBezierHelp, NULL);
}

void
beziermatrixdialog(void)
{
  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[80];
  longint zx, zz;

  Widget WButtonOK, WButtonPick, WButtonCancel, WRowCol, WRowCol2, WRowColM,
    WEscrollwin, Wframe;

  WBezierMatrixDialog = XmCreateDialogShell(WTop, "matrixdialog", NULL, 0);
  XtManageChild(WBezierMatrixDialog);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 690);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 400);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol = XmCreateRowColumn(WBezierMatrixDialog, "matrixrow", Aargs, nArgs);
  XtManageChild(WRowCol);

  /* Arbeitsflche */
  Wframe = XtCreateManagedWidget("matrixframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WEscrollwin =
    XtVaCreateManagedWidget("matrixscrol", xmScrolledWindowWidgetClass, Wframe,
			    XmNscrollingPolicy, XmAUTOMATIC,
			    XmNvisualPolicy, XmVARIABLE,
			    XmNwidth, 580,
			    XmNheight, 300,
			    NULL);

  // Eingabezeilen anordnen
  WRowColM = XtVaCreateManagedWidget("matrixrowm", xmRowColumnWidgetClass, WEscrollwin,
				     XmNorientation, XmHORIZONTAL,
				     XmNpacking, XmPACK_COLUMN,
				     XmNnumColumns, 4,
				     NULL);

  for (zz = 0; zz < 4; zz++)
    for (zx = 0; zx < 4; zx++)
      {
	// if (BezierDialogArt == AENDERN)
	sprintf(str, "%0.1f;%0.1f;%0.1f",
		BezierDialog.pbuf[zz][zx].x, BezierDialog.pbuf[zz][zx].y,
		BezierDialog.pbuf[zz][zx].z);

	nArgs = 0;
	XtSetArg(Aargs[nArgs], XmNvalue, str);
	nArgs++;
	XtSetArg(Aargs[nArgs], XmNwidth, 150);
	nArgs++;
	WBezierMatrix[zx][zz] =
	  XtCreateManagedWidget("matrixt", xmTextWidgetClass, WRowColM, Aargs, nArgs);
      }

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(WRowCol, "matrixrow2", Aargs, nArgs);
  // XtManageChild(WRowCol2);

  WButtonOK = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonOK);
  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBBezierMatrixOk, NULL);

  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonPick);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);

  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol2, NULL, 0);
  XtManageChild(WButtonCancel);
  XtManageChild(WRowCol2);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBBezierMatrixCancel, NULL);
}
