/*  
   Dialogbox fr Hintergrund
   Copyright (C) 1996, 1997 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cadtool.H"

STRING helpbackgdialog = "Definition der Hintergrundstruktur.";

struct backgstruktur BackgDialog;
GC BackgDialogGCFarbe;

Widget WBackgDialog, BackgTextureHLabel, BackgMusterHLabel, BackgTextureBLabel,
  BackgMusterBLabel, WVerschXH, WVerschYH, WMScalH, WVerschXB, WVerschYB,
  WMScalB;



#define BACKGROUND_MAX_BUTTONS 12

void
delete_BackgDialoglisten(void)
{
  int x, anzelem;

  for (anzelem = 0, mustx = mustanf; mustx; anzelem++, mustx = mustx->next);
  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(BackgDialog.pBackgMusterHStr[x]);

  for (anzelem = 0, textx = textanf; textx; anzelem++, textx = textx->next);
  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(BackgDialog.pBackgTextureHStr[x]);
}

void
BackgFarbealloc(Widget W)
{
  BackgDialog.XCol.flags = DoRed | DoGreen | DoBlue;
  BackgDialog.XCol.red = (unsigned) (BackgDialog.rh * 65535.0);
  BackgDialog.XCol.green = (unsigned) (BackgDialog.gh * 65535.0);
  BackgDialog.XCol.blue = (unsigned) (BackgDialog.bh * 65535.0);
  if (BackgDialog.privat)
    XStoreColor(XtDisplay(W), BackgDialog.CMap, &BackgDialog.XCol);
  else
    XAllocColor(XtDisplay(W), BackgDialog.CMap, &BackgDialog.XCol);
}

void
BackgFarbanzeige()
{
  if (BackgDialog.Win)
    {
      XSetForeground(BackgDialog.pD, BackgDialogGCFarbe, BackgDialog.XCol.pixel);
      XFillRectangle(BackgDialog.pD, BackgDialog.Win, BackgDialogGCFarbe, 1, 1, 245, 25);
    }
}

void
CBBackgFarbanzeige(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  BackgDialog.Win = ((XmDrawingAreaCallbackStruct *) pCallData)->window;
  if (BackgDialog.Win != 0)
    {
      BackgDialog.pD = XtDisplay(W);
      XSetForeground(BackgDialog.pD, BackgDialogGCFarbe, BackgDialog.XCol.pixel);
      XFillRectangle(BackgDialog.pD, BackgDialog.Win, BackgDialogGCFarbe, 1, 1, 245, 25);
    }
}


void
CBBackgOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;
  /* Farbe freigeben */
  if (BackgDialog.privat)
    XFreeColors(BackgDialog.pD, BackgDialog.CMap, &BackgDialog.XCol.pixel, 1, 0);
  /* Text Widgets auslesen */
  str = XmTextGetString(WVerschXH);
  sscanf(str, "%f", &BackgDialog.verschxh);
  str = XmTextGetString(WVerschYH);
  sscanf(str, "%f", &BackgDialog.verschyh);
  str = XmTextGetString(WMScalH);
  sscanf(str, "%f", &BackgDialog.scalh);
  str = XmTextGetString(WVerschXB);
  sscanf(str, "%f", &BackgDialog.verschxb);
  str = XmTextGetString(WVerschYB);
  sscanf(str, "%f", &BackgDialog.verschyb);
  str = XmTextGetString(WMScalB);
  sscanf(str, "%f", &BackgDialog.scalb);
  delete_BackgDialoglisten();
  /* Dialog schlieen */
  XtUnmanageChild(WBackgDialog);
  WBackgDialog = NULL;
}

void
CBBackgCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  delete_BackgDialoglisten();

  /* Farbe freigeben */
  if (BackgDialog.privat)
    XFreeColors(BackgDialog.pD, BackgDialog.CMap, &BackgDialog.XCol.pixel, 1, 0);

  XtUnmanageChild(WBackgDialog);
  WBackgDialog = NULL;
}

void
CBBackgHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpbackgdialog);
  else
    infobox("helpnureinmal");
}

void
CBBackgScaleCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *) pClientData)
    {
    case 1:
      BackgDialog.rh = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 2:
      BackgDialog.gh = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 3:
      BackgDialog.bh = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 4:
      BackgDialog.rb = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 5:
      BackgDialog.gb = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 6:
      BackgDialog.bb = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 7:
      BackgDialog.entfernung = ((float) ((XmScaleCallbackStruct *) pCallData)->value) / 10.0;
      break;
    case 8:
      BackgDialog.zufall = ((XmScaleCallbackStruct *) pCallData)->value;
      break;
    default:
      fprintf(stderr, "BackgroundRegler %d\n", *(int *) pClientData);
    }
  BackgFarbealloc(W);
  BackgFarbanzeige();
}

/* zeigt selektierte Textur im Label an */
void
CBBackgTextureHimmel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  BackgDialog.textnrh = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", BackgDialog.textnrh);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(BackgTextureHLabel, &Aargs, 1);
  strcpy(BackgDialog.texthlabel, cpos);
}

/* zeigt selektiertes Muster im Label an */
void
CBBackgMusterHimmel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  BackgDialog.mustnrh = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", BackgDialog.mustnrh);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(BackgMusterHLabel, &Aargs, 1);
  strcpy(BackgDialog.musthlabel, cpos);
}

/* zeigt selektierte Textur im Label an */
void
CBBackgTextureBoden(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  BackgDialog.textnrb = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", BackgDialog.textnrb);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(BackgTextureBLabel, &Aargs, 1);
  strcpy(BackgDialog.textblabel, cpos);
}

/* zeigt selektiertes Muster im Label an */
void
CBBackgMusterBoden(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  BackgDialog.mustnrb = ((XmListCallbackStruct *) pCallData)->item_position - 1;
  sprintf(cpos, "%d", BackgDialog.mustnrb);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(BackgMusterBLabel, &Aargs, 1);
  strcpy(BackgDialog.mustblabel, cpos);
}


void
CBButtonH(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /*  nur einschalten ist interresant */
  if (((XmToggleButtonCallbackStruct *) pCallData)->set)
    BackgDialog.turbarth = *(int *) pClientData - 1;
}

void
CBButtonB(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /*  nur einschalten ist interresant */
  if (((XmToggleButtonCallbackStruct *) pCallData)->set)
    BackgDialog.turbartb = *(int *) pClientData - 1;
}

void
CBRauschenH(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  BackgDialog.rauschh = ((XmToggleButtonCallbackStruct *) pCallData)->set;
}

void
CBRauschenB(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  BackgDialog.rauschb = ((XmToggleButtonCallbackStruct *) pCallData)->set;
}

void
CBFreqHCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  BackgDialog.freqh = ((XmScaleCallbackStruct *) pCallData)->value;
}

void
CBFreqBCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  BackgDialog.freqb = ((XmScaleCallbackStruct *) pCallData)->value;
}

void
create_bkg_listen(void)
{
  char str[256];
  int x = 0, anzelem = 0;

  /* TextureListe */
  if (textanf)
    {
      textx = textanf;
      while (textx)
	{
	  anzelem = textx->nr;
	  textx = textx->next;
	}
      BackgDialog.anztexture = anzelem + 1;
      BackgDialog.pBackgTextureHStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      textx = textanf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      BackgDialog.pBackgTextureHStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (textx)
	{
	  sprintf(str, "%d: %s", (int) textx->nr, textx->name);		/* C String erzeugen */
	  BackgDialog.pBackgTextureHStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  textx = textx->next;
	  x++;
	}
    }
  else
    {
      /* nur Dummy */
      BackgDialog.anztexture = 1;
      BackgDialog.pBackgTextureHStr = (XmString *) XtMalloc(sizeof(XmString));
      strcpy(str, "0: keine");
      BackgDialog.pBackgTextureHStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }


  /* Musterliste */
  if (mustanf)
    {
      mustx = mustanf;
      while (mustx)
	{
	  anzelem = mustx->nr;
	  mustx = mustx->next;
	}
      BackgDialog.anzmuster = anzelem + 1;
      BackgDialog.pBackgMusterHStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      mustx = mustanf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "kein");	/* C String erzeugen */
      BackgDialog.pBackgMusterHStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (mustx)
	{
	  sprintf(str, "%ld: %s", mustx->nr, mustx->name);	/* C String erzeugen */
	  BackgDialog.pBackgMusterHStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  mustx = mustx->next;
	  x++;
	}
    }
  else
    {
      BackgDialog.anzmuster = 1;
      BackgDialog.pBackgMusterHStr = (XmString *) XtMalloc(sizeof(XmString));
      /* Dummy fr kein */
      strcpy(str, "0: kein");
      BackgDialog.pBackgMusterHStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }
}


void
backgdialog(Widget W)
{
  unsigned long pixel;
  char str[80];

  Widget WButtonOK, /* WButtonCancel, */ WButtonHelp, WRowCol1, WRowCol2,
    WRowCol3, WRowCol4, WRowCol5, WRowCol6, WRowCol7, WRowCol8, WRowCol9,
    WRowCol10, WRowCol11, WRowCol12, WRowCol13, WRowCol14, WRowCol15, WRowCol16,
    WScale[3], frame1, frame2, frame3, frame4, frame5, frame6, frame7,
    frame8, frame9, frame10, frame11, frame12, frame13, frame14, Wdrawarea,
    WLabel, AWButtonH[BACKGROUND_MAX_BUTTONS], AWButtonB[BACKGROUND_MAX_BUTTONS],
    WRadioBoxH, WRadioBoxB, WTextListH, WMustListH, WTextListB, WMustListB,
    WVerschXHL, WVerschYHL, WVerschXBL, WVerschYBL, WRauschenH, WFrequenzH,
    WMScalHL, WRauschenB, WFrequenzB, WMScalBL;


  /* Definitionen */
  static int AiButtonID[] =  { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 };

  STRING AIScale[] =
  {"backgrh1", "backgrh2", "backgrh3", "backgrb1", "backgrb2", "backgrb3", 
   "backentf", "backanz"};

  static int AIScaleID[] =  { 1, 2, 3, 4, 5, 6, 7, 8 };

  int nScale, maxScale = 8, nArgs, nButton;
  Arg Aargs[MAX_ARGS];
  XmString mstr;

  /* Strings fr Listen Aufbauen */
  create_bkg_listen();


  // Leider noch kein Widget dafr, um dies im CAD-Tool einstellen zu knnen
  //BackgDialog.entfernung = 2.0;
  //BackgDialog.zufall = 32;

  // Labels laden
  sprintf(BackgDialog.texthlabel, "%d", BackgDialog.textnrh);
  sprintf(BackgDialog.textblabel, "%d", BackgDialog.textnrb);
  sprintf(BackgDialog.musthlabel, "%d", BackgDialog.mustnrh);
  sprintf(BackgDialog.mustblabel, "%d", BackgDialog.mustnrb);

  /* Der Dialog */
  WBackgDialog = XmCreateDialogShell(W, "backgdialog", NULL, 0);
  XtManageChild(WBackgDialog);

  /* Umrahmung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 730);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 550);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WBackgDialog, "backgdrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  /* fr Regler */
  frame1 = XtCreateManagedWidget("backgframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 1);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(frame1, "backgdrow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  /* fr Farbanzeige */
  frame2 = XtCreateManagedWidget("backgframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNadjustLast, True);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(frame2, "backgdrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);
  /* Farbanzeige */
  WLabel = XtCreateManagedWidget("Farbe         :", xmLabelWidgetClass, WRowCol3, NULL, 0);

  /* Scalen */
  for (nScale = 0; nScale < maxScale; nScale++)
    {
      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNshowValue, True);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
      nArgs++;
      switch (nScale)
	{
	case 0:
      	  mstr = XmStringCreateLtoR("RH", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, BackgDialog.rh * 100.0);
	  break;
	case 1:
	  mstr = XmStringCreateLtoR("GH", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, BackgDialog.gh * 100.0);
	  break;
	case 2:
	  mstr = XmStringCreateLtoR("BH", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, BackgDialog.bh * 100.0);
	  break;
	case 3:
	  mstr = XmStringCreateLtoR("RB", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, BackgDialog.rb * 100.0);
	  break;
	case 4:
	  mstr = XmStringCreateLtoR("GB", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, BackgDialog.bh * 100.0);
	  break;
	case 5:
	  mstr = XmStringCreateLtoR("BB", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, BackgDialog.bb * 100.0);
	  break;
	case 6:
	  nArgs = 0;
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 1);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Entf", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, BackgDialog.entfernung * 10.0);
	  break;
	case 7:
	  nArgs=0;
	  XtSetArg(Aargs[nArgs], XmNshowValue, True);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Zufall", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, BackgDialog.zufall);
	  break;
	}
      nArgs++;
      WScale[nScale] =
	XtCreateManagedWidget(AIScale[nScale], xmScaleWidgetClass, WRowCol2, Aargs, nArgs);
      XtAddCallback(WScale[nScale], XmNvalueChangedCallback,
		    (XtCallbackProc) CBBackgScaleCanged, &AIScaleID[nScale]);
    }

  /* Fr Farbnderung eine ColorCell holen */
  BackgDialog.pD = XtDisplay(WTop);
  BackgDialog.CMap = DefaultColormap(BackgDialog.pD, DefaultScreen(BackgDialog.pD));
  BackgDialog.privat = true;

  if (XAllocColor(BackgDialog.pD, BackgDialog.CMap, &BackgDialog.XCol))
    {
      BackgDialog.privat = false;
      BackgFarbealloc(WTop);
    }
  else if (!XAllocColorCells(BackgDialog.pD, BackgDialog.CMap, false, NULL, 0, &pixel, 1))
    {
      infobox("keinefarbzelle");
      BackgDialog.privat = false;
    }
  if (BackgDialog.privat)
    {
      BackgDialog.XCol.pixel = pixel;
      BackgFarbealloc(WTop);
    }
  Wdrawarea =
    XtCreateManagedWidget("backgdrawcol", xmDrawingAreaWidgetClass, WRowCol3, NULL, 0);
  /* Callbacks um neu zu zeichnen */
  XtAddCallback(Wdrawarea, XmNexposeCallback, (XtCallbackProc) CBBackgFarbanzeige, NULL);
  XtAddCallback(Wdrawarea, XmNresizeCallback, (XtCallbackProc) CBBackgFarbanzeige, NULL);

  /* GC erzeugen um zeichnen zu knnen */
  BackgDialogGCFarbe = CreateSimpleGC(Wdrawarea);

  /* Himmel */

  /* fr Himmel */
  frame3 = XtCreateManagedWidget("backgframe3", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNadjustLast, True);
  nArgs++;
  WRowCol4 = XmCreateRowColumn(frame3, "backgdrow4", Aargs, nArgs);
  XtManageChild(WRowCol4);

  /* Erzeugen der Liste und Initialiesierung mit Listeneintrgen */
  /* Texturenummer */

  /* fr Texturanzeige Himmel */
  frame5 = XtCreateManagedWidget("backgtextur1", xmFrameWidgetClass, WRowCol4, NULL, 0);
  WRowCol7 = XmCreateRowColumn(frame5, "backgtextur1r", NULL, 0);
  XtManageChild(WRowCol7);

  BackgTextureHLabel =
    XtCreateManagedWidget(BackgDialog.texthlabel, xmLabelWidgetClass, WRowCol7, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, BackgDialog.pBackgTextureHStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, BackgDialog.anztexture);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WTextListH = XmCreateScrolledList(WRowCol7, "backtexturehlist", Aargs, nArgs);
  XtAddCallback(WTextListH, XmNdefaultActionCallback, (XtCallbackProc) CBBackgTextureHimmel, NULL);
  XtManageChild(WTextListH);

  /* fr Musteranzeige Himmel */
  frame6 = XtCreateManagedWidget("backgmuster1", xmFrameWidgetClass, WRowCol4, NULL, 0);
  WRowCol8 = XmCreateRowColumn(frame6, "backgmuster1f", NULL, 0);
  XtManageChild(WRowCol8);

  BackgMusterHLabel =
    XtCreateManagedWidget(BackgDialog.musthlabel, xmLabelWidgetClass, WRowCol8, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, BackgDialog.pBackgMusterHStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, BackgDialog.anzmuster);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WMustListH = XmCreateScrolledList(WRowCol8, "backmusthlist", Aargs, nArgs);
  XtAddCallback(WMustListH, XmNdefaultActionCallback, (XtCallbackProc) CBBackgMusterHimmel, NULL);
  XtManageChild(WMustListH);

  /* Verschiebung des Musters Himmel */
  frame7 = XtCreateManagedWidget("backgverschxhf", xmFrameWidgetClass, WRowCol4, NULL, 0);
  WRowCol9 = XmCreateRowColumn(frame7, "backgverschxhr", NULL, 0);
  XtManageChild(WRowCol9);

  WVerschXHL = XtCreateManagedWidget("Versch X", xmLabelWidgetClass, WRowCol9, NULL, 0);
  sprintf(str, "%0.2f", BackgDialog.verschxh);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  WVerschXH = XtCreateManagedWidget("backgxh", xmTextWidgetClass, WRowCol9, Aargs, nArgs);

  WVerschYHL = XtCreateManagedWidget("Versch Y", xmLabelWidgetClass, WRowCol9, NULL, 0);
  sprintf(str, "%0.2f", BackgDialog.verschyh);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  WVerschYH = XtCreateManagedWidget("backgyh", xmTextWidgetClass, WRowCol9, Aargs, nArgs);

  /* Turbolenzart: keine Muster Helligk beide */
  frame9 = XtCreateManagedWidget("backgframe9", xmFrameWidgetClass, WRowCol4, NULL, 0);
  WRowCol11 = XmCreateRowColumn(frame9, "backgdrow11", NULL, 0);
  XtManageChild(WRowCol11);

  /* RadioBox erzeugen die Togglebuttons als Kinder hat */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNentryClass, xmToggleButtonWidgetClass);
  nArgs++;
  WRadioBoxH = XmCreateRadioBox(WRowCol11, "backgradiobox", Aargs, nArgs);
  XtManageChild(WRadioBoxH);

  /* 4 Togglebuttons erzeugen */
  if (BackgDialog.turbarth < 0 || BackgDialog.turbarth > 4)
    BackgDialog.turbarth = 0;
  nButton = 0;
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (BackgDialog.turbarth + 1) == 1);
  nArgs++;
  AWButtonH[nButton++] =
    XtCreateManagedWidget("kein", xmToggleButtonWidgetClass, WRadioBoxH, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (BackgDialog.turbarth + 1) == 2);
  nArgs++;
  AWButtonH[nButton++] =
    XtCreateManagedWidget("Muster", xmToggleButtonWidgetClass, WRadioBoxH, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (BackgDialog.turbarth + 1) == 3);
  nArgs++;
  AWButtonH[nButton++] =
    XtCreateManagedWidget("Farbe", xmToggleButtonWidgetClass, WRadioBoxH, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (BackgDialog.turbarth + 1) == 4);
  nArgs++;
  AWButtonH[nButton++] =
    XtCreateManagedWidget("Beides", xmToggleButtonWidgetClass, WRadioBoxH, Aargs, nArgs);
  /* Callbacks fr alle Buttons */
  for (nButton = 0; nButton < 4; nButton++)
    XtAddCallback(AWButtonH[nButton], XmNvalueChangedCallback, (XtCallbackProc) CBButtonH, &AiButtonID[nButton]);


  /* Art des Rauschens */
  frame8 = XtCreateManagedWidget("backgrauschhf", xmFrameWidgetClass, WRowCol4, NULL, 0);
  WRowCol10 = XmCreateRowColumn(frame8, "backgrauschhr", NULL, 0);
  XtManageChild(WRowCol10);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, BackgDialog.rauschh);
  nArgs++;
  WRauschenH =
    XtCreateManagedWidget("Rauschen", xmToggleButtonWidgetClass, WRowCol10, Aargs, nArgs);
  XtAddCallback(WRauschenH, XmNvalueChangedCallback, (XtCallbackProc) CBRauschenH, NULL);

  /* Anzahl der Frequenzen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNshowValue, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvalue, BackgDialog.freqh);
  nArgs++;
  WFrequenzH =
    XtCreateManagedWidget("backgfreqH", xmScaleWidgetClass, WRowCol10, Aargs, nArgs);
  XtAddCallback(WFrequenzH, XmNvalueChangedCallback, (XtCallbackProc) CBFreqHCanged, NULL);

  /* Scallierung des Musters */
  WMScalHL = XtCreateManagedWidget("Scalierung", xmLabelWidgetClass, WRowCol10, NULL, 0);
  sprintf(str, "%0.2f", BackgDialog.scalh);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  WMScalH = XtCreateManagedWidget("backgscalm", xmTextWidgetClass, WRowCol10, Aargs, nArgs);



  /* ********* fr Erde  ********** */
  /* Texture Erde */
  frame4 = XtCreateManagedWidget("backgframe4", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNadjustLast, True);
  nArgs++;
  WRowCol5 = XmCreateRowColumn(frame4, "backgdrow5", Aargs, nArgs);
  XtManageChild(WRowCol5);

  frame10 = XtCreateManagedWidget("backgtextur2", xmFrameWidgetClass, WRowCol5, NULL, 0);
  WRowCol12 = XmCreateRowColumn(frame10, "backgtextur2r", NULL, 0);
  XtManageChild(WRowCol12);

  BackgTextureBLabel =
    XtCreateManagedWidget(BackgDialog.textblabel, xmLabelWidgetClass, WRowCol12, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, BackgDialog.pBackgTextureHStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, BackgDialog.anztexture);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WTextListB = XmCreateScrolledList(WRowCol12, "backtextureblist", Aargs, nArgs);
  XtAddCallback(WTextListB, XmNdefaultActionCallback, (XtCallbackProc) CBBackgTextureBoden, NULL);
  XtManageChild(WTextListB);


  /* fr Musteranzeige Erde */
  frame11 = XtCreateManagedWidget("backgmuster2", xmFrameWidgetClass, WRowCol5, NULL, 0);
  WRowCol13 = XmCreateRowColumn(frame11, "backgmuster2f", NULL, 0);
  XtManageChild(WRowCol13);

  BackgMusterBLabel =
    XtCreateManagedWidget(BackgDialog.mustblabel, xmLabelWidgetClass, WRowCol13, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, BackgDialog.pBackgMusterHStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, BackgDialog.anzmuster);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 5);
  nArgs++;
  WMustListB = XmCreateScrolledList(WRowCol13, "backmustblist", Aargs, nArgs);
  XtAddCallback(WMustListB, XmNdefaultActionCallback, (XtCallbackProc) CBBackgMusterBoden, NULL);
  XtManageChild(WMustListB);

  /* Verschiebung des Musters Himmel */
  frame12 = XtCreateManagedWidget("backgverschxbf", xmFrameWidgetClass, WRowCol5, NULL, 0);
  WRowCol14 = XmCreateRowColumn(frame12, "backgverschxbr", NULL, 0);
  XtManageChild(WRowCol14);

  WVerschXBL = XtCreateManagedWidget("Versch X", xmLabelWidgetClass, WRowCol14, NULL, 0);
  sprintf(str, "%0.2f", BackgDialog.verschxb);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  WVerschXB = XtCreateManagedWidget("backgxh", xmTextWidgetClass, WRowCol14, Aargs, nArgs);
  WVerschYBL = XtCreateManagedWidget("Versch Y", xmLabelWidgetClass, WRowCol14, NULL, 0);
  sprintf(str, "%0.2f", BackgDialog.verschyb);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  WVerschYB = XtCreateManagedWidget("backgyh", xmTextWidgetClass, WRowCol14, Aargs, nArgs);


  /* Turbolenzart: keine Muster Helligk beide */
  frame13 = XtCreateManagedWidget("backgframe13", xmFrameWidgetClass, WRowCol5, NULL, 0);
  WRowCol15 = XmCreateRowColumn(frame13, "backgdrow15", NULL, 0);
  XtManageChild(WRowCol15);

  /* RadioBox erzeugen die Togglebuttons als Kinder hat */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNentryClass, xmToggleButtonWidgetClass);
  nArgs++;
  WRadioBoxB = XmCreateRadioBox(WRowCol15, "backgradioboxb", Aargs, nArgs);
  XtManageChild(WRadioBoxB);

  /* 4 Togglebuttons erzeugen */
  if (BackgDialog.turbartb < 0 || BackgDialog.turbartb > 4)
    BackgDialog.turbartb = 0;
  nButton = 0;
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (BackgDialog.turbartb + 1) == 1);
  nArgs++;
  AWButtonB[nButton++] =
    XtCreateManagedWidget("kein", xmToggleButtonWidgetClass, WRadioBoxB, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (BackgDialog.turbartb + 1) == 2);
  nArgs++;
  AWButtonB[nButton++] =
    XtCreateManagedWidget("Muster", xmToggleButtonWidgetClass, WRadioBoxB, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (BackgDialog.turbartb + 1) == 3);
  nArgs++;
  AWButtonB[nButton++] =
    XtCreateManagedWidget("Farbe", xmToggleButtonWidgetClass, WRadioBoxB, Aargs, nArgs);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, (BackgDialog.turbartb + 1) == 4);
  nArgs++;
  AWButtonB[nButton++] =
    XtCreateManagedWidget("Beides", xmToggleButtonWidgetClass, WRadioBoxB, Aargs, nArgs);
  /* Callbacks fr alle Buttons */
  for (nButton = 0; nButton < 4; nButton++)
    XtAddCallback(AWButtonB[nButton], XmNvalueChangedCallback, (XtCallbackProc) CBButtonB, &AiButtonID[nButton]);

  /* Art des Rauschens */
  frame14 = XtCreateManagedWidget("backgrauschbf", xmFrameWidgetClass, WRowCol5, NULL, 0);
  WRowCol16 = XmCreateRowColumn(frame14, "backgrauschbr", NULL, 0);
  XtManageChild(WRowCol16);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNset, BackgDialog.rauschb);
  nArgs++;
  WRauschenB =
    XtCreateManagedWidget("Rauschen", xmToggleButtonWidgetClass, WRowCol16, Aargs, nArgs);
  XtAddCallback(WRauschenB, XmNvalueChangedCallback, (XtCallbackProc) CBRauschenB, NULL);

  /* Anzahl der Frequenzen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNshowValue, True);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvalue, BackgDialog.freqb);
  nArgs++;
  WFrequenzB =
    XtCreateManagedWidget("backgfreqB", xmScaleWidgetClass, WRowCol16, Aargs, nArgs);
  XtAddCallback(WFrequenzB, XmNvalueChangedCallback, (XtCallbackProc) CBFreqBCanged, NULL);

  /* Scallierung des Musters */
  WMScalBL = XtCreateManagedWidget("Scalierung", xmLabelWidgetClass, WRowCol16, NULL, 0);
  sprintf(str, "%0.2f", BackgDialog.scalb);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 5);
  nArgs++;
  WMScalB = XtCreateManagedWidget("backgscalm", xmTextWidgetClass, WRowCol16, Aargs, nArgs);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol6 = XmCreateRowColumn(WRowCol1, "backgdrow6", Aargs, nArgs);
  // XtManageChild(WRowCol6);
  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol6, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol6, NULL, 0);
  XtManageChild(WButtonHelp);
  XtManageChild(WRowCol6);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBBackgOk, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBBackgHelp, NULL);
}
