/*  
   Dialogbox fr die Auswahl in der Objektliste
   Copyright (C) 1996 Helmut Fahrion


   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"


STRING helpausdialog =

"Waehlen Sie das zu aendernde Objekt aus oder NEU.";

Widget WAusDialog, WList, WLabel;	/* Liste */
int anzelem, Objart, nr;	/* Anzahl der Elemente, Art des Objektes, Nr. des Obj */
XmString *pXSList;		/* Array mit Compound Strings */


void
CBAusNeu(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  int x;

  switch (Objart)
    {
    case IDM_LIGHTSOURCE:
      LichtDialog_init(1.0, 1.0, 1.0, 10.0, 1.0, 1.0, 0.0);
      if (!WLichtDialog)
	lichtdialog(WTop, NEU);
      else
	infobox("lichtnureinmal");
      break;
    case IDM_LIGHTSTRAHLER:
      StrahlerDialog_init(1.0, 1.0, 1.0, 10.0, vector(1.0, 1.0, 0.0), vector(1.0, 1.0, 1.0), 0.9);
      if (!WStrahlerDialog)
	strahlerdialog(WTop, NEU);
      else
	infobox("lichtnureinmal");
      break;
    case IDM_LIGHTPOLYGON:
      LichtPolygonDialog_init(1.0, 1.0, 1.0, 10.0, 3, 3, 3.14,
		       vector(-0.77, 0.10, 0.14), vector(-0.28, 0.86, 0.14),
		      vector(-0.91, 1.26, 0.65), vector(-1.40, 0.50, 0.65));
      if (!WLichtPolygonDialog)
	lichtpolygondialog(WTop, NEU);
      else
	infobox("lichtnureinmal");
      break;
    case IDM_TEXTURE:
      TextDialog_init(1.0, "", "");
      if (!WTexturDialog)
	texturdialog(WTop, NEU);
      else
	infobox("textnureinmal");
      break;
    case IDM_TEXTURE3D:
      Text3dDialog_init(1.00, 0.20, 0.20, 0.20, 1.00, 0.20, 0.7, 0.07, 1, 0, 0,
	     vector(0.133, 0.133, 0.133), vector(0.0, 1.0, 0.0), "text3d1");
      if (!WText3dDialog)
	text3ddialog(WTop, NEU);
      else
	infobox("text3dnureinmal");
      break;
    case IDM_MUSTER:
      MusterDialog_init(0.25, 0.25, 0.25, 0.90, 0.90, 0.90, 0.7, 0.2, 0.2, 2, 0, "");
      if (!WMusterDialog)
	musterdialog(WTop, NEU);
      else
	infobox("musternureinmal");
      break;
    case IDM_WAVE:
      WaveDialog_init(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
		      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
		      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "");
      if (!WWaveDialog)
	wavedialog(WTop, NEU);
      else
	infobox("wavenureinmal");
      break;
    case IDM_COVER:
      CoverDialog_init(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0,0,0,0,0, 0, 0, 0, 0, 0, 0, 0L, 0L);
      if (!WCoverDialog)
	coverdialog(WTop, NEU);
      else
	infobox("covernureinmal");
      break;
    default:
      fprintf(stderr, "CBAusNeu art= %d\n", Objart);
    }

  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(pXSList[x]);
  anzelem = 0;
  XtUnmanageChild(WAusDialog);
  WAusDialog = NULL;
}

void
CBAusAender(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  longint x = nr;

  /* Zu nderndes Suchen */
  if (x)
    {
      switch (Objart)
	{
	case IDM_LIGHTSOURCE:
	  lichtx = lichtanf;
	  while (lichtx && (lichtx->nr != x))
	    lichtx = lichtx->next;

	  LichtDialog_init(lichtx->r, lichtx->b, lichtx->g, lichtx->s,
			   lichtx->x, lichtx->y, lichtx->z);

	  if (!WLichtDialog)
	    lichtdialog(WTop, AENDER);
	  else
	    infobox("lichtnureinmal");
	  break;

	case IDM_LIGHTSTRAHLER:
	  for (strahlerx = strahleranf;
	       strahlerx && (strahlerx->nr != x);
	       strahlerx = strahlerx->next);

	  if (strahlerx)
	    StrahlerDialog_init(strahlerx->r, strahlerx->b, strahlerx->g, strahlerx->s,
		    strahlerx->pos, strahlerx->richtung, strahlerx->winkel);

	  if (!WStrahlerDialog)
	    strahlerdialog(WTop, AENDER);
	  else
	    infobox("lichtnureinmal");

	  break;

	case IDM_LIGHTPOLYGON:
	  for (lichtpolyx = lichtpolyanf;
	       lichtpolyx && (lichtpolyx->nr != x);
	       lichtpolyx = lichtpolyx->next);
	  if (lichtpolyx)
	    LichtPolygonDialog_init(lichtpolyx->r, lichtpolyx->g, lichtpolyx->b,
			  lichtpolyx->i, lichtpolyx->xanz, lichtpolyx->yanz,
			      lichtpolyx->w, lichtpolyx->p1, lichtpolyx->p2,
				    lichtpolyx->p3, lichtpolyx->p4);
	  if (!WLichtPolygonDialog)
	    lichtpolygondialog(WTop, AENDER);
	  else
	    infobox("lichtnureinmal");
	  break;

	case IDM_TEXTURE:
	  textx = textanf;
	  while (textx && (textx->nr != x))
	    textx = textx->next;

	  TextDialog_init(textx->prozent, textx->dname, textx->name);

	  if (!WTexturDialog)
	    texturdialog(WTop, AENDER);
	  else
	    infobox("textnureinmal");
	  break;
	case IDM_TEXTURE3D:
	  text3dx = text3danf;
	  while (text3dx && (text3dx->nr != x))
	    text3dx = text3dx->next;

	  Text3dDialog_init(text3dx->r1, text3dx->g1, text3dx->b1, text3dx->r2, text3dx->g2,
			    text3dx->b2, text3dx->mix, text3dx->abs,
			    text3dx->art, text3dx->fehler, text3dx->anz,
			    text3dx->d, text3dx->r, text3dx->name);

	  if (!WText3dDialog)
	    text3ddialog(WTop, AENDER);
	  else
	    infobox("text3dnureinmal");
	  break;

	case IDM_MUSTER:
	  mustx = mustanf;
	  while (mustx && (mustx->nr != x))
	    mustx = mustx->next;

	  MusterDialog_init(mustx->r1, mustx->b1, mustx->g1, mustx->r2, mustx->b2,
			    mustx->g2, mustx->mix, mustx->x, mustx->y,
			    mustx->art, mustx->fehler, mustx->name);

	  if (!WMusterDialog)
	    musterdialog(WTop, AENDER);
	  else
	    infobox("textnureinmal");
	  break;
	case IDM_WAVE:
	  wavex = waveanf;
	  while (wavex && (wavex->nr != x))
	    wavex = wavex->next;

	  WaveDialog_init(wavex->x1, wavex->y1, wavex->z1, wavex->freq1,
			  wavex->amp1, wavex->damp1, wavex->d1,
			  wavex->x2, wavex->y2, wavex->z2, wavex->freq2,
			  wavex->amp2, wavex->damp2, wavex->d2,
			  wavex->x3, wavex->y3, wavex->z3, wavex->freq3,
			  wavex->amp3, wavex->damp3, wavex->d3,
			  wavex->name);

	  if (!WWaveDialog)
	    wavedialog(WTop, AENDER);
	  else
	    infobox("wavenureinmal");
	  break;
	case IDM_COVER:
	  coverx = coveranf;
	  while (coverx && (coverx->nr != x))
	    coverx = coverx->next;

	  CoverDialog_init(coverx->tx1, coverx->tx2, coverx->ty1, coverx->ty2,
			   coverx->movx, coverx->movy, coverx->scal,
		 coverx->text1, coverx->text2, coverx->text3, coverx->text4, 
			   coverx->must1, coverx->must2,coverx->must3, coverx->must4,
	     coverx->turbart, coverx->normalv, coverx->freq, coverx->wavenr,
			   coverx->text3dnr);

	  if (!WCoverDialog)
	    coverdialog(WTop, AENDER);
	  else
	    infobox("covernureinmal");
	  break;
	default:
	  fprintf(stderr, "CBAusNeu art= %d\n", Objart);
	}

      /* Strings freigeben */
      for (x = 0; x < anzelem; x++)
	XmStringFree(pXSList[x]);

      anzelem = 0;
      XtUnmanageChild(WAusDialog);
      WAusDialog = NULL;
    }
}

void
CBAusLoesch(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  int x;

  /* Zu lschende Suchen */
  switch (Objart)
    {
    case IDM_LIGHTSOURCE:
      if (nr)
	{
	  entf_lichtquelle(nr);
	  neue_licht_marker();
	}
      break;
    case IDM_LIGHTSTRAHLER:
      if (nr)
	{
	  entf_strahler(nr);
	  neue_strahler_marker();
	}
      break;
    case IDM_LIGHTPOLYGON:
      if (nr)
	{
	  entf_lichtpoly(nr);
	  neue_lichtpoly_marker();
	}
      break;
    case IDM_TEXTURE:
      if (nr)
	entf_texturen(nr);
      break;
    case IDM_TEXTURE3D:
      if (nr)
	entf_text3d(nr);
      break;
    case IDM_MUSTER:
      if (nr)
	entf_muster(nr);
      break;
    case IDM_WAVE:
      if (nr)
	entf_wave(nr);
      break;
    case IDM_COVER:
      if (nr)
	entf_cover(nr);
      break;
    default:
      fprintf(stderr, "CBAusLschen art= %d\n", Objart);
    }
  redraw(True);			// neu Zeichnen

  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(pXSList[x]);
  anzelem = 0;

  XtUnmanageChild(WAusDialog);
  WAusDialog = NULL;
}

void
CBAusCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  int x;
  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(pXSList[x]);
  anzelem = 0;
  XtUnmanageChild(WAusDialog);
  WAusDialog = NULL;
}

void
CBAusHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpausdialog);
  else
    infobox("helpnureinmal");
}

void
CBList(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  Arg Aargs;
  XtSetArg(Aargs, XmNlabelString, ((XmListCallbackStruct *) pCallData)->item);
  XtSetValues(WLabel, &Aargs, 1);
  nr = ((XmListCallbackStruct *) pCallData)->item_position;
}

void
create_list(int art)
{
  int x;
  char str[80];

  switch (art)
    {
    case IDM_LIGHTSOURCE:
      if (lichtanf)
	{
	  lichtx = lichtanf;
	  while (lichtx)
	    {
	      anzelem = lichtx->nr;
	      lichtx = lichtx->next;
	    }
	  pXSList = (XmString *) XtMalloc(sizeof(XmString) * anzelem);
	  /* Alle Lichter durchlaufen */
	  lichtx = lichtanf;
	  x = 0;
	  while (lichtx)
	    {
	      sprintf(str, "Lichtquelle %ld", lichtx->nr);	/* C String erzeugen */
	      pXSList[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	      lichtx = lichtx->next;
	      x++;
	    }
	}
      break;
    case IDM_LIGHTSTRAHLER:
      if (strahleranf)
	{
	  strahlerx = strahleranf;
	  while (strahlerx)
	    {
	      anzelem = strahlerx->nr;
	      strahlerx = strahlerx->next;
	    }
	  pXSList = (XmString *) XtMalloc(sizeof(XmString) * anzelem);
	  /* Alle Lichter durchlaufen */
	  strahlerx = strahleranf;
	  x = 0;
	  while (strahlerx)
	    {
	      sprintf(str, "Strahler %ld", strahlerx->nr);	/* C String erzeugen */
	      pXSList[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	      strahlerx = strahlerx->next;
	      x++;
	    }
	}
      break;
    case IDM_LIGHTPOLYGON:
      if (lichtpolyanf)
	{
	  lichtpolyx = lichtpolyanf;
	  while (lichtpolyx)
	    {
	      anzelem = lichtpolyx->nr;
	      lichtpolyx = lichtpolyx->next;
	    }
	  pXSList = (XmString *) XtMalloc(sizeof(XmString) * anzelem);
	  /* Alle Lichter durchlaufen */
	  lichtpolyx = lichtpolyanf;
	  x = 0;
	  while (lichtpolyx)
	    {
	      sprintf(str, "Lichtpolygon %ld", lichtpolyx->nr);		/* C String erzeugen */
	      pXSList[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	      lichtpolyx = lichtpolyx->next;
	      x++;
	    }
	}
      break;
    case IDM_TEXTURE:
      if (textanf)
	{
	  textx = textanf;
	  while (textx)
	    {
	      anzelem = textx->nr;
	      textx = textx->next;
	    }
	  pXSList = (XmString *) XtMalloc(sizeof(XmString) * anzelem);
	  /* Alle Texturen durchlaufen */
	  textx = textanf;
	  x = 0;
	  while (textx)
	    {
	      sprintf(str, "%ld: %s", textx->nr, textx->name);	/* C String erzeugen */
	      pXSList[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	      textx = textx->next;
	      x++;
	    }
	}
      break;
    case IDM_TEXTURE3D:
      if (text3danf)
	{
	  text3dx = text3danf;
	  while (text3dx)
	    {
	      anzelem = text3dx->nr;
	      text3dx = text3dx->next;
	    }
	  pXSList = (XmString *) XtMalloc(sizeof(XmString) * anzelem);
	  /* Alle Muster durchlaufen */
	  text3dx = text3danf;
	  x = 0;
	  while (text3dx)
	    {
	      sprintf(str, "%ld: %s", text3dx->nr, text3dx->name);	/* C String erzeugen */
	      pXSList[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	      text3dx = text3dx->next;
	      x++;
	    }
	}
      break;
    case IDM_MUSTER:
      if (mustanf)
	{
	  mustx = mustanf;
	  while (mustx)
	    {
	      anzelem = mustx->nr;
	      mustx = mustx->next;
	    }
	  pXSList = (XmString *) XtMalloc(sizeof(XmString) * anzelem);
	  /* Alle Muster durchlaufen */
	  mustx = mustanf;
	  x = 0;
	  while (mustx)
	    {
	      sprintf(str, "%ld: %s", mustx->nr, mustx->name);	/* C String erzeugen */
	      pXSList[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	      mustx = mustx->next;
	      x++;
	    }
	}
      break;
    case IDM_WAVE:
      if (waveanf)
	{
	  wavex = waveanf;
	  while (wavex)
	    {
	      anzelem = wavex->nr;
	      wavex = wavex->next;
	    }
	  pXSList = (XmString *) XtMalloc(sizeof(XmString) * anzelem);
	  /* Alle Wellen durchlaufen */
	  wavex = waveanf;
	  x = 0;
	  while (wavex)
	    {
	      sprintf(str, "%ld: %s", wavex->nr, wavex->name);	/* C String erzeugen */
	      pXSList[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	      wavex = wavex->next;
	      x++;
	    }
	}
      break;
    case IDM_COVER:
      if (coveranf)
	{
	  coverx = coveranf;
	  while (coverx)
	    {
	      anzelem = coverx->nr;
	      coverx = coverx->next;
	    }
	  pXSList = (XmString *) XtMalloc(sizeof(XmString) * anzelem);
	  /* Alle Wellen durchlaufen */
	  coverx = coveranf;
	  x = 0;
	  while (coverx)
	    {
	      sprintf(str, "%ld: Cover", coverx->nr);	/* C String erzeugen */
	      pXSList[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	      coverx = coverx->next;
	      x++;
	    }
	}
      break;
    default:
      fprintf(stderr, "Auswahldialog art= %d\n", art);
    }
}

void
ausdialog(Widget W, int art)
{

  Widget WButtonNeu, WButtonAender, WButtonLoesch, WButtonCancel, WButtonHelp,
    WRowCol1, WRowCol2, WRowCol3, frame1;
  Arg Aargs[MAX_ARGS];
  int nArgs;

  Objart = art;
  nr = 0;


  /* Der Dialog */
  WAusDialog = XmCreateDialogShell(W, "ausdialog", NULL, 0);
  XtManageChild(WAusDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 440);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 250);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WAusDialog, "ausdrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("ausframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "ausdrow2", NULL, 0);
  XtManageChild(WRowCol2);

  /* ListenWidget zur Auswahl */

  WLabel = XtCreateManagedWidget("keine", xmLabelWidgetClass, WRowCol2, NULL, 0);
  create_list(art);		/* Liste mit Compound Strings erzeugen */

  if (anzelem)
    {
      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNitems, pXSList);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNitemCount, anzelem);
      nArgs++;
      XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 7);
      nArgs++;
      WList = XmCreateScrolledList(WRowCol2, "auslist", Aargs, nArgs);
    }
  else
    {
      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 7);
      nArgs++;
      WList = XmCreateScrolledList(WRowCol2, "auslist", Aargs, nArgs);
    }

  XtManageChild(WList);
  XtAddCallback(WList, XmNdefaultActionCallback, (XtCallbackProc) CBList, NULL);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "ausdrow3", Aargs, nArgs);
  // XtManageChild(WRowCol3);

  /* Buttons */
  WButtonNeu =
    XtCreateManagedWidget("neu", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonNeu);

  WButtonAender =
    XtCreateManagedWidget("aender", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonAender);

  WButtonLoesch =
    XtCreateManagedWidget("loesch", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonLoesch);

  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);
  XtManageChild(WRowCol3);

  XtAddCallback(WButtonNeu, XmNactivateCallback, (XtCallbackProc) CBAusNeu, NULL);
  XtAddCallback(WButtonAender, XmNactivateCallback, (XtCallbackProc) CBAusAender, NULL);
  XtAddCallback(WButtonLoesch, XmNactivateCallback, (XtCallbackProc) CBAusLoesch, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBAusCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBAusHelp, NULL);
}




