/*  
   Dialogbox zur Animation
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pextool.H"
#include <unistd.h>


#define GNU

STRING animationdialogstr = "Durchfhrung der Animation.";

Widget WAnimationDialog, WAnimationPause;
longint anim_pause;

void
animiere(kameral * k)
{
  static PEXCoord view_ref_pt;
  static PEXVector view_up_vec, view_plane_normal;
  int err;
  vector i;

  i = k->blickrichtung - k->punkt;

  SET_VECTA(i, view_plane_normal);
  SET_VECTA(k->blickrichtung, view_ref_pt);
  SET_VECT(0.0, 1.0, 0.0, view_up_vec);

  err = PEXViewOrientationMatrix(&view_ref_pt, &view_plane_normal, &view_up_vec,
				 view.orientation);
  if (!err)
    {
      // globales View ndern
      PEXSetTableEntries(pDisplay, view_table, 1, 1,
			 PEXLUTView, (PEXPointer) & view);
    }
  redraw(true);
}

void
CBAnimationOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;

  str = XmTextGetString(WAnimationPause);
  sscanf(str, "%ld", &anim_pause);

  if (kameraliste)
    {
      animiere(kameralistex);
#ifdef GNU
      // Kompatibel zu BSD 4.3
      usleep(anim_pause * 1000);	// mikrosec * 1000 = millisec
#endif
#ifdef ALPHA
      // Kompatibel zu POSIX, nur Sekunden!
      sleep(anim_pause);
#endif
      kameralistex = kameralistex->next;
      if (!kameralistex)
	{
	  kameralistex = kameraliste;
	}
    }
}

void
CBAnimationGo(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;

  str = XmTextGetString(WAnimationPause);
  sscanf(str, "%ld", &anim_pause);

  if (kameraliste)
    {
      for (kameralistex = kameraliste;
	   kameralistex;
	   kameralistex = kameralistex->next)
	{
	  animiere(kameralistex);
#ifdef GNU
	  // Kompatibel zu BSD 4.3
	  usleep(anim_pause * 1000);	// mikrosec * 1000 = millisec
#endif
#ifdef ALPHA
	  // Kompatibel zu POSIX, nur Sekunden!
	  sleep(anim_pause);
#endif
	}
      kameralistex = kameraliste;
    }
}

void
CBAnimationCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Orginal wieder setzen
  set_view();
  XtUnmanageChild(WAnimationDialog);
  WAnimationDialog = NULL;
  redraw(true);
}

void
CBAnimationHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, animationdialogstr);
  else
    infobox("helpnureinmal");
}


void
animationdialog(Widget W)
{
  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];

  Widget WButtonOK, WButtonCancel, WButtonHelp, WRowCol1, WRowCol2, WRowCol3,
    frame1, frame2, WButtonGo, WLabel;

  // Zur Sicherheit
  kameralistex = kameraliste;

  /* Der Dialog */
  WAnimationDialog = XmCreateDialogShell(W, "animationdialog", NULL, 0);
  XtManageChild(WAnimationDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 260);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 165);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WAnimationDialog, "animationrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("animationframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "animationrow2", NULL, 0);
  XtManageChild(WRowCol2);

  frame2 = XtCreateManagedWidget("animationframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNorientation, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNnumColumns, 2);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(frame2, "animationrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);

#ifdef GNU
  WLabel = XtCreateManagedWidget("msek:", xmLabelWidgetClass, WRowCol2, NULL, 0);
  sprintf(str, "100");
#endif
#ifdef ALPHA
  WLabel = XtCreateManagedWidget("sek:", xmLabelWidgetClass, WRowCol2, NULL, 0);
  sprintf(str, "0");
#endif

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  WAnimationPause = XtCreateManagedWidget("animationzeit", xmTextWidgetClass, WRowCol2,
					  Aargs, nArgs);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);

  WButtonGo =
    XtCreateManagedWidget("go", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonGo);

  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);

  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBAnimationOk, NULL);
  XtAddCallback(WButtonGo, XmNactivateCallback, (XtCallbackProc) CBAnimationGo, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBAnimationCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBAnimationHelp, NULL);
}
