/*  
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Dialogbox fr Hintergrundlicht
   Copyright (C) 1996 Helmut Fahrion
*/

#include "cadtool.H"

STRING helpambdialog = "Definition des Hintergrundlichtes.";

struct ambstruktur AmbDialog;
GC     AmbDialogGCFarbe;
Widget WAmbDialog;

void
AmbFarbealloc(Widget W)
{
  AmbDialog.XCol.flags = DoRed | DoGreen | DoBlue;
  AmbDialog.XCol.red = (unsigned)(AmbDialog.r * 65535.0);
  AmbDialog.XCol.green = (unsigned)(AmbDialog.g * 65535.0);
  AmbDialog.XCol.blue = (unsigned)(AmbDialog.b * 65535.0);

  if (AmbDialog.privat)
    XStoreColor(XtDisplay(W), AmbDialog.CMap, &AmbDialog.XCol);
  else
    XAllocColor(XtDisplay(W), AmbDialog.CMap, &AmbDialog.XCol);
}

void
AmbFarbanzeige()
{
  if (AmbDialog.Win)
    {
      XSetForeground(AmbDialog.pD, AmbDialogGCFarbe, AmbDialog.XCol.pixel);
      XFillRectangle(AmbDialog.pD, AmbDialog.Win, AmbDialogGCFarbe, 1, 1, 245, 25);
    }
}

void
CBAmbFarbanzeige(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  AmbDialog.Win = ((XmDrawingAreaCallbackStruct *) pCallData)->window;
  if (AmbDialog.Win != 0)
    {
      AmbDialog.pD = XtDisplay(W);
      XSetForeground(AmbDialog.pD, AmbDialogGCFarbe, AmbDialog.XCol.pixel);
      XFillRectangle(AmbDialog.pD, AmbDialog.Win, AmbDialogGCFarbe, 1, 1, 245, 25);
    }
}

void
CBAmbOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* Farbe freigeben */
  if (AmbDialog.privat)
    XFreeColors(AmbDialog.pD, AmbDialog.CMap, &AmbDialog.XCol.pixel, 1, 0);

  XtUnmanageChild(WAmbDialog);
  WAmbDialog = NULL;
}

void
CBAmbCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  /* Farbe freigeben */
  if (AmbDialog.privat)
    XFreeColors(AmbDialog.pD, AmbDialog.CMap, &AmbDialog.XCol.pixel, 1, 0);

  XtUnmanageChild(WAmbDialog);
  WAmbDialog = NULL;
}

void
CBAmbHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpambdialog);
  else
    infobox("helpnureinmal");
}

void
CBAmbScaleCanged(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  switch (*(int *)pClientData)
    {
    case 1:
      AmbDialog.r = ((float)((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 2:
      AmbDialog.g = ((float)((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    case 3:
      AmbDialog.b = ((float)((XmScaleCallbackStruct *) pCallData)->value) / 100.0;
      break;
    default:
      fprintf(stderr, "AmbientRegler %d\n", *(int *)pClientData);
    }
  AmbFarbealloc(W);
  AmbFarbanzeige();
}

void
ambdialog(Widget W)
{
  unsigned long pixel;
  Arg    Aargs[MAX_ARGS];
  int    nArgs;

  Widget WButtonOK,		/* WButtonCancel, */
         WButtonHelp, WRowCol1, WRowCol2, WRowCol3, WRowCol4, WScale[3],
         frame1, frame2, frame3, Wdrawarea, WLabel;

  /* Definitionen */
  STRING AIScale[] =
  {"ambr1", "ambr2", "ambr3"};
  XmString mstr;

  static int AIScaleID[] =
  {
    1, 2, 3
  };

  int    nScale;
  int    maxScale = 3;

  /* Der Dialog */
  WAmbDialog = XmCreateDialogShell(W, "ambdialog", NULL, 0);
  XtManageChild(WAmbDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 350);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 200);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_TIGHT);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WAmbDialog, "ambdrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("ambframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol2 = XmCreateRowColumn(frame1, "ambdrow2", Aargs, nArgs);
  XtManageChild(WRowCol2);

  frame2 = XtCreateManagedWidget("ambframe2", xmFrameWidgetClass, WRowCol1, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNadjustLast, true);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(frame2, "ambdrow3", Aargs, nArgs);
  XtManageChild(WRowCol3);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol4 = XmCreateRowColumn(WRowCol1, "ambdrow4", Aargs, nArgs);
  XtManageChild(WRowCol4);

  /* Scalen */
  for (nScale = 0; nScale < maxScale; nScale++)
    {
      nArgs = 0;
      if (nScale == 0)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, true);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Rot", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, AmbDialog.r * 100.0);
	}
      else if (nScale == 1)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, true);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Grn", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, AmbDialog.g * 100.0);
	}
      else if (nScale == 2)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, true);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Blau", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, AmbDialog.b * 100.0);
	}
      else if (nScale == 3)
	{
	  XtSetArg(Aargs[nArgs], XmNshowValue, true);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNdecimalPoints, 2);
	  nArgs++;
	  mstr = XmStringCreateLtoR("Intens", XmSTRING_DEFAULT_CHARSET);
	  XtSetArg(Aargs[nArgs], XmNtitleString, mstr);
	  nArgs++;
	  XtSetArg(Aargs[nArgs], XmNvalue, LichtDialog.intens);
	}



      /* in Res.Max auf10gesetzt */
      nArgs++;
      WScale[nScale] =
	XtCreateManagedWidget(AIScale[nScale], xmScaleWidgetClass, WRowCol2, Aargs, nArgs);
      XtAddCallback(WScale[nScale], XmNvalueChangedCallback,
	    (XtCallbackProc) CBAmbScaleCanged, (caddr_t) & AIScaleID[nScale]);
    }

  /* Farbanzeige */
  WLabel = XtCreateManagedWidget("Farbe    :", xmLabelWidgetClass, WRowCol3, NULL, 0);
  frame3 = XtCreateManagedWidget("ambframe3", xmFrameWidgetClass, WRowCol3, NULL, 0);

  /* Fr Farbnderung eine ColorCell holen */
  AmbDialog.pD = XtDisplay(WTop);
  AmbDialog.CMap = DefaultColormap(AmbDialog.pD, DefaultScreen(AmbDialog.pD));
  AmbDialog.privat = true;

  if (XAllocColor(AmbDialog.pD, AmbDialog.CMap, &AmbDialog.XCol))
    {
      AmbDialog.privat = false;
      AmbFarbealloc(WTop);
    }
  else if (!XAllocColorCells(AmbDialog.pD, AmbDialog.CMap, false, NULL,
			     0, &pixel, 1))
    {
      AmbDialog.privat = false;
      infobox("keinefarbzelle");
    }
  if (AmbDialog.privat)
    {
      AmbDialog.XCol.pixel = pixel;
      AmbFarbealloc(WTop);
    }

  Wdrawarea = XtCreateManagedWidget("ambdrawcol", xmDrawingAreaWidgetClass, frame3, NULL, 0);
  /* Callbacks um neu zu zeichnen */
  XtAddCallback(Wdrawarea, XmNexposeCallback, (XtCallbackProc) CBAmbFarbanzeige, NULL);
  XtAddCallback(Wdrawarea, XmNresizeCallback, (XtCallbackProc) CBAmbFarbanzeige, NULL);

  /* GC erzeugen um zeichnen zu knnen */
  AmbDialogGCFarbe = CreateSimpleGC(Wdrawarea);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonOK);

  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol4, NULL, 0);
  XtManageChild(WButtonHelp);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBAmbOk, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBAmbHelp, NULL);
}
