#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xproto.h>
#include <X11/Xresource.h>
#include <X11/Xutil.h>
#include "tk.h"
#include "tkTkwm.h"
#include <stdlib.h>
#include <ctype.h>
#include "tkShape.h"


/*
 * escapes for the new <ShapeNotify> event binding:
 *	%d	whether or not the region exists (0 or 1)
 *	%s	which regions it is (ShapeClip, ShapeBounding)
 *	%W	the plug that changed shape
 *	%x	x of the region
 *	%y	y of the region
 *	%w	width of the region
 *	%h	height of the region
 */

int shapeEventType;

int initShape(interp, d)
Tcl_Interp *interp;
Display *d;
{
	int err;

	if (!XShapeQueryExtension(d, &shapeEventType, &err)) {
		Tcl_AppendResult(interp, "no shape extension", (char *) NULL);
		return TCL_ERROR;
	}
	return TCL_OK;
}


int unshapify(interp, p)
Tcl_Interp *interp;
Plug *p;
{
	XShapeCombineMask(p->display,
			  Tk_WindowId(p->frame),
			  ShapeBounding,
			  0,
			  0,
			  None,
			  ShapeSet);
	return TCL_OK;
}


/*
 *	hack out my empty bits from the top window.  Prevent flicker with double-buffering
 */
int shapify(interp, p)
Tcl_Interp *interp;
Plug *p;
{
	Window cur, top = Tk_WindowId(p->frame), root, parent, *children, scratch;
	unsigned int nchildren;
	int xoff = 0, yoff = 0;
	XWindowAttributes att;
	XRectangle bounds;

	bounds.x = 0;
	bounds.y = 0;
	bounds.width = p->winatts.width;
	bounds.height = p->winatts.height;

	/* record window info and compute offset for top region */
	for (cur = Tk_WindowId(p->tkwin);;) {
		XGetWindowAttributes(p->display, cur, &att);
		if (!XQueryTree(p->display, cur, &root, &parent, &children, &nchildren)) {
			Tcl_AppendResult(interp, "accessed nonexistent window in shapify", (char *) NULL);
			return TCL_ERROR;
		}
		XFree(children);
		if (cur == top) {
			break;
		}
		xoff += att.x + att.border_width;
		yoff += att.y + att.border_width;
		cur = parent;
	}
	scratch = XCreateWindow(p->display, top, 0, 0, att.width, att.height, 0, 0, InputOnly, CopyFromParent, 0, 0);
	XShapeCombineRectangles(p->display,
				scratch,
				ShapeBounding,
				xoff,
				yoff,
				&bounds,
				1,
				ShapeSubtract,
				Unsorted);
	XShapeCombineShape(p->display,
			   scratch,
			   ShapeBounding,
			   xoff,
			   yoff,
			   p->window,
			   ShapeBounding,
			   ShapeUnion);
	XShapeCombineShape(p->display,
			   top,
			   ShapeBounding,
			   0,
			   0,
			   scratch,
			   ShapeBounding,
			   ShapeSet);
	XDestroyWindow(p->display, scratch);
	return TCL_OK;
}


int hasShape(interp, p)
Tcl_Interp *interp;
Plug *p;
{
	int shapeb, xb, yb, shapec, xc, yc;
	unsigned int wb, hb, wc, hc;
	Status s;

	if (!XShapeQueryExtents(p->display,
				p->window,
				&shapeb,
				&xb,
				&yb,
				&wb,
				&hb,
				&shapec,
				&xc,
				&yc,
				&wc,
				&hc)) {
		Tcl_AppendResult(interp, "Attempt to test shape of nonexistent window", (char *) NULL);
		return TCL_ERROR;
	}
	Tcl_AppendResult(interp, shapeb ? "1" : "0", (char *) NULL);
	return TCL_OK;
}

int compressMotion(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
	XEvent current, ahead;
	int cur = False, queued = False;
	Display *d = Tk_Display(clientData);

	if (argc != 2) {
		Tcl_AppendResult(interp, "wrong # args: should be\"",
				 argv[0], " ", argv[1], (char *)NULL);
		return TCL_ERROR;
	}
	while (XEventsQueued(d, QueuedAfterReading) > 0) {
		XPeekEvent(d, &ahead);
		if (ahead.type != MotionNotify)
			break;
		XNextEvent(d, &current);
		queued = True;
	}
	if (queued) {
		XPutBackEvent(d, &current);
		Tk_DoOneEvent(TK_X_EVENTS);
		Tcl_AppendResult(interp, "1", (char *) NULL);
	} else {
		Tcl_AppendResult(interp, "0", (char *) NULL);
	}
	return TCL_OK;
}
