#
# Copyright (c) 1993 Eric Schenk.
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
# 
# IN NO EVENT SHALL ERIC SCHENK BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ERIC
# SCHENK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

# The failure of anything in this file should never cause
# anything that uses these functions to fail. Therefore all calls to these
# functions should be protected be a catch.

# Maintainer and version information
set tkwm(maintainer) schenk@cs.toronto.edu
set tkwm(version) 0.1a12

# FRAMES

#-----------------------------------------------------------------------------
# Class bindings.
# 	Class bindings are preferred since they don't affect startup time
#	when decorating a new client window. Note that we can only do class
#	bindings for events that we grab from the client.
#-----------------------------------------------------------------------------

# Sun specific bindings
bind Client <L7> "iconify %W"
bind Client <L5> "raise_lower %W"
bind Client <Shift-L5> "lower %W"
bind Client <L9> "wrefresh %W"

# Motif style bindings
bind Client <Meta-F1> {raise %W}
bind Client <Meta-F3> {lower %W}
bind Client <Meta-F7> {move %W <Any-ButtonRelease-1>}
bind Client <Meta-F8> {resize %W <Any-ButtonRelease-1>}
bind Client <Meta-F9> {iconify %W}
bind Client <Meta-F10> {zoom %W}
bind Client <Meta-F11> {vzoom %W}
bind Client <Meta-F12> {hzoom %W}
bind Client <Shift-Escape> {client_menu %W}

proc frame_bindings {frame} {
    grabevents $frame <Meta-F1> <Meta-F3> <Meta-F7> <Meta-F8> \
	<Meta-F9> <Meta-F10> <Meta-F11> <Meta-F12> <L7> <L5> \
	<Shift-L5> <L9> <Shift-Escape>

    tree-bind $frame <ButtonPress-2> "move $frame <Any-ButtonRelease-2>"
    tree-bind $frame <ButtonPress-3> "resize $frame <Any-ButtonRelease-3>"
    tree-bind $frame <ButtonPress-1> "raise_lower $frame"
}

# ICONS
# Sun specific bindings
bind Icon <L7> {deiconify [client_root %W]}
bind Icon <L5> {raise_lower %W}

# Motif MWM like bindings
bind Icon <Meta-F1> {raise %W}
bind Icon <Meta-F3> {lower %W}
bind Icon <Meta-F7> {move %W <Any-ButtonRelease-1>}
bind Icon <Meta-F9> {deiconify [client_root %W]}
bind Icon <Meta-F10> {zoom [client_root %W]; deiconify [client_root %W]}

proc icon_bindings {iconwin} {
    # bind some keys to the icon
    grabevents $iconwin <Button-1> <Button-2> <L5> <L7> <Meta-F1> <Meta-F3> \
	<Meta-F5> <Meta-F7>

    tree-bind $iconwin <ButtonPress-2> [list move $iconwin <Any-ButtonRelease-2>]
    tree-bind $iconwin <ButtonRelease-1> "deiconify \[client_root \"$iconwin\"\]"
}

# Define the menus

tkwm_menu .windows_menu {
    {title  "Windows Menu"}
    {separator}
    {command  "Tiny XTerm"  "exec xterm &"}
    {command  "XTerm"  "exec xterm -ut -geometry 80x40 &"}
}

tkwm_menu .root_menu {
    {title  "Root Menu"}
    {separator}
    {command  "Blank"  {exec xset s 1; exec sleep 2; exec xset s 600}}
    {command  "Refresh"  {refresh}}
    {separator}
    {command  "Preferences" {exec stkwm_prefs &}}
    {separator}
    {command  "Restart TKWM"  {source $tkwm_resource}}
    {separator}
    {command  "Quit TKWM"  {exit}}
}

tkwm_menu .client_menu {
    {command "Move" {move $current_client <Any-ButtonRelease-1>} "    Alt+F7"}
    {command "Size" {resize $current_client <Any-ButtonRelease-1>} "    Alt+F8"}
    {command "Iconify" {iconify $current_client} "    Alt+F9"}
    {command "Zoom" {zoom $current_client} "   Alt+F10"}
    {command "Vert. Zoom" {vzoom $current_client} "   Alt+F11"}
    {command "Hor. Zoom" {hzoom $current_client} "   Alt+F12"}
    {command "Raise" {raise $current_client} "    Alt+F1"}
    {command "Lower" {lower $current_client} "    Alt+F3"}
    {command "Refresh" {wrefresh $current_client} "        L9"}
    {command "Preferences" {exec stkwm_prefs $current_client &}}
    {command "Destroy" {handleError {$current_client.plug delete} {destroy $current_client}}}
}

# bind the menus to keys over the root window

bind . <ButtonPress-1> {tkwm_postmenu .windows_menu %X %Y}
bind . <ButtonPress-3> {tkwm_postmenu .root_menu %X %Y}

# Set up geometry managers

# Set up a simple manager that just maps windows where they ask.
simpleManager tkwmDefaultSimpleManager

# set up an icon region in the lower right corner of size 200x600
# with a padding of 5 between windows, and filled starting from the
# south to the north, and then from the east to the west as each
# column is filled.

packingManager tkwmDefaultIconManager 200x600-0-0 5 5 south east

# Trivial choose_room so that things work even if the user does
# not choose to use a rooms package.
proc choose_room {plug} {
    return global
}
