#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdarg.h>
#include "hcon.h"

#define U unsigned int

int tga_read(PTYPE **hh, unsigned int *xs, unsigned int *ys, char *fname)
{
  int ix, iy;
  FILE *infile;
  size_t mem;
  int xsize, ysize;     /* necessary for EL() macro */

  unsigned char red, green, blue;
  unsigned char IDLength;             /* length of Identifier String */
  unsigned char CoMapType;            /* 0 = no map */
  unsigned char ImgType;              /* image type (see below for values) */
  unsigned char Index_lo, Index_hi;   /* index of first color map entry */
  unsigned char Length_lo, Length_hi; /* number of entries in color map */
  unsigned char CoSize;               /* size colormap entry (15,16,24,32) */
  unsigned char X_org_lo, X_org_hi;   /* x origin of image */
  unsigned char Y_org_lo, Y_org_hi;   /* y origin of image */
  unsigned char Width_lo, Width_hi;   /* width of image */
  unsigned char Height_lo, Height_hi; /* height of image */
  unsigned char PixelSize;            /* pixel size (8,16,24,32) */
  unsigned char Dbyte;            /* pixel size (8,16,24,32) */
    

    /* ------------- open TGA file ----------- */

  infile = fopen(fname, "rb");
  if (infile == NULL) {
    fprintf(stderr,"Trouble opening TGA file %s\n",fname);
    exit(1);
  }


    /*----------- Read in data from TGA format file ------- */
    /* eighteen-byte header */

    fscanf(infile,"%c",&IDLength);
    fscanf(infile,"%c",&CoMapType);
    fscanf(infile,"%c",&ImgType);
    fscanf(infile,"%c",&Index_lo);
    fscanf(infile,"%c",&Index_hi);
    fscanf(infile,"%c",&Length_lo);
    fscanf(infile,"%c",&Length_hi);
    fscanf(infile,"%c",&CoSize);
    fscanf(infile,"%c",&X_org_lo); fscanf(infile,"%c",&X_org_hi);
    fscanf(infile,"%c",&Y_org_lo); fscanf(infile,"%c",&Y_org_hi);
    fscanf(infile,"%c",&Width_lo);
    fscanf(infile,"%c",&Width_hi);              /* file in lo-byte, hi-byte order b12,b13*/
    fscanf(infile,"%c",&Height_lo);
    fscanf(infile,"%c",&Height_hi);    /* ysize b14, b15 */
    fscanf(infile,"%c",&PixelSize);
    fscanf(infile,"%c",&Dbyte);        /* descriptor byte b17 */
  
  
  xs[0] = (unsigned int) Width_lo + 256*Width_hi;
  ys[0] = (unsigned int) Height_lo + 256*Height_hi;

  xsize = xs[0];  ysize = ys[0];

  mem = (size_t) sizeof(PTYPE) * xs[0] * ys[0];
/*  fprintf(stderr,"TGA image type %d PixelSize %d Descriptor %d\n",
    (int)ImgType,PixelSize,Dbyte); 
  fprintf(stderr,"allocating %lu bytes for array\n",(long unsigned) mem); */
  hh[0] = (PTYPE *) malloc(mem);

  for (iy = 0; iy < ys[0]; iy++) {
    for (ix = 0; ix < xs[0]; ix++) {
      if (fscanf(infile,"%c%c%c",&blue,&green,&red) == EOF) {
	fprintf(stderr,"Read error, %s file appears truncated.\n",fname);
	return(1);
      }
      El(hh[0],ix,iy) = ((PTYPE)red*256.0 + (PTYPE)green) / 65535.0;
    }
  }
  
  fclose(infile);
  return(0);

} /* end tga_read() */


int tga_write(PTYPE *hf, U xsize, U ysize, char *fname)
{
  int ix, iy;
  FILE *outfile;
  double temp;

  unsigned char red, green, blue;
  unsigned char IDLength;             /* length of Identifier String */
  unsigned char CoMapType;            /* 0 = no map */
  unsigned char ImgType;              /* image type (see below for values) */
  unsigned char Index_lo, Index_hi;   /* index of first color map entry */
  unsigned char Length_lo, Length_hi; /* number of entries in color map */
  unsigned char CoSize;               /* size colormap entry (15,16,24,32) */
  unsigned char X_org_lo, X_org_hi;   /* x origin of image */
  unsigned char Y_org_lo, Y_org_hi;   /* y origin of image */
  unsigned char Width_lo, Width_hi;   /* width of image */
  unsigned char Height_lo, Height_hi; /* height of image */
  unsigned char PixelSize;            /* pixel size (8,16,24,32) */

    /* ------------- open TGA file ----------- */

  outfile = fopen(fname, "wb");
  if (outfile == NULL) {
    fprintf(stderr,"Trouble opening TGA file %s\n",fname);
    exit(1);
  }

    /*----------- Write out data to TGA format file ------- */
    /* eighteen-byte header */
  
     /* b0-b7 */
    IDLength = 0; CoMapType = 0; ImgType = 2; Index_lo = 0; Index_hi=0;
    Length_lo = 0; Length_hi = 0; CoSize = 0; X_org_lo = 0; X_org_hi = 0;
    temp = xsize / 256;
    Width_hi = (unsigned char) temp;     /* low and high bytes of x width */
    Width_lo = xsize % 256;
    temp = ysize / 256;
    Height_hi = (unsigned char) temp;
    Height_lo = ysize % 256;
    PixelSize = 24;
    Y_org_lo = 0;
    Y_org_hi = 0;

    fprintf(outfile,"%c",IDLength);
    fprintf(outfile,"%c",CoMapType);
    fprintf(outfile,"%c",ImgType);
    fprintf(outfile,"%c",Index_lo);
    fprintf(outfile,"%c", Index_hi);
    fprintf(outfile,"%c",Length_lo);
    fprintf(outfile,"%c",Length_hi);
    fprintf(outfile,"%c",CoSize);
    fprintf(outfile,"%c",X_org_lo); fprintf(outfile,"%c",X_org_hi);
    fprintf(outfile,"%c",Y_org_lo); fprintf(outfile,"%c",Y_org_hi);
    fprintf(outfile,"%c",Width_lo);
    fprintf(outfile,"%c",Width_hi);              /* file in lo-byte, hi-byte order b12,b13*/
    fprintf(outfile,"%c",Height_lo);
    fprintf(outfile,"%c",Height_hi);    /* ysize b14, b15 */
    fprintf(outfile,"%c",PixelSize);
    fprintf(outfile,"%c",(unsigned char) 0x20);        /* descriptor byte b17 */

    blue = 0;
    for (iy = 0; iy < ysize; iy++) {
     for (ix = 0; ix < xsize; ix++) {
       red = (U)(65535.0*El(hf,ix,iy))/256; /* high byte */
       green = (U)(65535.0*El(hf,ix,iy)) % 256; /* low byte */
       fprintf(outfile,"%c%c%c",blue,green,red);
     }
    }
  
  fclose(outfile);
  return(0);

} /* end tga_write() */

