/* slopegen.c: create heightfield with a slope along y-axis      */
/*             write out in one of various formats            */
/*           John P. Beale 9/11/95                           */
/*          GIF library routines from gd library             */

#include <stdio.h>                      /* fopen() sprintf() etc. */
#include <stdlib.h>                     /* strtod() */
#include <math.h>                       /* math stuff */
#include <string.h>                     /* strcpy() */
#include "hcon.h"
#include "hf_io.h"

void renorm(int r);                     /* normalize array */

U xsize, ysize;     /* size of hf array (input xsize+2) */
U meshsize;
PTYPE *hf;                            /* height field array */
double yf, yb, ybr, z;
double slope_exp = 2.0;

/* ---------------------------------- */

int main(int argc, char **argv)
{ char *usage = 
"slopegen: Heightfield Generator v0.1a <beale@jump.stanford.edu> 1995\n\
Usage: slopegen <outfile> <meshsize> <slopefrac> [ <exp> ]\n\
  Generate a heightfield of type PGM|PG8|MAT|OCT|GIF|POT|TGA\n\
  Determines filetype based on extension, eg:  slopegen slope1.pot 128 0.1\n\
  meshsize is x,y dimension of array, slopefrac is fractional distance\n\
  from y=0 for slope to start. Slope is of the form y=x^(exp),\n\
  where exp defaults to 2.0 \n";
  
  char fname_out[160];
  char *ext2;
  char *buf;
  int rval,i,j;
  size_t hsize;

  if (argc < 4) {
	fprintf(stderr,"%s",usage);
	exit(1);
      }
 
  strcpy(fname_out,argv[1]);

  meshsize = (int) strtod(argv[2], &buf);
  yb = (double) strtod(argv[3], &buf);   /* fractional y distance */
  xsize = meshsize;
  ysize = meshsize;

  if (argc > 4) slope_exp = strtod(argv[4], &buf);  /* slope exponent */


  /* allocate memory for the heightfield array */
  hsize = (size_t) ( xsize * ysize * sizeof(PTYPE));
  if ((hf = (PTYPE *) malloc( hsize ) ) == NULL)   {
   fprintf(stderr,"Could not allocate memory for heightfield (%lu bytes)\n",
     (unsigned long)hsize);
   exit(1);
  }
  memset(hf,(char) 0, hsize);  /* clear memory to zero bytes */

  for (j=0;j<ysize;j++) {   
   for (i=0;i<xsize;i++) {
    yf = ((double)j)/ysize;
    if (yf > yb) z = 0;
    else {
      ybr = yf/yb;
      z = pow(1.0-ybr,slope_exp);
      }
    El(hf,i,j) = (PTYPE)z;
   } /* end for i */
  } /* end for j */

   if (xsize < 9) hf_print();  /* print small arrays */

   rval = writen_hf(hf, xsize, ysize, fname_out);

   return(rval);    /* return a value */
} /* end main() */

void hf_print()                /* print out hf array on stdout */
{
  int ix,iy;

   printf("Heightfield array: %dx%d\n",xsize,ysize);
   for (iy = 0; iy<ysize; iy++) {
    printf("%d:",iy);
    for (ix = 0; ix<xsize; ix++) {
	printf(" %1.2f",El(hf,ix,iy));
    }
     printf("\n");
   }
}



