/* rmat.c:  very simple file I/O for reading numbers from matlab files  */
/* JPB  '95  */

#include <stdio.h>
#include <stdlib.h>             /* ansi malloc */
#include <math.h>
#include <string.h>
#include "hcon.h"

int main()
{
  char pname[80]="land\x00";           /* data matrix name, null-terminated*/
  PTYPE *pr;                          /* pointer to real data */
  Fmatrix x;
  int mn;
  int rows, cols;

  int i,j;
  int a,b,c,xsize,ysize,etype;
  int mtype,prec,rem,numtype;
  double tdbl;
  float tflt;
  FILE *fpin;
  char fname_in[80] = "input.dat";

  printf("\nEnter input file name:");
  scanf("%s",fname_in);

   /* --------- read in Matlab-format (Level 1.0) file ------- */

   etype = (NUM_FMT*1000) + (PREC*10);    /* expected data type flag */

   if ((fpin = fopen(fname_in,"rb")) == NULL) {
    perror("could not open file.\n");
    exit(1);
   }

   printf("Opening matlab file %s...\n",fname_in);

   a = fread(&x, sizeof(Fmatrix),(size_t)1, fpin);          /* read header */
    if (a != 1) {
      perror("Problem reading matlab file header.\n");
      exit(1);
    }
   numtype = (x.type % 10000)/1000;
   prec = (x.type % 100)/10;
   mtype = (x.type % 10);
   rem = (x.type - (1000*numtype + 10*prec + mtype));
   printf("Data type flag: M%d P%d T%d R%d\n",
       numtype,prec,mtype,rem);
   if ( (numtype!=NUM_FMT) || ((prec!=0)&&(prec!=1)) || (mtype!=0) )  {
     perror("Unsupported file format type\n");
     exit(1);
   }
   b = fread(pname, sizeof(char), (size_t)x.namelen, fpin);   /* read mx name */
   xsize = x.mrows;
   ysize = x.ncols;
   printf("Array name: %s [%dx%d]\n",pname,xsize,ysize);
   mn = x.mrows * x.ncols;
   if ((pr = (float *) malloc(mn*sizeof(float)) ) == NULL) {
     perror("Could not allocate memory for input array.\n");
     exit(1);
   }
   if (prec==1) {               /* read in floats 1 by 1 */
     for (i=0;i<mn;i++) {
       c = fread(&tflt, sizeof(float), 1, fpin);
       pr[i] = (PTYPE) tflt;
     } /* end for */
   } else if (prec==0) {                     /* read doubles 1 by 1 and convert */
     for (i=0;i<mn;i++) {
       c = fread(&tdbl, sizeof(double), 1, fpin);
       pr[i]=(PTYPE)tdbl;
     } /* end for */
   } else {
	perror("Unsupported floating-point type\n");
	exit(1);
   } /* end else */


   fclose( fpin );

/* ----------------------------------------------------------- */
  printf("items read %d %d %d.\n",a,b,c);
  printf("All done with file operations.\n");

  rows = x.mrows;  cols = x.ncols;

  printf("Data array read:\n");
  for (j=0;j<rows;j++) {
   for (i=0;i<cols;i++) {
    printf("%3.1f ",pr[i+(cols*j)]);
   }
   printf("\n");
  } /* end for j */

 return(0);
}

