/* pwrite.c     write out data as a POT format file    -jpb 6/25/95    */
/*              read data in from POT file  -jpb 7/15/95 */

/* pwrite.c   uses routines from the gd 1.1.1 library:   

   gd 1.1.1 is copyright 1994, Quest Protein Database Center, Cold Spring
   Harbor Labs. Permission granted to copy and distribute this work
   provided that this notice remains intact.

	Tom Boutell, boutell@netcom.com
	http://sunsite.unc.edu/boutell/index.html
	116 14th Ave E Apt 2
	Seattle, WA 98102
*/

#include <stdio.h>
#include <stdlib.h>
#include <gd.h>
#include <gdfontl.h>
#include <gdfonts.h>
#include "hcon.h"

/* ---------------------------------------------------------------------- */
/* pwrite() --  write out data in hf array (xsize x ysize) as a greyscale */
/*              POT format image file with the name <fname>.              */
/*              hf is assumed hold values between 0.0 and 1.0             */
/* ---------------------------------------------------------------------- */

int pwrite(PTYPE *hf, U xsize, U ysize, char *fname)
{
			/* Input and output files */
    FILE *out;
    gdImagePtr im_out;       /* Input and output images */
    int blue;                   /* Color indexes */
    int red;
    int green;
    int x,y;

      /* Create output image, x by y pixels. */
	im_out = gdImageCreate(xsize*2,ysize);

	/* First color allocated is background. */
	/* this loop makes a 0-255 graylevel palette (only 64 unique tho) */
	for (x = 0; x < 256; x++) {  
	  red = x - 2;
	  if (red<0) red = 0;
	  blue = x - 3;
	  if (blue<0) blue=0;
	  green = x;
	  gdImageColorAllocate(im_out, red,green,blue);
	}

	for (x=0;x<xsize;x++) {         /* transfer hf data to pixel array */
	 for (y=0;y<ysize;y++) {
	  im_out->pixels[x][y] = (int)(65535.0*El(hf,x,y))/256; /* high byte */
	  im_out->pixels[x+xsize][y] = (int)(65535.0*El(hf,x,y)) % 256; /* low byte */
	 }
	}

	out = fopen(fname, "wb");
	
	/* Write GIF */
	gdImageGif(im_out, out);
	fclose(out);
	gdImageDestroy(im_out);         /* free up image memory */
	return(0);
}

/* read hf array from POT */

int pread(PTYPE **hh, unsigned int *xs, unsigned int *ys, char *fname) 
{
  int ix, iy;
  int xsize;
  gdImagePtr im;
  FILE *infile;
  size_t mem;

  infile = fopen(fname, "rb");
  if (infile == NULL) {
    fprintf(stderr,"Trouble opening POT file %s\n",fname);
    exit(1);
  }
  im = gdImageCreateFromGif(infile);
  fclose(infile);

  if (!im) {
    fprintf(stderr,"Trouble reading POT file %s\n",fname);
    exit(1);
  }

  xs[0] = gdImageSX(im) / 2;
  ys[0] = gdImageSY(im);
  xsize = xs[0];
  if (xs[0]*2 != gdImageSX(im)) {
    printf("Error: file cannot be POT, horizontal dimension is odd.\n");
    exit(1);
  }

  mem = (size_t) sizeof(PTYPE) * xs[0] * ys[0];
  fprintf(stderr,"allocating %lu bytes for array\n",(long unsigned) mem);
  hh[0] = (PTYPE *) malloc(mem);
  for (ix = 0; ix < xs[0]; ix++) {
    for (iy = 0; iy < ys[0]; iy++) {
      El(hh[0],ix,iy) = (PTYPE) im->pixels[ix][iy]/256.0 + 
	 (PTYPE) im->pixels[ix+xs[0]][iy]/65536.0;
    }
  }

  return(0);
} /* end pread() */
