/* gwrite.c     write out data as a GIF format file    -jpb 6/25/95    */

/* gwrite.c   uses routines from the gd 1.1.1 library:   

   gd 1.1.1 is copyright 1994, Quest Protein Database Center, Cold Spring
   Harbor Labs. Permission granted to copy and distribute this work
   provided that this notice remains intact.

	Tom Boutell, boutell@netcom.com
	http://sunsite.unc.edu/boutell/index.html
	116 14th Ave E Apt 2
	Seattle, WA 98102
*/

#include <stdio.h>
#include <gd.h>
#include <gdfontl.h>
#include <gdfonts.h>
#include "hcon.h"



extern unsigned int xsize, ysize;     /* size of hf array (input xsize+2) */
extern float *hf;                            /* height field array */

/* ---------------------------------------------------------------------- */
/* gwrite() --  write out data in hf array (xsize x ysize) as a greyscale */
/*              GIF format image file with the name <fname>.              */
/*              hf is assumed hold values between 0.0 and 1.0           */
/* ---------------------------------------------------------------------- */

int gwrite(char *fname)
{
			/* Input and output files */
    FILE *out;
    gdImagePtr im_out;       /* Input and output images */
    int blue;                   /* Color indexes */
    int red;
    int green;
    int x,y;

      /* Create output image, x by y pixels. */
	im_out = gdImageCreate(xsize,ysize);

	/* First color allocated is background. */
	/* this loop makes a 0-255 graylevel palette (only 64 unique tho) */
	for (x = 0; x < 256; x++) {  
	  red = x - 2;
	  if (red<0) red = 0;
	  blue = x - 3;
	  if (blue<0) blue=0;
	  green = x;
	  gdImageColorAllocate(im_out, red,green,blue);
	}

	for (x=0;x<xsize;x++) {         /* transfer hf data to pixel array */
	 for (y=0;y<ysize;y++) {
	  im_out->pixels[x][y] = (int)(255.0*El(hf,x,y));
	 }
	}

	out = fopen(fname, "wb");
	
	/* Write GIF */
	gdImageGif(im_out, out);
	fclose(out);
	gdImageDestroy(im_out);         /* free up image memory */
	return(0);
}

